/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.export;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.util.Set;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionCall;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionCallExpression;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.model.AStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.FunctionSummaryEdge;
import org.sosy_lab.cpachecker.util.CFATraversal;

public class FunctionCallDumper {
    public static void dump(Appendable pAppender, CFA pCfa) throws IOException {
        CFAFunctionCallFinder finder = new CFAFunctionCallFinder();
        for (FunctionEntryNode entryNode : pCfa.getAllFunctionHeads()) {
            CFATraversal.dfs().ignoreFunctionCalls().traverseOnce(entryNode, finder);
        }
        pAppender.append("digraph functioncalls {\n");
        pAppender.append("rankdir=LR;\n\n");
        Set<String> functionNames = pCfa.getAllFunctionNames();
        String mainFunction = pCfa.getMainFunction().getFunctionName();
        pAppender.append(mainFunction + " [shape=\"box\", color=blue];\n");
        for (String callerFunctionName : finder.functionCalls.keySet()) {
            for (String calleeFunctionName : finder.functionCalls.get((Object)callerFunctionName)) {
                if (!functionNames.contains(calleeFunctionName)) {
                    pAppender.append(calleeFunctionName + " [shape=\"box\", color=grey];\n");
                }
                pAppender.append(callerFunctionName + " -> " + calleeFunctionName + ";\n");
            }
        }
        pAppender.append("}\n");
    }

    private static class CFAFunctionCallFinder
    extends CFATraversal.DefaultCFAVisitor {
        final Multimap<String, String> functionCalls = LinkedHashMultimap.create();

        private CFAFunctionCallFinder() {
        }

        @Override
        public CFATraversal.TraversalProcess visitEdge(CFAEdge pEdge) {
            switch (pEdge.getEdgeType()) {
                case CallToReturnEdge: {
                    FunctionSummaryEdge function = (FunctionSummaryEdge)pEdge;
                    String functionName = function.getPredecessor().getFunctionName();
                    String calledFunction = function.getPredecessor().getLeavingEdge(0).getSuccessor().getFunctionName();
                    this.functionCalls.put((Object)functionName, (Object)calledFunction);
                    break;
                }
                case StatementEdge: {
                    AFunctionCall functionCall;
                    AFunctionCallExpression functionCallExpression;
                    AFunctionDeclaration declaration;
                    AStatementEdge edge = (AStatementEdge)pEdge;
                    if (!(edge.getStatement() instanceof AFunctionCall) || (declaration = (functionCallExpression = (functionCall = (AFunctionCall)edge.getStatement()).getFunctionCallExpression()).getDeclaration()) == null) break;
                    String functionName = pEdge.getPredecessor().getFunctionName();
                    String calledFunction = declaration.getName();
                    this.functionCalls.put((Object)functionName, (Object)calledFunction);
                    break;
                }
                case FunctionCallEdge: {
                    throw new AssertionError((Object)"traversal-strategy should ignore functioncalls");
                }
            }
            return CFATraversal.TraversalProcess.CONTINUE;
        }
    }
}

