/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.model;

import com.google.common.base.Optional;
import org.sosy_lab.cpachecker.cfa.ast.AExpression;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.model.AbstractCFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdgeType;
import org.sosy_lab.cpachecker.cfa.model.CFANode;

public class AssumeEdge
extends AbstractCFAEdge {
    private final boolean truthAssumption;
    protected final AExpression expression;

    protected AssumeEdge(String pRawStatement, FileLocation pFileLocation, CFANode pPredecessor, CFANode pSuccessor, AExpression pExpression, boolean pTruthAssumption) {
        super("[" + pRawStatement + "]", pFileLocation, pPredecessor, pSuccessor);
        this.truthAssumption = pTruthAssumption;
        this.expression = pExpression;
    }

    @Override
    public CFAEdgeType getEdgeType() {
        return CFAEdgeType.AssumeEdge;
    }

    public boolean getTruthAssumption() {
        return this.truthAssumption;
    }

    public AExpression getExpression() {
        return this.expression;
    }

    @Override
    public String getCode() {
        if (this.truthAssumption) {
            return this.expression.toASTString();
        }
        return "!(" + this.expression.toASTString() + ")";
    }

    @Override
    public String getDescription() {
        return "[" + this.getCode() + "]";
    }

    public Optional<? extends AExpression> getRawAST() {
        return Optional.of((Object)this.expression);
    }
}

