/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.model;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.FunctionExitNode;
import org.sosy_lab.cpachecker.cfa.model.FunctionSummaryEdge;
import org.sosy_lab.cpachecker.cfa.model.MultiEdge;
import org.sosy_lab.cpachecker.util.UniqueIdGenerator;

public class CFANode
implements Comparable<CFANode> {
    private static final UniqueIdGenerator idGenerator = new UniqueIdGenerator();
    private final int nodeNumber;
    private final List<CFAEdge> leavingEdges = new ArrayList<CFAEdge>(1);
    private final List<CFAEdge> enteringEdges = new ArrayList<CFAEdge>(1);
    private boolean isLoopStart = false;
    private final String functionName;
    private FunctionSummaryEdge leavingSummaryEdge = null;
    private FunctionSummaryEdge enteringSummaryEdge = null;
    private int reversePostorderId = 0;

    public CFANode(String pFunctionName) {
        assert (!pFunctionName.isEmpty());
        this.functionName = pFunctionName;
        this.nodeNumber = idGenerator.getFreshId();
    }

    public int getNodeNumber() {
        return this.nodeNumber;
    }

    public int getReversePostorderId() {
        return this.reversePostorderId;
    }

    public void setReversePostorderId(int pId) {
        this.reversePostorderId = pId;
    }

    public void addLeavingEdge(CFAEdge pNewLeavingEdge) {
        Preconditions.checkArgument((pNewLeavingEdge.getPredecessor() == this ? 1 : 0) != 0, (String)"Cannot add edge \"%s\" to node %s as leaving edge", (Object[])new Object[]{pNewLeavingEdge, this});
        this.leavingEdges.add(pNewLeavingEdge);
    }

    public void removeLeavingEdge(CFAEdge pEdge) {
        boolean removed = this.leavingEdges.remove(pEdge);
        Preconditions.checkArgument((boolean)removed, (String)"Cannot remove non-existing leaving edge \"%s\" from node %s", (Object[])new Object[]{pEdge, this});
    }

    public int getNumLeavingEdges() {
        return this.leavingEdges.size();
    }

    public CFAEdge getLeavingEdge(int pIndex) {
        return this.leavingEdges.get(pIndex);
    }

    public void addEnteringEdge(CFAEdge pEnteringEdge) {
        Preconditions.checkArgument((pEnteringEdge.getSuccessor() == this ? 1 : 0) != 0, (String)"Cannot add edge \"%s\" to node %s as entering edge", (Object[])new Object[]{pEnteringEdge, this});
        this.enteringEdges.add(pEnteringEdge);
    }

    public void removeEnteringEdge(CFAEdge pEdge) {
        boolean removed = this.enteringEdges.remove(pEdge);
        Preconditions.checkArgument((boolean)removed, (String)"Cannot remove non-existing entering edge \"%s\" from node %s", (Object[])new Object[]{pEdge, this});
    }

    public int getNumEnteringEdges() {
        return this.enteringEdges.size();
    }

    public CFAEdge getEnteringEdge(int pIndex) {
        return this.enteringEdges.get(pIndex);
    }

    public CFAEdge getEdgeTo(CFANode pOther) {
        for (CFAEdge edge : this.leavingEdges) {
            if (edge.getSuccessor() != pOther) continue;
            return edge;
        }
        throw new IllegalArgumentException("there is no edge from " + this + " to " + pOther);
    }

    public boolean hasEdgeTo(CFANode pOther) {
        boolean hasEdge = false;
        for (CFAEdge edge : this.leavingEdges) {
            if (edge.getSuccessor() != pOther) continue;
            hasEdge = true;
            break;
        }
        return hasEdge;
    }

    public void setLoopStart() {
        this.isLoopStart = true;
    }

    public boolean isLoopStart() {
        return this.isLoopStart;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public void addEnteringSummaryEdge(FunctionSummaryEdge pEdge) {
        Preconditions.checkState((this.enteringSummaryEdge == null ? 1 : 0) != 0, (String)"Cannot add two entering summary edges to node %s", (Object[])new Object[]{this});
        this.enteringSummaryEdge = pEdge;
    }

    public void addLeavingSummaryEdge(FunctionSummaryEdge pEdge) {
        Preconditions.checkState((this.leavingSummaryEdge == null ? 1 : 0) != 0, (String)"Cannot add two leaving summary edges to node %s", (Object[])new Object[]{this});
        this.leavingSummaryEdge = pEdge;
    }

    public FunctionSummaryEdge getEnteringSummaryEdge() {
        return this.enteringSummaryEdge;
    }

    public FunctionSummaryEdge getLeavingSummaryEdge() {
        return this.leavingSummaryEdge;
    }

    public void removeEnteringSummaryEdge(FunctionSummaryEdge pEdge) {
        Preconditions.checkArgument((this.enteringSummaryEdge == pEdge ? 1 : 0) != 0, (String)"Cannot remove non-existing entering summary edge \"%s\" from node \"%s\"", (Object[])new Object[]{pEdge, this});
        this.enteringSummaryEdge = null;
    }

    public void removeLeavingSummaryEdge(FunctionSummaryEdge pEdge) {
        Preconditions.checkArgument((this.leavingSummaryEdge == pEdge ? 1 : 0) != 0, (String)"Cannot remove non-existing leaving summary edge \"%s\" from node \"%s\"", (Object[])new Object[]{pEdge, this});
        this.leavingSummaryEdge = null;
    }

    public String toString() {
        return "N" + this.nodeNumber;
    }

    @Override
    public final int compareTo(CFANode pOther) {
        return Integer.compare(this.nodeNumber, pOther.nodeNumber);
    }

    public final boolean equals(Object pObj) {
        return super.equals(pObj);
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public String describeFileLocation() {
        CFAEdge edge;
        if (this instanceof FunctionEntryNode) {
            return "entry of function " + this.getFunctionName() + " in " + ((FunctionEntryNode)this).getFileLocation();
        }
        if (this instanceof FunctionExitNode) {
            return "exit of function " + this.getFunctionName() + " in " + ((FunctionExitNode)this).getEntryNode().getFileLocation();
        }
        if (this.getNumLeavingEdges() > 0) {
            edge = this.getLeavingEdge(0);
            if (edge instanceof MultiEdge) {
                edge = (CFAEdge)((MultiEdge)edge).getEdges().get(0);
            }
            if (!edge.getFileLocation().equals(FileLocation.DUMMY)) {
                return "before " + edge.getFileLocation();
            }
        }
        if (this.getNumEnteringEdges() > 0) {
            edge = this.getEnteringEdge(0);
            if (edge instanceof MultiEdge) {
                edge = (CFAEdge)Iterables.getLast(((MultiEdge)edge).getEdges());
            }
            if (!edge.getFileLocation().equals(FileLocation.DUMMY)) {
                return "after " + edge.getFileLocation();
            }
        }
        return "";
    }
}

