/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.model;

import com.google.common.base.Optional;
import java.util.List;
import org.sosy_lab.cpachecker.cfa.ast.AExpression;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionCall;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.model.AbstractCFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdgeType;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.FunctionSummaryEdge;

public class FunctionCallEdge
extends AbstractCFAEdge {
    protected final AFunctionCall functionCall;
    protected final FunctionSummaryEdge summaryEdge;

    protected FunctionCallEdge(String pRawStatement, FileLocation pFileLocation, CFANode pPredecessor, CFANode pSuccessor, AFunctionCall pFunctionCall, FunctionSummaryEdge pSummaryEdge) {
        super(pRawStatement, pFileLocation, pPredecessor, pSuccessor);
        this.functionCall = pFunctionCall;
        this.summaryEdge = pSummaryEdge;
    }

    @Override
    public CFAEdgeType getEdgeType() {
        return CFAEdgeType.FunctionCallEdge;
    }

    public FunctionSummaryEdge getSummaryEdge() {
        return this.summaryEdge;
    }

    public List<? extends AExpression> getArguments() {
        return this.functionCall.getFunctionCallExpression().getParameterExpressions();
    }

    @Override
    public String getCode() {
        return this.functionCall.getFunctionCallExpression().toASTString();
    }

    public Optional<? extends AFunctionCall> getRawAST() {
        return Optional.of((Object)this.functionCall);
    }

    @Override
    public FunctionEntryNode getSuccessor() {
        return (FunctionEntryNode)super.getSuccessor();
    }
}

