/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.model;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.AParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.AVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionExitNode;

public abstract class FunctionEntryNode
extends CFANode {
    private final FileLocation location;
    private final AFunctionDeclaration functionDefinition;
    private final List<String> parameterNames;
    private final Optional<? extends AVariableDeclaration> returnVariable;
    private final FunctionExitNode exitNode;

    protected FunctionEntryNode(FileLocation pFileLocation, String pFunctionName, FunctionExitNode pExitNode, AFunctionDeclaration pFunctionDefinition, List<String> pParameterNames, Optional<? extends AVariableDeclaration> pReturnVariable) {
        super(pFunctionName);
        this.location = (FileLocation)Preconditions.checkNotNull((Object)pFileLocation);
        this.functionDefinition = pFunctionDefinition;
        this.parameterNames = ImmutableList.copyOf(pParameterNames);
        this.exitNode = pExitNode;
        this.returnVariable = (Optional)Preconditions.checkNotNull(pReturnVariable);
    }

    public FileLocation getFileLocation() {
        return this.location;
    }

    public FunctionExitNode getExitNode() {
        return this.exitNode;
    }

    public AFunctionDeclaration getFunctionDefinition() {
        return this.functionDefinition;
    }

    public List<String> getFunctionParameterNames() {
        return this.parameterNames;
    }

    public abstract List<? extends AParameterDeclaration> getFunctionParameters();

    public Optional<? extends AVariableDeclaration> getReturnVariable() {
        return this.returnVariable;
    }
}

