/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.parser.eclipse;

import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URLClassLoader;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.regex.Pattern;
import org.sosy_lab.common.ChildFirstPatternClassLoader;
import org.sosy_lab.common.Classes;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CParser;
import org.sosy_lab.cpachecker.cfa.Parser;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;

public class EclipseParsers {
    private static final Pattern OUR_CLASSES = Pattern.compile("^(org\\.eclipse|org\\.sosy_lab\\.cpachecker\\.cfa\\.parser\\.eclipse)\\..*");
    private static final String C_PARSER_CLASS = "org.sosy_lab.cpachecker.cfa.parser.eclipse.c.EclipseCParser";
    private static final String JAVA_PARSER_CLASS = "org.sosy_lab.cpachecker.cfa.parser.eclipse.java.EclipseJavaParser";
    private static WeakReference<ClassLoader> loadedClassLoader = new WeakReference<Object>(null);
    private static WeakReference<Constructor<? extends CParser>> loadedCParser = new WeakReference<Object>(null);
    private static WeakReference<Constructor<? extends Parser>> loadedJavaParser = new WeakReference<Object>(null);
    private static final AtomicInteger loadingCount = new AtomicInteger(0);

    private EclipseParsers() {
    }

    private static ClassLoader getClassLoader(LogManager logger) {
        ClassLoader classLoader = (ClassLoader)loadedClassLoader.get();
        if (classLoader != null) {
            return classLoader;
        }
        if (loadingCount.incrementAndGet() > 1) {
            logger.log(Level.INFO, new Object[]{"Repeated loading of Eclipse source parser"});
        }
        if ((classLoader = EclipseParsers.class.getClassLoader()) instanceof URLClassLoader) {
            classLoader = new ChildFirstPatternClassLoader(OUR_CLASSES, ((URLClassLoader)classLoader).getURLs(), classLoader);
        }
        loadedClassLoader = new WeakReference<ClassLoader>(classLoader);
        return classLoader;
    }

    public static CParser getCParser(Configuration config, LogManager logger, CParser.Dialect dialect, MachineModel machine) {
        try {
            Constructor<?> parserConstructor = (Constructor<?>)loadedCParser.get();
            if (parserConstructor == null) {
                ClassLoader classLoader = EclipseParsers.getClassLoader(logger);
                Class<?> parserClass = classLoader.loadClass(C_PARSER_CLASS);
                parserConstructor = parserClass.getConstructor(Configuration.class, LogManager.class, CParser.Dialect.class, MachineModel.class);
                parserConstructor.setAccessible(true);
                loadedCParser = new WeakReference(parserConstructor);
            }
            return (CParser)parserConstructor.newInstance(new Object[]{config, logger, dialect, machine});
        }
        catch (ReflectiveOperationException e) {
            throw new Classes.UnexpectedCheckedException("Failed to create Eclipse CDT parser", (Throwable)e);
        }
    }

    public static Parser getJavaParser(LogManager logger, Configuration config) throws InvalidConfigurationException {
        try {
            Constructor<?> parserConstructor = (Constructor<?>)loadedJavaParser.get();
            if (parserConstructor == null) {
                ClassLoader classLoader = EclipseParsers.getClassLoader(logger);
                Class<?> parserClass = classLoader.loadClass(JAVA_PARSER_CLASS);
                parserConstructor = parserClass.getConstructor(LogManager.class, Configuration.class);
                parserConstructor.setAccessible(true);
                loadedJavaParser = new WeakReference(parserConstructor);
            }
            try {
                return (Parser)parserConstructor.newInstance(logger, config);
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof InvalidConfigurationException) {
                    throw (InvalidConfigurationException)e.getCause();
                }
                throw e;
            }
        }
        catch (ReflectiveOperationException e) {
            throw new Classes.UnexpectedCheckedException("Failed to create Eclipse Java parser", (Throwable)e);
        }
    }
}

