/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.parser.eclipse.c;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import javax.annotation.Nullable;
import org.eclipse.cdt.core.dom.ast.IASTArrayDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTArrayModifier;
import org.eclipse.cdt.core.dom.ast.IASTArraySubscriptExpression;
import org.eclipse.cdt.core.dom.ast.IASTBinaryExpression;
import org.eclipse.cdt.core.dom.ast.IASTCastExpression;
import org.eclipse.cdt.core.dom.ast.IASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTConditionalExpression;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTEnumerationSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTEqualsInitializer;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTExpressionList;
import org.eclipse.cdt.core.dom.ast.IASTExpressionStatement;
import org.eclipse.cdt.core.dom.ast.IASTFieldReference;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTForStatement;
import org.eclipse.cdt.core.dom.ast.IASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTInitializer;
import org.eclipse.cdt.core.dom.ast.IASTInitializerClause;
import org.eclipse.cdt.core.dom.ast.IASTInitializerList;
import org.eclipse.cdt.core.dom.ast.IASTLiteralExpression;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNamedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTPointerOperator;
import org.eclipse.cdt.core.dom.ast.IASTProblemDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTProblemStatement;
import org.eclipse.cdt.core.dom.ast.IASTReturnStatement;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTStandardFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTTypeId;
import org.eclipse.cdt.core.dom.ast.IASTTypeIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTTypeIdInitializerExpression;
import org.eclipse.cdt.core.dom.ast.IASTUnaryExpression;
import org.eclipse.cdt.core.dom.ast.IBasicType;
import org.eclipse.cdt.core.dom.ast.IPointerType;
import org.eclipse.cdt.core.dom.ast.c.ICASTArrayDesignator;
import org.eclipse.cdt.core.dom.ast.c.ICASTArrayModifier;
import org.eclipse.cdt.core.dom.ast.c.ICASTDesignatedInitializer;
import org.eclipse.cdt.core.dom.ast.c.ICASTDesignator;
import org.eclipse.cdt.core.dom.ast.c.ICASTFieldDesignator;
import org.eclipse.cdt.core.dom.ast.gnu.IGNUASTCompoundStatementExpression;
import org.eclipse.cdt.core.dom.ast.gnu.c.IGCCASTArrayRangeDesignator;
import org.eclipse.cdt.internal.core.dom.parser.c.CASTArrayDesignator;
import org.eclipse.cdt.internal.core.dom.parser.c.CASTArrayRangeDesignator;
import org.eclipse.cdt.internal.core.dom.parser.c.CASTFunctionCallExpression;
import org.sosy_lab.common.Pair;
import org.sosy_lab.common.Triple;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.log.LogManagerWithoutDuplicates;
import org.sosy_lab.cpachecker.cfa.CSourceOriginMapping;
import org.sosy_lab.cpachecker.cfa.ast.AbstractExpression;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.c.CAddressOfLabelExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CArrayDesignator;
import org.sosy_lab.cpachecker.cfa.ast.c.CArrayRangeDesignator;
import org.sosy_lab.cpachecker.cfa.ast.c.CArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CAssignment;
import org.sosy_lab.cpachecker.cfa.ast.c.CAstNode;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpressionBuilder;
import org.sosy_lab.cpachecker.cfa.ast.c.CCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCharLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CComplexCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CComplexTypeDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CDesignatedInitializer;
import org.sosy_lab.cpachecker.cfa.ast.c.CDesignator;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpressionAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpressionStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFieldDesignator;
import org.sosy_lab.cpachecker.cfa.ast.c.CFieldReference;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializer;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializerList;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CLeftHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CPointerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CReturnStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CRightHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CSimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CTypeDefDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CTypeIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CUnaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.parser.Scope;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.c.ASTLiteralConverter;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.c.ASTOperatorConverter;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.c.ASTTypeConverter;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.c.CFAGenerationRuntimeException;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.c.FillInBindingVisitor;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.c.FunctionScope;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.c.Sideassignments;
import org.sosy_lab.cpachecker.cfa.simplification.ExpressionSimplificationVisitor;
import org.sosy_lab.cpachecker.cfa.simplification.NonRecursiveExpressionSimplificationVisitor;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.c.CArrayType;
import org.sosy_lab.cpachecker.cfa.types.c.CBasicType;
import org.sosy_lab.cpachecker.cfa.types.c.CComplexType;
import org.sosy_lab.cpachecker.cfa.types.c.CCompositeType;
import org.sosy_lab.cpachecker.cfa.types.c.CDefaults;
import org.sosy_lab.cpachecker.cfa.types.c.CElaboratedType;
import org.sosy_lab.cpachecker.cfa.types.c.CEnumType;
import org.sosy_lab.cpachecker.cfa.types.c.CFunctionType;
import org.sosy_lab.cpachecker.cfa.types.c.CFunctionTypeWithNames;
import org.sosy_lab.cpachecker.cfa.types.c.CNumericTypes;
import org.sosy_lab.cpachecker.cfa.types.c.CPointerType;
import org.sosy_lab.cpachecker.cfa.types.c.CProblemType;
import org.sosy_lab.cpachecker.cfa.types.c.CSimpleType;
import org.sosy_lab.cpachecker.cfa.types.c.CStorageClass;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cfa.types.c.CTypedefType;
import org.sosy_lab.cpachecker.cfa.types.c.CTypes;
import org.sosy_lab.cpachecker.cfa.types.c.CVoidType;
import org.sosy_lab.cpachecker.cfa.types.c.DefaultCTypeVisitor;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCCodeException;

@Options(prefix="cfa")
class ASTConverter {
    @Option(secure=true, description="simplify pointer expressions like s->f to (*s).f with this option the cfa is simplified until at maximum one pointer is allowed for left- and rightHandSide")
    private boolean simplifyPointerExpressions = false;
    @Option(secure=true, description="simplify simple const expressions like 1+2")
    private boolean simplifyConstExpressions = true;
    private final ExpressionSimplificationVisitor expressionSimplificator;
    private final NonRecursiveExpressionSimplificationVisitor nonRecursiveExpressionSimplificator;
    private final CBinaryExpressionBuilder binExprBuilder;
    private final LogManager logger;
    private final ASTLiteralConverter literalConverter;
    private final ASTOperatorConverter operatorConverter;
    private final ASTTypeConverter typeConverter;
    private final Function<String, String> niceFileNameFunction;
    private final CSourceOriginMapping sourceOriginMapping;
    private final Scope scope;
    private static int anonTypeCounter = 0;
    private static int anonTypeMemberCounter = 0;
    private final Sideassignments sideAssignmentStack;
    private final String staticVariablePrefix;
    private static final ContainsProblemTypeVisitor containsProblemTypeVisitor = new ContainsProblemTypeVisitor();

    public ASTConverter(Configuration pConfig, Scope pScope, LogManagerWithoutDuplicates pLogger, Function<String, String> pNiceFileNameFunction, CSourceOriginMapping pSourceOriginMapping, MachineModel pMachineModel, String pStaticVariablePrefix, Sideassignments pSideAssignmentStack) throws InvalidConfigurationException {
        pConfig.inject((Object)this);
        this.scope = pScope;
        this.logger = pLogger;
        this.typeConverter = new ASTTypeConverter(this.scope, this, pStaticVariablePrefix, pNiceFileNameFunction);
        this.literalConverter = new ASTLiteralConverter(pMachineModel, pNiceFileNameFunction);
        this.operatorConverter = new ASTOperatorConverter(pNiceFileNameFunction);
        this.niceFileNameFunction = pNiceFileNameFunction;
        this.sourceOriginMapping = pSourceOriginMapping;
        this.staticVariablePrefix = pStaticVariablePrefix;
        this.sideAssignmentStack = pSideAssignmentStack;
        this.expressionSimplificator = new ExpressionSimplificationVisitor(pMachineModel, pLogger);
        this.nonRecursiveExpressionSimplificator = new NonRecursiveExpressionSimplificationVisitor(pMachineModel, pLogger);
        this.binExprBuilder = new CBinaryExpressionBuilder(pMachineModel, (LogManager)pLogger);
    }

    public CExpression convertExpressionWithoutSideEffects(IASTExpression e) {
        CAstNode node = this.convertExpressionWithSideEffects(e);
        if (node == null || node instanceof CExpression) {
            return (CExpression)node;
        }
        if (node instanceof CFunctionCallExpression) {
            return this.addSideassignmentsForExpressionsWithoutSideEffects(node, e);
        }
        if (e instanceof IASTUnaryExpression && (((IASTUnaryExpression)e).getOperator() == 10 || ((IASTUnaryExpression)e).getOperator() == 9)) {
            return this.addSideAssignmentsForUnaryExpressions(((CAssignment)node).getLeftHandSide(), node.getFileLocation(), this.typeConverter.convert(e.getExpressionType()), ((CBinaryExpression)((CAssignment)node).getRightHandSide()).getOperator());
        }
        if (node instanceof CAssignment) {
            this.sideAssignmentStack.addPreSideAssignment(node);
            return ((CAssignment)node).getLeftHandSide();
        }
        throw new AssertionError((Object)("unknown expression " + node));
    }

    CExpression simplifyExpressionRecursively(CExpression exp) {
        return exp.accept(this.expressionSimplificator);
    }

    CExpression simplifyExpressionOneStep(CExpression exp) {
        return exp.accept(this.nonRecursiveExpressionSimplificator);
    }

    private CExpression addSideassignmentsForExpressionsWithoutSideEffects(CAstNode node, IASTExpression e) {
        CIdExpression tmp = this.createTemporaryVariable(e);
        this.sideAssignmentStack.addPreSideAssignment(new CFunctionCallAssignmentStatement(this.getLocation((IASTNode)e), tmp, (CFunctionCallExpression)node));
        return tmp;
    }

    private CIdExpression addSideAssignmentsForUnaryExpressions(CLeftHandSide exp, FileLocation fileLoc, CType type, CBinaryExpression.BinaryOperator op) {
        CIdExpression tmp = this.createInitializedTemporaryVariable(fileLoc, exp.getExpressionType(), exp);
        CBinaryExpression postExp = this.buildBinaryExpression(exp, CIntegerLiteralExpression.ONE, op);
        this.sideAssignmentStack.addPreSideAssignment(new CExpressionAssignmentStatement(fileLoc, exp, postExp));
        return tmp;
    }

    private CComplexTypeDeclaration addSideEffectDeclarationForType(CCompositeType type, FileLocation loc) {
        CComplexTypeDeclaration decl = new CComplexTypeDeclaration(loc, this.scope.isGlobalScope(), type);
        this.scope.registerTypeDeclaration(decl);
        this.sideAssignmentStack.addPreSideAssignment(decl);
        return decl;
    }

    protected CAstNode convertExpressionWithSideEffects(IASTExpression e) {
        CAstNode converted = this.convertExpressionWithSideEffectsNotSimplified(e);
        if (!this.simplifyConstExpressions || !(converted instanceof CExpression)) {
            return converted;
        }
        return this.simplifyExpressionOneStep((CExpression)converted);
    }

    private CAstNode convertExpressionWithSideEffectsNotSimplified(IASTExpression e) {
        assert (!(e instanceof CExpression));
        if (e == null) {
            return null;
        }
        if (e instanceof IASTArraySubscriptExpression) {
            return this.convert((IASTArraySubscriptExpression)e);
        }
        if (e instanceof IASTBinaryExpression) {
            return this.convert((IASTBinaryExpression)e);
        }
        if (e instanceof IASTCastExpression) {
            return this.convert((IASTCastExpression)e);
        }
        if (e instanceof IASTFieldReference) {
            return this.convert((IASTFieldReference)e);
        }
        if (e instanceof IASTFunctionCallExpression) {
            return this.convert((IASTFunctionCallExpression)e);
        }
        if (e instanceof IASTIdExpression) {
            AbstractExpression exp = this.convert((IASTIdExpression)e);
            CType type = exp.getExpressionType();
            if (type instanceof CFunctionType && !this.isFunctionCallNameExpression(e) && !this.isAddressOfArgument(e)) {
                exp = new CUnaryExpression(exp.getFileLocation(), new CPointerType(type.isConst(), type.isVolatile(), type), (CExpression)((Object)exp), CUnaryExpression.UnaryOperator.AMPER);
            }
            return exp;
        }
        if (e instanceof IASTLiteralExpression) {
            CType type = this.typeConverter.convert(e.getExpressionType());
            return this.literalConverter.convert((IASTLiteralExpression)e, type, this.getLocation((IASTNode)e));
        }
        if (e instanceof IASTUnaryExpression) {
            return this.convert((IASTUnaryExpression)e);
        }
        if (e instanceof IASTTypeIdExpression) {
            return this.convert((IASTTypeIdExpression)e);
        }
        if (e instanceof IASTTypeIdInitializerExpression) {
            return this.convert((IASTTypeIdInitializerExpression)e);
        }
        if (e instanceof IASTConditionalExpression) {
            return this.convert((IASTConditionalExpression)e);
        }
        if (e instanceof IGNUASTCompoundStatementExpression) {
            return this.convert((IGNUASTCompoundStatementExpression)e);
        }
        if (e instanceof IASTExpressionList) {
            return this.convertExpressionListAsExpression((IASTExpressionList)e);
        }
        throw new CFAGenerationRuntimeException("Unknown expression type " + e.getClass().getSimpleName(), (IASTNode)e, this.niceFileNameFunction);
    }

    private boolean isFunctionCallNameExpression(IASTExpression e) {
        return e.getParent() instanceof IASTFunctionCallExpression && e.getPropertyInParent() == IASTFunctionCallExpression.FUNCTION_NAME;
    }

    private boolean isAddressOfArgument(IASTExpression e) {
        return e.getParent() instanceof IASTUnaryExpression && ((IASTUnaryExpression)e.getParent()).getOperator() == 5;
    }

    CONDITION getConditionKind(CExpression condition) {
        if (condition instanceof CIntegerLiteralExpression || condition instanceof CCharLiteralExpression) {
            if (this.isZero(condition)) {
                return CONDITION.ALWAYS_FALSE;
            }
            return CONDITION.ALWAYS_TRUE;
        }
        return CONDITION.NORMAL;
    }

    private CAstNode convert(IASTConditionalExpression e) {
        CONDITION conditionKind = this.getConditionKind(e.getLogicalConditionExpression());
        switch (conditionKind) {
            case ALWAYS_TRUE: {
                return this.convertExpressionWithSideEffects(e.getPositiveResultExpression());
            }
            case ALWAYS_FALSE: {
                return this.convertExpressionWithSideEffects(e.getNegativeResultExpression());
            }
            case NORMAL: {
                CIdExpression tmp = this.createTemporaryVariable((IASTExpression)e);
                this.sideAssignmentStack.addConditionalExpression((IASTExpression)e, tmp);
                return tmp;
            }
        }
        throw new AssertionError((Object)("Unhandled case statement: " + (Object)((Object)conditionKind)));
    }

    private CONDITION getConditionKind(IASTExpression exp) {
        if (exp instanceof IASTBinaryExpression && (((IASTBinaryExpression)exp).getOperator() == 15 || ((IASTBinaryExpression)exp).getOperator() == 16)) {
            IASTBinaryExpression binExp = (IASTBinaryExpression)exp;
            switch (binExp.getOperator()) {
                case 15: {
                    CONDITION left = this.getConditionKind(binExp.getOperand1());
                    switch (left) {
                        case ALWAYS_TRUE: {
                            return this.getConditionKind(binExp.getOperand2());
                        }
                        case ALWAYS_FALSE: {
                            return left;
                        }
                        case NORMAL: {
                            if (this.getConditionKind(binExp.getOperand2()) == CONDITION.ALWAYS_FALSE) {
                                return CONDITION.ALWAYS_FALSE;
                            }
                            return CONDITION.NORMAL;
                        }
                    }
                    throw new AssertionError((Object)"unhandled case statement");
                }
                case 16: {
                    CONDITION left = this.getConditionKind(binExp.getOperand1());
                    switch (left) {
                        case ALWAYS_TRUE: {
                            return CONDITION.ALWAYS_TRUE;
                        }
                        case ALWAYS_FALSE: {
                            return this.getConditionKind(binExp.getOperand2());
                        }
                        case NORMAL: {
                            CONDITION right = this.getConditionKind(binExp.getOperand2());
                            if (right == CONDITION.ALWAYS_FALSE) {
                                return CONDITION.NORMAL;
                            }
                            return right;
                        }
                    }
                    throw new AssertionError((Object)"unhandled case statement");
                }
            }
            throw new AssertionError((Object)"unhandled case statement");
        }
        this.sideAssignmentStack.enterBlock();
        CExpression simplifiedExp = this.simplifyExpressionRecursively(this.convertExpressionWithoutSideEffects(exp));
        this.sideAssignmentStack.getAndResetConditionalExpressions();
        this.sideAssignmentStack.getAndResetPostSideAssignments();
        this.sideAssignmentStack.getAndResetPreSideAssignments();
        this.sideAssignmentStack.leaveBlock();
        return this.getConditionKind(simplifiedExp);
    }

    private boolean isZero(CExpression exp) {
        if (exp instanceof CIntegerLiteralExpression) {
            BigInteger value = ((CIntegerLiteralExpression)exp).getValue();
            return value.equals(BigInteger.ZERO);
        }
        if (exp instanceof CCharLiteralExpression) {
            char value = ((CCharLiteralExpression)exp).getCharacter();
            return value == '\u0000';
        }
        return false;
    }

    private CAstNode convert(IGNUASTCompoundStatementExpression e) {
        CIdExpression tmp = this.createTemporaryVariable((IASTExpression)e);
        this.sideAssignmentStack.addConditionalExpression((IASTExpression)e, tmp);
        return tmp;
    }

    private CAstNode convertExpressionListAsExpression(IASTExpressionList e) {
        CIdExpression tmp = this.createTemporaryVariable((IASTExpression)e);
        this.sideAssignmentStack.addConditionalExpression((IASTExpression)e, tmp);
        return tmp;
    }

    private CArraySubscriptExpression convert(IASTArraySubscriptExpression e) {
        CExpression arrayExpr = this.convertExpressionWithoutSideEffects(e.getArrayExpression());
        CExpression subscriptExpr = this.convertExpressionWithoutSideEffects(this.toExpression(e.getArgument()));
        CType resultType = arrayExpr.getExpressionType();
        while (resultType instanceof CTypedefType) {
            resultType = ((CTypedefType)resultType).getRealType();
        }
        resultType = resultType instanceof CArrayType ? ((CArrayType)resultType).getType() : (resultType instanceof CPointerType ? ((CPointerType)resultType).getType() : this.typeConverter.convert(e.getExpressionType()));
        return new CArraySubscriptExpression(this.getLocation((IASTNode)e), resultType, arrayExpr, subscriptExpr);
    }

    private CIdExpression createTemporaryVariable(IASTExpression e) {
        CType type = this.typeConverter.convert(e.getExpressionType());
        if (type.getCanonicalType() instanceof CVoidType && e instanceof IASTFunctionCallExpression) {
            type = CNumericTypes.INT;
        }
        return this.createInitializedTemporaryVariable(this.getLocation((IASTNode)e), type, (CInitializer)null);
    }

    private CIdExpression createInitializedTemporaryVariable(FileLocation loc, CType pType, @Nullable CExpression initializer) {
        return this.createInitializedTemporaryVariable(loc, pType, initializer == null ? null : new CInitializerExpression(loc, initializer));
    }

    private CIdExpression createInitializedTemporaryVariable(FileLocation loc, CType pType, @Nullable CInitializer initializer) {
        String name = "__CPAchecker_TMP_";
        int i = 0;
        while (this.scope.variableNameInUse(name + i)) {
            ++i;
        }
        name = name + i;
        CType type = initializer == null ? CTypes.withoutConst(pType) : pType;
        CVariableDeclaration decl = new CVariableDeclaration(loc, this.scope.isGlobalScope(), CStorageClass.AUTO, type, name, name, this.scope.createScopedNameOf(name), initializer);
        this.scope.registerDeclaration(decl);
        this.sideAssignmentStack.addPreSideAssignment(decl);
        return new CIdExpression(loc, decl);
    }

    private CAstNode convert(IASTBinaryExpression e) {
        switch (e.getOperator()) {
            case 15: 
            case 16: {
                CIdExpression tmp = this.createTemporaryVariable((IASTExpression)e);
                this.sideAssignmentStack.addConditionalExpression((IASTExpression)e, tmp);
                return tmp;
            }
        }
        Pair<CBinaryExpression.BinaryOperator, Boolean> opPair = this.operatorConverter.convertBinaryOperator(e);
        CBinaryExpression.BinaryOperator op = (CBinaryExpression.BinaryOperator)opPair.getFirst();
        boolean isAssign = (Boolean)opPair.getSecond();
        FileLocation fileLoc = this.getLocation((IASTNode)e);
        CExpression leftHandSide = this.convertExpressionWithoutSideEffects(e.getOperand1());
        if (isAssign) {
            if (!(leftHandSide instanceof CLeftHandSide)) {
                throw new CFAGenerationRuntimeException("Lefthandside of Assignment " + e.getRawSignature() + " is no CLeftHandside but should be.", leftHandSide);
            }
            CLeftHandSide lhs = (CLeftHandSide)leftHandSide;
            if (op == null) {
                CAstNode rightHandSide = this.convertExpressionWithSideEffects(e.getOperand2());
                if (rightHandSide instanceof CExpression) {
                    return new CExpressionAssignmentStatement(fileLoc, lhs, (CExpression)rightHandSide);
                }
                if (rightHandSide instanceof CFunctionCallExpression) {
                    return new CFunctionCallAssignmentStatement(fileLoc, lhs, (CFunctionCallExpression)rightHandSide);
                }
                if (rightHandSide instanceof CAssignment) {
                    this.sideAssignmentStack.addPreSideAssignment(rightHandSide);
                    return new CExpressionAssignmentStatement(fileLoc, lhs, ((CAssignment)rightHandSide).getLeftHandSide());
                }
                throw new CFAGenerationRuntimeException("Expression is not free of side-effects", (IASTNode)e, this.niceFileNameFunction);
            }
            CExpression rightHandSide = this.convertExpressionWithoutSideEffects(e.getOperand2());
            CBinaryExpression exp = this.buildBinaryExpression(leftHandSide, rightHandSide, op);
            return new CExpressionAssignmentStatement(fileLoc, lhs, exp);
        }
        CExpression rightHandSide = this.convertExpressionWithoutSideEffects(e.getOperand2());
        return this.buildBinaryExpression(leftHandSide, rightHandSide, op);
    }

    private CBinaryExpression buildBinaryExpression(CExpression operand1, CExpression operand2, CBinaryExpression.BinaryOperator op) {
        try {
            return this.binExprBuilder.buildBinaryExpression(operand1, operand2, op);
        }
        catch (UnrecognizedCCodeException e) {
            throw new CFAGenerationRuntimeException(e);
        }
    }

    private static boolean isPointerToVoid(IASTExpression e) {
        return e.getExpressionType() instanceof IPointerType && ((IPointerType)e.getExpressionType()).getType() instanceof IBasicType && ((IBasicType)((IPointerType)e.getExpressionType()).getType()).getKind() == IBasicType.Kind.eVoid;
    }

    private static boolean isRightHandSide(IASTExpression e) {
        return e.getParent() instanceof IASTBinaryExpression && ((IASTBinaryExpression)e.getParent()).getOperator() == 17 && ((IASTBinaryExpression)e.getParent()).getOperand2() == e;
    }

    private CAstNode convert(IASTCastExpression e) {
        FileLocation loc = this.getLocation((IASTNode)e);
        CType castType = this.convert(e.getTypeId());
        if (e.getOperand() instanceof CASTFunctionCallExpression && castType.getCanonicalType() instanceof CPointerType && ASTConverter.isRightHandSide((IASTExpression)e) && ASTConverter.isPointerToVoid(e.getOperand())) {
            return this.convertExpressionWithSideEffects(e.getOperand());
        }
        CExpression operand = this.convertExpressionWithoutSideEffects(e.getOperand());
        if ("__imag__".equals(e.getTypeId().getRawSignature())) {
            return new CComplexCastExpression(loc, castType, operand, castType, false);
        }
        if ("__real__".equals(e.getTypeId().getRawSignature())) {
            return new CComplexCastExpression(loc, castType, operand, castType, true);
        }
        if (e.getOperand() instanceof IASTFieldReference && ((IASTFieldReference)e.getOperand()).isPointerDereference()) {
            return this.createInitializedTemporaryVariable(loc, castType, new CCastExpression(loc, castType, operand));
        }
        return new CCastExpression(loc, castType, operand);
    }

    private static boolean containsProblemType(CType type) {
        return type.accept(containsProblemTypeVisitor);
    }

    private CFieldReference convert(IASTFieldReference e) {
        CExpression fullFieldReference;
        CExpression owner = this.convertExpressionWithoutSideEffects(e.getFieldOwner());
        String fieldName = ASTConverter.convert(e.getFieldName());
        FileLocation loc = this.getLocation((IASTNode)e);
        CType ownerType = owner.getExpressionType().getCanonicalType();
        while (ownerType instanceof CPointerType) {
            ownerType = ((CPointerType)ownerType).getType().getCanonicalType();
        }
        Object wayToInnerField = ImmutableList.of();
        if (ownerType instanceof CElaboratedType) {
            assert (((CElaboratedType)ownerType).getRealType() == null);
            throw new CFAGenerationRuntimeException("Cannot access the field " + fieldName + " in type " + ownerType + " which does not have a definition", (IASTNode)e, this.niceFileNameFunction);
        }
        if (ownerType instanceof CProblemType) {
            fullFieldReference = new CFieldReference(loc, this.typeConverter.convert(e.getExpressionType()), fieldName, owner, e.isPointerDereference());
        } else {
            assert (ownerType instanceof CCompositeType) : "owner of field has no CCompositeType, but is a: " + ownerType.getClass() + " instead.";
            wayToInnerField = ASTConverter.getWayToInnerField(ownerType, fieldName, loc, new ArrayList<Pair<String, CType>>());
            if (!wayToInnerField.isEmpty()) {
                fullFieldReference = owner;
                boolean isPointerDereference = e.isPointerDereference();
                Iterator i$ = wayToInnerField.iterator();
                while (i$.hasNext()) {
                    Pair field = (Pair)i$.next();
                    fullFieldReference = new CFieldReference(loc, (CType)field.getSecond(), (String)field.getFirst(), fullFieldReference, isPointerDereference);
                    isPointerDereference = false;
                }
            } else {
                throw new CFAGenerationRuntimeException("Accessing unknown field " + fieldName + " in " + ownerType + " in file " + this.staticVariablePrefix.split("__")[0], (IASTNode)e, this.niceFileNameFunction);
            }
        }
        if (this.simplifyPointerExpressions && (wayToInnerField.size() > 1 || owner instanceof CFieldReference) && !this.scope.isGlobalScope()) {
            CExpression tmp = fullFieldReference;
            LinkedList<Pair> fields = new LinkedList<Pair>();
            while (tmp != owner) {
                fields.push(Pair.of((Object)tmp.getExpressionType(), (Object)((CFieldReference)tmp).getFieldName()));
                tmp = ((CFieldReference)tmp).getFieldOwner();
            }
            boolean isFirstVisit = true;
            while (!fields.isEmpty()) {
                CFieldReference tmpOwner;
                CPointerExpression exp;
                Pair actField = (Pair)fields.pop();
                if (fields.isEmpty()) {
                    if (isFirstVisit && e.isPointerDereference()) {
                        exp = new CPointerExpression(loc, owner.getExpressionType(), owner);
                        tmpOwner = new CFieldReference(loc, (CType)actField.getFirst(), (String)actField.getSecond(), exp, false);
                        owner = this.createInitializedTemporaryVariable(loc, tmpOwner.getExpressionType(), tmpOwner);
                        continue;
                    }
                    owner = new CFieldReference(loc, (CType)actField.getFirst(), (String)actField.getSecond(), owner, false);
                    continue;
                }
                if (isFirstVisit) {
                    if (e.isPointerDereference()) {
                        exp = new CPointerExpression(loc, owner.getExpressionType(), owner);
                        tmpOwner = new CFieldReference(loc, (CType)actField.getFirst(), (String)actField.getSecond(), exp, false);
                        owner = this.createInitializedTemporaryVariable(loc, tmpOwner.getExpressionType(), tmpOwner);
                    } else {
                        owner = new CFieldReference(loc, (CType)actField.getFirst(), (String)actField.getSecond(), owner, false);
                    }
                    isFirstVisit = false;
                    continue;
                }
                owner = new CFieldReference(loc, (CType)actField.getFirst(), (String)actField.getSecond(), owner, false);
            }
            return (CFieldReference)owner;
        }
        if (this.simplifyPointerExpressions && e.isPointerDereference()) {
            CType newType = null;
            CType typeDefType = owner.getExpressionType();
            while (typeDefType instanceof CTypedefType) {
                typeDefType = ((CTypedefType)typeDefType).getRealType();
            }
            if (!(typeDefType instanceof CPointerType)) {
                throw new CFAGenerationRuntimeException("The owner of the struct with field dereference has an invalid type", owner);
            }
            newType = ((CPointerType)typeDefType).getType();
            CPointerExpression exp = new CPointerExpression(loc, newType, owner);
            return new CFieldReference(loc, fullFieldReference.getExpressionType(), fieldName, exp, false);
        }
        return fullFieldReference;
    }

    private static List<Pair<String, CType>> getWayToInnerField(CType owner, String fieldName, FileLocation loc, List<Pair<String, CType>> allReferences) {
        CType type = owner.getCanonicalType();
        if (type instanceof CCompositeType) {
            for (CCompositeType.CCompositeTypeMemberDeclaration member : ((CCompositeType)type).getMembers()) {
                if (!member.getName().equals(fieldName)) continue;
                allReferences.add((Pair<String, CType>)Pair.of((Object)member.getName(), (Object)member.getType()));
                return allReferences;
            }
            for (CCompositeType.CCompositeTypeMemberDeclaration member : ((CCompositeType)type).getMembers()) {
                if (!member.getName().contains("__anon_type_member_")) continue;
                List<Pair<String, CType>> tmp = new ArrayList<Pair<String, CType>>(allReferences);
                tmp.add((Pair<String, CType>)Pair.of((Object)member.getName(), (Object)member.getType()));
                tmp = ASTConverter.getWayToInnerField(member.getType(), fieldName, loc, tmp);
                if (tmp.isEmpty()) continue;
                return tmp;
            }
        }
        return Collections.emptyList();
    }

    private CRightHandSide convert(IASTFunctionCallExpression e) {
        CType functionNameType;
        ArrayList<CExpression> params;
        CExpression functionName = this.convertExpressionWithoutSideEffects(e.getFunctionNameExpression());
        CFunctionDeclaration declaration = null;
        if (functionName instanceof CIdExpression && ((CIdExpression)functionName).getName().equals("__builtin_types_compatible_p")) {
            this.sideAssignmentStack.enterBlock();
            params = new ArrayList();
            for (IASTInitializerClause i : e.getArguments()) {
                params.add(this.convertExpressionWithoutSideEffects(this.toExpression(i)));
            }
            this.sideAssignmentStack.getAndResetConditionalExpressions();
            this.sideAssignmentStack.getAndResetPostSideAssignments();
            this.sideAssignmentStack.getAndResetPreSideAssignments();
            this.sideAssignmentStack.leaveBlock();
            if (params.size() == 2) {
                if (this.areCompatibleTypes(((CExpression)params.get(0)).getExpressionType(), ((CExpression)params.get(1)).getExpressionType())) {
                    return CIntegerLiteralExpression.ONE;
                }
                return CIntegerLiteralExpression.ZERO;
            }
        }
        params = new ArrayList<CExpression>();
        for (IASTInitializerClause i : e.getArguments()) {
            params.add(this.convertExpressionWithoutSideEffects(this.toExpression(i)));
        }
        if (functionName instanceof CIdExpression) {
            if (((CIdExpression)functionName).getName().equals("__builtin_constant_p") && params.size() == 1 && this.scope.lookupFunction("__builtin_constant_p") == null) {
                if (params.get(0) instanceof CLiteralExpression) {
                    return CIntegerLiteralExpression.ONE;
                }
                return CIntegerLiteralExpression.ZERO;
            }
            CSimpleDeclaration d = ((CIdExpression)functionName).getDeclaration();
            if (d instanceof CFunctionDeclaration) {
                declaration = (CFunctionDeclaration)d;
            }
            if (declaration == null && ((CIdExpression)functionName).getName().equals("__builtin_expect") && params.size() == 2) {
                return this.buildBinaryExpression((CExpression)params.get(0), (CExpression)params.get(1), CBinaryExpression.BinaryOperator.EQUALS);
            }
        }
        if ((functionNameType = functionName.getExpressionType().getCanonicalType()) instanceof CPointerType && ((CPointerType)functionNameType).getType() instanceof CFunctionType) {
            functionName = new CPointerExpression(functionName.getFileLocation(), ((CPointerType)functionNameType).getType(), functionName);
        }
        FileLocation loc = this.getLocation((IASTNode)e);
        CType returnType = this.typeConverter.convert(e.getExpressionType());
        if (ASTConverter.containsProblemType(returnType)) {
            if (declaration != null) {
                returnType = declaration.getType().getReturnType();
                this.logger.log(Level.FINE, new Object[]{loc + ":", "Replacing return type", returnType, "of function call", e.getRawSignature(), "with", returnType});
            } else {
                CType functionType = functionName.getExpressionType().getCanonicalType();
                if (functionType instanceof CFunctionType) {
                    returnType = ((CFunctionType)functionType).getReturnType();
                    this.logger.log(Level.FINE, new Object[]{loc + ":", "Replacing return type", returnType, "of function call", e.getRawSignature(), "with", returnType});
                }
            }
        }
        if (declaration == null && functionName instanceof CIdExpression && returnType instanceof CVoidType) {
            this.logger.log(Level.FINE, new Object[]{loc + ":", "Setting return type of of undeclared function", functionName, "to int."});
            returnType = CNumericTypes.INT;
        }
        return new CFunctionCallExpression(loc, returnType, functionName, params, declaration);
    }

    private boolean areCompatibleTypes(CType a, CType b) {
        if ((a = CTypes.withoutConst(CTypes.withoutVolatile(a.getCanonicalType()))).equals(b = CTypes.withoutConst(CTypes.withoutVolatile(b.getCanonicalType())))) {
            return true;
        }
        if (a instanceof CArrayType && b instanceof CArrayType) {
            CArrayType arrayA = (CArrayType)a;
            CArrayType arrayB = (CArrayType)b;
            if (arrayA.getType().equals(arrayB.getType()) && (arrayA.getLength() == null || arrayB.getLength() == null)) {
                return true;
            }
        }
        return false;
    }

    private CIdExpression convert(IASTIdExpression e) {
        CEnumType enumType;
        String name = ASTConverter.convert(e.getName());
        CSimpleDeclaration declaration = this.scope.lookupVariable(this.staticVariablePrefix + name);
        if (declaration == null) {
            declaration = this.scope.lookupVariable(name);
        }
        if (declaration == null) {
            declaration = this.scope.lookupFunction(this.staticVariablePrefix + name);
        }
        if (declaration == null) {
            declaration = this.scope.lookupFunction(name);
        }
        if (declaration != null) {
            name = declaration.getName();
        }
        CType type = declaration != null ? declaration.getType() : this.typeConverter.convert(e.getExpressionType());
        if (declaration instanceof CEnumType.CEnumerator && type instanceof CElaboratedType && ((CElaboratedType)type).getKind() == CComplexType.ComplexTypeKind.ENUM && ((CElaboratedType)type).getRealType() == null && (enumType = ((CEnumType.CEnumerator)declaration).getEnum()) != null) {
            type = new CElaboratedType(type.isConst(), type.isVolatile(), CComplexType.ComplexTypeKind.ENUM, enumType.getName(), enumType.getOrigName(), enumType);
        }
        return new CIdExpression(this.getLocation((IASTNode)e), type, name, declaration);
    }

    private CAstNode convert(IASTUnaryExpression e) {
        if (e.getOperator() == 11) {
            return this.convertExpressionWithSideEffects(e.getOperand());
        }
        CExpression operand = this.convertExpressionWithoutSideEffects(e.getOperand());
        FileLocation fileLoc = this.getLocation((IASTNode)e);
        CType operandType = operand.getExpressionType();
        switch (e.getOperator()) {
            case 11: {
                throw new AssertionError((Object)"handled above");
            }
            case 2: {
                return operand;
            }
            case 4: {
                CType type;
                if (operandType instanceof CPointerType) {
                    type = ((CPointerType)operand.getExpressionType()).getType();
                } else if (operandType instanceof CArrayType) {
                    type = ((CArrayType)operand.getExpressionType()).getType();
                } else {
                    this.logger.logf(Level.WARNING, "Dereferencing of a non-pointer in expression %s (%s)", new Object[]{e.getRawSignature(), operand.getExpressionType().toString()});
                    type = this.typeConverter.convert(e.getExpressionType());
                }
                return this.simplifyUnaryPointerExpression(operand, fileLoc, type);
            }
            case 5: {
                if (this.simplifyPointerExpressions && operand instanceof CPointerExpression) {
                    return ((CPointerExpression)operand).getOperand();
                }
                CType type = this.typeConverter.convert(e.getExpressionType());
                if (ASTConverter.containsProblemType(type)) {
                    type = new CPointerType(true, false, operandType);
                }
                return new CUnaryExpression(fileLoc, type, operand, CUnaryExpression.UnaryOperator.AMPER);
            }
            case 18: {
                if (!(operand instanceof CIdExpression)) {
                    throw new CFAGenerationRuntimeException("Invalid operand for address-of-label operator", (IASTNode)e, this.niceFileNameFunction);
                }
                String labelName = ((CIdExpression)operand).getName();
                return new CAddressOfLabelExpression(fileLoc, CPointerType.POINTER_TO_VOID, labelName);
            }
            case 0: 
            case 1: {
                CBinaryExpression.BinaryOperator preOp;
                switch (e.getOperator()) {
                    case 0: {
                        preOp = CBinaryExpression.BinaryOperator.PLUS;
                        break;
                    }
                    case 1: {
                        preOp = CBinaryExpression.BinaryOperator.MINUS;
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
                CBinaryExpression preExp = this.buildBinaryExpression(operand, CIntegerLiteralExpression.ONE, preOp);
                CLeftHandSide lhsPre = (CLeftHandSide)operand;
                return new CExpressionAssignmentStatement(fileLoc, lhsPre, preExp);
            }
            case 9: 
            case 10: {
                CBinaryExpression.BinaryOperator postOp;
                switch (e.getOperator()) {
                    case 9: {
                        postOp = CBinaryExpression.BinaryOperator.PLUS;
                        break;
                    }
                    case 10: {
                        postOp = CBinaryExpression.BinaryOperator.MINUS;
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
                CBinaryExpression postExp = this.buildBinaryExpression(operand, CIntegerLiteralExpression.ONE, postOp);
                CLeftHandSide lhsPost = (CLeftHandSide)operand;
                CExpressionAssignmentStatement result = new CExpressionAssignmentStatement(fileLoc, lhsPost, postExp);
                if (e.getParent() instanceof IASTForStatement && e.getPropertyInParent() == IASTForStatement.ITERATION) {
                    return result;
                }
                CIdExpression tmp = this.createInitializedTemporaryVariable(fileLoc, lhsPost.getExpressionType(), lhsPost);
                this.sideAssignmentStack.addPreSideAssignment(result);
                return tmp;
            }
            case 7: {
                return this.simplifyUnaryNotExpression(operand);
            }
        }
        CType type = this.typeConverter.convert(e.getExpressionType());
        return new CUnaryExpression(fileLoc, type, operand, this.operatorConverter.convertUnaryOperator(e));
    }

    private static CBinaryExpression.BinaryOperator getNegatedOperator(CBinaryExpression.BinaryOperator op) {
        switch (op) {
            case EQUALS: {
                return CBinaryExpression.BinaryOperator.NOT_EQUALS;
            }
            case NOT_EQUALS: {
                return CBinaryExpression.BinaryOperator.EQUALS;
            }
            case LESS_THAN: {
                return CBinaryExpression.BinaryOperator.GREATER_EQUAL;
            }
            case LESS_EQUAL: {
                return CBinaryExpression.BinaryOperator.GREATER_THAN;
            }
            case GREATER_THAN: {
                return CBinaryExpression.BinaryOperator.LESS_EQUAL;
            }
            case GREATER_EQUAL: {
                return CBinaryExpression.BinaryOperator.LESS_THAN;
            }
        }
        throw new AssertionError((Object)"operator can not be negated");
    }

    private CExpression simplifyUnaryNotExpression(CExpression expr) {
        CBinaryExpression binExpr;
        if (expr instanceof CBinaryExpression && CBinaryExpressionBuilder.relationalOperators.contains((binExpr = (CBinaryExpression)expr).getOperator())) {
            CBinaryExpression.BinaryOperator inverseOperator = ASTConverter.getNegatedOperator(binExpr.getOperator());
            return this.buildBinaryExpression(binExpr.getOperand1(), binExpr.getOperand2(), inverseOperator);
        }
        return this.buildBinaryExpression(CIntegerLiteralExpression.ZERO, expr, CBinaryExpression.BinaryOperator.EQUALS);
    }

    private CExpression simplifyUnaryPointerExpression(CExpression operand, FileLocation fileLoc, CType type) {
        if (this.simplifyPointerExpressions) {
            CType operandType = operand.getExpressionType();
            if (operand instanceof CFieldReference) {
                CIdExpression tmpVar = this.createInitializedTemporaryVariable(fileLoc, operandType, operand);
                return new CPointerExpression(fileLoc, type, tmpVar);
            }
            if (operand instanceof CArraySubscriptExpression) {
                CIdExpression tmpVar = this.createInitializedTemporaryVariable(fileLoc, operandType, operand);
                return new CPointerExpression(fileLoc, type, tmpVar);
            }
            if (operand instanceof CUnaryExpression && ((CUnaryExpression)operand).getOperator() == CUnaryExpression.UnaryOperator.AMPER) {
                return ((CUnaryExpression)operand).getOperand();
            }
            if (operand instanceof CPointerExpression) {
                CIdExpression tmpVar = this.createInitializedTemporaryVariable(fileLoc, operandType, operand);
                return new CPointerExpression(fileLoc, type, tmpVar);
            }
            if (operand instanceof CBinaryExpression) {
                CIdExpression tmpVar = this.createInitializedTemporaryVariable(fileLoc, operandType, operand);
                return new CPointerExpression(fileLoc, type, tmpVar);
            }
        }
        return new CPointerExpression(fileLoc, type, operand);
    }

    private CTypeIdExpression convert(IASTTypeIdExpression e) {
        return new CTypeIdExpression(this.getLocation((IASTNode)e), this.typeConverter.convert(e.getExpressionType()), this.operatorConverter.convertTypeIdOperator(e), this.convert(e.getTypeId()));
    }

    private CExpression convert(IASTTypeIdInitializerExpression e) {
        FileLocation fileLoc = this.getLocation((IASTNode)e);
        CType type = this.convert(e.getTypeId());
        CInitializer initializer = this.convert(e.getInitializer(), null);
        return this.createInitializedTemporaryVariable(fileLoc, type, initializer);
    }

    public CAstNode convert(IASTStatement s) {
        if (s instanceof IASTExpressionStatement) {
            return this.convert((IASTExpressionStatement)s);
        }
        if (s instanceof IASTReturnStatement) {
            return this.convert((IASTReturnStatement)s);
        }
        if (s instanceof IASTProblemStatement) {
            throw new CFAGenerationRuntimeException((IASTProblemStatement)s, this.niceFileNameFunction);
        }
        throw new CFAGenerationRuntimeException("unknown statement: " + s.getClass(), (IASTNode)s, this.niceFileNameFunction);
    }

    public CStatement convert(IASTExpressionStatement s) {
        return this.convertExpressionToStatement(s.getExpression());
    }

    public CStatement convertExpressionToStatement(IASTExpression e) {
        CAstNode node = this.convertExpressionWithSideEffects(e);
        if (node instanceof CExpressionAssignmentStatement) {
            return (CExpressionAssignmentStatement)node;
        }
        if (node instanceof CFunctionCallAssignmentStatement) {
            return (CFunctionCallAssignmentStatement)node;
        }
        if (node instanceof CFunctionCallExpression) {
            return new CFunctionCallStatement(this.getLocation((IASTNode)e), (CFunctionCallExpression)node);
        }
        if (node instanceof CExpression) {
            return new CExpressionStatement(this.getLocation((IASTNode)e), (CExpression)node);
        }
        throw new AssertionError();
    }

    public CReturnStatement convert(IASTReturnStatement s) {
        Optional returnAssignment;
        FileLocation loc = this.getLocation((IASTNode)s);
        Optional returnExp = Optional.fromNullable((Object)this.convertExpressionWithoutSideEffects(s.getReturnValue()));
        Optional<CVariableDeclaration> returnVariableDeclaration = ((FunctionScope)this.scope).getReturnVariable();
        if (returnVariableDeclaration.isPresent()) {
            CIdExpression lhs = new CIdExpression(loc, (CSimpleDeclaration)returnVariableDeclaration.get());
            CExpression rhs = null;
            if (returnExp.isPresent()) {
                rhs = (CExpression)returnExp.get();
            } else {
                this.logger.log(Level.WARNING, new Object[]{loc + ":", "Return statement without expression in non-void function."});
                CInitializer defaultValue = CDefaults.forType(((CVariableDeclaration)returnVariableDeclaration.get()).getType(), loc);
                if (defaultValue instanceof CInitializerExpression) {
                    rhs = ((CInitializerExpression)defaultValue).getExpression();
                }
            }
            returnAssignment = rhs != null ? Optional.of((Object)new CExpressionAssignmentStatement(loc, lhs, rhs)) : Optional.absent();
        } else {
            if (returnExp.isPresent()) {
                this.logger.log(Level.WARNING, new Object[]{loc + ":", "Return statement with expression", returnExp.get(), "in void function."});
            }
            returnAssignment = Optional.absent();
        }
        return new CReturnStatement(loc, (Optional<CExpression>)returnExp, (Optional<CAssignment>)returnAssignment);
    }

    public CFunctionDeclaration convert(IASTFunctionDefinition f) {
        Pair<CStorageClass, ? extends CType> specifier = this.convert(f.getDeclSpecifier());
        CStorageClass cStorageClass = (CStorageClass)((Object)specifier.getFirst());
        if (cStorageClass != CStorageClass.AUTO && cStorageClass != CStorageClass.STATIC && cStorageClass != CStorageClass.EXTERN) {
            throw new CFAGenerationRuntimeException("Unsupported storage class for function definition", (IASTNode)f, this.niceFileNameFunction);
        }
        Triple<CType, IASTInitializer, String> declarator = this.convert(f.getDeclarator(), (CType)specifier.getSecond(), cStorageClass == CStorageClass.STATIC);
        if (!(declarator.getFirst() instanceof CFunctionTypeWithNames)) {
            throw new CFAGenerationRuntimeException("Unsupported nested declarator for function definition", (IASTNode)f, this.niceFileNameFunction);
        }
        if (declarator.getSecond() != null) {
            throw new CFAGenerationRuntimeException("Unsupported initializer for function definition", (IASTNode)f, this.niceFileNameFunction);
        }
        if (declarator.getThird() == null) {
            throw new CFAGenerationRuntimeException("Missing name for function definition", (IASTNode)f, this.niceFileNameFunction);
        }
        CFunctionTypeWithNames declSpec = (CFunctionTypeWithNames)declarator.getFirst();
        return new CFunctionDeclaration(this.getLocation((IASTNode)f), declSpec, (String)declarator.getThird(), declSpec.getParameterDeclarations());
    }

    public List<CDeclaration> convert(IASTSimpleDeclaration d) {
        FileLocation fileLoc = this.getLocation((IASTNode)d);
        Pair<CStorageClass, ? extends CType> specifier = this.convert(d.getDeclSpecifier());
        CStorageClass cStorageClass = (CStorageClass)((Object)specifier.getFirst());
        CType type = (CType)specifier.getSecond();
        IASTDeclarator[] declarators = d.getDeclarators();
        ArrayList<CDeclaration> result = new ArrayList<CDeclaration>();
        if (type instanceof CCompositeType || type instanceof CEnumType) {
            CComplexType complexType = (CComplexType)type;
            CComplexTypeDeclaration newD = new CComplexTypeDeclaration(fileLoc, this.scope.isGlobalScope(), complexType);
            result.add(newD);
            type = new CElaboratedType(type.isConst(), type.isVolatile(), complexType.getKind(), complexType.getName(), complexType.getOrigName(), newD.getType());
        } else if (type instanceof CElaboratedType) {
            boolean variableDeclaration;
            boolean typeAlreadyKnown = this.scope.lookupType(((CElaboratedType)type).getQualifiedName()) != null;
            boolean bl = variableDeclaration = declarators != null && declarators.length > 0;
            if (!typeAlreadyKnown || !variableDeclaration) {
                CComplexTypeDeclaration newD = new CComplexTypeDeclaration(fileLoc, this.scope.isGlobalScope(), (CElaboratedType)type);
                result.add(newD);
            }
        }
        if (declarators != null) {
            for (IASTDeclarator c : declarators) {
                result.add(this.createDeclaration(fileLoc, cStorageClass, type, c));
            }
        }
        return result;
    }

    private CDeclaration createDeclaration(FileLocation fileLoc, CStorageClass cStorageClass, CType type, IASTDeclarator d) {
        boolean isGlobal = this.scope.isGlobalScope();
        if (d != null) {
            Triple<CType, IASTInitializer, String> declarator = this.convert(d, type);
            type = (CType)declarator.getFirst();
            IASTInitializer initializer = (IASTInitializer)declarator.getSecond();
            String name = (String)declarator.getThird();
            if (name == null) {
                throw new CFAGenerationRuntimeException("Declaration without name", (IASTNode)d, this.niceFileNameFunction);
            }
            if (cStorageClass == CStorageClass.TYPEDEF) {
                if (initializer != null) {
                    throw new CFAGenerationRuntimeException("Typedef with initializer", (IASTNode)d, this.niceFileNameFunction);
                }
                return new CTypeDefDeclaration(fileLoc, isGlobal, type, name, this.scope.createScopedNameOf(name));
            }
            while (type instanceof CTypedefType) {
                type = ((CTypedefType)type).getRealType();
            }
            if (type instanceof CFunctionType) {
                List<CParameterDeclaration> params;
                if (initializer != null) {
                    throw new CFAGenerationRuntimeException("Function definition with initializer", (IASTNode)d, this.niceFileNameFunction);
                }
                CFunctionType functionType = (CFunctionType)type;
                if (functionType instanceof CFunctionTypeWithNames) {
                    params = ((CFunctionTypeWithNames)functionType).getParameterDeclarations();
                } else {
                    params = new ArrayList<CParameterDeclaration>(functionType.getParameters().size());
                    int i = 0;
                    for (CType paramType : functionType.getParameters()) {
                        params.add(new CParameterDeclaration(fileLoc, paramType, "__param" + i++));
                    }
                }
                return new CFunctionDeclaration(fileLoc, functionType, name, params);
            }
            if (cStorageClass == CStorageClass.EXTERN && initializer != null) {
                throw new CFAGenerationRuntimeException("Extern declarations cannot have initializers", (IASTNode)d, this.niceFileNameFunction);
            }
            String origName = name;
            if (cStorageClass == CStorageClass.STATIC) {
                if (!isGlobal) {
                    isGlobal = true;
                    name = "static__" + ((FunctionScope)this.scope).getCurrentFunctionName() + "__" + name;
                } else {
                    name = this.staticVariablePrefix + name;
                }
                cStorageClass = CStorageClass.AUTO;
            }
            if (!isGlobal && this.scope.variableNameInUse(name)) {
                String sep = "__";
                int index = 1;
                while (this.scope.variableNameInUse(name + sep + index)) {
                    ++index;
                }
                name = name + sep + index;
            }
            CVariableDeclaration declaration = new CVariableDeclaration(fileLoc, isGlobal, cStorageClass, type, name, origName, this.scope.createScopedNameOf(name), null);
            this.scope.registerDeclaration(declaration);
            declaration.addInitializer(this.convert(initializer, declaration));
            return declaration;
        }
        throw new CFAGenerationRuntimeException("Declaration without declarator, but type is unknown: " + type.toASTString(""));
    }

    private List<CCompositeType.CCompositeTypeMemberDeclaration> convertDeclarationInCompositeType(IASTDeclaration d) {
        List<CCompositeType.CCompositeTypeMemberDeclaration> result;
        IASTDeclarator[] declarators;
        if (d instanceof IASTProblemDeclaration) {
            throw new CFAGenerationRuntimeException((IASTProblemDeclaration)d, this.niceFileNameFunction);
        }
        if (!(d instanceof IASTSimpleDeclaration)) {
            throw new CFAGenerationRuntimeException("unknown declaration type " + d.getClass().getSimpleName(), (IASTNode)d, this.niceFileNameFunction);
        }
        IASTSimpleDeclaration sd = (IASTSimpleDeclaration)d;
        Pair<CStorageClass, ? extends CType> specifier = this.convert(sd.getDeclSpecifier());
        if (specifier.getFirst() != CStorageClass.AUTO) {
            throw new CFAGenerationRuntimeException("Unsupported storage class inside composite type", (IASTNode)d, this.niceFileNameFunction);
        }
        CType type = (CType)specifier.getSecond();
        if (type instanceof CCompositeType) {
            CCompositeType compositeType = (CCompositeType)type;
            this.addSideEffectDeclarationForType(compositeType, this.getLocation((IASTNode)d));
            type = new CElaboratedType(compositeType.isConst(), compositeType.isVolatile(), compositeType.getKind(), compositeType.getName(), compositeType.getOrigName(), compositeType);
        }
        if ((declarators = sd.getDeclarators()) == null || declarators.length == 0) {
            CCompositeType.CCompositeTypeMemberDeclaration newD = this.createDeclarationForCompositeType(type, null);
            result = Collections.singletonList(newD);
        } else if (declarators.length == 1) {
            CCompositeType.CCompositeTypeMemberDeclaration newD = this.createDeclarationForCompositeType(type, declarators[0]);
            result = Collections.singletonList(newD);
        } else {
            result = new ArrayList<CCompositeType.CCompositeTypeMemberDeclaration>(declarators.length);
            for (IASTDeclarator c : declarators) {
                result.add(this.createDeclarationForCompositeType(type, c));
            }
        }
        return result;
    }

    private CCompositeType.CCompositeTypeMemberDeclaration createDeclarationForCompositeType(CType type, IASTDeclarator d) {
        String name = null;
        if (d != null) {
            Triple<CType, IASTInitializer, String> declarator = this.convert(d, type);
            if (declarator.getSecond() != null) {
                throw new CFAGenerationRuntimeException("Unsupported initializer inside composite type", (IASTNode)d, this.niceFileNameFunction);
            }
            type = (CType)declarator.getFirst();
            name = (String)declarator.getThird();
        }
        if (name == null) {
            name = "__anon_type_member_" + anonTypeMemberCounter++;
        }
        return new CCompositeType.CCompositeTypeMemberDeclaration(type, name);
    }

    private Triple<CType, IASTInitializer, String> convert(IASTDeclarator d, CType specifier) {
        IASTInitializerClause initClause;
        CArrayType arrayType;
        if (d instanceof IASTFunctionDeclarator) {
            return this.convert((IASTFunctionDeclarator)d, specifier, false);
        }
        ArrayList modifiers = Lists.newArrayListWithExpectedSize((int)1);
        IASTInitializer initializer = null;
        String name = null;
        for (IASTDeclarator currentDecl = d; currentDecl != null; currentDecl = currentDecl.getNestedDeclarator()) {
            if (currentDecl instanceof IASTFunctionDeclarator) {
                throw new CFAGenerationRuntimeException("Unsupported declaration nested function declarations", (IASTNode)d, this.niceFileNameFunction);
            }
            modifiers.addAll(Arrays.asList(currentDecl.getPointerOperators()));
            if (currentDecl instanceof IASTArrayDeclarator) {
                modifiers.addAll(Arrays.asList(((IASTArrayDeclarator)currentDecl).getArrayModifiers()));
            }
            if (currentDecl.getInitializer() != null) {
                if (initializer != null) {
                    throw new CFAGenerationRuntimeException("Unsupported declaration with two initializers", (IASTNode)d, this.niceFileNameFunction);
                }
                initializer = currentDecl.getInitializer();
            }
            if (currentDecl.getName().toString().isEmpty()) continue;
            if (name != null) {
                throw new CFAGenerationRuntimeException("Unsupported declaration with two names", (IASTNode)d, this.niceFileNameFunction);
            }
            name = ASTConverter.convert(currentDecl.getName());
        }
        name = Strings.nullToEmpty(name);
        CType type = specifier;
        ArrayList tmpArrMod = Lists.newArrayListWithExpectedSize((int)1);
        for (IASTNode modifier : modifiers) {
            if (modifier instanceof IASTArrayModifier) {
                tmpArrMod.add((IASTArrayModifier)modifier);
                continue;
            }
            if (modifier instanceof IASTPointerOperator) {
                for (int i = tmpArrMod.size() - 1; i >= 0; --i) {
                    type = this.convert((IASTArrayModifier)tmpArrMod.get(i), type);
                }
                tmpArrMod.clear();
                type = this.typeConverter.convert((IASTPointerOperator)modifier, type);
                continue;
            }
            assert (false);
        }
        for (int i = tmpArrMod.size() - 1; i >= 0; --i) {
            type = this.convert((IASTArrayModifier)tmpArrMod.get(i), type);
        }
        if (type instanceof CArrayType && (arrayType = (CArrayType)type).getLength() == null && initializer instanceof IASTEqualsInitializer && (initClause = ((IASTEqualsInitializer)initializer).getInitializerClause()) instanceof IASTInitializerList) {
            int length = 0;
            int position = 0;
            block4: for (IASTInitializerClause x : ((IASTInitializerList)initClause).getClauses()) {
                if (length == -1) break;
                if (x instanceof ICASTDesignatedInitializer) {
                    for (ICASTDesignator designator : ((ICASTDesignatedInitializer)x).getDesignators()) {
                        if (designator instanceof CASTArrayRangeDesignator) {
                            CAstNode ceil = this.convertExpressionWithSideEffects(((CASTArrayRangeDesignator)designator).getRangeCeiling());
                            if (ceil instanceof CIntegerLiteralExpression) {
                                int c = ((CIntegerLiteralExpression)ceil).getValue().intValue();
                                length = Math.max(length, c + 1);
                                position = c + 1;
                                continue;
                            }
                            length = -1;
                            continue block4;
                        }
                        if (designator instanceof CASTArrayDesignator) {
                            CAstNode subscript = this.convertExpressionWithSideEffects(((CASTArrayDesignator)designator).getSubscriptExpression());
                            int s = ((CIntegerLiteralExpression)subscript).getValue().intValue();
                            length = Math.max(length, s + 1);
                            position = s + 1;
                            continue;
                        }
                        length = -1;
                        continue block4;
                    }
                    continue;
                }
                length = Math.max(++position, length);
            }
            if (length != -1) {
                CIntegerLiteralExpression lengthExp = new CIntegerLiteralExpression(this.getLocation((IASTNode)initializer), CNumericTypes.INT, BigInteger.valueOf(length));
                type = new CArrayType(arrayType.isConst(), arrayType.isVolatile(), arrayType.getType(), lengthExp);
            }
        }
        return Triple.of((Object)type, (Object)initializer, (Object)name);
    }

    private CType convert(IASTArrayModifier am, CType type) {
        if (am instanceof ICASTArrayModifier) {
            ICASTArrayModifier a = (ICASTArrayModifier)am;
            CExpression lengthExp = this.convertExpressionWithoutSideEffects(a.getConstantExpression());
            if (lengthExp != null) {
                lengthExp = this.simplifyExpressionRecursively(lengthExp);
            }
            return new CArrayType(a.isConst(), a.isVolatile(), type, lengthExp);
        }
        throw new CFAGenerationRuntimeException("Unknown array modifier", (IASTNode)am, this.niceFileNameFunction);
    }

    private Triple<CType, IASTInitializer, String> convert(IASTFunctionDeclarator d, CType returnType, boolean isStaticFunction) {
        String name;
        CFunctionTypeWithNames fType;
        CSimpleType t;
        if (!(d instanceof IASTStandardFunctionDeclarator)) {
            throw new CFAGenerationRuntimeException("Unknown non-standard function definition", (IASTNode)d, this.niceFileNameFunction);
        }
        IASTStandardFunctionDeclarator sd = (IASTStandardFunctionDeclarator)d;
        returnType = this.typeConverter.convertPointerOperators(d.getPointerOperators(), returnType);
        if (returnType instanceof CSimpleType && (t = (CSimpleType)returnType).getType() == CBasicType.UNSPECIFIED) {
            returnType = new CSimpleType(t.isConst(), t.isVolatile(), CBasicType.INT, t.isLong(), t.isShort(), t.isSigned(), t.isUnsigned(), t.isComplex(), t.isImaginary(), t.isLongLong());
        }
        List<CParameterDeclaration> paramsList = this.convert(sd.getParameters());
        CType type = fType = new CFunctionTypeWithNames(false, false, returnType, paramsList, sd.takesVarArgs());
        if (d.getNestedDeclarator() != null) {
            Triple<CType, IASTInitializer, String> nestedDeclarator = this.convert(d.getNestedDeclarator(), type);
            assert (d.getName().getRawSignature().isEmpty()) : d;
            assert (nestedDeclarator.getSecond() == null);
            type = (CType)nestedDeclarator.getFirst();
            name = (String)nestedDeclarator.getThird();
        } else {
            name = ASTConverter.convert(d.getName());
        }
        if (isStaticFunction) {
            name = this.staticVariablePrefix + name;
        }
        fType.setName(name);
        for (CParameterDeclaration param : paramsList) {
            param.setQualifiedName(FunctionScope.createQualifiedName(name, param.getName()));
        }
        return Triple.of((Object)type, (Object)d.getInitializer(), (Object)name);
    }

    private Pair<CStorageClass, ? extends CType> convert(IASTDeclSpecifier d) {
        CStorageClass sc = this.typeConverter.convertCStorageClass(d);
        if (d instanceof IASTCompositeTypeSpecifier) {
            return Pair.of((Object)((Object)sc), (Object)this.convert((IASTCompositeTypeSpecifier)d));
        }
        if (d instanceof IASTElaboratedTypeSpecifier) {
            return Pair.of((Object)((Object)sc), (Object)this.typeConverter.convert((IASTElaboratedTypeSpecifier)d));
        }
        if (d instanceof IASTEnumerationSpecifier) {
            return Pair.of((Object)((Object)sc), (Object)this.convert((IASTEnumerationSpecifier)d));
        }
        if (d instanceof IASTNamedTypeSpecifier) {
            return Pair.of((Object)((Object)sc), (Object)this.typeConverter.convert((IASTNamedTypeSpecifier)d));
        }
        if (d instanceof IASTSimpleDeclSpecifier) {
            return Pair.of((Object)((Object)sc), (Object)this.typeConverter.convert((IASTSimpleDeclSpecifier)d));
        }
        throw new CFAGenerationRuntimeException("unknown declSpecifier", (IASTNode)d, this.niceFileNameFunction);
    }

    private CCompositeType convert(IASTCompositeTypeSpecifier d) {
        String name;
        CComplexType.ComplexTypeKind kind;
        ArrayList<CCompositeType.CCompositeTypeMemberDeclaration> list = new ArrayList<CCompositeType.CCompositeTypeMemberDeclaration>(d.getMembers().length);
        for (IASTDeclaration c : d.getMembers()) {
            List<CCompositeType.CCompositeTypeMemberDeclaration> newCs = this.convertDeclarationInCompositeType(c);
            assert (!newCs.isEmpty());
            list.addAll(newCs);
        }
        switch (d.getKey()) {
            case 1: {
                kind = CComplexType.ComplexTypeKind.STRUCT;
                break;
            }
            case 2: {
                kind = CComplexType.ComplexTypeKind.UNION;
                break;
            }
            default: {
                throw new CFAGenerationRuntimeException("Unknown key " + d.getKey() + " for composite type", (IASTNode)d, this.niceFileNameFunction);
            }
        }
        String origName = name = ASTConverter.convert(d.getName());
        if (Strings.isNullOrEmpty((String)name)) {
            name = "__anon_type_" + anonTypeCounter++;
        }
        if (origName == null) {
            origName = "";
        }
        CCompositeType compositeType = new CCompositeType(d.isConst(), d.isVolatile(), kind, list, name, origName);
        compositeType.accept(new FillInBindingVisitor(kind, name, compositeType));
        return compositeType;
    }

    private CEnumType convert(IASTEnumerationSpecifier d) {
        String name;
        ArrayList<CEnumType.CEnumerator> list = new ArrayList<CEnumType.CEnumerator>(d.getEnumerators().length);
        Long lastValue = -1L;
        for (IASTEnumerationSpecifier.IASTEnumerator c : d.getEnumerators()) {
            CEnumType.CEnumerator newC = this.convert(c, lastValue);
            list.add(newC);
            lastValue = newC.hasValue() ? Long.valueOf(newC.getValue()) : null;
        }
        String origName = name = ASTConverter.convert(d.getName());
        if (name.isEmpty()) {
            name = "__anon_type_" + anonTypeCounter++;
        }
        CEnumType enumType = new CEnumType(d.isConst(), d.isVolatile(), list, name, origName);
        for (CEnumType.CEnumerator enumValue : enumType.getEnumerators()) {
            enumValue.setEnum(enumType);
        }
        return enumType;
    }

    private CEnumType.CEnumerator convert(IASTEnumerationSpecifier.IASTEnumerator e, Long lastValue) {
        Long value = null;
        if (e.getValue() == null && lastValue != null) {
            value = lastValue + 1L;
        } else {
            CExpression v = this.convertExpressionWithoutSideEffects(e.getValue());
            boolean negate = false;
            boolean complement = false;
            if (v instanceof CUnaryExpression && ((CUnaryExpression)v).getOperator() == CUnaryExpression.UnaryOperator.MINUS) {
                CUnaryExpression u = (CUnaryExpression)v;
                negate = true;
                v = u.getOperand();
            } else if (v instanceof CUnaryExpression && ((CUnaryExpression)v).getOperator() == CUnaryExpression.UnaryOperator.TILDE) {
                CUnaryExpression u = (CUnaryExpression)v;
                complement = true;
                v = u.getOperand();
            }
            assert (!(v instanceof CUnaryExpression)) : v;
            if (v instanceof CIntegerLiteralExpression) {
                value = ((CIntegerLiteralExpression)v).asLong();
                if (negate) {
                    value = -value.longValue();
                } else if (complement) {
                    value = value ^ 0xFFFFFFFFFFFFFFFFL;
                }
            }
        }
        String name = ASTConverter.convert(e.getName());
        CEnumType.CEnumerator result = new CEnumType.CEnumerator(this.getLocation((IASTNode)e), name, this.scope.createScopedNameOf(name), value);
        this.scope.registerDeclaration(result);
        return result;
    }

    private IASTExpression toExpression(IASTInitializerClause i) {
        if (i instanceof IASTExpression) {
            return (IASTExpression)i;
        }
        throw new CFAGenerationRuntimeException("Initializer clause in unexpected location", (IASTNode)i, this.niceFileNameFunction);
    }

    private CInitializer convert(IASTInitializerClause i, @Nullable CVariableDeclaration declaration) {
        if (i instanceof IASTExpression) {
            CExpression exp = this.convertExpressionWithoutSideEffects((IASTExpression)i);
            return new CInitializerExpression(exp.getFileLocation(), exp);
        }
        if (i instanceof IASTInitializerList) {
            return this.convert((IASTInitializerList)i, declaration);
        }
        if (i instanceof ICASTDesignatedInitializer) {
            return this.convert((ICASTDesignatedInitializer)i, declaration);
        }
        throw new CFAGenerationRuntimeException("unknown initializer claus: " + i.getClass().getSimpleName(), (IASTNode)i, this.niceFileNameFunction);
    }

    private CInitializer convert(IASTInitializer i, @Nullable CVariableDeclaration declaration) {
        if (i == null) {
            return null;
        }
        if (i instanceof IASTInitializerList) {
            return this.convert((IASTInitializerList)i, declaration);
        }
        if (i instanceof IASTEqualsInitializer) {
            return this.convert((IASTEqualsInitializer)i, declaration);
        }
        if (i instanceof ICASTDesignatedInitializer) {
            return this.convert((ICASTDesignatedInitializer)i, declaration);
        }
        throw new CFAGenerationRuntimeException("unknown initializer: " + i.getClass().getSimpleName(), (IASTNode)i, this.niceFileNameFunction);
    }

    private CInitializer convert(ICASTDesignatedInitializer init, @Nullable CVariableDeclaration declaration) {
        ICASTDesignator[] desInit = init.getDesignators();
        CInitializer cInit = this.convert(init.getOperand(), declaration);
        FileLocation fileLoc = cInit.getFileLocation();
        ArrayList<CDesignator> designators = new ArrayList<CDesignator>(desInit.length);
        for (ICASTDesignator designator : desInit) {
            CDesignator r;
            if (designator instanceof ICASTFieldDesignator) {
                r = new CFieldDesignator(fileLoc, ASTConverter.convert(((ICASTFieldDesignator)designator).getName()));
            } else if (designator instanceof ICASTArrayDesignator) {
                r = new CArrayDesignator(fileLoc, this.convertExpressionWithoutSideEffects(((ICASTArrayDesignator)designator).getSubscriptExpression()));
            } else if (designator instanceof IGCCASTArrayRangeDesignator) {
                r = new CArrayRangeDesignator(fileLoc, this.convertExpressionWithoutSideEffects(((IGCCASTArrayRangeDesignator)designator).getRangeFloor()), this.convertExpressionWithoutSideEffects(((IGCCASTArrayRangeDesignator)designator).getRangeCeiling()));
            } else {
                throw new CFAGenerationRuntimeException("Unsupported Designator", (IASTNode)designator, this.niceFileNameFunction);
            }
            designators.add(r);
        }
        return new CDesignatedInitializer(fileLoc, designators, cInit);
    }

    private CInitializerList convert(IASTInitializerList iList, @Nullable CVariableDeclaration declaration) {
        ArrayList<CInitializer> initializerList = new ArrayList<CInitializer>();
        for (IASTInitializerClause i : iList.getClauses()) {
            CInitializer newI = this.convert(i, declaration);
            if (newI == null) continue;
            initializerList.add(newI);
        }
        return new CInitializerList(this.getLocation((IASTNode)iList), initializerList);
    }

    private CInitializer convert(IASTEqualsInitializer i, @Nullable CVariableDeclaration declaration) {
        IASTInitializerClause ic = i.getInitializerClause();
        if (ic instanceof IASTExpression) {
            IASTExpression e = (IASTExpression)ic;
            CAstNode initializer = this.convertExpressionWithSideEffects(e);
            if (initializer == null) {
                return null;
            }
            if (initializer instanceof CAssignment) {
                this.sideAssignmentStack.addPreSideAssignment(initializer);
                return new CInitializerExpression(this.getLocation((IASTNode)e), ((CAssignment)initializer).getLeftHandSide());
            }
            if (initializer instanceof CFunctionCallExpression) {
                FileLocation loc = this.getLocation((IASTNode)i);
                if (declaration != null) {
                    CIdExpression var = new CIdExpression(loc, declaration);
                    this.sideAssignmentStack.addPostSideAssignment(new CFunctionCallAssignmentStatement(loc, var, (CFunctionCallExpression)initializer));
                    return null;
                }
                CIdExpression var = this.createTemporaryVariable(e);
                this.sideAssignmentStack.addPreSideAssignment(new CFunctionCallAssignmentStatement(loc, var, (CFunctionCallExpression)initializer));
                return new CInitializerExpression(loc, var);
            }
            if (!(initializer instanceof CExpression)) {
                throw new CFAGenerationRuntimeException("Initializer is not free of side-effects, it is a " + initializer.getClass().getSimpleName(), (IASTNode)e, this.niceFileNameFunction);
            }
            return new CInitializerExpression(this.getLocation((IASTNode)ic), (CExpression)initializer);
        }
        if (ic instanceof IASTInitializerList) {
            return this.convert((IASTInitializerList)ic, declaration);
        }
        throw new CFAGenerationRuntimeException("unknown initializer: " + i.getClass().getSimpleName(), (IASTNode)i, this.niceFileNameFunction);
    }

    private List<CParameterDeclaration> convert(IASTParameterDeclaration[] ps) {
        ArrayList<CParameterDeclaration> paramsList = new ArrayList<CParameterDeclaration>(ps.length);
        for (IASTParameterDeclaration c : ps) {
            if (!c.getRawSignature().equals("void")) {
                paramsList.add(this.convert(c));
                continue;
            }
            assert (ps.length == 1);
        }
        return paramsList;
    }

    private CParameterDeclaration convert(IASTParameterDeclaration p) {
        Pair<CStorageClass, ? extends CType> specifier = this.convert(p.getDeclSpecifier());
        if (specifier.getFirst() != CStorageClass.AUTO) {
            throw new CFAGenerationRuntimeException("Unsupported storage class for parameters", (IASTNode)p, this.niceFileNameFunction);
        }
        Triple<CType, IASTInitializer, String> declarator = this.convert(p.getDeclarator(), (CType)specifier.getSecond());
        if (declarator.getSecond() != null) {
            throw new CFAGenerationRuntimeException("Unsupported initializer for parameters", (IASTNode)p, this.niceFileNameFunction);
        }
        CType type = (CType)declarator.getFirst();
        if (type instanceof CFunctionTypeWithNames) {
            CFunctionTypeWithNames functionType = (CFunctionTypeWithNames)type;
            type = new CPointerType(false, false, functionType);
        }
        return new CParameterDeclaration(this.getLocation((IASTNode)p), type, (String)declarator.getThird());
    }

    FileLocation getLocation(IASTNode n) {
        int startingLineInInput;
        IASTFileLocation l = n.getFileLocation();
        if (l == null) {
            return FileLocation.DUMMY;
        }
        String fileName = l.getFileName();
        int startingLineInOrigin = startingLineInInput = l.getStartingLineNumber();
        Pair<String, Integer> startingInOrigin = this.sourceOriginMapping.getOriginLineFromAnalysisCodeLine(fileName, startingLineInInput);
        fileName = (String)startingInOrigin.getFirst();
        startingLineInOrigin = (Integer)startingInOrigin.getSecond();
        return new FileLocation(l.getEndingLineNumber(), fileName, (String)this.niceFileNameFunction.apply((Object)fileName), l.getNodeLength(), l.getNodeOffset(), startingLineInInput, startingLineInOrigin);
    }

    static String convert(IASTName n) {
        return n.toString();
    }

    private CType convert(IASTTypeId t) {
        Pair<CStorageClass, ? extends CType> specifier = this.convert(t.getDeclSpecifier());
        if (specifier.getFirst() != CStorageClass.AUTO) {
            throw new CFAGenerationRuntimeException("Unsupported storage class for type ids", (IASTNode)t, this.niceFileNameFunction);
        }
        Triple<CType, IASTInitializer, String> declarator = this.convert(t.getAbstractDeclarator(), (CType)specifier.getSecond());
        if (declarator.getSecond() != null) {
            throw new CFAGenerationRuntimeException("Unsupported initializer for type ids", (IASTNode)t, this.niceFileNameFunction);
        }
        if (declarator.getThird() != null && !((String)declarator.getThird()).trim().isEmpty()) {
            throw new CFAGenerationRuntimeException("Unsupported name for type ids", (IASTNode)t, this.niceFileNameFunction);
        }
        return (CType)declarator.getFirst();
    }

    private static class ContainsProblemTypeVisitor
    extends DefaultCTypeVisitor<Boolean, RuntimeException> {
        private ContainsProblemTypeVisitor() {
        }

        @Override
        public Boolean visitDefault(CType pT) {
            return Boolean.FALSE;
        }

        @Override
        public Boolean visit(CArrayType t) {
            return t.getType().accept(this);
        }

        @Override
        public Boolean visit(CElaboratedType t) {
            CComplexType realType = t.getRealType();
            if (realType != null) {
                return realType.accept(this);
            }
            return false;
        }

        @Override
        public Boolean visit(CFunctionType t) {
            for (CType parameterType : t.getParameters()) {
                if (!parameterType.accept(this).booleanValue()) continue;
                return true;
            }
            return t.getReturnType().accept(this);
        }

        @Override
        public Boolean visit(CPointerType t) {
            return t.getType().accept(this);
        }

        @Override
        public Boolean visit(CProblemType t) {
            return true;
        }

        @Override
        public Boolean visit(CTypedefType t) {
            return t.getRealType().accept(this);
        }
    }

    static enum CONDITION {
        NORMAL,
        ALWAYS_FALSE,
        ALWAYS_TRUE;

    }
}

