/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.parser.eclipse.c;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import org.junit.Assert;
import org.junit.Test;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.c.ASTLiteralConverter;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.c.CFAGenerationRuntimeException;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;

public class ASTConverterTest {
    private final ASTLiteralConverter converter32 = new ASTLiteralConverter(MachineModel.LINUX32, (Function<String, String>)Functions.identity());
    private final ASTLiteralConverter converter64 = new ASTLiteralConverter(MachineModel.LINUX64, (Function<String, String>)Functions.identity());

    @Test
    public final void testCharacterExpression() {
        Assert.assertEquals((long)0L, (long)this.converter32.parseCharacterLiteral("'\\000'", null));
        Assert.assertEquals((long)63L, (long)this.converter32.parseCharacterLiteral("'\\077'", null));
        Assert.assertEquals((long)255L, (long)this.converter32.parseCharacterLiteral("'\\xFF'", null));
        Assert.assertEquals((long)188L, (long)this.converter32.parseCharacterLiteral("'\\xBC'", null));
        Assert.assertEquals((long)128L, (long)this.converter32.parseCharacterLiteral("'\\x80'", null));
        Assert.assertEquals((long)127L, (long)this.converter32.parseCharacterLiteral("'\\X7F'", null));
        Assert.assertEquals((long)92L, (long)this.converter32.parseCharacterLiteral("'\\\\'", null));
        Assert.assertEquals((long)39L, (long)this.converter32.parseCharacterLiteral("'\\''", null));
        Assert.assertEquals((long)34L, (long)this.converter32.parseCharacterLiteral("'\\\"'", null));
        Assert.assertEquals((long)0L, (long)this.converter32.parseCharacterLiteral("'\\0'", null));
        Assert.assertEquals((long)7L, (long)this.converter32.parseCharacterLiteral("'\\a'", null));
        Assert.assertEquals((long)8L, (long)this.converter32.parseCharacterLiteral("'\\b'", null));
        Assert.assertEquals((long)12L, (long)this.converter32.parseCharacterLiteral("'\\f'", null));
        Assert.assertEquals((long)10L, (long)this.converter32.parseCharacterLiteral("'\\n'", null));
        Assert.assertEquals((long)13L, (long)this.converter32.parseCharacterLiteral("'\\r'", null));
        Assert.assertEquals((long)9L, (long)this.converter32.parseCharacterLiteral("'\\t'", null));
        Assert.assertEquals((long)11L, (long)this.converter32.parseCharacterLiteral("'\\v'", null));
        Assert.assertEquals((long)97L, (long)this.converter32.parseCharacterLiteral("'a'", null));
        Assert.assertEquals((long)32L, (long)this.converter32.parseCharacterLiteral("' '", null));
        Assert.assertEquals((long)57L, (long)this.converter32.parseCharacterLiteral("'9'", null));
        Assert.assertEquals((long)180L, (long)this.converter32.parseCharacterLiteral("'\u00b4'", null));
        Assert.assertEquals((long)180L, (long)this.converter32.parseCharacterLiteral("'\u00b4'", null));
    }

    @Test(expected=CFAGenerationRuntimeException.class)
    public final void testInvalidCharacterExpression1() {
        this.converter32.parseCharacterLiteral("", null);
    }

    @Test(expected=CFAGenerationRuntimeException.class)
    public final void testInvalidCharacterExpression2() {
        this.converter32.parseCharacterLiteral("'\\'", null);
    }

    @Test(expected=CFAGenerationRuntimeException.class)
    public final void testInvalidCharacterExpression3() {
        this.converter32.parseCharacterLiteral("'aa'", null);
    }

    @Test(expected=CFAGenerationRuntimeException.class)
    public final void testInvalidCharacterExpression4() {
        this.converter32.parseCharacterLiteral("'\\777'", null);
    }

    @Test(expected=CFAGenerationRuntimeException.class)
    public final void testInvalidCharacterExpression5() {
        this.converter32.parseCharacterLiteral("'\\xFFF'", null);
    }

    @Test(expected=CFAGenerationRuntimeException.class)
    public final void testInvalidCharacterExpression6() {
        this.converter32.parseCharacterLiteral("'\\z'", null);
    }

    @Test(expected=CFAGenerationRuntimeException.class)
    public final void testInvalidCharacterExpression7() {
        this.converter32.parseCharacterLiteral("'\\0777'", null);
    }

    @Test(expected=CFAGenerationRuntimeException.class)
    public final void testInvalidCharacterExpression8() {
        this.converter32.parseCharacterLiteral("'\\088'", null);
    }

    @Test(expected=CFAGenerationRuntimeException.class)
    public final void testInvalidCharacterExpression9() {
        this.converter32.parseCharacterLiteral("'\\xGG'", null);
    }

    private String parseIntegerExpression32(String s) {
        return this.converter32.parseIntegerLiteral(s, null).toString();
    }

    @Test
    public final void testIntegerExpression() {
        Assert.assertEquals((Object)"0", (Object)this.parseIntegerExpression32("0"));
        Assert.assertEquals((Object)"1", (Object)this.parseIntegerExpression32("1"));
        Assert.assertEquals((Object)"2", (Object)this.parseIntegerExpression32("2L"));
        Assert.assertEquals((Object)"3", (Object)this.parseIntegerExpression32("3u"));
        Assert.assertEquals((Object)"4", (Object)this.parseIntegerExpression32("4LL"));
        Assert.assertEquals((Object)"5", (Object)this.parseIntegerExpression32("5uLl"));
        Assert.assertEquals((Object)"63", (Object)this.parseIntegerExpression32("077"));
        Assert.assertEquals((Object)"2147483647", (Object)this.parseIntegerExpression32("2147483647"));
        Assert.assertEquals((Object)"2147483647", (Object)this.parseIntegerExpression32("0x7FFFFFFFL"));
        Assert.assertEquals((Object)"-2147483648", (Object)this.parseIntegerExpression32("2147483648L"));
        Assert.assertEquals((Object)"-2147483648", (Object)this.parseIntegerExpression32("0x80000000"));
        Assert.assertEquals((Object)"-1", (Object)this.parseIntegerExpression32("4294967295"));
        Assert.assertEquals((Object)"-1", (Object)this.parseIntegerExpression32("0xFFFFFFFFl"));
        Assert.assertEquals((Object)"0", (Object)this.parseIntegerExpression32("4294967296l"));
        Assert.assertEquals((Object)"-294967296", (Object)this.parseIntegerExpression32("4000000000"));
        Assert.assertEquals((Object)"4000000000", (Object)this.parseIntegerExpression32("4000000000u"));
        Assert.assertEquals((Object)"2147483647", (Object)this.parseIntegerExpression32("2147483647LL"));
        Assert.assertEquals((Object)"2147483647", (Object)this.parseIntegerExpression32("0x7FFFFFFFlL"));
        Assert.assertEquals((Object)"2147483648", (Object)this.parseIntegerExpression32("2147483648Ll"));
        Assert.assertEquals((Object)"2147483648", (Object)this.parseIntegerExpression32("0x80000000LL"));
        Assert.assertEquals((Object)"4294967295", (Object)this.parseIntegerExpression32("4294967295ll"));
        Assert.assertEquals((Object)"4294967295", (Object)this.parseIntegerExpression32("0xFFFFFFFFLL"));
        Assert.assertEquals((Object)"4294967296", (Object)this.parseIntegerExpression32("4294967296Ll"));
        Assert.assertEquals((Object)"4000000000", (Object)this.parseIntegerExpression32("4000000000lL"));
        Assert.assertEquals((Object)"4000000000", (Object)this.parseIntegerExpression32("4000000000uLL"));
        Assert.assertEquals((Object)"18446744073709551600", (Object)this.parseIntegerExpression32("0xfffffffffffffff0ull"));
        Assert.assertEquals((Object)"-16", (Object)this.parseIntegerExpression32("0xfffffffffffffff0ll"));
        Assert.assertEquals((Object)"9223372036854775807", (Object)this.parseIntegerExpression32("9223372036854775807LL"));
        Assert.assertEquals((Object)"9223372036854775807", (Object)this.parseIntegerExpression32("0x7FFFFFFFFFFFFFFFLL"));
        Assert.assertEquals((Object)"-9223372036854775808", (Object)this.parseIntegerExpression32("9223372036854775808LL"));
        Assert.assertEquals((Object)"-9223372036854775808", (Object)this.parseIntegerExpression32("0x8000000000000000LL"));
        Assert.assertEquals((Object)"9223372036854775808", (Object)this.parseIntegerExpression32("9223372036854775808uLL"));
        Assert.assertEquals((Object)"9223372036854775808", (Object)this.parseIntegerExpression32("0x8000000000000000uLL"));
        Assert.assertEquals((Object)"18446744073709551615", (Object)this.parseIntegerExpression32("18446744073709551615uLL"));
        Assert.assertEquals((Object)"18446744073709551615", (Object)this.parseIntegerExpression32("0xFFFFFFFFFFFFFFFFuLL"));
        Assert.assertEquals((Object)"-1", (Object)this.parseIntegerExpression32("0xFFFFFFFFFFFFFFFF"));
        Assert.assertEquals((Object)"-1", (Object)this.parseIntegerExpression32("0xFFFFFFFFFFFFFFFFLL"));
        Assert.assertEquals((Object)"1", (Object)this.parseIntegerExpression32("18446744073709551617uLL"));
        Assert.assertEquals((Object)"0", (Object)this.parseIntegerExpression32("0xffffe20000000000UL"));
        Assert.assertEquals((Object)"0", (Object)this.parseIntegerExpression32("0xffff810000000000UL"));
    }

    private String parseIntegerExpression64(String s) {
        return this.converter64.parseIntegerLiteral(s, null).toString();
    }

    @Test
    public final void testIntegerExpression64() {
        Assert.assertEquals((Object)"0", (Object)this.parseIntegerExpression64("0"));
        Assert.assertEquals((Object)"1", (Object)this.parseIntegerExpression64("1"));
        Assert.assertEquals((Object)"2", (Object)this.parseIntegerExpression64("2L"));
        Assert.assertEquals((Object)"3", (Object)this.parseIntegerExpression64("3u"));
        Assert.assertEquals((Object)"4", (Object)this.parseIntegerExpression64("4LL"));
        Assert.assertEquals((Object)"5", (Object)this.parseIntegerExpression64("5uLl"));
        Assert.assertEquals((Object)"63", (Object)this.parseIntegerExpression64("077"));
        Assert.assertEquals((Object)"2147483647", (Object)this.parseIntegerExpression64("2147483647"));
        Assert.assertEquals((Object)"2147483647", (Object)this.parseIntegerExpression64("0x7FFFFFFFL"));
        Assert.assertEquals((Object)"2147483648", (Object)this.parseIntegerExpression64("2147483648L"));
        Assert.assertEquals((Object)"-2147483648", (Object)this.parseIntegerExpression64("0x80000000"));
        Assert.assertEquals((Object)"-1", (Object)this.parseIntegerExpression64("4294967295"));
        Assert.assertEquals((Object)"4294967295", (Object)this.parseIntegerExpression64("0xFFFFFFFFl"));
        Assert.assertEquals((Object)"4294967296", (Object)this.parseIntegerExpression64("4294967296l"));
        Assert.assertEquals((Object)"-294967296", (Object)this.parseIntegerExpression64("4000000000"));
        Assert.assertEquals((Object)"4000000000", (Object)this.parseIntegerExpression64("4000000000u"));
        Assert.assertEquals((Object)"2147483647", (Object)this.parseIntegerExpression64("2147483647LL"));
        Assert.assertEquals((Object)"2147483647", (Object)this.parseIntegerExpression64("0x7FFFFFFFlL"));
        Assert.assertEquals((Object)"2147483648", (Object)this.parseIntegerExpression64("2147483648Ll"));
        Assert.assertEquals((Object)"2147483648", (Object)this.parseIntegerExpression64("0x80000000LL"));
        Assert.assertEquals((Object)"4294967295", (Object)this.parseIntegerExpression64("4294967295ll"));
        Assert.assertEquals((Object)"4294967295", (Object)this.parseIntegerExpression64("0xFFFFFFFFLL"));
        Assert.assertEquals((Object)"4294967296", (Object)this.parseIntegerExpression64("4294967296Ll"));
        Assert.assertEquals((Object)"4000000000", (Object)this.parseIntegerExpression64("4000000000lL"));
        Assert.assertEquals((Object)"4000000000", (Object)this.parseIntegerExpression64("4000000000uLL"));
        Assert.assertEquals((Object)"18446744073709551600", (Object)this.parseIntegerExpression64("0xfffffffffffffff0ull"));
        Assert.assertEquals((Object)"-16", (Object)this.parseIntegerExpression64("0xfffffffffffffff0ll"));
        Assert.assertEquals((Object)"9223372036854775807", (Object)this.parseIntegerExpression64("9223372036854775807LL"));
        Assert.assertEquals((Object)"9223372036854775807", (Object)this.parseIntegerExpression64("0x7FFFFFFFFFFFFFFFLL"));
        Assert.assertEquals((Object)"-9223372036854775808", (Object)this.parseIntegerExpression64("9223372036854775808LL"));
        Assert.assertEquals((Object)"-9223372036854775808", (Object)this.parseIntegerExpression64("0x8000000000000000LL"));
        Assert.assertEquals((Object)"9223372036854775808", (Object)this.parseIntegerExpression64("9223372036854775808uLL"));
        Assert.assertEquals((Object)"9223372036854775808", (Object)this.parseIntegerExpression64("0x8000000000000000uLL"));
        Assert.assertEquals((Object)"18446744073709551615", (Object)this.parseIntegerExpression64("18446744073709551615uLL"));
        Assert.assertEquals((Object)"18446744073709551615", (Object)this.parseIntegerExpression64("0xFFFFFFFFFFFFFFFFuLL"));
        Assert.assertEquals((Object)"-1", (Object)this.parseIntegerExpression64("0xFFFFFFFFFFFFFFFF"));
        Assert.assertEquals((Object)"-1", (Object)this.parseIntegerExpression64("0xFFFFFFFFFFFFFFFFLL"));
        Assert.assertEquals((Object)"1", (Object)this.parseIntegerExpression64("18446744073709551617uLL"));
        Assert.assertEquals((Object)"18446711088360718336", (Object)this.parseIntegerExpression64("0xffffe20000000000UL"));
        Assert.assertEquals((Object)"18446604435732824064", (Object)this.parseIntegerExpression64("0xffff810000000000UL"));
    }
}

