/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.parser.eclipse.c;

import com.google.common.base.Function;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.eclipse.cdt.core.dom.ast.IASTLiteralExpression;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.c.CCharLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFloatLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CImaginaryLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CStringLiteralExpression;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.c.CFAGenerationRuntimeException;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.c.CSimpleType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;

class ASTLiteralConverter {
    private final MachineModel machine;
    private final Function<String, String> niceFileNameFunction;

    ASTLiteralConverter(MachineModel pMachineModel, Function<String, String> pNiceFileNameFunction) {
        this.machine = pMachineModel;
        this.niceFileNameFunction = pNiceFileNameFunction;
    }

    private void check(boolean assertion, String msg, IASTNode astNode) throws CFAGenerationRuntimeException {
        if (!assertion) {
            throw new CFAGenerationRuntimeException(msg, astNode, this.niceFileNameFunction);
        }
    }

    CLiteralExpression convert(IASTLiteralExpression e, CType type, FileLocation fileLoc) {
        if (!(type instanceof CSimpleType) && e.getKind() != 3) {
            throw new CFAGenerationRuntimeException("Invalid type " + type + " for literal expression", (IASTNode)e, this.niceFileNameFunction);
        }
        String valueStr = String.valueOf(e.getValue());
        if (valueStr.endsWith("i") || valueStr.endsWith("j")) {
            return this.handleImaginaryNumber(fileLoc, (CSimpleType)type, e, valueStr);
        }
        switch (e.getKind()) {
            case 2: {
                return new CCharLiteralExpression(fileLoc, type, this.parseCharacterLiteral(valueStr, (IASTNode)e));
            }
            case 0: {
                return new CIntegerLiteralExpression(fileLoc, type, this.parseIntegerLiteral(valueStr, (IASTNode)e));
            }
            case 1: {
                BigDecimal value;
                try {
                    if (valueStr.endsWith("L") || valueStr.endsWith("l")) {
                        valueStr = valueStr.substring(0, valueStr.length() - 1) + "d";
                    }
                    value = new BigDecimal(valueStr);
                }
                catch (NumberFormatException nfe1) {
                    try {
                        value = BigDecimal.valueOf(Double.parseDouble(valueStr));
                    }
                    catch (NumberFormatException nfe2) {
                        throw new CFAGenerationRuntimeException("illegal floating point literal", (IASTNode)e, this.niceFileNameFunction);
                    }
                }
                return new CFloatLiteralExpression(fileLoc, type, value);
            }
            case 3: {
                return new CStringLiteralExpression(fileLoc, type, valueStr);
            }
        }
        throw new CFAGenerationRuntimeException("Unknown literal", (IASTNode)e, this.niceFileNameFunction);
    }

    private CImaginaryLiteralExpression handleImaginaryNumber(FileLocation fileLoc, CSimpleType type, IASTLiteralExpression exp, String valueStr) {
        valueStr = valueStr.substring(0, valueStr.length() - 1);
        type = new CSimpleType(type.isConst(), type.isVolatile(), type.getType(), type.isLong(), type.isShort(), type.isSigned(), type.isUnsigned(), type.isComplex(), true, type.isLongLong());
        switch (exp.getKind()) {
            case 2: {
                return new CImaginaryLiteralExpression(fileLoc, type, new CCharLiteralExpression(fileLoc, type, this.parseCharacterLiteral(valueStr, (IASTNode)exp)));
            }
            case 0: {
                return new CImaginaryLiteralExpression(fileLoc, type, new CIntegerLiteralExpression(fileLoc, type, this.parseIntegerLiteral(valueStr, (IASTNode)exp)));
            }
            case 1: {
                BigDecimal val;
                try {
                    if (valueStr.endsWith("L") || valueStr.endsWith("l")) {
                        valueStr = valueStr.substring(0, valueStr.length() - 1) + "d";
                    }
                    val = new BigDecimal(valueStr);
                }
                catch (NumberFormatException nfe1) {
                    try {
                        val = BigDecimal.valueOf(Double.parseDouble(valueStr));
                    }
                    catch (NumberFormatException nfe2) {
                        throw new CFAGenerationRuntimeException("illegal floating point literal", (IASTNode)exp, this.niceFileNameFunction);
                    }
                }
                return new CImaginaryLiteralExpression(fileLoc, type, new CFloatLiteralExpression(fileLoc, type, val));
            }
        }
        throw new CFAGenerationRuntimeException("Unknown imaginary literal", (IASTNode)exp, this.niceFileNameFunction);
    }

    char parseCharacterLiteral(String s, IASTNode e) {
        int result;
        this.check(s.length() >= 3, "invalid character literal (too short)", e);
        this.check(s.charAt(0) == '\'' && s.charAt(s.length() - 1) == '\'', "character literal without quotation marks", e);
        s = s.substring(1, s.length() - 1);
        if (s.length() == 1) {
            result = s.charAt(0);
            this.check(result != 92, "invalid quoting sequence", e);
        } else {
            this.check(s.charAt(0) == '\\', "character literal too long", e);
            s = s.substring(1);
            this.check(s.length() >= 1, "invalid quoting sequence", e);
            char c = s.charAt(0);
            if (c == 'x' || c == 'X') {
                this.check((s = s.substring(1)).length() > 0 && s.length() <= 3, "character literal with illegal hex number", e);
                try {
                    result = (char)Integer.parseInt(s, 16);
                    this.check(result <= 255, "hex escape sequence out of range", e);
                }
                catch (NumberFormatException _) {
                    throw new CFAGenerationRuntimeException("character literal with illegal hex number", e, this.niceFileNameFunction);
                }
            } else if (Character.isDigit(c)) {
                this.check(s.length() <= 3, "character literal with illegal octal number", e);
                try {
                    result = (char)Integer.parseInt(s, 8);
                    this.check(result <= 255, "octal escape sequence out of range", e);
                }
                catch (NumberFormatException _) {
                    throw new CFAGenerationRuntimeException("character literal with illegal octal number", e, this.niceFileNameFunction);
                }
            } else {
                this.check(s.length() == 1, "character literal too long", e);
                switch (c) {
                    case 'a': {
                        result = 7;
                        break;
                    }
                    case 'b': {
                        result = 8;
                        break;
                    }
                    case 'f': {
                        result = 12;
                        break;
                    }
                    case 'n': {
                        result = 10;
                        break;
                    }
                    case 'r': {
                        result = 13;
                        break;
                    }
                    case 't': {
                        result = 9;
                        break;
                    }
                    case 'v': {
                        result = 11;
                        break;
                    }
                    case '\"': {
                        result = 34;
                        break;
                    }
                    case '\'': {
                        result = 39;
                        break;
                    }
                    case '\\': {
                        result = 92;
                        break;
                    }
                    default: {
                        throw new CFAGenerationRuntimeException("unknown character literal", e, this.niceFileNameFunction);
                    }
                }
            }
        }
        return (char)result;
    }

    BigInteger parseIntegerLiteral(String s, IASTNode e) {
        BigInteger result;
        int last = s.length() - 1;
        int bytes = this.machine.getSizeofInt();
        boolean signed = true;
        if (s.charAt(last) == 'U' || s.charAt(last) == 'u') {
            --last;
            signed = false;
        }
        if (s.charAt(last) == 'L' || s.charAt(last) == 'l') {
            --last;
            bytes = this.machine.getSizeofLongInt();
        }
        if (s.charAt(last) == 'L' || s.charAt(last) == 'l') {
            --last;
            bytes = this.machine.getSizeofLongLongInt();
        }
        if (s.charAt(last) == 'U' || s.charAt(last) == 'u') {
            if (!signed) {
                throw new CFAGenerationRuntimeException("invalid duplicate modifier U in integer literal", e, this.niceFileNameFunction);
            }
            --last;
            signed = false;
        }
        int bits = bytes * this.machine.getSizeofCharInBits();
        s = s.substring(0, last + 1);
        try {
            if (s.startsWith("0x") || s.startsWith("0X")) {
                s = s.substring(2);
                result = new BigInteger(s, 16);
            } else {
                result = s.startsWith("0") ? new BigInteger(s, 8) : new BigInteger(s, 10);
            }
        }
        catch (NumberFormatException _) {
            throw new CFAGenerationRuntimeException("invalid number", e, this.niceFileNameFunction);
        }
        this.check(result.compareTo(BigInteger.ZERO) >= 0, "invalid number", e);
        BigInteger mask = BigInteger.ZERO.setBit(bits).subtract(BigInteger.ONE);
        result = result.and(mask);
        assert (result.bitLength() <= bits);
        if (signed && result.testBit(bits - 1)) {
            result = result.clearBit(bits - 1);
            BigInteger minValue = BigInteger.ZERO.setBit(bits - 1).negate();
            result = minValue.add(result);
        }
        return result;
    }
}

