/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.parser.eclipse.c;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNamedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTPointer;
import org.eclipse.cdt.core.dom.ast.IASTPointerOperator;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IBasicType;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.ICompositeType;
import org.eclipse.cdt.core.dom.ast.IEnumeration;
import org.eclipse.cdt.core.dom.ast.IField;
import org.eclipse.cdt.core.dom.ast.IFunctionType;
import org.eclipse.cdt.core.dom.ast.IPointerType;
import org.eclipse.cdt.core.dom.ast.IProblemBinding;
import org.eclipse.cdt.core.dom.ast.IProblemType;
import org.eclipse.cdt.core.dom.ast.IQualifierType;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.dom.ast.c.ICArrayType;
import org.eclipse.cdt.core.dom.ast.c.ICBasicType;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.parser.Scope;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.c.ASTConverter;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.c.CFAGenerationRuntimeException;
import org.sosy_lab.cpachecker.cfa.types.c.CArrayType;
import org.sosy_lab.cpachecker.cfa.types.c.CBasicType;
import org.sosy_lab.cpachecker.cfa.types.c.CComplexType;
import org.sosy_lab.cpachecker.cfa.types.c.CCompositeType;
import org.sosy_lab.cpachecker.cfa.types.c.CElaboratedType;
import org.sosy_lab.cpachecker.cfa.types.c.CFunctionType;
import org.sosy_lab.cpachecker.cfa.types.c.CNumericTypes;
import org.sosy_lab.cpachecker.cfa.types.c.CPointerType;
import org.sosy_lab.cpachecker.cfa.types.c.CProblemType;
import org.sosy_lab.cpachecker.cfa.types.c.CSimpleType;
import org.sosy_lab.cpachecker.cfa.types.c.CStorageClass;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cfa.types.c.CTypedefType;
import org.sosy_lab.cpachecker.cfa.types.c.CTypes;
import org.sosy_lab.cpachecker.cfa.types.c.CVoidType;

class ASTTypeConverter {
    private final Scope scope;
    private final ASTConverter converter;
    private final String filePrefix;
    private final Function<String, String> niceFileNameFunction;
    private static final Map<String, Map<IType, CType>> typeConversions = new HashMap<String, Map<IType, CType>>();

    ASTTypeConverter(Scope pScope, ASTConverter pConverter, String pFilePrefix, Function<String, String> pNiceFileNameFunction) {
        this.scope = pScope;
        this.converter = pConverter;
        this.filePrefix = pFilePrefix;
        this.niceFileNameFunction = pNiceFileNameFunction;
        if (!typeConversions.containsKey(this.filePrefix)) {
            typeConversions.put(this.filePrefix, new IdentityHashMap());
        }
    }

    static void overwriteType(IType cdtType, CType ourType, String filePrefix) {
        typeConversions.get(filePrefix).put(cdtType, ourType);
    }

    static IType getTypeFromTypeConversion(CType ourCType, String filePrefix) {
        for (Map.Entry<IType, CType> entry : typeConversions.get(filePrefix).entrySet()) {
            if (!ourCType.equals(entry.getValue())) continue;
            return entry.getKey();
        }
        return null;
    }

    CType convert(IType t) {
        CType result = typeConversions.get(this.filePrefix).get(t);
        if (result == null) {
            result = (CType)Preconditions.checkNotNull((Object)this.convert0(t));
            if (!typeConversions.get(this.filePrefix).containsKey(t)) {
                typeConversions.get(this.filePrefix).put(t, result);
            }
        }
        return result;
    }

    private CType convert0(IType t) {
        if (t instanceof IBasicType) {
            return this.conv((IBasicType)t);
        }
        if (t instanceof IPointerType) {
            return this.conv((IPointerType)t);
        }
        if (t instanceof ITypedef) {
            return this.conv((ITypedef)t);
        }
        if (t instanceof ICompositeType) {
            CComplexType.ComplexTypeKind kind;
            ICompositeType ct = (ICompositeType)t;
            switch (ct.getKey()) {
                case 1: {
                    kind = CComplexType.ComplexTypeKind.STRUCT;
                    break;
                }
                case 2: {
                    kind = CComplexType.ComplexTypeKind.UNION;
                    break;
                }
                default: {
                    throw new CFAGenerationRuntimeException("Unknown key " + ct.getKey() + " for composite type " + t);
                }
            }
            String name = ct.getName();
            String qualifiedName = kind.toASTString() + " " + name;
            CComplexType oldType = this.scope.lookupType(qualifiedName);
            if (oldType != null) {
                return new CElaboratedType(false, false, kind, oldType.getName(), oldType.getOrigName(), oldType);
            }
            CCompositeType compType = new CCompositeType(false, false, kind, (List<CCompositeType.CCompositeTypeMemberDeclaration>)ImmutableList.of(), name, name);
            typeConversions.get(this.filePrefix).put(t, new CElaboratedType(false, false, kind, name, compType.getOrigName(), compType));
            compType.setMembers(this.conv(ct.getFields()));
            return compType;
        }
        if (t instanceof IFunctionType) {
            IFunctionType ft = (IFunctionType)t;
            IType[] parameters = ft.getParameterTypes();
            ArrayList newParameters = Lists.newArrayListWithExpectedSize((int)parameters.length);
            for (IType p : parameters) {
                if (p instanceof IBasicType && ((IBasicType)p).getKind() == IBasicType.Kind.eVoid) {
                    assert (parameters.length == 1);
                    continue;
                }
                newParameters.add(this.convert(p));
            }
            return new CFunctionType(false, false, this.convert(ft.getReturnType()), newParameters, false);
        }
        if (t instanceof ICArrayType) {
            return this.conv((ICArrayType)t);
        }
        if (t instanceof IQualifierType) {
            return this.conv((IQualifierType)t);
        }
        if (t instanceof IEnumeration) {
            return this.conv((IEnumeration)t);
        }
        if (t instanceof IProblemType) {
            return new CProblemType(t.toString() + ": " + ((IProblemType)t).getMessage());
        }
        if (t instanceof IProblemBinding) {
            IProblemBinding problem = (IProblemBinding)t;
            if (problem.getASTNode().getRawSignature().equals("__label__")) {
                return new CProblemType(problem.getASTNode().getRawSignature());
            }
            throw new CFAGenerationRuntimeException(problem.getMessage(), problem.getASTNode(), this.niceFileNameFunction);
        }
        throw new CFAGenerationRuntimeException("unknown type " + t.getClass().getSimpleName());
    }

    private CType conv(IBasicType t) {
        if (t.getKind() == IBasicType.Kind.eVoid) {
            if (t.isComplex() || t.isImaginary() || t.isLong() || t.isLongLong() || t.isShort() || t.isSigned() || t.isUnsigned()) {
                throw new CFAGenerationRuntimeException("Void type with illegal modifier: " + t);
            }
            return CVoidType.VOID;
        }
        if (t instanceof ICBasicType) {
            CBasicType type;
            ICBasicType c = (ICBasicType)t;
            switch (t.getKind()) {
                case eBoolean: {
                    type = CBasicType.BOOL;
                    break;
                }
                case eChar: {
                    type = CBasicType.CHAR;
                    break;
                }
                case eDouble: {
                    type = CBasicType.DOUBLE;
                    break;
                }
                case eFloat: {
                    type = CBasicType.FLOAT;
                    break;
                }
                case eInt: {
                    type = CBasicType.INT;
                    break;
                }
                case eUnspecified: {
                    type = CBasicType.UNSPECIFIED;
                    break;
                }
                case eVoid: {
                    throw new AssertionError();
                }
                default: {
                    throw new CFAGenerationRuntimeException("Unknown basic type " + t.getKind());
                }
            }
            if (c.isShort() && c.isLong() || c.isShort() && c.isLongLong() || c.isLong() && c.isLongLong() || c.isSigned() && c.isUnsigned()) {
                throw new CFAGenerationRuntimeException("Illegal combination of type identifiers");
            }
            return new CSimpleType(false, false, type, c.isLong(), c.isShort(), c.isSigned(), c.isUnsigned(), c.isComplex(), c.isImaginary(), c.isLongLong());
        }
        throw new CFAGenerationRuntimeException("Unknown type " + t.toString());
    }

    private CPointerType conv(IPointerType t) {
        return new CPointerType(t.isConst(), t.isVolatile(), this.convert(t.getType()));
    }

    private CTypedefType conv(ITypedef t) {
        String name = t.getName();
        CType oldType = this.scope.lookupTypedef(name);
        if (oldType != null) {
            return new CTypedefType(false, false, t.getName(), oldType);
        }
        return new CTypedefType(false, false, t.getName(), this.convert(t.getType()));
    }

    private List<CCompositeType.CCompositeTypeMemberDeclaration> conv(IField[] pFields) {
        ArrayList<CCompositeType.CCompositeTypeMemberDeclaration> list = new ArrayList<CCompositeType.CCompositeTypeMemberDeclaration>(pFields.length);
        for (IField pField : pFields) {
            list.add(new CCompositeType.CCompositeTypeMemberDeclaration(this.convert(pField.getType()), pField.getName()));
        }
        return list;
    }

    private CArrayType conv(ICArrayType t) {
        CExpression length = null;
        IValue v = t.getSize();
        if (v != null && v.numericalValue() != null) {
            length = new CIntegerLiteralExpression(FileLocation.DUMMY, CNumericTypes.INT, BigInteger.valueOf(v.numericalValue()));
        } else {
            try {
                length = this.converter.convertExpressionWithoutSideEffects(t.getArraySizeExpression());
                if (length != null) {
                    length = this.converter.simplifyExpressionRecursively(length);
                }
            }
            catch (DOMException e) {
                throw new CFAGenerationRuntimeException(e);
            }
        }
        return new CArrayType(t.isConst(), t.isVolatile(), this.convert(t.getType()), length);
    }

    private CType conv(IQualifierType t) {
        CType i = this.convert(t.getType());
        boolean isConst = t.isConst();
        boolean isVolatile = t.isVolatile();
        i = isConst ? CTypes.withConst(i) : CTypes.withoutConst(i);
        CType cType = i = isVolatile ? CTypes.withVolatile(i) : CTypes.withoutVolatile(i);
        assert (i instanceof CProblemType || isConst == i.isConst() && isVolatile == i.isVolatile());
        return i;
    }

    private CType conv(IEnumeration e) {
        String name;
        CComplexType realType = this.scope.lookupType("enum " + e.getName());
        String origName = name = e.getName();
        if (realType != null) {
            name = realType.getName();
            origName = realType.getOrigName();
        }
        return new CElaboratedType(false, false, CComplexType.ComplexTypeKind.ENUM, name, origName, realType);
    }

    CType convert(IASTSimpleDeclSpecifier dd) {
        CBasicType type;
        switch (dd.getType()) {
            case 6: {
                type = CBasicType.BOOL;
                break;
            }
            case 2: {
                type = CBasicType.CHAR;
                break;
            }
            case 5: {
                type = CBasicType.DOUBLE;
                break;
            }
            case 4: {
                type = CBasicType.FLOAT;
                break;
            }
            case 3: {
                type = CBasicType.INT;
                break;
            }
            case 0: {
                type = CBasicType.UNSPECIFIED;
                break;
            }
            case 1: {
                if (dd.isComplex() || dd.isImaginary() || dd.isLong() || dd.isLongLong() || dd.isShort() || dd.isSigned() || dd.isUnsigned()) {
                    throw new CFAGenerationRuntimeException("Void type with illegal modifier", (IASTNode)dd, this.niceFileNameFunction);
                }
                return CVoidType.create(dd.isConst(), dd.isVolatile());
            }
            case 8: {
                CType ctype = this.convert(dd.getDeclTypeExpression().getExpressionType());
                if (dd.isConst()) {
                    ctype = CTypes.withConst(ctype);
                }
                if (dd.isVolatile()) {
                    ctype = CTypes.withVolatile(ctype);
                }
                return ctype;
            }
            default: {
                throw new CFAGenerationRuntimeException("Unknown basic type " + dd.getType() + " " + dd.getClass().getSimpleName(), (IASTNode)dd, this.niceFileNameFunction);
            }
        }
        if (dd.isShort() && dd.isLong() || dd.isShort() && dd.isLongLong() || dd.isLong() && dd.isLongLong() || dd.isSigned() && dd.isUnsigned()) {
            throw new CFAGenerationRuntimeException("Illegal combination of type identifiers", (IASTNode)dd, this.niceFileNameFunction);
        }
        return new CSimpleType(dd.isConst(), dd.isVolatile(), type, dd.isLong(), dd.isShort(), dd.isSigned(), dd.isUnsigned(), dd.isComplex(), dd.isImaginary(), dd.isLongLong());
    }

    CType convert(IASTNamedTypeSpecifier d) {
        IASTName astName = d.getName();
        String name = ASTConverter.convert(astName);
        IBinding binding = astName.resolveBinding();
        if (!(binding instanceof IType)) {
            throw new CFAGenerationRuntimeException("Unknown binding of typedef", (IASTNode)d, this.niceFileNameFunction);
        }
        CType type = null;
        if (binding instanceof IProblemBinding && (type = this.scope.lookupTypedef(name)) == null) {
            type = this.scope.lookupType(name);
        }
        if (type == null) {
            type = this.convert((IType)binding);
        }
        return new CTypedefType(d.isConst(), d.isVolatile(), name, type);
    }

    CStorageClass convertCStorageClass(IASTDeclSpecifier d) {
        switch (d.getStorageClass()) {
            case 0: 
            case 4: 
            case 5: {
                return CStorageClass.AUTO;
            }
            case 3: {
                return CStorageClass.STATIC;
            }
            case 2: {
                return CStorageClass.EXTERN;
            }
            case 1: {
                return CStorageClass.TYPEDEF;
            }
        }
        throw new CFAGenerationRuntimeException("Unsupported storage class", (IASTNode)d, this.niceFileNameFunction);
    }

    CElaboratedType convert(IASTElaboratedTypeSpecifier d) {
        String name;
        CComplexType.ComplexTypeKind type;
        switch (d.getKind()) {
            case 0: {
                type = CComplexType.ComplexTypeKind.ENUM;
                break;
            }
            case 1: {
                type = CComplexType.ComplexTypeKind.STRUCT;
                break;
            }
            case 2: {
                type = CComplexType.ComplexTypeKind.UNION;
                break;
            }
            default: {
                throw new CFAGenerationRuntimeException("Unknown elaborated type", (IASTNode)d, this.niceFileNameFunction);
            }
        }
        String origName = name = ASTConverter.convert(d.getName());
        CComplexType realType = this.scope.lookupType(type.toASTString() + " " + name);
        if (realType != null) {
            name = realType.getName();
            origName = realType.getOrigName();
        }
        return new CElaboratedType(d.isConst(), d.isVolatile(), type, name, origName, realType);
    }

    CPointerType convert(IASTPointerOperator po, CType type) {
        if (po instanceof IASTPointer) {
            IASTPointer p = (IASTPointer)po;
            return new CPointerType(p.isConst(), p.isVolatile(), type);
        }
        throw new CFAGenerationRuntimeException("Unknown pointer operator", (IASTNode)po, this.niceFileNameFunction);
    }

    CType convertPointerOperators(IASTPointerOperator[] ps, CType type) {
        for (IASTPointerOperator p : ps) {
            type = this.convert(p, type);
        }
        return type;
    }
}

