/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.parser.eclipse.c;

import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.collect.SortedSetMultimap;
import com.google.common.collect.TreeMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.logging.Level;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTASMDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTProblem;
import org.eclipse.cdt.core.dom.ast.IASTProblemDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.sosy_lab.common.Pair;
import org.sosy_lab.common.Triple;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.log.LogManagerWithoutDuplicates;
import org.sosy_lab.cpachecker.cfa.CSourceOriginMapping;
import org.sosy_lab.cpachecker.cfa.Language;
import org.sosy_lab.cpachecker.cfa.ParseResult;
import org.sosy_lab.cpachecker.cfa.ast.ADeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CAstNode;
import org.sosy_lab.cpachecker.cfa.ast.c.CComplexTypeDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializer;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializerList;
import org.sosy_lab.cpachecker.cfa.ast.c.CSimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CTypeDefDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.parser.Scope;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.c.ASTConverter;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.c.CFAFunctionBuilder;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.c.CFAGenerationRuntimeException;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.c.CheckBindingVisitor;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.c.FillInAllBindingsVisitor;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.c.FunctionScope;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.c.GlobalScope;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.c.ProgramDeclarations;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.c.Sideassignments;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.exceptions.CParserException;

class CFABuilder
extends ASTVisitor {
    private final List<Triple<List<IASTFunctionDefinition>, String, GlobalScope>> functionDeclarations = new ArrayList<Triple<List<IASTFunctionDefinition>, String, GlobalScope>>();
    private final SortedMap<String, FunctionEntryNode> cfas = new TreeMap<String, FunctionEntryNode>();
    private final SortedSetMultimap<String, CFANode> cfaNodes = TreeMultimap.create();
    private final List<String> eliminateableDuplicates = new ArrayList<String>();
    private final List<Triple<ADeclaration, String, GlobalScope>> globalDeclarations = Lists.newArrayList();
    private final Set<String> globalInitializedVariables = Sets.newHashSet();
    private GlobalScope fileScope = new GlobalScope();
    private ProgramDeclarations programDeclarations = new ProgramDeclarations();
    private ASTConverter astCreator;
    private final Function<String, String> niceFileNameFunction;
    private final CSourceOriginMapping sourceOriginMapping;
    private final MachineModel machine;
    private final LogManagerWithoutDuplicates logger;
    private final CheckBindingVisitor checkBinding;
    private final Configuration config;
    private boolean encounteredAsm = false;
    private Sideassignments sideAssignmentStack = null;

    public CFABuilder(Configuration pConfig, LogManager pLogger, Function<String, String> pNiceFileNameFunction, CSourceOriginMapping pSourceOriginMapping, MachineModel pMachine) throws InvalidConfigurationException {
        this.logger = new LogManagerWithoutDuplicates(pLogger);
        this.niceFileNameFunction = pNiceFileNameFunction;
        this.sourceOriginMapping = pSourceOriginMapping;
        this.machine = pMachine;
        this.config = pConfig;
        this.checkBinding = new CheckBindingVisitor(pLogger);
        this.shouldVisitDeclarations = true;
        this.shouldVisitEnumerators = true;
        this.shouldVisitProblems = true;
        this.shouldVisitTranslationUnit = true;
    }

    public void analyzeTranslationUnit(IASTTranslationUnit ast, String staticVariablePrefix) throws InvalidConfigurationException {
        this.sideAssignmentStack = new Sideassignments();
        this.fileScope = new GlobalScope(new HashMap<String, CSimpleDeclaration>(), new HashMap<String, CSimpleDeclaration>(), new HashMap<String, CFunctionDeclaration>(), new HashMap<String, CComplexTypeDeclaration>(), new HashMap<String, CTypeDefDeclaration>(), this.programDeclarations, staticVariablePrefix);
        this.astCreator = new ASTConverter(this.config, this.fileScope, this.logger, this.niceFileNameFunction, this.sourceOriginMapping, this.machine, staticVariablePrefix, this.sideAssignmentStack);
        this.functionDeclarations.add((Triple<List<IASTFunctionDefinition>, String, GlobalScope>)Triple.of(new ArrayList(), (Object)staticVariablePrefix, (Object)this.fileScope));
        ast.accept((ASTVisitor)this);
    }

    public int visit(IASTDeclaration declaration) {
        this.sideAssignmentStack.enterBlock();
        IASTFileLocation fileloc = declaration.getFileLocation();
        if (declaration instanceof IASTSimpleDeclaration) {
            return this.handleSimpleDeclaration((IASTSimpleDeclaration)declaration, fileloc);
        }
        if (declaration instanceof IASTFunctionDefinition) {
            IASTFunctionDefinition fd = (IASTFunctionDefinition)declaration;
            ((List)this.functionDeclarations.get(this.functionDeclarations.size() - 1).getFirst()).add(fd);
            CFunctionDeclaration functionDefinition = this.astCreator.convert(fd);
            if (this.sideAssignmentStack.hasPreSideAssignments() || this.sideAssignmentStack.hasPostSideAssignments()) {
                throw new CFAGenerationRuntimeException("Function definition has side effect", (IASTNode)fd, this.niceFileNameFunction);
            }
            this.fileScope.registerFunctionDeclaration(functionDefinition);
            if (!this.eliminateableDuplicates.contains(functionDefinition.toASTString())) {
                this.globalDeclarations.add((Triple<ADeclaration, String, GlobalScope>)Triple.of((Object)functionDefinition, (Object)(fd.getDeclSpecifier().getRawSignature() + " " + fd.getDeclarator().getRawSignature()), (Object)this.fileScope));
                this.eliminateableDuplicates.add(functionDefinition.toASTString());
            }
            this.sideAssignmentStack.leaveBlock();
            return 1;
        }
        if (declaration instanceof IASTProblemDeclaration) {
            this.visit(((IASTProblemDeclaration)declaration).getProblem());
            this.sideAssignmentStack.leaveBlock();
            return 1;
        }
        if (declaration instanceof IASTASMDeclaration) {
            this.encounteredAsm = true;
            this.logger.log(Level.FINER, new Object[]{"Ignoring inline assembler code at line", fileloc.getStartingLineNumber()});
            this.sideAssignmentStack.leaveBlock();
            return 1;
        }
        throw new CFAGenerationRuntimeException("Unknown declaration type " + declaration.getClass().getSimpleName(), (IASTNode)declaration, this.niceFileNameFunction);
    }

    private int handleSimpleDeclaration(IASTSimpleDeclaration sd, IASTFileLocation fileloc) {
        if (sd.getDeclarators().length == 0 && sd.getDeclSpecifier() instanceof IASTSimpleDeclSpecifier) {
            this.sideAssignmentStack.leaveBlock();
            return 1;
        }
        List<CDeclaration> newDs = this.astCreator.convert(sd);
        assert (!newDs.isEmpty());
        if (this.sideAssignmentStack.hasConditionalExpression() || this.sideAssignmentStack.hasPostSideAssignments()) {
            throw new CFAGenerationRuntimeException("Initializer of global variable has side effect", (IASTNode)sd, this.niceFileNameFunction);
        }
        String rawSignature = sd.getRawSignature();
        for (CAstNode astNode : this.sideAssignmentStack.getAndResetPreSideAssignments()) {
            if (astNode instanceof CComplexTypeDeclaration) {
                this.globalDeclarations.add((Triple<ADeclaration, String, GlobalScope>)Triple.of((Object)((ADeclaration)((Object)astNode)), (Object)rawSignature, (Object)this.fileScope));
                continue;
            }
            if (astNode instanceof CVariableDeclaration) {
                CInitializer initializer = ((CVariableDeclaration)astNode).getInitializer();
                if (initializer instanceof CInitializerList) {
                    this.globalDeclarations.add((Triple<ADeclaration, String, GlobalScope>)Triple.of((Object)((ADeclaration)((Object)astNode)), (Object)rawSignature, (Object)this.fileScope));
                    continue;
                }
                throw new CFAGenerationRuntimeException("Initializer of global variable has side effect", (IASTNode)sd, this.niceFileNameFunction);
            }
            throw new CFAGenerationRuntimeException("Initializer of global variable has side effect", (IASTNode)sd, this.niceFileNameFunction);
        }
        for (CDeclaration newD : newDs) {
            boolean used = true;
            if (newD instanceof CVariableDeclaration) {
                CInitializer init = ((CVariableDeclaration)newD).getInitializer();
                if (init != null) {
                    init.accept(this.checkBinding);
                    if (!this.globalInitializedVariables.add(newD.getName())) {
                        throw new CFAGenerationRuntimeException("Variable " + newD.getName() + " initialized for the second time", newD);
                    }
                }
                this.fileScope.registerDeclaration(newD);
            } else if (newD instanceof CFunctionDeclaration) {
                this.fileScope.registerFunctionDeclaration((CFunctionDeclaration)newD);
            } else if (newD instanceof CComplexTypeDeclaration) {
                used = this.fileScope.registerTypeDeclaration((CComplexTypeDeclaration)newD);
            } else if (newD instanceof CTypeDefDeclaration) {
                used = this.fileScope.registerTypeDeclaration((CTypeDefDeclaration)newD);
            }
            if (!used || this.eliminateableDuplicates.contains(newD.toASTString())) continue;
            this.globalDeclarations.add((Triple<ADeclaration, String, GlobalScope>)Triple.of((Object)newD, (Object)rawSignature, (Object)this.fileScope));
            this.eliminateableDuplicates.add(newD.toASTString());
        }
        this.sideAssignmentStack.leaveBlock();
        return 1;
    }

    public int visit(IASTProblem problem) {
        throw new CFAGenerationRuntimeException(problem, this.niceFileNameFunction);
    }

    public ParseResult createCFA() throws CParserException {
        for (Triple<ADeclaration, String, GlobalScope> triple : this.globalDeclarations) {
            FillInAllBindingsVisitor fillInAllBindingsVisitor = new FillInAllBindingsVisitor((Scope)triple.getThird());
            ((CDeclaration)triple.getFirst()).getType().accept(fillInAllBindingsVisitor);
        }
        for (Triple triple : this.functionDeclarations) {
            for (IASTFunctionDefinition declaration : (List)triple.getFirst()) {
                this.handleFunctionDefinition((GlobalScope)triple.getThird(), (String)triple.getSecond(), declaration);
            }
        }
        if (this.encounteredAsm) {
            this.logger.log(Level.WARNING, new Object[]{"Inline assembler ignored, analysis is probably unsound!"});
        }
        if (this.checkBinding.foundUndefinedIdentifiers()) {
            throw new CParserException("Invalid C code because of undefined identifiers mentioned above.");
        }
        ArrayList<Pair<ADeclaration, String>> globalDecls = new ArrayList<Pair<ADeclaration, String>>((Collection<Pair<ADeclaration, String>>)FluentIterable.from(this.globalDeclarations).transform((Function)new Function<Triple<ADeclaration, String, GlobalScope>, Pair<ADeclaration, String>>(){

            public Pair<ADeclaration, String> apply(Triple<ADeclaration, String, GlobalScope> pInput) {
                return Pair.of((Object)pInput.getFirst(), (Object)pInput.getSecond());
            }
        }).toList());
        ParseResult parseResult = new ParseResult(this.cfas, this.cfaNodes, globalDecls, Language.C);
        return parseResult;
    }

    private void handleFunctionDefinition(final GlobalScope actScope, String fileName, IASTFunctionDefinition declaration) {
        CFAFunctionBuilder functionBuilder;
        FunctionScope localScope = new FunctionScope(actScope.getFunctions(), actScope.getTypes(), actScope.getTypeDefs(), actScope.getGlobalVars(), fileName);
        try {
            functionBuilder = new CFAFunctionBuilder(this.config, this.logger, localScope, this.niceFileNameFunction, this.sourceOriginMapping, this.machine, fileName, this.sideAssignmentStack, this.checkBinding);
        }
        catch (InvalidConfigurationException e) {
            throw new CFAGenerationRuntimeException("Invalid configuration");
        }
        declaration.accept((ASTVisitor)functionBuilder);
        FunctionEntryNode startNode = functionBuilder.getStartNode();
        String functionName = startNode.getFunctionName();
        if (this.cfas.containsKey(functionName)) {
            throw new CFAGenerationRuntimeException("Duplicate function " + functionName);
        }
        this.cfas.put(functionName, startNode);
        this.cfaNodes.putAll((Object)functionName, functionBuilder.getCfaNodes());
        this.globalDeclarations.addAll((Collection<Triple<ADeclaration, String, GlobalScope>>)FluentIterable.from(functionBuilder.getGlobalDeclarations()).transform((Function)new Function<Pair<ADeclaration, String>, Triple<ADeclaration, String, GlobalScope>>(){

            public Triple<ADeclaration, String, GlobalScope> apply(Pair<ADeclaration, String> pInput) {
                return Triple.of((Object)pInput.getFirst(), (Object)pInput.getSecond(), (Object)actScope);
            }
        }).toList());
        this.encounteredAsm |= functionBuilder.didEncounterAsm();
        functionBuilder.finish();
    }

    public int leave(IASTTranslationUnit ast) {
        return 3;
    }
}

