/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.parser.eclipse.c;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.math.BigInteger;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.annotation.Nullable;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTASMDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTBinaryExpression;
import org.eclipse.cdt.core.dom.ast.IASTBreakStatement;
import org.eclipse.cdt.core.dom.ast.IASTCaseStatement;
import org.eclipse.cdt.core.dom.ast.IASTCompoundStatement;
import org.eclipse.cdt.core.dom.ast.IASTConditionalExpression;
import org.eclipse.cdt.core.dom.ast.IASTContinueStatement;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarationStatement;
import org.eclipse.cdt.core.dom.ast.IASTDefaultStatement;
import org.eclipse.cdt.core.dom.ast.IASTDoStatement;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTExpressionList;
import org.eclipse.cdt.core.dom.ast.IASTExpressionStatement;
import org.eclipse.cdt.core.dom.ast.IASTForStatement;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTGotoStatement;
import org.eclipse.cdt.core.dom.ast.IASTIfStatement;
import org.eclipse.cdt.core.dom.ast.IASTLabelStatement;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTNullStatement;
import org.eclipse.cdt.core.dom.ast.IASTProblem;
import org.eclipse.cdt.core.dom.ast.IASTProblemDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTProblemStatement;
import org.eclipse.cdt.core.dom.ast.IASTReturnStatement;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTSwitchStatement;
import org.eclipse.cdt.core.dom.ast.IASTUnaryExpression;
import org.eclipse.cdt.core.dom.ast.IASTWhileStatement;
import org.eclipse.cdt.core.dom.ast.gnu.IGNUASTCompoundStatementExpression;
import org.eclipse.cdt.internal.core.dom.parser.c.CASTDeclarationStatement;
import org.sosy_lab.common.Pair;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.log.LogManagerWithoutDuplicates;
import org.sosy_lab.cpachecker.cfa.CFACreationUtils;
import org.sosy_lab.cpachecker.cfa.CSourceOriginMapping;
import org.sosy_lab.cpachecker.cfa.ast.ADeclaration;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.c.CAssignment;
import org.sosy_lab.cpachecker.cfa.ast.c.CAstNode;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpressionBuilder;
import org.sosy_lab.cpachecker.cfa.ast.c.CComplexTypeDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpressionAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpressionStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializer;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CReturnStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CRightHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.model.AbstractCFAEdge;
import org.sosy_lab.cpachecker.cfa.model.BlankEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.FunctionExitNode;
import org.sosy_lab.cpachecker.cfa.model.c.CAssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CDeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.c.CLabelNode;
import org.sosy_lab.cpachecker.cfa.model.c.CReturnStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CStatementEdge;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.c.ASTConverter;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.c.ASTOperatorConverter;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.c.CFAGenerationRuntimeException;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.c.CheckBindingVisitor;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.c.FunctionScope;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.c.Sideassignments;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.c.CDefaults;
import org.sosy_lab.cpachecker.cfa.types.c.CNumericTypes;
import org.sosy_lab.cpachecker.cfa.types.c.CSimpleType;
import org.sosy_lab.cpachecker.cfa.types.c.CTypedefType;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCCodeException;
import org.sosy_lab.cpachecker.util.CFATraversal;
import org.sosy_lab.cpachecker.util.CFAUtils;

@Options(prefix="cfa")
class CFAFunctionBuilder
extends ASTVisitor {
    private final Deque<CFANode> locStack = new ArrayDeque<CFANode>();
    private final Deque<CFANode> loopStartStack = new ArrayDeque<CFANode>();
    private final Deque<CFANode> loopNextStack = new ArrayDeque<CFANode>();
    private final Deque<CFANode> elseStack = new ArrayDeque<CFANode>();
    private final Deque<CExpression> switchExprStack = new ArrayDeque<CExpression>();
    private final Deque<CFANode> switchCaseStack = new ArrayDeque<CFANode>();
    private final Deque<CFANode> switchDefaultStack = new LinkedList<CFANode>();
    private final CBinaryExpressionBuilder binExprBuilder;
    private final Map<String, CLabelNode> labelMap = new HashMap<String, CLabelNode>();
    private final Multimap<String, Pair<CFANode, FileLocation>> gotoLabelNeeded = ArrayListMultimap.create();
    private FunctionEntryNode cfa = null;
    private Set<CFANode> cfaNodes = null;
    private final List<Pair<ADeclaration, String>> globalDeclarations = new ArrayList<Pair<ADeclaration, String>>();
    private final FunctionScope scope;
    private final ASTConverter astCreator;
    private final Function<String, String> niceFileNameFunction;
    private final LogManager logger;
    private final CheckBindingVisitor checkBinding;
    private final Sideassignments sideAssignmentStack;
    private boolean encounteredAsm = false;
    @Option(secure=true, description="Also initialize local variables with default values, or leave them uninitialized.")
    private boolean initializeAllVariables = false;
    @Option(secure=true, description="Show messages when dead code is encountered during parsing.")
    private boolean showDeadCode = true;

    public CFAFunctionBuilder(Configuration config, LogManagerWithoutDuplicates pLogger, FunctionScope pScope, Function<String, String> pNiceFileNameFunction, CSourceOriginMapping pSourceOriginMapping, MachineModel pMachine, String staticVariablePrefix, Sideassignments pSideAssignmentStack, CheckBindingVisitor pCheckBinding) throws InvalidConfigurationException {
        config.inject((Object)this);
        this.logger = pLogger;
        this.scope = pScope;
        this.astCreator = new ASTConverter(config, pScope, pLogger, pNiceFileNameFunction, pSourceOriginMapping, pMachine, staticVariablePrefix, pSideAssignmentStack);
        this.niceFileNameFunction = pNiceFileNameFunction;
        this.checkBinding = pCheckBinding;
        this.binExprBuilder = new CBinaryExpressionBuilder(pMachine, (LogManager)pLogger);
        this.shouldVisitDeclarations = true;
        this.shouldVisitEnumerators = true;
        this.shouldVisitParameterDeclarations = true;
        this.shouldVisitProblems = true;
        this.shouldVisitStatements = true;
        this.sideAssignmentStack = pSideAssignmentStack;
    }

    FunctionEntryNode getStartNode() {
        Preconditions.checkState((this.cfa != null ? 1 : 0) != 0);
        return this.cfa;
    }

    Set<CFANode> getCfaNodes() {
        Preconditions.checkState((this.cfa != null ? 1 : 0) != 0);
        Preconditions.checkState((this.cfaNodes == null ? 1 : 0) != 0);
        this.cfaNodes = CFATraversal.dfs().collectNodesReachableFrom(this.cfa);
        return this.cfaNodes;
    }

    boolean didEncounterAsm() {
        return this.encounteredAsm;
    }

    List<Pair<ADeclaration, String>> getGlobalDeclarations() {
        return this.globalDeclarations;
    }

    void finish() {
        for (CFANode node : this.cfaNodes) {
            for (CFAEdge edge : CFAUtils.enteringEdges(node).toList()) {
                if (this.cfaNodes.contains(edge.getPredecessor())) continue;
                CFACreationUtils.removeEdgeFromNodes(edge);
            }
        }
        assert (!this.sideAssignmentStack.hasPreSideAssignments());
        assert (!this.sideAssignmentStack.hasPostSideAssignments());
        assert (this.locStack.isEmpty());
        assert (this.loopStartStack.isEmpty());
        assert (this.loopNextStack.isEmpty());
        assert (this.elseStack.isEmpty());
        assert (this.switchCaseStack.isEmpty());
        assert (this.switchExprStack.isEmpty());
        assert (this.gotoLabelNeeded.isEmpty());
    }

    public int visit(IASTDeclaration declaration) {
        this.sideAssignmentStack.enterBlock();
        if (declaration instanceof IASTSimpleDeclaration) {
            return this.handleSimpleDeclaration((IASTSimpleDeclaration)declaration);
        }
        if (declaration instanceof IASTFunctionDefinition) {
            return this.handleFunctionDefinition((IASTFunctionDefinition)declaration);
        }
        if (declaration instanceof IASTProblemDeclaration) {
            this.visit(((IASTProblemDeclaration)declaration).getProblem());
            return 1;
        }
        if (declaration instanceof IASTASMDeclaration) {
            return this.ignoreASMDeclaration((IASTNode)declaration);
        }
        throw new CFAGenerationRuntimeException("Unknown declaration type " + declaration.getClass().getSimpleName(), (IASTNode)declaration, this.niceFileNameFunction);
    }

    private int handleSimpleDeclaration(IASTSimpleDeclaration sd) {
        assert (this.locStack.size() > 0) : "not in a function's scope";
        CFANode prevNode = this.locStack.pop();
        CFANode nextNode = this.createEdgeForDeclaration(sd, this.astCreator.getLocation((IASTNode)sd), prevNode);
        assert (nextNode != null);
        this.locStack.push(nextNode);
        return 1;
    }

    private CFANode createEdgeForDeclaration(IASTSimpleDeclaration sd, FileLocation fileLocation, CFANode prevNode) {
        List<CAstNode> lst = this.sideAssignmentStack.getAndResetPostSideAssignments();
        assert (lst.isEmpty()) : "post side assignments should occur only on declarations,but they occurred somewhere else and where not handled";
        List<CDeclaration> declList = this.astCreator.convert(sd);
        String rawSignature = sd.getRawSignature();
        prevNode = this.handleAllSideEffects(prevNode, fileLocation, rawSignature, true);
        for (CDeclaration newD : declList) {
            if (newD instanceof CVariableDeclaration) {
                assert (this.scope.lookupVariable(newD.getOrigName()) == newD);
                CInitializer init = ((CVariableDeclaration)newD).getInitializer();
                if (init != null) {
                    init.accept(this.checkBinding);
                } else {
                    if (((CVariableDeclaration)newD).getType() instanceof CTypedefType && ((CTypedefType)((CVariableDeclaration)newD).getType()).getName().equals("__label__")) {
                        this.scope.registerLocalLabel((CVariableDeclaration)newD);
                        CFANode nextNode = this.newCFANode();
                        BlankEdge blankEdge = new BlankEdge(sd.getRawSignature(), fileLocation, prevNode, nextNode, "Local Label Declaration: " + newD.getName());
                        this.addToCFA(blankEdge);
                        prevNode = nextNode;
                        prevNode = this.createEdgesForSideEffects(prevNode, this.sideAssignmentStack.getAndResetPostSideAssignments(), rawSignature, fileLocation);
                        return prevNode;
                    }
                    if (this.initializeAllVariables) {
                        CInitializer initializer = CDefaults.forType(newD.getType(), newD.getFileLocation());
                        newD = new CVariableDeclaration(newD.getFileLocation(), newD.isGlobal(), ((CVariableDeclaration)newD).getCStorageClass(), newD.getType(), newD.getName(), newD.getOrigName(), newD.getQualifiedName(), initializer);
                    }
                }
            } else if (newD instanceof CComplexTypeDeclaration) {
                this.scope.registerTypeDeclaration((CComplexTypeDeclaration)newD);
            } else if (newD instanceof CFunctionDeclaration) {
                if (this.scope.lookupFunction(((CFunctionDeclaration)newD).getName()) == null) {
                    this.scope.registerLocalFunction((CFunctionDeclaration)newD);
                } else {
                    return prevNode;
                }
            }
            if (newD.isGlobal()) {
                this.globalDeclarations.add((Pair<ADeclaration, String>)Pair.of((Object)newD, (Object)rawSignature));
                continue;
            }
            CFANode nextNode = this.newCFANode();
            CDeclarationEdge edge = new CDeclarationEdge(rawSignature, fileLocation, prevNode, nextNode, newD);
            this.addToCFA(edge);
            prevNode = nextNode;
        }
        prevNode = this.createEdgesForSideEffects(prevNode, this.sideAssignmentStack.getAndResetPostSideAssignments(), rawSignature, fileLocation);
        return prevNode;
    }

    private int handleFunctionDefinition(IASTFunctionDefinition declaration) {
        if (this.locStack.size() != 0) {
            throw new CFAGenerationRuntimeException("Nested function declarations?");
        }
        assert (this.labelMap.isEmpty());
        assert (this.gotoLabelNeeded.isEmpty());
        assert (this.cfa == null);
        CFunctionDeclaration fdef = this.astCreator.convert(declaration);
        String nameOfFunction = fdef.getName();
        assert (!nameOfFunction.isEmpty());
        this.scope.enterFunction(fdef);
        List<CParameterDeclaration> parameters = fdef.getParameters();
        ArrayList<String> parameterNames = new ArrayList<String>(parameters.size());
        for (CParameterDeclaration param : parameters) {
            this.scope.registerDeclaration(param);
            parameterNames.add(param.getName());
        }
        FileLocation fileloc = this.astCreator.getLocation((IASTNode)declaration);
        FunctionExitNode returnNode = new FunctionExitNode(nameOfFunction);
        CFunctionEntryNode startNode = new CFunctionEntryNode(fileloc, fdef, returnNode, parameterNames, this.scope.getReturnVariable());
        returnNode.setEntryNode(startNode);
        this.cfa = startNode;
        CFANode nextNode = this.newCFANode();
        this.locStack.add(nextNode);
        BlankEdge dummyEdge = new BlankEdge("", FileLocation.DUMMY, startNode, nextNode, "Function start dummy edge");
        this.addToCFA(dummyEdge);
        return 3;
    }

    private int ignoreASMDeclaration(IASTNode asmCode) {
        FileLocation fileloc = this.astCreator.getLocation(asmCode);
        this.logger.log(Level.FINER, new Object[]{fileloc + ": Ignoring inline assembler code."});
        this.encounteredAsm = true;
        CFANode prevNode = this.locStack.pop();
        CFANode nextNode = this.newCFANode();
        this.locStack.push(nextNode);
        BlankEdge edge = new BlankEdge(asmCode.getRawSignature(), fileloc, prevNode, nextNode, "Ignored inline assembler code");
        this.addToCFA(edge);
        return 1;
    }

    public int leave(IASTDeclaration declaration) {
        this.sideAssignmentStack.leaveBlock();
        if (declaration instanceof IASTFunctionDefinition) {
            if (this.locStack.size() != 1) {
                throw new CFAGenerationRuntimeException("Depth wrong. Geoff needs to do more work");
            }
            CFANode lastNode = this.locStack.pop();
            if (CFACreationUtils.isReachableNode(lastNode)) {
                BlankEdge blankEdge = new BlankEdge("", FileLocation.DUMMY, lastNode, this.cfa.getExitNode(), "default return");
                this.addToCFA(blankEdge);
            }
            if (!this.gotoLabelNeeded.isEmpty()) {
                throw new CFAGenerationRuntimeException("Following labels were not found in function " + this.cfa.getFunctionName() + ": " + this.gotoLabelNeeded.keySet());
            }
            Set<CFANode> reachableNodes = CFATraversal.dfs().collectNodesReachableFrom(this.cfa);
            for (CLabelNode n : this.labelMap.values()) {
                if (reachableNodes.contains(n)) continue;
                this.logDeadLabel(n);
                while (n.getNumEnteringEdges() > 0) {
                    CFACreationUtils.removeEdgeFromNodes(n.getEnteringEdge(0));
                }
                CFACreationUtils.removeChainOfNodesFromCFA(n);
            }
        }
        return 3;
    }

    private void logDeadLabel(CLabelNode n) {
        Level level = Level.INFO;
        if (n.getLabel().matches("(switch|while|ldv)_(\\d+$|\\d+_[a-z0-9]+|[a-z0-9]+___\\d+)")) {
            level = Level.FINER;
        }
        this.logger.log(level, new Object[]{"Dead code detected: Label", n.getLabel(), "is not reachable."});
    }

    public int visit(IASTStatement statement) {
        this.sideAssignmentStack.enterBlock();
        FileLocation fileloc = this.astCreator.getLocation((IASTNode)statement);
        if (statement.getPropertyInParent() == IASTIfStatement.ELSE) {
            CFANode prevNode = this.locStack.pop();
            CFANode nextNode = this.locStack.peek();
            if (CFACreationUtils.isReachableNode(prevNode)) {
                BlankEdge blankEdge = new BlankEdge("", FileLocation.DUMMY, prevNode, nextNode, "");
                this.addToCFA(blankEdge);
            }
            CFANode elseNode = this.elseStack.pop();
            this.locStack.push(elseNode);
        }
        if (statement instanceof IASTCompoundStatement) {
            if (statement.getPropertyInParent() == IGNUASTCompoundStatementExpression.STATEMENT) {
                return 1;
            }
            this.scope.enterBlock();
        } else if (statement instanceof IASTExpressionStatement) {
            this.handleExpressionStatement((IASTExpressionStatement)statement, fileloc);
        } else if (statement instanceof IASTIfStatement) {
            this.handleIfStatement((IASTIfStatement)statement, fileloc);
        } else if (statement instanceof IASTWhileStatement) {
            this.handleWhileStatement((IASTWhileStatement)statement, fileloc);
        } else {
            if (statement instanceof IASTForStatement) {
                return this.handleForStatement((IASTForStatement)statement, fileloc);
            }
            if (statement instanceof IASTBreakStatement) {
                this.handleBreakStatement((IASTBreakStatement)statement, fileloc);
            } else if (statement instanceof IASTContinueStatement) {
                this.handleContinueStatement((IASTContinueStatement)statement, fileloc);
            } else if (statement instanceof IASTLabelStatement) {
                this.handleLabelStatement((IASTLabelStatement)statement, fileloc);
            } else if (statement instanceof IASTGotoStatement) {
                this.handleGotoStatement((IASTGotoStatement)statement, fileloc);
            } else if (statement instanceof IASTReturnStatement) {
                this.handleReturnStatement((IASTReturnStatement)statement, fileloc);
            } else {
                if (statement instanceof IASTSwitchStatement) {
                    return this.handleSwitchStatement((IASTSwitchStatement)statement, fileloc);
                }
                if (statement instanceof IASTCaseStatement) {
                    this.handleCaseStatement((IASTCaseStatement)statement, fileloc);
                } else if (statement instanceof IASTDefaultStatement) {
                    this.handleDefaultStatement((IASTDefaultStatement)statement, fileloc);
                } else if (!(statement instanceof IASTNullStatement) && !(statement instanceof IASTDeclarationStatement)) {
                    if (statement instanceof IASTProblemStatement) {
                        this.visit(((IASTProblemStatement)statement).getProblem());
                    } else if (statement instanceof IASTDoStatement) {
                        this.handleDoWhileStatement((IASTDoStatement)statement, fileloc);
                    } else {
                        throw new CFAGenerationRuntimeException("Unknown AST node " + statement.getClass().getSimpleName(), (IASTNode)statement, this.niceFileNameFunction);
                    }
                }
            }
        }
        return 3;
    }

    private void handleExpressionStatement(IASTExpressionStatement exprStatement, FileLocation fileloc) {
        CFANode prevNode = this.locStack.pop();
        CFANode lastNode = null;
        String rawSignature = exprStatement.getRawSignature();
        if (exprStatement.getExpression() instanceof IASTExpressionList) {
            for (IASTExpression exp : ((IASTExpressionList)exprStatement.getExpression()).getExpressions()) {
                CStatement statement = this.astCreator.convertExpressionToStatement(exp);
                prevNode = lastNode = this.createIASTExpressionStatementEdges(rawSignature, fileloc, prevNode, statement);
            }
            assert (lastNode != null);
        } else {
            CStatement statement = this.astCreator.convert(exprStatement);
            lastNode = this.createIASTExpressionStatementEdges(rawSignature, fileloc, prevNode, statement);
        }
        this.locStack.push(lastNode);
    }

    private CFANode createIASTExpressionStatementEdges(String rawSignature, FileLocation fileloc, CFANode prevNode, CStatement statement) {
        CFANode lastNode;
        List<Pair<IASTExpression, CIdExpression>> tempVars;
        boolean resultIsUsed = true;
        if (this.sideAssignmentStack.hasConditionalExpression() && statement instanceof CExpressionStatement && (tempVars = this.sideAssignmentStack.getConditionalExpressions()).size() == 1 && tempVars.get(0).getSecond() == ((CExpressionStatement)statement).getExpression()) {
            resultIsUsed = false;
        }
        prevNode = this.handleAllSideEffects(prevNode, fileloc, rawSignature, resultIsUsed);
        statement.accept(this.checkBinding);
        if (resultIsUsed) {
            lastNode = this.newCFANode();
            CStatementEdge edge = new CStatementEdge(rawSignature, statement, fileloc, prevNode, lastNode);
            this.addToCFA(edge);
        } else {
            lastNode = prevNode;
        }
        return lastNode;
    }

    private void handleLabelStatement(IASTLabelStatement labelStatement, FileLocation fileloc) {
        String labelName = labelStatement.getName().toString();
        if (this.labelMap.containsKey(labelName) && this.scope.lookupLocalLabel(labelName) == null) {
            throw new CFAGenerationRuntimeException("Duplicate label " + labelName + " in function " + this.cfa.getFunctionName(), (IASTNode)labelStatement, this.niceFileNameFunction);
        }
        CFANode prevNode = this.locStack.pop();
        CVariableDeclaration localLabel = this.scope.lookupLocalLabel(labelName);
        if (localLabel != null) {
            labelName = localLabel.getName();
        }
        CLabelNode labelNode = new CLabelNode(this.cfa.getFunctionName(), labelName);
        this.locStack.push(labelNode);
        if (localLabel == null) {
            this.labelMap.put(labelName, labelNode);
        } else {
            this.scope.addLabelCFANode(labelNode);
        }
        boolean isPrevNodeReachable = CFACreationUtils.isReachableNode(prevNode);
        if (isPrevNodeReachable) {
            BlankEdge blankEdge = new BlankEdge(labelStatement.getRawSignature(), fileloc, prevNode, labelNode, "Label: " + labelName);
            this.addToCFA(blankEdge);
        }
        for (Pair gotoNode : this.gotoLabelNeeded.get((Object)labelName)) {
            String description = "Goto: " + labelName;
            BlankEdge gotoEdge = new BlankEdge(description, (FileLocation)gotoNode.getSecond(), (CFANode)gotoNode.getFirst(), labelNode, description);
            this.addToCFA(gotoEdge);
        }
        this.gotoLabelNeeded.removeAll((Object)labelName);
        if (!isPrevNodeReachable && CFACreationUtils.isReachableNode(labelNode)) {
            this.locStack.pop();
            CFANode node = this.newCFANode();
            BlankEdge blankEdge = new BlankEdge(labelStatement.getRawSignature(), fileloc, labelNode, node, "Label: " + labelName);
            this.addToCFA(blankEdge);
            this.locStack.push(node);
        }
    }

    private void handleGotoStatement(IASTGotoStatement gotoStatement, FileLocation fileloc) {
        String labelName = gotoStatement.getName().toString();
        CFANode prevNode = this.locStack.pop();
        CFANode labelNode = this.labelMap.get(labelName);
        CVariableDeclaration localLabel = this.scope.lookupLocalLabel(labelName);
        if (localLabel != null) {
            labelName = localLabel.getName();
            labelNode = this.scope.lookupLocalLabelNode(labelName);
        }
        if (labelNode != null) {
            BlankEdge gotoEdge = new BlankEdge(gotoStatement.getRawSignature(), fileloc, prevNode, labelNode, "Goto: " + labelName);
            if (!labelNode.isLoopStart() && this.isPathFromTo(labelNode, prevNode)) {
                labelNode.setLoopStart();
            }
            this.addToCFA(gotoEdge);
        } else {
            this.gotoLabelNeeded.put((Object)labelName, (Object)Pair.of((Object)prevNode, (Object)fileloc));
        }
        CFANode nextNode = this.newCFANode();
        this.locStack.push(nextNode);
    }

    private void handleReturnStatement(IASTReturnStatement returnStatement, FileLocation fileloc) {
        CFANode prevNode = this.locStack.pop();
        FunctionExitNode functionExitNode = this.cfa.getExitNode();
        CReturnStatement returnstmt = this.astCreator.convert(returnStatement);
        prevNode = this.handleAllSideEffects(prevNode, fileloc, returnStatement.getRawSignature(), true);
        if (returnstmt.getReturnValue().isPresent()) {
            ((CExpression)returnstmt.getReturnValue().get()).accept(this.checkBinding);
        }
        CReturnStatementEdge edge = new CReturnStatementEdge(returnStatement.getRawSignature(), returnstmt, fileloc, prevNode, functionExitNode);
        this.addToCFA(edge);
        CFANode nextNode = this.newCFANode();
        this.locStack.push(nextNode);
    }

    public int leave(IASTStatement statement) {
        this.sideAssignmentStack.leaveBlock();
        if (statement instanceof IASTIfStatement) {
            CFANode prevNode = this.locStack.pop();
            CFANode nextNode = this.locStack.peek();
            if (CFACreationUtils.isReachableNode(prevNode)) {
                for (CFAEdge prevEdge : CFAUtils.allEnteringEdges(prevNode).toList()) {
                    if (!(prevEdge instanceof BlankEdge) || !prevEdge.getDescription().equals("")) continue;
                    CFANode prevPrevNode = prevEdge.getPredecessor();
                    assert (prevPrevNode.getNumLeavingEdges() == 1);
                    prevNode.removeEnteringEdge(prevEdge);
                    prevPrevNode.removeLeavingEdge(prevEdge);
                    BlankEdge blankEdge = new BlankEdge("", prevEdge.getFileLocation(), prevPrevNode, nextNode, "");
                    this.addToCFA(blankEdge);
                }
                if (prevNode.getNumEnteringEdges() > 0) {
                    BlankEdge blankEdge = new BlankEdge("", FileLocation.DUMMY, prevNode, nextNode, "");
                    this.addToCFA(blankEdge);
                }
            }
        } else if (statement instanceof IASTCompoundStatement) {
            if (statement.getPropertyInParent() == IGNUASTCompoundStatementExpression.STATEMENT) {
                return 1;
            }
            this.scope.leaveBlock();
        } else if (statement instanceof IASTWhileStatement || statement instanceof IASTDoStatement) {
            CFANode prevNode = this.locStack.pop();
            CFANode startNode = this.loopStartStack.pop();
            if (CFACreationUtils.isReachableNode(prevNode)) {
                BlankEdge blankEdge = new BlankEdge("", FileLocation.DUMMY, prevNode, startNode, "");
                this.addToCFA(blankEdge);
            }
            CFANode nextNode = this.loopNextStack.pop();
            assert (nextNode == this.locStack.peek());
        }
        return 3;
    }

    public int visit(IASTProblem problem) {
        throw new CFAGenerationRuntimeException(problem, this.niceFileNameFunction);
    }

    private void addToCFA(CFAEdge edge) {
        CFACreationUtils.addEdgeToCFA(edge, this.logger, this.showDeadCode);
    }

    private CFANode newCFANode() {
        assert (this.cfa != null);
        CFANode nextNode = new CFANode(this.cfa.getFunctionName());
        return nextNode;
    }

    private boolean isPathFromTo(CFANode fromNode, CFANode toNode) {
        ArrayDeque<CFANode> toProcessForwards = new ArrayDeque<CFANode>();
        ArrayDeque<CFANode> toProcessBackwards = new ArrayDeque<CFANode>();
        HashSet<CFANode> visitedForwards = new HashSet<CFANode>();
        HashSet<CFANode> visitedBackwards = new HashSet<CFANode>();
        toProcessForwards.addLast(fromNode);
        visitedForwards.add(fromNode);
        toProcessBackwards.addLast(toNode);
        visitedBackwards.add(toNode);
        while (!toProcessForwards.isEmpty() && !toProcessBackwards.isEmpty()) {
            CFANode currentForwards = (CFANode)toProcessForwards.removeLast();
            if (visitedBackwards.contains(currentForwards)) {
                return true;
            }
            for (CFANode successor : CFAUtils.successorsOf(currentForwards)) {
                if (!visitedForwards.add(successor)) continue;
                toProcessForwards.addLast(successor);
            }
            CFANode currentBackwards = (CFANode)toProcessBackwards.removeLast();
            if (visitedForwards.contains(currentBackwards)) {
                return true;
            }
            for (CFANode predecessor : CFAUtils.predecessorsOf(currentBackwards)) {
                if (!visitedBackwards.add(predecessor)) continue;
                toProcessBackwards.addLast(predecessor);
            }
        }
        return false;
    }

    private CFANode createEdgeForExpression(IASTExpression expression, FileLocation fileLocation, CFANode prevNode, @Nullable CFANode lastNode) {
        assert (expression != null);
        if (expression instanceof IASTExpressionList) {
            IASTExpression[] expressions = ((IASTExpressionList)expression).getExpressions();
            CFANode nextNode = null;
            for (int i = 0; i < expressions.length; ++i) {
                nextNode = lastNode != null && i == expressions.length - 1 ? lastNode : this.newCFANode();
                this.createEdgeForExpression(expressions[i], fileLocation, prevNode, nextNode);
                prevNode = nextNode;
            }
            return nextNode;
        }
        String rawSignature = expression.getRawSignature();
        CStatement stmt = this.astCreator.convertExpressionToStatement(expression);
        prevNode = this.handleAllSideEffects(prevNode, fileLocation, rawSignature, true);
        stmt.accept(this.checkBinding);
        if (lastNode == null) {
            lastNode = this.newCFANode();
        }
        CStatementEdge lastEdge = new CStatementEdge(rawSignature, stmt, fileLocation, prevNode, lastNode);
        this.addToCFA(lastEdge);
        return lastNode;
    }

    private CBinaryExpression buildBinaryExpression(CExpression operand1, CExpression operand2, CBinaryExpression.BinaryOperator op) {
        try {
            return this.binExprBuilder.buildBinaryExpression(operand1, operand2, op);
        }
        catch (UnrecognizedCCodeException e) {
            throw new CFAGenerationRuntimeException(e);
        }
    }

    private void handleIfStatement(IASTIfStatement ifStatement, FileLocation fileloc) {
        CFANode elseNode;
        CFANode prevNode = this.locStack.pop();
        CFANode postIfNode = this.newCFANode();
        this.locStack.push(postIfNode);
        CFANode thenNode = this.newCFANode();
        this.locStack.push(thenNode);
        if (ifStatement.getElseClause() == null) {
            elseNode = postIfNode;
        } else {
            elseNode = this.newCFANode();
            this.elseStack.push(elseNode);
        }
        this.createConditionEdges(ifStatement.getConditionExpression(), fileloc, prevNode, thenNode, elseNode);
    }

    private Optional<CExpression> createConditionEdges(IASTExpression condition, FileLocation fileLocation, CFANode rootNode, CFANode thenNode, CFANode elseNode) {
        assert (condition != null);
        return this.buildConditionTree(condition, fileLocation, rootNode, thenNode, elseNode, thenNode, elseNode, true, true);
    }

    private Optional<CExpression> buildConditionTree(IASTExpression condition, FileLocation fileLocation, CFANode rootNode, CFANode thenNode, CFANode elseNode, CFANode thenNodeForLastThen, CFANode elseNodeForLastElse, boolean furtherThenComputation, boolean furtherElseComputation) {
        if (condition instanceof IASTUnaryExpression && ((IASTUnaryExpression)condition).getOperator() == 11) {
            return this.buildConditionTree(((IASTUnaryExpression)condition).getOperand(), fileLocation, rootNode, thenNode, elseNode, thenNode, elseNode, true, true);
        }
        if (condition instanceof IASTUnaryExpression && ((IASTUnaryExpression)condition).getOperator() == 7) {
            this.buildConditionTree(((IASTUnaryExpression)condition).getOperand(), fileLocation, rootNode, elseNode, thenNode, elseNode, thenNode, true, true);
            return Optional.absent();
        }
        if (condition instanceof IASTBinaryExpression && ((IASTBinaryExpression)condition).getOperator() == 15) {
            CFANode innerNode = this.newCFANode();
            this.buildConditionTree(((IASTBinaryExpression)condition).getOperand1(), fileLocation, rootNode, innerNode, elseNode, thenNodeForLastThen, elseNodeForLastElse, true, false);
            this.buildConditionTree(((IASTBinaryExpression)condition).getOperand2(), fileLocation, innerNode, thenNode, elseNode, thenNodeForLastThen, elseNodeForLastElse, true, true);
            return Optional.absent();
        }
        if (condition instanceof IASTBinaryExpression && ((IASTBinaryExpression)condition).getOperator() == 16) {
            CFANode innerNode = this.newCFANode();
            this.buildConditionTree(((IASTBinaryExpression)condition).getOperand1(), fileLocation, rootNode, thenNode, innerNode, thenNodeForLastThen, elseNodeForLastElse, false, true);
            this.buildConditionTree(((IASTBinaryExpression)condition).getOperand2(), fileLocation, innerNode, thenNode, elseNode, thenNodeForLastThen, elseNodeForLastElse, true, true);
            return Optional.absent();
        }
        String rawSignature = condition.getRawSignature();
        CExpression exp = this.astCreator.convertExpressionWithoutSideEffects(condition);
        rootNode = this.handleAllSideEffects(rootNode, fileLocation, rawSignature, true);
        exp.accept(this.checkBinding);
        ASTConverter.CONDITION kind = this.astCreator.getConditionKind(exp);
        switch (kind) {
            case ALWAYS_FALSE: {
                BlankEdge falseEdge = new BlankEdge(rawSignature, fileLocation, rootNode, elseNode, "");
                this.addToCFA(falseEdge);
                return Optional.of((Object)CIntegerLiteralExpression.ZERO);
            }
            case ALWAYS_TRUE: {
                BlankEdge trueEdge = new BlankEdge(rawSignature, fileLocation, rootNode, thenNode, "");
                this.addToCFA(trueEdge);
                return Optional.of((Object)CIntegerLiteralExpression.ONE);
            }
            default: {
                throw new AssertionError();
            }
            case NORMAL: 
        }
        if (furtherThenComputation) {
            thenNodeForLastThen = thenNode;
        }
        if (furtherElseComputation) {
            elseNodeForLastElse = elseNode;
        }
        FileLocation loc = this.astCreator.getLocation((IASTNode)condition);
        if (fileLocation.getStartingLineNumber() < loc.getStartingLineNumber()) {
            loc = new FileLocation(loc.getEndingLineNumber(), loc.getFileName(), (String)this.niceFileNameFunction.apply((Object)loc.getFileName()), loc.getNodeLength() + loc.getNodeOffset() - fileLocation.getNodeOffset(), fileLocation.getNodeOffset(), fileLocation.getStartingLineNumber(), fileLocation.getStartingLineInOrigin());
        }
        if (ASTOperatorConverter.isBooleanExpression(exp)) {
            this.addConditionEdges(exp, rootNode, thenNodeForLastThen, elseNodeForLastElse, loc);
            return Optional.of((Object)exp);
        }
        CBinaryExpression conv = this.buildBinaryExpression(exp, CIntegerLiteralExpression.ZERO, CBinaryExpression.BinaryOperator.EQUALS);
        this.addConditionEdges(conv, rootNode, elseNodeForLastElse, thenNodeForLastThen, loc);
        return Optional.of((Object)exp);
    }

    private void addConditionEdges(CExpression condition, CFANode rootNode, CFANode thenNode, CFANode elseNode, FileLocation fileLocation) {
        CAssumeEdge trueEdge = new CAssumeEdge(condition.toASTString(), fileLocation, rootNode, thenNode, condition, true);
        this.addToCFA(trueEdge);
        CAssumeEdge falseEdge = new CAssumeEdge("!(" + condition.toASTString() + ")", fileLocation, rootNode, elseNode, condition, false);
        this.addToCFA(falseEdge);
    }

    private void handleWhileStatement(IASTWhileStatement whileStatement, FileLocation fileloc) {
        CFANode prevNode = this.locStack.pop();
        this.createLoop(whileStatement.getCondition(), fileloc);
        BlankEdge blankEdge = new BlankEdge("", fileloc, prevNode, this.loopStartStack.peek(), "while");
        this.addToCFA(blankEdge);
    }

    private void handleDoWhileStatement(IASTDoStatement doStatement, FileLocation fileloc) {
        CFANode prevNode = this.locStack.pop();
        this.createLoop(doStatement.getCondition(), fileloc);
        BlankEdge blankEdge = new BlankEdge("", fileloc, prevNode, this.locStack.peek(), "do");
        this.addToCFA(blankEdge);
    }

    private void createLoop(IASTExpression condition, FileLocation fileloc) {
        CFANode loopStart = this.newCFANode();
        loopStart.setLoopStart();
        this.loopStartStack.push(loopStart);
        CFANode firstLoopNode = this.newCFANode();
        CFANode postLoopNode = this.newCFANode();
        this.loopNextStack.push(postLoopNode);
        this.locStack.push(postLoopNode);
        this.locStack.push(firstLoopNode);
        this.createConditionEdges(condition, fileloc, loopStart, firstLoopNode, postLoopNode);
    }

    private void handleBreakStatement(IASTBreakStatement breakStatement, FileLocation fileloc) {
        CFANode prevNode = this.locStack.pop();
        CFANode postLoopNode = this.loopNextStack.peek();
        BlankEdge blankEdge = new BlankEdge(breakStatement.getRawSignature(), fileloc, prevNode, postLoopNode, "break");
        this.addToCFA(blankEdge);
        CFANode nextNode = this.newCFANode();
        this.locStack.push(nextNode);
    }

    private void handleContinueStatement(IASTContinueStatement continueStatement, FileLocation fileloc) {
        CFANode prevNode = this.locStack.pop();
        CFANode loopStartNode = this.loopStartStack.peek();
        BlankEdge blankEdge = new BlankEdge(continueStatement.getRawSignature(), fileloc, prevNode, loopStartNode, "continue");
        this.addToCFA(blankEdge);
        CFANode nextNode = new CFANode(this.cfa.getFunctionName());
        this.locStack.push(nextNode);
    }

    private int handleForStatement(IASTForStatement forStatement, FileLocation fileLocation) {
        CFANode prevNode = this.locStack.pop();
        this.scope.enterBlock();
        CFANode loopInit = this.newCFANode();
        this.addToCFA(new BlankEdge("", fileLocation, prevNode, loopInit, "for"));
        CFANode loopStart = this.createInitEdgeForForLoop(forStatement.getInitializerStatement(), fileLocation, loopInit);
        loopStart.setLoopStart();
        IASTExpression iterationExpression = forStatement.getIterationExpression();
        CFANode loopEnd = iterationExpression != null ? this.newCFANode() : loopStart;
        this.loopStartStack.push(loopEnd);
        CFANode firstLoopNode = this.newCFANode();
        CFANode postLoopNode = this.newCFANode();
        this.loopNextStack.push(postLoopNode);
        this.locStack.push(postLoopNode);
        this.locStack.push(firstLoopNode);
        this.createConditionEdgesForForLoop(forStatement.getConditionExpression(), fileLocation, loopStart, postLoopNode, firstLoopNode);
        forStatement.getBody().accept((ASTVisitor)this);
        CFANode lastNodeInLoop = this.locStack.pop();
        assert (loopEnd == this.loopStartStack.peek());
        assert (postLoopNode == this.loopNextStack.peek());
        assert (postLoopNode == this.locStack.peek());
        this.loopStartStack.pop();
        this.loopNextStack.pop();
        if (CFACreationUtils.isReachableNode(lastNodeInLoop)) {
            BlankEdge blankEdge = new BlankEdge("", FileLocation.DUMMY, lastNodeInLoop, loopEnd, "");
            this.addToCFA(blankEdge);
        }
        if (iterationExpression != null) {
            this.createEdgeForExpression(iterationExpression, fileLocation, loopEnd, loopStart);
        } else assert (loopEnd == loopStart);
        this.scope.leaveBlock();
        return 1;
    }

    private CFANode createInitEdgeForForLoop(IASTStatement statement, FileLocation fileLocation, CFANode prevNode) {
        if (statement instanceof IASTDeclarationStatement) {
            IASTDeclaration decl = ((IASTDeclarationStatement)statement).getDeclaration();
            if (!(decl instanceof IASTSimpleDeclaration)) {
                throw new CFAGenerationRuntimeException("Unexpected declaration in header of for loop", (IASTNode)decl, this.niceFileNameFunction);
            }
            return this.createEdgeForDeclaration((IASTSimpleDeclaration)decl, fileLocation, prevNode);
        }
        if (statement instanceof IASTExpressionStatement) {
            IASTExpression expression = ((IASTExpressionStatement)statement).getExpression();
            return this.createEdgeForExpression(expression, fileLocation, prevNode, null);
        }
        if (statement instanceof IASTNullStatement) {
            return prevNode;
        }
        throw new CFAGenerationRuntimeException("Unexpected statement type in header of for loop", (IASTNode)statement, this.niceFileNameFunction);
    }

    private void createConditionEdgesForForLoop(IASTExpression condition, FileLocation fileLocation, CFANode loopStart, CFANode postLoopNode, CFANode firstLoopNode) {
        if (condition == null) {
            BlankEdge blankEdge = new BlankEdge("", fileLocation, loopStart, firstLoopNode, "");
            this.addToCFA(blankEdge);
        } else if (condition instanceof IASTExpressionList) {
            IASTExpression[] expl = ((IASTExpressionList)condition).getExpressions();
            for (int i = 0; i < expl.length - 1; ++i) {
                loopStart = this.createEdgeForExpression(expl[i], fileLocation, loopStart, null);
            }
            this.createConditionEdges(expl[expl.length - 1], fileLocation, loopStart, firstLoopNode, postLoopNode);
        } else {
            this.createConditionEdges(condition, fileLocation, loopStart, firstLoopNode, postLoopNode);
        }
    }

    private int handleSwitchStatement(IASTSwitchStatement statement, FileLocation fileloc) {
        CFANode prevNode = this.locStack.pop();
        CExpression switchExpression = this.astCreator.convertExpressionWithoutSideEffects(statement.getControllerExpression());
        prevNode = this.handleAllSideEffects(prevNode, switchExpression.getFileLocation(), statement.getRawSignature(), true);
        CFANode firstSwitchNode = this.newCFANode();
        String rawSignature = "switch (" + statement.getControllerExpression().getRawSignature() + ")";
        String description = "switch (" + switchExpression.toASTString() + ")";
        this.addToCFA(new BlankEdge(rawSignature, fileloc, prevNode, firstSwitchNode, description));
        this.switchExprStack.push(switchExpression);
        this.switchCaseStack.push(firstSwitchNode);
        CFANode postSwitchNode = this.newCFANode();
        this.loopNextStack.push(postSwitchNode);
        this.locStack.push(postSwitchNode);
        this.locStack.push(new CFANode(this.cfa.getFunctionName()));
        this.switchDefaultStack.push(null);
        statement.getBody().accept((ASTVisitor)this);
        CFANode lastNodeInSwitch = this.locStack.pop();
        CFANode lastNotCaseNode = this.switchCaseStack.pop();
        CFANode defaultCaseNode = this.switchDefaultStack.pop();
        this.switchExprStack.pop();
        assert (postSwitchNode == this.loopNextStack.peek());
        assert (postSwitchNode == this.locStack.peek());
        assert (this.switchExprStack.size() == this.switchCaseStack.size());
        this.loopNextStack.pop();
        if (defaultCaseNode == null) {
            BlankEdge blankEdge = new BlankEdge("", FileLocation.DUMMY, lastNotCaseNode, postSwitchNode, "");
            this.addToCFA(blankEdge);
        } else {
            BlankEdge defaultEdge = new BlankEdge(statement.getRawSignature(), FileLocation.DUMMY, lastNotCaseNode, defaultCaseNode, "default");
            this.addToCFA(defaultEdge);
        }
        BlankEdge blankEdge2 = new BlankEdge("", FileLocation.DUMMY, lastNodeInSwitch, postSwitchNode, "");
        this.addToCFA(blankEdge2);
        return 1;
    }

    private void handleCaseStatement(IASTCaseStatement statement, FileLocation fileLocation) {
        IASTExpression right = statement.getExpression();
        CFANode rootNode = this.switchCaseStack.pop();
        CExpression switchExpr = this.switchExprStack.peek();
        CFANode caseNode = this.newCFANode();
        CFANode notCaseNode = this.newCFANode();
        CFANode nextCaseStartsAtNode = right instanceof IASTBinaryExpression && ((IASTBinaryExpression)right).getOperator() == 34 ? this.handleCaseRangeStatement((IASTBinaryExpression)right, switchExpr, rootNode, caseNode, notCaseNode, fileLocation) : this.handleCaseSingleStatement(statement.getExpression(), switchExpr, rootNode, caseNode, notCaseNode, fileLocation);
        CFANode oldNode = this.locStack.pop();
        if (oldNode.getNumEnteringEdges() > 0 || oldNode instanceof CLabelNode) {
            BlankEdge blankEdge = new BlankEdge("", fileLocation, oldNode, caseNode, "fall through");
            this.addToCFA(blankEdge);
        }
        this.switchCaseStack.push(nextCaseStartsAtNode);
        this.locStack.push(caseNode);
    }

    private CFANode handleCaseSingleStatement(IASTExpression right, CExpression switchExpr, CFANode rootNode, CFANode caseNode, CFANode notCaseNode, FileLocation fileLocation) {
        CFANode nextCaseStartsAtNode;
        CExpression caseExpr = this.astCreator.convertExpressionWithoutSideEffects(right);
        CBinaryExpression binExp = this.buildBinaryExpression(switchExpr, caseExpr, CBinaryExpression.BinaryOperator.EQUALS);
        CExpression exp = this.astCreator.simplifyExpressionOneStep(binExp);
        switch (this.astCreator.getConditionKind(exp)) {
            case ALWAYS_FALSE: {
                nextCaseStartsAtNode = rootNode;
                break;
            }
            case ALWAYS_TRUE: {
                BlankEdge trueEdge = new BlankEdge("", fileLocation, rootNode, caseNode, "__case__[" + binExp.toASTString() + "]");
                this.addToCFA(trueEdge);
                nextCaseStartsAtNode = notCaseNode;
                break;
            }
            case NORMAL: {
                assert (ASTOperatorConverter.isBooleanExpression(exp));
                this.addConditionEdges(exp, rootNode, caseNode, notCaseNode, fileLocation);
                nextCaseStartsAtNode = notCaseNode;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return nextCaseStartsAtNode;
    }

    private CFANode handleCaseRangeStatement(IASTBinaryExpression range, CExpression switchExpr, CFANode rootNode, CFANode caseNode, CFANode notCaseNode, FileLocation fileLocation) {
        CFANode nextCaseStartsAtNode;
        CExpression smallEnd = this.astCreator.convertExpressionWithoutSideEffects(range.getOperand1());
        CExpression bigEnd = this.astCreator.convertExpressionWithoutSideEffects(range.getOperand2());
        CBinaryExpression firstPart = this.buildBinaryExpression(smallEnd, switchExpr, CBinaryExpression.BinaryOperator.LESS_EQUAL);
        CBinaryExpression secondPart = this.buildBinaryExpression(switchExpr, bigEnd, CBinaryExpression.BinaryOperator.LESS_EQUAL);
        CExpression firstExp = this.astCreator.simplifyExpressionOneStep(firstPart);
        ASTConverter.CONDITION firstKind = this.astCreator.getConditionKind(firstExp);
        CExpression secondExp = this.astCreator.simplifyExpressionOneStep(secondPart);
        ASTConverter.CONDITION secondKind = this.astCreator.getConditionKind(secondExp);
        if (firstKind == ASTConverter.CONDITION.ALWAYS_FALSE || secondKind == ASTConverter.CONDITION.ALWAYS_FALSE) {
            nextCaseStartsAtNode = rootNode;
        } else if (firstKind == ASTConverter.CONDITION.ALWAYS_TRUE && secondKind == ASTConverter.CONDITION.ALWAYS_TRUE) {
            BlankEdge trueEdge = new BlankEdge("", fileLocation, rootNode, caseNode, "__case__[" + firstPart + " && " + secondPart + "]");
            this.addToCFA(trueEdge);
            nextCaseStartsAtNode = notCaseNode;
        } else {
            assert (firstKind == ASTConverter.CONDITION.NORMAL && secondKind == ASTConverter.CONDITION.NORMAL) : "either both conditions can be evaluated or not, but mixed is not allowed";
            CFANode intermediateNode = this.newCFANode();
            this.addConditionEdges(firstExp, rootNode, intermediateNode, notCaseNode, fileLocation);
            this.addConditionEdges(secondExp, intermediateNode, caseNode, notCaseNode, fileLocation);
            nextCaseStartsAtNode = notCaseNode;
        }
        return nextCaseStartsAtNode;
    }

    private void handleDefaultStatement(IASTDefaultStatement statement, FileLocation fileLocation) {
        CLabelNode caseNode = new CLabelNode(this.cfa.getFunctionName(), "__switch__default__");
        CFANode oldDefaultNode = this.switchDefaultStack.pop();
        if (oldDefaultNode != null) {
            throw new CFAGenerationRuntimeException("Duplicate default statement in switch", (IASTNode)statement, this.niceFileNameFunction);
        }
        this.switchDefaultStack.push(caseNode);
        CFANode oldNode = this.locStack.pop();
        if (oldNode.getNumEnteringEdges() > 0) {
            BlankEdge blankEdge = new BlankEdge("", fileLocation, oldNode, caseNode, "fall through");
            this.addToCFA(blankEdge);
        }
        this.locStack.push(caseNode);
    }

    private CFANode handleAllSideEffects(CFANode prevNode, FileLocation fileLocation, String rawSignature, boolean resultIsUsed) {
        if (this.sideAssignmentStack.hasConditionalExpression() && !resultIsUsed) {
            List<Pair<IASTExpression, CIdExpression>> condExps = this.sideAssignmentStack.getAndResetConditionalExpressions();
            assert (condExps.size() == 1);
            this.sideAssignmentStack.getAndResetPreSideAssignments();
            prevNode = this.handleConditionalExpression(prevNode, (IASTExpression)condExps.get(0).getFirst(), null);
        } else {
            prevNode = this.createEdgesForSideEffects(prevNode, this.sideAssignmentStack.getAndResetPreSideAssignments(), rawSignature, fileLocation);
            for (Pair<IASTExpression, CIdExpression> cond : this.sideAssignmentStack.getAndResetConditionalExpressions()) {
                IASTExpression condExp = (IASTExpression)cond.getFirst();
                CIdExpression tempVar = (CIdExpression)cond.getSecond();
                prevNode = this.handleConditionalExpression(prevNode, condExp, tempVar);
            }
        }
        return prevNode;
    }

    private CFANode handleConditionalExpression(CFANode prevNode, IASTExpression condExp, @Nullable CIdExpression tempVar) {
        if (condExp instanceof IASTConditionalExpression) {
            return this.handleTernaryOperator((IASTConditionalExpression)condExp, prevNode, tempVar);
        }
        if (condExp instanceof IASTBinaryExpression) {
            return this.handleShortcuttingOperators((IASTBinaryExpression)condExp, prevNode, tempVar);
        }
        if (condExp instanceof IGNUASTCompoundStatementExpression) {
            return this.handleCompoundStatementExpression((IGNUASTCompoundStatementExpression)condExp, prevNode, tempVar);
        }
        if (condExp instanceof IASTExpressionList) {
            return this.handleExpressionList((IASTExpressionList)condExp, prevNode, tempVar);
        }
        throw new AssertionError();
    }

    private CFANode handleExpressionList(IASTExpressionList listExp, CFANode prevNode, CIdExpression tempVar) {
        IASTExpression[] expressions = listExp.getExpressions();
        for (int i = 0; i < expressions.length - 1; ++i) {
            IASTExpression e = expressions[i];
            prevNode = this.createEdgeForExpression(e, this.astCreator.getLocation((IASTNode)e), prevNode, null);
        }
        IASTExpression lastExp = expressions[expressions.length - 1];
        CAstNode exp = this.astCreator.convertExpressionWithSideEffects(lastExp);
        FileLocation lastExpLocation = this.astCreator.getLocation((IASTNode)lastExp);
        prevNode = this.handleAllSideEffects(prevNode, lastExpLocation, lastExp.getRawSignature(), true);
        CStatement stmt = null;
        if (tempVar != null) {
            stmt = this.createStatement(lastExpLocation, tempVar, (CRightHandSide)exp);
        } else if (exp instanceof CStatement) {
            stmt = (CStatement)exp;
        } else {
            if (!(exp instanceof CRightHandSide)) {
                throw new CFAGenerationRuntimeException("invalid expression type");
            }
            stmt = this.createStatement(lastExpLocation, null, (CRightHandSide)exp);
        }
        CFANode lastNode = this.newCFANode();
        CStatementEdge edge = new CStatementEdge(stmt.toASTString(), stmt, lastExpLocation, prevNode, lastNode);
        this.addToCFA(edge);
        return lastNode;
    }

    private CFANode handleCompoundStatementExpression(IGNUASTCompoundStatementExpression compoundExp, CFANode rootNode, CIdExpression tempVar) {
        this.scope.enterBlock();
        IASTStatement[] statements = compoundExp.getCompoundStatement().getStatements();
        if (statements.length == 0) {
            throw new CFAGenerationRuntimeException("Empty compound-statement expression", (IASTNode)compoundExp, this.niceFileNameFunction);
        }
        int locDepth = this.locStack.size();
        int conditionDepth = this.elseStack.size();
        int loopDepth = this.loopStartStack.size();
        this.locStack.push(rootNode);
        for (int i = 0; i < statements.length - 1; ++i) {
            IASTStatement statement = statements[i];
            statement.accept((ASTVisitor)this);
        }
        CFANode middleNode = this.locStack.pop();
        assert (locDepth == this.locStack.size());
        assert (conditionDepth == this.elseStack.size());
        assert (loopDepth == this.loopStartStack.size());
        IASTStatement lastStatement = statements[statements.length - 1];
        if (lastStatement instanceof IASTProblemStatement) {
            throw new CFAGenerationRuntimeException((IASTProblemStatement)lastStatement, this.niceFileNameFunction);
        }
        if (lastStatement instanceof CASTDeclarationStatement && tempVar == null) {
            this.locStack.push(middleNode);
            this.visit(lastStatement);
            return this.locStack.pop();
        }
        FileLocation fileLocation = this.astCreator.getLocation((IASTNode)compoundExp);
        if (!(lastStatement instanceof IASTExpressionStatement)) {
            if (tempVar == null) {
                CFANode lastNode = this.handleAllSideEffects(middleNode, fileLocation, lastStatement.getRawSignature(), true);
                this.scope.leaveBlock();
                return lastNode;
            }
            throw new CFAGenerationRuntimeException("Unsupported statement type " + lastStatement.getClass().getSimpleName() + " at end of compound-statement expression", (IASTNode)lastStatement, this.niceFileNameFunction);
        }
        CAstNode exp = this.astCreator.convertExpressionWithSideEffects(((IASTExpressionStatement)lastStatement).getExpression());
        middleNode = this.handleAllSideEffects(middleNode, fileLocation, lastStatement.getRawSignature(), true);
        CStatement stmt = exp instanceof CStatement ? (CStatement)exp : this.createStatement(this.astCreator.getLocation((IASTNode)compoundExp), tempVar, (CRightHandSide)exp);
        CFANode lastNode = this.newCFANode();
        CStatementEdge edge = new CStatementEdge(stmt.toASTString(), stmt, fileLocation, middleNode, lastNode);
        this.addToCFA(edge);
        this.scope.leaveBlock();
        return lastNode;
    }

    private CFANode handleShortcuttingOperators(IASTBinaryExpression binExp, CFANode rootNode, CIdExpression tempVar) {
        FileLocation fileLocation = this.astCreator.getLocation((IASTNode)binExp);
        CFANode intermediateNode = this.newCFANode();
        CFANode thenNode = this.newCFANode();
        CFANode elseNode = this.newCFANode();
        switch (binExp.getOperator()) {
            case 15: {
                this.createConditionEdges(binExp.getOperand1(), fileLocation, rootNode, intermediateNode, elseNode);
                break;
            }
            case 16: {
                this.createConditionEdges(binExp.getOperand1(), fileLocation, rootNode, thenNode, intermediateNode);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        this.createConditionEdges(binExp.getOperand2(), fileLocation, intermediateNode, thenNode, elseNode);
        CFANode lastNode = this.newCFANode();
        if (tempVar != null) {
            FileLocation loc = this.astCreator.getLocation((IASTNode)binExp);
            CSimpleType intType = CNumericTypes.INT;
            CIntegerLiteralExpression one = new CIntegerLiteralExpression(loc, intType, BigInteger.ONE);
            CStatement assignOne = this.createStatement(loc, tempVar, one);
            CStatementEdge trueEdge = new CStatementEdge(binExp.getRawSignature(), assignOne, FileLocation.DUMMY, thenNode, lastNode);
            this.addToCFA(trueEdge);
            CIntegerLiteralExpression zero = new CIntegerLiteralExpression(loc, intType, BigInteger.ZERO);
            CStatement assignZero = this.createStatement(loc, tempVar, zero);
            CStatementEdge falseEdge = new CStatementEdge(binExp.getRawSignature(), assignZero, FileLocation.DUMMY, elseNode, lastNode);
            this.addToCFA(falseEdge);
        } else {
            BlankEdge trueEdge = new BlankEdge("", fileLocation, thenNode, lastNode, "");
            this.addToCFA(trueEdge);
            BlankEdge falseEdge = new BlankEdge("", fileLocation, elseNode, lastNode, "");
            this.addToCFA(falseEdge);
        }
        return lastNode;
    }

    private CFANode handleTernaryOperator(IASTConditionalExpression condExp, CFANode rootNode, CIdExpression tempVar) {
        FileLocation fileLocation = this.astCreator.getLocation((IASTNode)condExp);
        CFANode thenNode = this.newCFANode();
        CFANode elseNode = this.newCFANode();
        Optional<CExpression> condition = this.createConditionEdges(condExp.getLogicalConditionExpression(), fileLocation, rootNode, thenNode, elseNode);
        CFANode lastNode = this.newCFANode();
        if (condExp.getPositiveResultExpression() == null) {
            if (condition.isPresent()) {
                this.createEdgesForTernaryOperatorBranch((CAstNode)condition.get(), condExp.getLogicalConditionExpression(), lastNode, fileLocation, thenNode, tempVar);
            } else {
                this.createEdgesForTernaryOperatorBranch(condExp.getLogicalConditionExpression(), lastNode, fileLocation, thenNode, tempVar);
            }
        } else {
            this.createEdgesForTernaryOperatorBranch(condExp.getPositiveResultExpression(), lastNode, fileLocation, thenNode, tempVar);
        }
        this.createEdgesForTernaryOperatorBranch(condExp.getNegativeResultExpression(), lastNode, fileLocation, elseNode, tempVar);
        return lastNode;
    }

    private void createEdgesForTernaryOperatorBranch(IASTExpression condExp, CFANode lastNode, FileLocation fileLocation, CFANode prevNode, @Nullable CIdExpression tempVar) {
        this.createEdgesForTernaryOperatorBranch(this.astCreator.convertExpressionWithSideEffects(condExp), condExp, lastNode, fileLocation, prevNode, tempVar);
    }

    private void createEdgesForTernaryOperatorBranch(CAstNode exp, IASTExpression condExp, CFANode lastNode, FileLocation fileLocation, CFANode prevNode, @Nullable CIdExpression tempVar) {
        if (!this.sideAssignmentStack.hasConditionalExpression()) {
            CStatementEdge edge;
            prevNode = this.createEdgesForSideEffects(prevNode, this.sideAssignmentStack.getAndResetPreSideAssignments(), exp.toASTString(), fileLocation);
            if (exp instanceof CStatement) {
                assert (exp instanceof CAssignment);
                CFANode middle = this.newCFANode();
                edge = new CStatementEdge(condExp.getRawSignature(), (CStatement)exp, fileLocation, prevNode, middle);
                this.addToCFA(edge);
                prevNode = middle;
                exp = ((CAssignment)exp).getLeftHandSide();
            }
            assert (exp instanceof CRightHandSide);
            CStatement stmt = this.createStatement(this.astCreator.getLocation((IASTNode)condExp), tempVar, (CRightHandSide)exp);
            edge = new CStatementEdge(condExp.getRawSignature(), stmt, fileLocation, prevNode, lastNode);
            this.addToCFA(edge);
        } else {
            assert (exp instanceof CRightHandSide);
            boolean resultIsUsed = tempVar != null || this.sideAssignmentStack.getConditionalExpressions().size() > 1 || exp != this.sideAssignmentStack.getConditionalExpressions().get(0).getSecond();
            prevNode = this.handleAllSideEffects(prevNode, fileLocation, condExp.getRawSignature(), resultIsUsed);
            if (resultIsUsed) {
                CStatement stmt = this.createStatement(this.astCreator.getLocation((IASTNode)condExp), tempVar, (CRightHandSide)exp);
                this.addToCFA(new CStatementEdge(stmt.toASTString(), stmt, fileLocation, prevNode, lastNode));
            } else {
                this.addToCFA(new BlankEdge("", fileLocation, prevNode, lastNode, ""));
            }
        }
    }

    private CFANode createEdgesForSideEffects(CFANode prevNode, List<CAstNode> sideeffects, String rawSignature, FileLocation fileLocation) {
        for (CAstNode sideeffect : sideeffects) {
            AbstractCFAEdge edge;
            CFANode nextNode = this.newCFANode();
            if (sideeffect instanceof CExpression) {
                sideeffect = new CExpressionStatement(sideeffect.getFileLocation(), (CExpression)sideeffect);
            }
            if (sideeffect instanceof CStatement) {
                ((CStatement)sideeffect).accept(this.checkBinding);
                edge = new CStatementEdge(rawSignature, (CStatement)sideeffect, fileLocation, prevNode, nextNode);
            } else if (sideeffect instanceof CDeclaration) {
                CInitializer init;
                if (sideeffect instanceof CVariableDeclaration && (init = ((CVariableDeclaration)sideeffect).getInitializer()) != null) {
                    init.accept(this.checkBinding);
                }
                edge = new CDeclarationEdge(rawSignature, fileLocation, prevNode, nextNode, (CDeclaration)sideeffect);
            } else {
                throw new AssertionError();
            }
            this.addToCFA(edge);
            prevNode = nextNode;
        }
        return prevNode;
    }

    private CStatement createStatement(FileLocation fileLoc, @Nullable CIdExpression leftHandSide, CRightHandSide rightHandSide) {
        rightHandSide.accept(this.checkBinding);
        if (leftHandSide != null) {
            leftHandSide.accept(this.checkBinding);
            if (rightHandSide instanceof CExpression) {
                return new CExpressionAssignmentStatement(fileLoc, leftHandSide, (CExpression)rightHandSide);
            }
            if (rightHandSide instanceof CFunctionCallExpression) {
                return new CFunctionCallAssignmentStatement(fileLoc, leftHandSide, (CFunctionCallExpression)rightHandSide);
            }
            throw new AssertionError();
        }
        if (rightHandSide instanceof CExpression) {
            return new CExpressionStatement(fileLoc, (CExpression)rightHandSide);
        }
        if (rightHandSide instanceof CFunctionCallExpression) {
            return new CFunctionCallStatement(fileLoc, (CFunctionCallExpression)rightHandSide);
        }
        throw new AssertionError();
    }
}

