/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.parser.eclipse.c;

import com.google.common.base.CharMatcher;
import com.google.common.base.Function;
import com.google.common.base.Strings;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTProblem;
import org.eclipse.cdt.core.dom.ast.IASTProblemHolder;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CAstNode;

class CFAGenerationRuntimeException
extends RuntimeException {
    private static final long serialVersionUID = 6850681425709171716L;
    private static final CharMatcher SEMICOLON = CharMatcher.is((char)';');

    public CFAGenerationRuntimeException(String msg) {
        super(msg);
    }

    public CFAGenerationRuntimeException(Throwable cause) {
        super(cause.getMessage(), cause);
    }

    public CFAGenerationRuntimeException(String msg, IASTNode astNode, Function<String, String> niceFileNameFunction) {
        this(astNode == null ? msg : CFAGenerationRuntimeException.createMessage(msg, astNode, niceFileNameFunction));
    }

    public CFAGenerationRuntimeException(String msg, CAstNode astNode) {
        this(astNode == null ? msg : astNode.getFileLocation() + ": " + msg + ": " + astNode.toASTString());
    }

    public CFAGenerationRuntimeException(IASTProblem problem, Function<String, String> niceFileNameFunction) {
        this(CFAGenerationRuntimeException.createMessage(problem.getMessage(), (IASTNode)problem, niceFileNameFunction));
    }

    public <P extends IASTProblemHolder & IASTNode> CFAGenerationRuntimeException(P problem, Function<String, String> niceFileNameFunction) {
        this(CFAGenerationRuntimeException.createMessage(problem.getProblem().getMessage(), problem, niceFileNameFunction));
    }

    private static String createMessage(String msg, IASTNode node, Function<String, String> niceFileNameFunction) {
        IASTNode fullLine;
        StringBuilder sb = new StringBuilder();
        IASTFileLocation fileLocation = node.getFileLocation();
        String fileName = (String)niceFileNameFunction.apply((Object)fileLocation.getFileName());
        if (!fileName.isEmpty()) {
            sb.append(fileName);
            sb.append(", ");
        }
        if (fileLocation.getEndingLineNumber() != fileLocation.getStartingLineNumber()) {
            sb.append("lines ");
            sb.append(fileLocation.getStartingLineNumber());
            sb.append("-");
            sb.append(fileLocation.getEndingLineNumber());
        } else {
            sb.append("line ");
            sb.append(fileLocation.getStartingLineNumber());
        }
        sb.append(": ");
        if (Strings.isNullOrEmpty((String)msg)) {
            sb.append("Problem");
        } else {
            sb.append(msg);
        }
        sb.append(": ");
        String rawSignature = node.getRawSignature();
        sb.append(rawSignature);
        for (fullLine = node; fullLine != null && !(fullLine instanceof IASTStatement) && !(fullLine instanceof IASTDeclaration); fullLine = fullLine.getParent()) {
        }
        if (fullLine != null && fullLine != node) {
            String lineRawSignature = fullLine.getRawSignature();
            String codeWithoutWhitespace = CharMatcher.WHITESPACE.removeFrom((CharSequence)rawSignature);
            String lineWithoutWhitespace = CharMatcher.WHITESPACE.removeFrom((CharSequence)lineRawSignature);
            if (!(codeWithoutWhitespace = SEMICOLON.trimFrom((CharSequence)codeWithoutWhitespace)).equals(lineWithoutWhitespace = SEMICOLON.trimFrom((CharSequence)lineWithoutWhitespace))) {
                sb.append(" (full line is ");
                sb.append(lineRawSignature);
                sb.append(")");
            }
        }
        return sb.toString();
    }
}

