/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.parser.eclipse.c;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.dom.ast.IASTCompoundStatement;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorIncludeStatement;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.gnu.c.GCCLanguage;
import org.eclipse.cdt.core.dom.parser.c.ANSICParserExtensionConfiguration;
import org.eclipse.cdt.core.dom.parser.c.ICParserExtensionConfiguration;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.parser.FileContent;
import org.eclipse.cdt.core.parser.IParserLogService;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.IncludeFileContentProvider;
import org.eclipse.cdt.core.parser.ParserFactory;
import org.eclipse.cdt.internal.core.parser.IMacroDictionary;
import org.eclipse.cdt.internal.core.parser.InternalParserUtil;
import org.eclipse.cdt.internal.core.parser.scanner.InternalFileContent;
import org.eclipse.cdt.internal.core.parser.scanner.InternalFileContentProvider;
import org.eclipse.core.runtime.CoreException;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.io.Path;
import org.sosy_lab.common.io.Paths;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.log.LogManagerWithoutDuplicates;
import org.sosy_lab.common.time.Timer;
import org.sosy_lab.cpachecker.cfa.CParser;
import org.sosy_lab.cpachecker.cfa.CSourceOriginMapping;
import org.sosy_lab.cpachecker.cfa.ParseResult;
import org.sosy_lab.cpachecker.cfa.ast.c.CAstNode;
import org.sosy_lab.cpachecker.cfa.parser.Scope;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.c.ASTConverter;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.c.CFABuilder;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.c.CFAGenerationRuntimeException;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.c.Sideassignments;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.exceptions.CParserException;

class EclipseCParser
implements CParser {
    protected final ILanguage language;
    protected final IParserLogService parserLog = ParserFactory.createDefaultLogService();
    private final MachineModel machine;
    private final LogManager logger;
    private final Configuration config;
    private final Timer parseTimer = new Timer();
    private final Timer cfaTimer = new Timer();
    protected static final int PARSER_OPTIONS = 12;

    public EclipseCParser(Configuration pConfig, LogManager pLogger, CParser.Dialect dialect, MachineModel pMachine) {
        this.logger = pLogger;
        this.machine = pMachine;
        this.config = pConfig;
        switch (dialect) {
            case C99: {
                this.language = new CLanguage((ICParserExtensionConfiguration)new ANSICParserExtensionConfiguration());
                break;
            }
            case GNUC: {
                this.language = GCCLanguage.getDefault();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown C dialect");
            }
        }
    }

    private static String fixPath(String pPath) {
        Path path = Paths.get((String)pPath, (String[])new String[0]);
        if (!path.isEmpty() && !path.isAbsolute() && path.getParent().isEmpty()) {
            return Paths.get((String)".", (String[])new String[0]).resolve(path).toString();
        }
        return pPath;
    }

    private FileContent wrapCode(CParser.FileContentToParse pContent) {
        return FileContent.create((String)EclipseCParser.fixPath(pContent.getFileName()), (char[])pContent.getFileContent().toCharArray());
    }

    private FileContent wrapCode(String pFileName, String pCode) {
        return FileContent.create((String)EclipseCParser.fixPath(pFileName), (char[])pCode.toCharArray());
    }

    private final FileContent wrapFile(String pFileName) throws IOException {
        String code = Paths.get((String)pFileName, (String[])new String[0]).asCharSource(Charset.defaultCharset()).read();
        return this.wrapCode(EclipseCParser.fixPath(pFileName), code);
    }

    @Override
    public ParseResult parseFile(List<CParser.FileToParse> pFilenames, CSourceOriginMapping sourceOriginMapping) throws CParserException, IOException, InvalidConfigurationException {
        ArrayList<IASTTranslationUnit> astUnits = new ArrayList<IASTTranslationUnit>();
        for (CParser.FileToParse f : pFilenames) {
            astUnits.add(this.parse(this.wrapFile(f.getFileName())));
        }
        return this.buildCFA(astUnits, sourceOriginMapping);
    }

    @Override
    public ParseResult parseString(List<CParser.FileContentToParse> codeFragments, CSourceOriginMapping sourceOriginMapping) throws CParserException, InvalidConfigurationException {
        ArrayList<IASTTranslationUnit> astUnits = new ArrayList<IASTTranslationUnit>();
        for (CParser.FileContentToParse f : codeFragments) {
            astUnits.add(this.parse(this.wrapCode(f)));
        }
        return this.buildCFA(astUnits, sourceOriginMapping);
    }

    @Override
    public ParseResult parseFile(String pFilename, CSourceOriginMapping sourceOriginMapping) throws CParserException, IOException, InvalidConfigurationException {
        IASTTranslationUnit unit = this.parse(this.wrapFile(pFilename));
        ArrayList<IASTTranslationUnit> returnParam = new ArrayList<IASTTranslationUnit>();
        returnParam.add(unit);
        return this.buildCFA(returnParam, sourceOriginMapping);
    }

    @Override
    public ParseResult parseString(String pFilename, String pCode, CSourceOriginMapping sourceOriginMapping) throws CParserException, InvalidConfigurationException {
        IASTTranslationUnit unit = this.parse(this.wrapCode(pFilename, pCode));
        ArrayList<IASTTranslationUnit> returnParam = new ArrayList<IASTTranslationUnit>();
        returnParam.add(unit);
        return this.buildCFA(returnParam, sourceOriginMapping);
    }

    @Override
    public CAstNode parseSingleStatement(String pCode, Scope scope) throws CParserException, InvalidConfigurationException {
        IASTTranslationUnit ast = this.parse(this.wrapCode("", pCode));
        IASTDeclaration[] declarations = ast.getDeclarations();
        if (declarations == null || declarations.length != 1 || !(declarations[0] instanceof IASTFunctionDefinition)) {
            throw new CParserException("Not a single function: " + ast.getRawSignature());
        }
        IASTFunctionDefinition func = (IASTFunctionDefinition)declarations[0];
        IASTStatement body = func.getBody();
        if (!(body instanceof IASTCompoundStatement)) {
            throw new CParserException("Function has an unexpected " + body.getClass().getSimpleName() + " as body: " + func.getRawSignature());
        }
        IASTStatement[] statements = ((IASTCompoundStatement)body).getStatements();
        if ((statements.length != 2 || statements[1] != null) && statements.length != 1) {
            throw new CParserException("Not exactly one statement in function body: " + body);
        }
        Sideassignments sa = new Sideassignments();
        sa.enterBlock();
        return new ASTConverter(this.config, scope, new LogManagerWithoutDuplicates(this.logger), (Function<String, String>)Functions.identity(), new CSourceOriginMapping(), this.machine, "", sa).convert(statements[0]);
    }

    @Override
    public List<CAstNode> parseStatements(String pCode, Scope scope) throws CParserException, InvalidConfigurationException {
        IASTTranslationUnit ast = this.parse(this.wrapCode("", pCode));
        IASTDeclaration[] declarations = ast.getDeclarations();
        if (declarations == null || declarations.length != 1 || !(declarations[0] instanceof IASTFunctionDefinition)) {
            throw new CParserException("Not a single function: " + ast.getRawSignature());
        }
        IASTFunctionDefinition func = (IASTFunctionDefinition)declarations[0];
        IASTStatement body = func.getBody();
        if (!(body instanceof IASTCompoundStatement)) {
            throw new CParserException("Function has an unexpected " + body.getClass().getSimpleName() + " as body: " + func.getRawSignature());
        }
        IASTStatement[] statements = ((IASTCompoundStatement)body).getStatements();
        if (statements.length == 1 && statements[0] == null || statements.length == 0) {
            throw new CParserException("No statement found in function body: " + body);
        }
        Sideassignments sa = new Sideassignments();
        sa.enterBlock();
        ASTConverter converter = new ASTConverter(this.config, scope, new LogManagerWithoutDuplicates(this.logger), (Function<String, String>)Functions.identity(), new CSourceOriginMapping(), this.machine, "", sa);
        ArrayList<CAstNode> nodeList = new ArrayList<CAstNode>(statements.length);
        for (IASTStatement statement : statements) {
            if (statement == null) continue;
            nodeList.add(converter.convert(statement));
        }
        if (nodeList.size() < 1) {
            throw new CParserException("No statement found in function body: " + body);
        }
        return nodeList;
    }

    private IASTTranslationUnit parse(FileContent codeReader) throws CParserException {
        this.parseTimer.start();
        try {
            IASTTranslationUnit result = this.getASTTranslationUnit(codeReader);
            for (IASTPreprocessorIncludeStatement include : result.getIncludeDirectives()) {
                if (include.isResolved()) continue;
                if (include.isSystemInclude()) {
                    throw new CFAGenerationRuntimeException("File includes system headers, either preprocess it manually or specify -preprocess.");
                }
                throw new CFAGenerationRuntimeException("Included file " + include.getName() + " is missing", (IASTNode)include, (Function<String, String>)Functions.identity());
            }
            int i$ = 0;
            IASTPreprocessorIncludeStatement[] arr$ = result.getPreprocessorProblems();
            int len$ = arr$.length;
            if (i$ < len$) {
                IASTPreprocessorIncludeStatement problem = arr$[i$];
                throw new CFAGenerationRuntimeException(problem, (Function<String, String>)Functions.identity());
            }
            IASTTranslationUnit iASTTranslationUnit = result;
            return iASTTranslationUnit;
        }
        catch (CFAGenerationRuntimeException e) {
            throw new CParserException(e);
        }
        catch (CoreException e) {
            throw new CParserException(e);
        }
        finally {
            this.parseTimer.stop();
        }
    }

    private IASTTranslationUnit getASTTranslationUnit(FileContent pCode) throws CParserException, CFAGenerationRuntimeException, CoreException {
        return this.language.getASTTranslationUnit(pCode, StubScannerInfo.instance, (IncludeFileContentProvider)FileContentProvider.instance, null, 12, this.parserLog);
    }

    private ParseResult buildCFA(List<IASTTranslationUnit> asts, CSourceOriginMapping sourceOriginMapping) throws CParserException, InvalidConfigurationException {
        Preconditions.checkArgument((!asts.isEmpty() ? 1 : 0) != 0);
        this.cfaTimer.start();
        Function<String, String> niceFileNameFunction = this.createNiceFileNameFunction(asts);
        try {
            CFABuilder builder = new CFABuilder(this.config, this.logger, niceFileNameFunction, sourceOriginMapping, this.machine);
            if (asts.size() == 1) {
                builder.analyzeTranslationUnit(asts.get(0), "");
            } else {
                for (IASTTranslationUnit ast : asts) {
                    builder.analyzeTranslationUnit(ast, ((String)niceFileNameFunction.apply((Object)ast.getFilePath())).replace("/", "_").replaceAll("\\W", "_"));
                }
            }
            ParseResult parseResult = builder.createCFA();
            return parseResult;
        }
        catch (CFAGenerationRuntimeException e) {
            throw new CParserException(e);
        }
        finally {
            this.cfaTimer.stop();
        }
    }

    private Function<String, String> createNiceFileNameFunction(List<IASTTranslationUnit> asts) {
        Iterator fileNames = Lists.transform(asts, (Function)new Function<IASTTranslationUnit, String>(){

            public String apply(IASTTranslationUnit pInput) {
                return pInput.getFilePath();
            }
        }).iterator();
        if (asts.size() == 1) {
            final String mainFileName = (String)fileNames.next();
            return new Function<String, String>(){

                public String apply(String pInput) {
                    return mainFileName.equals(pInput) ? "" : pInput;
                }
            };
        }
        String commonStringPrefix = (String)fileNames.next();
        while (fileNames.hasNext()) {
            commonStringPrefix = Strings.commonPrefix((CharSequence)commonStringPrefix, (CharSequence)((CharSequence)fileNames.next()));
        }
        int pos = commonStringPrefix.lastIndexOf(File.separator);
        final String commonPathPrefix = pos < 0 ? commonStringPrefix : commonStringPrefix.substring(0, pos + 1);
        return new Function<String, String>(){

            public String apply(String pInput) {
                if (pInput.isEmpty()) {
                    return pInput;
                }
                if (pInput.charAt(0) == '\"' && pInput.charAt(pInput.length() - 1) == '\"') {
                    pInput = pInput.substring(1, pInput.length() - 1);
                }
                if (pInput.startsWith(commonPathPrefix)) {
                    return pInput.substring(commonPathPrefix.length()).intern();
                }
                return pInput.intern();
            }
        };
    }

    @Override
    public Timer getParseTime() {
        return this.parseTimer;
    }

    @Override
    public Timer getCFAConstructionTime() {
        return this.cfaTimer;
    }

    private static class FileContentProvider
    extends InternalFileContentProvider {
        static final InternalFileContentProvider instance = new FileContentProvider();

        private FileContentProvider() {
        }

        public InternalFileContent getContentForInclusion(String pFilePath, IMacroDictionary pMacroDictionary) {
            return InternalParserUtil.createExternalFileContent((String)pFilePath, (String)InternalParserUtil.SYSTEM_DEFAULT_ENCODING);
        }

        public InternalFileContent getContentForInclusion(IIndexFileLocation pIfl, String pAstPath) {
            return InternalParserUtil.createFileContent((IIndexFileLocation)pIfl);
        }
    }

    protected static class StubScannerInfo
    implements IScannerInfo {
        private static final ImmutableMap<String, String> MACROS;
        protected static final IScannerInfo instance;

        protected StubScannerInfo() {
        }

        public Map<String, String> getDefinedSymbols() {
            return MACROS;
        }

        public String[] getIncludePaths() {
            return new String[0];
        }

        static {
            ImmutableMap.Builder macrosBuilder = ImmutableMap.builder();
            macrosBuilder.put((Object)"_Static_assert(c, m)", (Object)"");
            macrosBuilder.put((Object)"__builtin_va_arg", (Object)"__builtin_va_arg");
            macrosBuilder.put((Object)"__builtin_constant_p", (Object)"__builtin_constant_p");
            macrosBuilder.put((Object)"__builtin_types_compatible_p(t1,t2)", (Object)"__builtin_types_compatible_p(({t1 arg1; arg1;}), ({t2 arg2; arg2;}))");
            macrosBuilder.put((Object)"__offsetof__", (Object)"__offsetof__");
            macrosBuilder.put((Object)"__func__", (Object)"\"__func__\"");
            macrosBuilder.put((Object)"__FUNCTION__", (Object)"\"__FUNCTION__\"");
            macrosBuilder.put((Object)"__PRETTY_FUNCTION__", (Object)"\"__PRETTY_FUNCTION__\"");
            macrosBuilder.put((Object)"__attribute__(a)", (Object)"");
            MACROS = macrosBuilder.build();
            instance = new StubScannerInfo();
        }
    }

    private static class CLanguage
    extends GCCLanguage {
        private final ICParserExtensionConfiguration parserConfig;

        public CLanguage(ICParserExtensionConfiguration parserConfig) {
            this.parserConfig = parserConfig;
        }

        protected ICParserExtensionConfiguration getParserExtensionConfiguration() {
            return this.parserConfig;
        }
    }
}

