/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.parser.eclipse.c;

import com.google.common.base.Verify;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sosy_lab.common.Pair;
import org.sosy_lab.cpachecker.cfa.ast.c.CComplexTypeDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CSimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CTypeDefDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.c.CFAGenerationRuntimeException;
import org.sosy_lab.cpachecker.cfa.types.c.CComplexType;
import org.sosy_lab.cpachecker.cfa.types.c.CCompositeType;
import org.sosy_lab.cpachecker.cfa.types.c.CElaboratedType;
import org.sosy_lab.cpachecker.cfa.types.c.CEnumType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;

public class ProgramDeclarations {
    private final Map<String, CSimpleDeclaration> globalVars = new HashMap<String, CSimpleDeclaration>();
    private final Map<String, CFunctionDeclaration> functions = new HashMap<String, CFunctionDeclaration>();
    private final Map<String, CComplexTypeDeclaration> types = new HashMap<String, CComplexTypeDeclaration>();
    private final Map<String, CTypeDefDeclaration> typedefs = new HashMap<String, CTypeDefDeclaration>();
    private final Multimap<String, String> origNamesToQualifiedNames = HashMultimap.create();

    public void registerTypeDeclaration(CComplexTypeDeclaration declaration) {
        CComplexType type = declaration.getType();
        String qualifiedName = type.getQualifiedName();
        if (this.types.containsKey(qualifiedName)) {
            CComplexTypeDeclaration oldDecl = this.types.get(qualifiedName);
            if (!(oldDecl.getType().getCanonicalType() instanceof CElaboratedType) || !ProgramDeclarations.areEqualTypes(oldDecl.getType(), type, false)) {
                throw new IllegalArgumentException("There is already a type registered with the qualified name: " + qualifiedName);
            }
        } else {
            this.origNamesToQualifiedNames.put((Object)type.getOrigName(), (Object)type.getQualifiedName());
        }
        this.types.put(qualifiedName, declaration);
    }

    public void registerTypeDefDeclaration(CTypeDefDeclaration declaration) {
        String name = declaration.getName();
        this.origNamesToQualifiedNames.put((Object)declaration.getOrigName(), (Object)name);
        CTypeDefDeclaration shouldBeNull = this.typedefs.put(name, declaration);
        Verify.verify((shouldBeNull == null ? 1 : 0) != 0, (String)"There is already a typedeftype registered with the name: %s", (Object[])new Object[]{name});
    }

    public void registerFunctionDeclaration(CFunctionDeclaration declaration) {
        String name = declaration.getName();
        if (this.globalVars.containsKey(name)) {
            throw new CFAGenerationRuntimeException("Name of global variable " + name + " from " + this.globalVars.get(name).getFileLocation() + " is reused as function declaration", declaration);
        }
        this.functions.put(name, declaration);
    }

    public void registerVariableDeclaration(CVariableDeclaration declaration) {
        String name = declaration.getName();
        CSimpleDeclaration shouldBeNull = this.globalVars.put(name, declaration);
        Verify.verify((shouldBeNull == null ? 1 : 0) != 0, (String)"There is already a global variable registered with the name: %s", (Object[])new Object[]{name});
    }

    public boolean variableNameInUse(String name) {
        return this.globalVars.containsKey(name);
    }

    public boolean containsTypeWithExactName(String typeName) {
        return this.types.containsKey(typeName);
    }

    public boolean containsTypeDefWithExactName(String typeDefName) {
        return this.typedefs.containsKey(typeDefName);
    }

    public boolean containsFunctionWithExactName(String functionName) {
        return this.functions.containsKey(functionName);
    }

    public boolean containsVariableWithExactName(String variableName) {
        return this.globalVars.containsKey(variableName);
    }

    public boolean containsEqualType(CComplexTypeDeclaration declaration) {
        return (Boolean)this.getOrContainsEqualType(declaration).getFirst();
    }

    public boolean containsEqualTypeDef(CTypeDefDeclaration declaration) {
        return (Boolean)this.getOrContainsEqualTypeDef(declaration).getFirst();
    }

    public CComplexTypeDeclaration getEqualType(CComplexTypeDeclaration declaration) {
        return (CComplexTypeDeclaration)this.getOrContainsEqualType(declaration).getSecond();
    }

    public CTypeDefDeclaration getEqualTypeDefDeclaration(CTypeDefDeclaration declaration) {
        return (CTypeDefDeclaration)this.getOrContainsEqualTypeDef(declaration).getSecond();
    }

    private Pair<Boolean, CTypeDefDeclaration> getOrContainsEqualTypeDef(CTypeDefDeclaration declaration) {
        for (String name : this.origNamesToQualifiedNames.get((Object)declaration.getOrigName())) {
            if (!this.typedefs.containsKey(name)) continue;
            CType oldType = this.typedefs.get(name).getType().getCanonicalType();
            CType newType = declaration.getType().getCanonicalType();
            if ((!(oldType instanceof CComplexType) || !(newType instanceof CComplexType) || !ProgramDeclarations.areEqualTypes((CComplexType)oldType, (CComplexType)newType, false)) && oldType instanceof CComplexType && !(newType instanceof CComplexType) && oldType.equals(newType)) continue;
            return Pair.of((Object)true, (Object)this.typedefs.get(name));
        }
        return Pair.of((Object)false, null);
    }

    private Pair<Boolean, CComplexTypeDeclaration> getOrContainsEqualType(CComplexTypeDeclaration declaration) {
        for (String name : this.origNamesToQualifiedNames.get((Object)declaration.getType().getOrigName())) {
            if (!this.types.containsKey(name) || !ProgramDeclarations.areEqualTypes(this.types.get(name).getType(), declaration.getType(), false)) continue;
            return Pair.of((Object)true, (Object)this.types.get(name));
        }
        return Pair.of((Object)false, null);
    }

    public static boolean areEqualTypes(CComplexType oldType, CComplexType forwardType, boolean compareWithoutName) {
        boolean areEqual = false;
        oldType = (CComplexType)oldType.getCanonicalType();
        if ((forwardType = (CComplexType)forwardType.getCanonicalType()).equals(oldType) || compareWithoutName && forwardType.isConst() == oldType.isConst() && forwardType.isVolatile() == oldType.isVolatile() && forwardType.getKind() == oldType.getKind()) {
            if (forwardType instanceof CCompositeType) {
                List<CCompositeType.CCompositeTypeMemberDeclaration> members = ((CCompositeType)forwardType).getMembers();
                List<CCompositeType.CCompositeTypeMemberDeclaration> oldMembers = ((CCompositeType)oldType).getMembers();
                if (members.size() == oldMembers.size()) {
                    areEqual = true;
                    for (int i = 0; i < members.size() && areEqual; ++i) {
                        String member1 = members.get(i).getName();
                        String member2 = oldMembers.get(i).getName();
                        if (member1 == null) {
                            areEqual = false;
                            continue;
                        }
                        areEqual = member1.equals(member2);
                        CType typeM1 = members.get(i).getType();
                        CType typeM2 = oldMembers.get(i).getType();
                        if (areEqual || !(typeM1 instanceof CComplexType) || !(typeM2 instanceof CComplexType) || !member1.contains("_anon_type_member") || !member2.contains("_anon_type_member_")) continue;
                        areEqual = ProgramDeclarations.areEqualTypes((CComplexType)oldMembers.get(i).getType(), (CComplexType)members.get(i).getType(), true);
                    }
                }
            } else if (forwardType instanceof CEnumType) {
                ImmutableList<CEnumType.CEnumerator> members = ((CEnumType)forwardType).getEnumerators();
                ImmutableList<CEnumType.CEnumerator> oldMembers = ((CEnumType)oldType).getEnumerators();
                if (members.size() == oldMembers.size()) {
                    areEqual = true;
                    for (int i = 0; i < members.size() && areEqual; ++i) {
                        areEqual = ((CEnumType.CEnumerator)members.get(i)).getName().equals(((CEnumType.CEnumerator)oldMembers.get(i)).getName());
                    }
                }
            } else if (forwardType instanceof CElaboratedType && oldType instanceof CElaboratedType) {
                areEqual = forwardType.getQualifiedName().equals(oldType.getQualifiedName());
            }
        } else {
            areEqual = forwardType instanceof CElaboratedType && forwardType.getName().equals(oldType.getName()) || oldType instanceof CElaboratedType && oldType.getName().equals(forwardType.getName());
        }
        return areEqual;
    }
}

