/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.parser.eclipse.c;

import com.google.common.base.Preconditions;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.sosy_lab.common.Pair;
import org.sosy_lab.cpachecker.cfa.ast.c.CAstNode;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;

class Sideassignments {
    private final Deque<List<CAstNode>> preSideAssignments;
    private final Deque<List<CAstNode>> postSideAssignments;
    private final Deque<List<Pair<IASTExpression, CIdExpression>>> conditionalExpressions;

    public Sideassignments() {
        this.preSideAssignments = new ArrayDeque<List<CAstNode>>();
        this.postSideAssignments = new ArrayDeque<List<CAstNode>>();
        this.conditionalExpressions = new ArrayDeque<List<Pair<IASTExpression, CIdExpression>>>();
    }

    public Sideassignments(Deque<List<CAstNode>> preSideAssignments, Deque<List<CAstNode>> postSideAssignments, Deque<List<Pair<IASTExpression, CIdExpression>>> conditionalExpressions) {
        this.preSideAssignments = preSideAssignments;
        this.postSideAssignments = postSideAssignments;
        this.conditionalExpressions = conditionalExpressions;
    }

    public void enterBlock() {
        this.preSideAssignments.push(new ArrayList());
        this.postSideAssignments.push(new ArrayList());
        this.conditionalExpressions.push(new ArrayList());
    }

    public void leaveBlock() {
        Preconditions.checkArgument((!this.preSideAssignments.isEmpty() ? 1 : 0) != 0, (Object)"leaving sideassignment block before handling all of them");
        Preconditions.checkArgument((!this.postSideAssignments.isEmpty() ? 1 : 0) != 0, (Object)"leaving sideassignment block before handling all of them");
        Preconditions.checkArgument((!this.conditionalExpressions.isEmpty() ? 1 : 0) != 0, (Object)"leaving sideassignment block before handling all of them");
        this.preSideAssignments.pop();
        this.postSideAssignments.pop();
        this.conditionalExpressions.pop();
    }

    public List<CAstNode> getAndResetPreSideAssignments() {
        ArrayList<CAstNode> result = new ArrayList<CAstNode>((Collection)this.preSideAssignments.peek());
        this.preSideAssignments.peek().clear();
        return result;
    }

    public List<CAstNode> getAndResetPostSideAssignments() {
        ArrayList<CAstNode> result = new ArrayList<CAstNode>((Collection)this.postSideAssignments.peek());
        this.postSideAssignments.peek().clear();
        return result;
    }

    public List<Pair<IASTExpression, CIdExpression>> getAndResetConditionalExpressions() {
        ArrayList<Pair<IASTExpression, CIdExpression>> result = new ArrayList<Pair<IASTExpression, CIdExpression>>((Collection)this.conditionalExpressions.peek());
        this.conditionalExpressions.peek().clear();
        return result;
    }

    public boolean hasConditionalExpression() {
        if (this.conditionalExpressions.isEmpty()) {
            return false;
        }
        return !this.conditionalExpressions.peek().isEmpty();
    }

    public boolean hasPreSideAssignments() {
        if (this.preSideAssignments.isEmpty()) {
            return false;
        }
        return !this.preSideAssignments.peek().isEmpty();
    }

    public boolean hasPostSideAssignments() {
        if (this.postSideAssignments.isEmpty()) {
            return false;
        }
        return !this.postSideAssignments.peek().isEmpty();
    }

    public List<Pair<IASTExpression, CIdExpression>> getConditionalExpressions() {
        return Collections.unmodifiableList(this.conditionalExpressions.peek());
    }

    public void addConditionalExpression(IASTExpression e, CIdExpression tempVar) {
        this.conditionalExpressions.peek().add((Pair<IASTExpression, CIdExpression>)Pair.of((Object)Preconditions.checkNotNull((Object)e), (Object)Preconditions.checkNotNull((Object)tempVar)));
    }

    public void addPreSideAssignment(CAstNode node) {
        this.preSideAssignments.peek().add(node);
    }

    public void addPostSideAssignment(CAstNode node) {
        this.postSideAssignments.peek().add(node);
    }
}

