/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.parser.eclipse.java;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import javax.annotation.Nullable;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ArrayAccess;
import org.eclipse.jdt.core.dom.ArrayCreation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.BooleanLiteral;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.CharacterLiteral;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConditionalExpression;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.InstanceofExpression;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.NullLiteral;
import org.eclipse.jdt.core.dom.NumberLiteral;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.PostfixExpression;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeLiteral;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.ast.AbstractExpression;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.java.JArrayCreationExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JArrayInitializer;
import org.sosy_lab.cpachecker.cfa.ast.java.JArrayLengthExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JAssignment;
import org.sosy_lab.cpachecker.cfa.ast.java.JAstNode;
import org.sosy_lab.cpachecker.cfa.ast.java.JBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JBooleanLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JCharLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JClassInstanceCreation;
import org.sosy_lab.cpachecker.cfa.ast.java.JConstructorDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.java.JDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.java.JEnumConstantExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JExpressionAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.java.JExpressionStatement;
import org.sosy_lab.cpachecker.cfa.ast.java.JFieldAccess;
import org.sosy_lab.cpachecker.cfa.ast.java.JFieldDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.java.JFloatLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JInitializerExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JLeftHandSide;
import org.sosy_lab.cpachecker.cfa.ast.java.JMethodDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.java.JMethodInvocationAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.java.JMethodInvocationExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JMethodInvocationStatement;
import org.sosy_lab.cpachecker.cfa.ast.java.JNullLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JObjectReferenceReturn;
import org.sosy_lab.cpachecker.cfa.ast.java.JParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.java.JReferencedMethodInvocationExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JReturnStatement;
import org.sosy_lab.cpachecker.cfa.ast.java.JRunTimeTypeEqualsType;
import org.sosy_lab.cpachecker.cfa.ast.java.JSimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.java.JStatement;
import org.sosy_lab.cpachecker.cfa.ast.java.JStringLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JSuperConstructorInvocation;
import org.sosy_lab.cpachecker.cfa.ast.java.JThisExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JUnaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.java.JVariableRunTimeType;
import org.sosy_lab.cpachecker.cfa.ast.java.VisibilityModifier;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.java.ASTTypeConverter;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.java.AstDebugg;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.java.CFAGenerationRuntimeException;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.java.NameConverter;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.java.Scope;
import org.sosy_lab.cpachecker.cfa.types.java.JArrayType;
import org.sosy_lab.cpachecker.cfa.types.java.JBasicType;
import org.sosy_lab.cpachecker.cfa.types.java.JClassOrInterfaceType;
import org.sosy_lab.cpachecker.cfa.types.java.JClassType;
import org.sosy_lab.cpachecker.cfa.types.java.JConstructorType;
import org.sosy_lab.cpachecker.cfa.types.java.JInterfaceType;
import org.sosy_lab.cpachecker.cfa.types.java.JMethodType;
import org.sosy_lab.cpachecker.cfa.types.java.JSimpleType;
import org.sosy_lab.cpachecker.cfa.types.java.JType;

class ASTConverter {
    private static final boolean NOT_FINAL = false;
    private static final int FIRST = 0;
    private final LogManager logger;
    private Scope scope;
    private final ASTTypeConverter typeConverter;
    private LinkedList<JDeclaration> forInitDeclarations = new LinkedList();
    private LinkedList<JAstNode> preSideAssignments = new LinkedList();
    private LinkedList<JAstNode> postSideAssignments = new LinkedList();
    private ConditionalExpression conditionalExpression = null;
    private JIdExpression conditionalTemporaryVariable = null;
    private JIdExpression enhancedForLoopIterator;
    private static final Set<JBinaryExpression.BinaryOperator> BOOLEAN_BINARY_OPERATORS = ImmutableSet.of((Object)JBinaryExpression.BinaryOperator.EQUALS, (Object)JBinaryExpression.BinaryOperator.NOT_EQUALS, (Object)JBinaryExpression.BinaryOperator.GREATER_EQUAL, (Object)JBinaryExpression.BinaryOperator.GREATER_THAN, (Object)JBinaryExpression.BinaryOperator.LESS_EQUAL, (Object)JBinaryExpression.BinaryOperator.LESS_THAN, (Object[])new JBinaryExpression.BinaryOperator[]{JBinaryExpression.BinaryOperator.LOGICAL_AND, JBinaryExpression.BinaryOperator.LOGICAL_OR, JBinaryExpression.BinaryOperator.CONDITIONAL_AND, JBinaryExpression.BinaryOperator.CONDITIONAL_OR});

    public ASTConverter(Scope pScope, LogManager pLogger) {
        this.scope = pScope;
        this.logger = pLogger;
        this.typeConverter = new ASTTypeConverter(this.scope);
    }

    public int numberOfPostSideAssignments() {
        return this.postSideAssignments.size();
    }

    public int numberOfSideAssignments() {
        return this.preSideAssignments.size() + this.postSideAssignments.size();
    }

    public int numberOfPreSideAssignments() {
        return this.preSideAssignments.size();
    }

    public JAstNode getNextSideAssignment() {
        if (this.numberOfPreSideAssignments() > 0) {
            return this.preSideAssignments.removeFirst();
        }
        return this.postSideAssignments.removeFirst();
    }

    public JAstNode getNextPreSideAssignment() {
        return this.preSideAssignments.removeFirst();
    }

    public JAstNode getNextPostSideAssignment() {
        return this.postSideAssignments.removeFirst();
    }

    public void resetConditionalExpression() {
        this.conditionalExpression = null;
    }

    public ConditionalExpression getConditionalExpression() {
        return this.conditionalExpression;
    }

    public JIdExpression getConditionalTemporaryVariable() {
        return this.conditionalTemporaryVariable;
    }

    private static void check(boolean assertion, String msg, ASTNode astNode) throws CFAGenerationRuntimeException {
        if (!assertion) {
            throw new CFAGenerationRuntimeException(msg);
        }
    }

    public List<JDeclaration> getForInitDeclaration() {
        return this.forInitDeclarations;
    }

    public int numberOfForInitDeclarations() {
        return this.forInitDeclarations.size();
    }

    private String getQualifiedName(String var) {
        return this.scope.createQualifiedName(var);
    }

    private JType convert(ITypeBinding pTypeBinding) {
        return this.typeConverter.convert(pTypeBinding);
    }

    private JType convert(Type pType) {
        return this.typeConverter.convert(pType);
    }

    private JArrayType convert(ArrayType pType) {
        return (JArrayType)this.typeConverter.convert((Type)pType);
    }

    public JClassOrInterfaceType convertClassOrInterfaceType(ITypeBinding pClassBinding) {
        return this.typeConverter.convertClassOrInterfaceType(pClassBinding);
    }

    public JMethodDeclaration convert(MethodDeclaration md) {
        IMethodBinding methodBinding = md.resolveBinding();
        if (methodBinding == null) {
            this.logger.log(Level.WARNING, new Object[]{"Could not resolve Binding for Method Declaration "});
            this.logger.log(Level.WARNING, new Object[]{md.getName()});
            return JMethodDeclaration.createUnresolvedMethodDeclaration();
        }
        String methodName = NameConverter.convertName(methodBinding);
        Preconditions.checkArgument((boolean)this.scope.isMethodRegistered(methodName));
        return this.scope.lookupMethod(methodName);
    }

    private JClassOrInterfaceType getDeclaringClassType(IMethodBinding mi) {
        JType declaringClassType = null;
        if (mi != null) {
            declaringClassType = this.convert(mi.getDeclaringClass());
        }
        JClassOrInterfaceType declaringClass = declaringClassType instanceof JClassOrInterfaceType ? (JClassOrInterfaceType)declaringClassType : JClassType.createUnresolvableType();
        return declaringClass;
    }

    public FileLocation getFileLocation(ASTNode l) {
        if (l == null) {
            return FileLocation.DUMMY;
        }
        if (l.getRoot().getNodeType() != 15) {
            this.logger.log(Level.WARNING, new Object[]{"Can't find Placement Information for :" + l.toString()});
            return FileLocation.DUMMY;
        }
        CompilationUnit co = (CompilationUnit)l.getRoot();
        return new FileLocation(co.getLineNumber(l.getLength() + l.getStartPosition()), this.scope.getFileOfCurrentType(), l.getLength(), l.getStartPosition(), co.getLineNumber(l.getStartPosition()));
    }

    public List<JDeclaration> convert(FieldDeclaration fd) {
        ArrayList<JDeclaration> result = new ArrayList<JDeclaration>();
        List vdfs = fd.fragments();
        for (VariableDeclarationFragment vdf : vdfs) {
            result.add(this.handleFieldDeclarationFragment(vdf, fd));
        }
        return result;
    }

    private JDeclaration handleFieldDeclarationFragment(VariableDeclarationFragment pVdf, FieldDeclaration pFd) {
        NameAndInitializer nameAndInitializer = this.getNamesAndInitializer(pVdf);
        String fieldName = nameAndInitializer.getName();
        Preconditions.checkArgument((boolean)this.scope.isFieldRegistered(fieldName));
        JFieldDeclaration fieldDecl = this.scope.lookupField(fieldName);
        if (this.preSideAssignments.size() != 0 || this.postSideAssignments.size() != 0) {
            this.logger.log(Level.WARNING, new Object[]{"Sideeffects of initializer of field " + fieldName + "will be ignored"});
            this.preSideAssignments.clear();
            this.postSideAssignments.clear();
        }
        fieldDecl.updateInitializer(nameAndInitializer.getInitializer());
        return fieldDecl;
    }

    private NameAndInitializer getNamesAndInitializer(VariableDeclarationFragment d) {
        JInitializerExpression initializerExpression = null;
        if (d.getInitializer() != null) {
            JExpression iniExpr = this.convertExpressionWithoutSideEffects(d.getInitializer());
            initializerExpression = new JInitializerExpression(this.getFileLocation((ASTNode)d), iniExpr);
        }
        String name = NameConverter.convertName(d.resolveBinding());
        return new NameAndInitializer(name, initializerExpression);
    }

    public List<JDeclaration> convert(VariableDeclarationStatement vds) {
        ArrayList<JDeclaration> variableDeclarations = new ArrayList<JDeclaration>();
        List variableDeclarationFragments = vds.fragments();
        FileLocation fileLoc = this.getFileLocation((ASTNode)vds);
        Type type = vds.getType();
        ModifierBean mB = ModifierBean.getModifiers(vds.modifiers());
        assert (!mB.isAbstract()) : "Local Variable has abstract modifier?";
        assert (!mB.isNative()) : "Local Variable has native modifier?";
        assert (mB.getVisibility() == VisibilityModifier.NONE) : "Local Variable has Visibility modifier?";
        assert (!mB.isStatic()) : "Local Variable has static modifier?";
        assert (!mB.isStrictFp()) : "Local Variable has strictFp modifier?";
        assert (!mB.isSynchronized()) : "Local Variable has synchronized modifier?";
        for (VariableDeclarationFragment vdf : variableDeclarationFragments) {
            NameAndInitializer nameAndInitializer = this.getNamesAndInitializer(vdf);
            JVariableDeclaration newD = new JVariableDeclaration(fileLoc, this.convert(type), nameAndInitializer.getName(), nameAndInitializer.getName(), this.getQualifiedName(nameAndInitializer.getName()), nameAndInitializer.getInitializer(), mB.isFinal());
            variableDeclarations.add(newD);
        }
        return variableDeclarations;
    }

    public JDeclaration convert(SingleVariableDeclaration d) {
        Type type = d.getType();
        ModifierBean mB = ModifierBean.getModifiers(d.modifiers());
        assert (!mB.isAbstract) : "Local Variable has abstract modifier?";
        assert (!mB.isNative) : "Local Variable has native modifier?";
        assert (mB.visibility == VisibilityModifier.NONE) : "Local Variable has Visibility modifier?";
        assert (!mB.isStatic) : "Local Variable has static modifier?";
        assert (!mB.isStrictFp) : "Local Variable has strictFp modifier?";
        assert (!mB.isSynchronized) : "Local Variable has synchronized modifier?";
        JInitializerExpression initializerExpression = null;
        if (d.getInitializer() != null) {
            JExpression iniExpr = (JExpression)this.convertExpressionWithSideEffects(d.getInitializer());
            initializerExpression = new JInitializerExpression(this.getFileLocation((ASTNode)d), iniExpr);
        }
        return new JVariableDeclaration(this.getFileLocation((ASTNode)d), this.convert(type), d.getName().getFullyQualifiedName(), d.getName().getFullyQualifiedName(), this.getQualifiedName(d.getName().getFullyQualifiedName()), initializerExpression, mB.isFinal());
    }

    public JReturnStatement convert(ReturnStatement s) {
        JExpression expr = this.convertExpressionWithoutSideEffects(s.getExpression());
        return new JReturnStatement(this.getFileLocation((ASTNode)s), (Optional<JExpression>)Optional.fromNullable((Object)expr));
    }

    public JExpression convertExpressionWithoutSideEffects(Expression e) {
        JAstNode node = this.convertExpressionWithSideEffects(e);
        if (node instanceof JCastExpression) {
            return this.addSideassignmentsForCasts(node, e);
        }
        if (node == null || node instanceof JExpression) {
            return (JExpression)node;
        }
        if (node instanceof JMethodInvocationExpression) {
            return this.addSideassignmentsForExpressionsWithoutMethodInvocationSideEffects(node, e);
        }
        if (node instanceof JAssignment) {
            this.addSideassignmentsForExpressionsWithoutAssignmentSideEffects(node, e);
            return ((JAssignment)node).getLeftHandSide();
        }
        throw new AssertionError((Object)("unknown expression " + node));
    }

    private JIdExpression addSideassignmentsForCasts(JAstNode node, Expression e) {
        JIdExpression tmp = this.createTemporaryVariable(e);
        this.preSideAssignments.add(new JExpressionAssignmentStatement(node.getFileLocation(), tmp, (JExpression)node));
        return tmp;
    }

    private void addSideassignmentsForExpressionsWithoutAssignmentSideEffects(JAstNode node, Expression e) {
        if (e instanceof PostfixExpression) {
            this.postSideAssignments.add(node);
        } else {
            this.preSideAssignments.add(node);
        }
    }

    private JExpression addSideassignmentsForExpressionsWithoutMethodInvocationSideEffects(JAstNode node, Expression e) {
        JIdExpression tmp = this.createTemporaryVariable(e);
        this.preSideAssignments.add(new JMethodInvocationAssignmentStatement(node.getFileLocation(), tmp, (JMethodInvocationExpression)node));
        return tmp;
    }

    private JIdExpression createTemporaryVariable(Expression e) {
        String name = "__CPAchecker_TMP_";
        int i = 0;
        while (this.scope.variableNameInUse(name + i, name + i)) {
            ++i;
        }
        name = name + i;
        JVariableDeclaration decl = new JVariableDeclaration(this.getFileLocation((ASTNode)e), this.convert(e.resolveTypeBinding()), name, name, this.getQualifiedName(name), null, false);
        this.scope.registerDeclarationOfThisClass(decl);
        this.preSideAssignments.add(decl);
        JIdExpression tmp = new JIdExpression(decl.getFileLocation(), this.convert(e.resolveTypeBinding()), name, decl);
        return tmp;
    }

    public JStatement convert(ExpressionStatement s) {
        JAstNode node = this.convertExpressionWithSideEffects(s.getExpression());
        if (node instanceof JExpressionAssignmentStatement) {
            return (JExpressionAssignmentStatement)node;
        }
        if (node instanceof JMethodInvocationAssignmentStatement) {
            return (JMethodInvocationAssignmentStatement)node;
        }
        if (node instanceof JMethodInvocationExpression) {
            return new JMethodInvocationStatement(this.getFileLocation((ASTNode)s), (JMethodInvocationExpression)node);
        }
        if (node instanceof JExpression) {
            return new JExpressionStatement(this.getFileLocation((ASTNode)s), (JExpression)node);
        }
        throw new AssertionError((Object)("Unhandled node type " + node.getClass().getCanonicalName()));
    }

    public JStatement convert(SuperConstructorInvocation sCI) {
        JIdExpression functionName;
        JIdExpression idExpression;
        String simpleName;
        String name;
        List p;
        boolean canBeResolved;
        IMethodBinding binding = sCI.resolveConstructorBinding();
        boolean bl = canBeResolved = binding != null;
        if (canBeResolved) {
            this.scope.registerClass(binding.getDeclaringClass());
        }
        List<JExpression> params = (p = sCI.arguments()).size() > 0 ? this.convert(p) : new ArrayList<JExpression>();
        if (canBeResolved) {
            name = NameConverter.convertName(binding);
            simpleName = binding.getName();
        } else {
            name = sCI.toString();
            simpleName = sCI.toString();
        }
        JConstructorDeclaration declaration = (JConstructorDeclaration)this.scope.lookupMethod(name);
        if (declaration == null) {
            if (canBeResolved) {
                ModifierBean mb = ModifierBean.getModifiers(binding);
                declaration = this.scope.createExternConstructorDeclaration(this.convertConstructorType(binding), name, simpleName, mb.getVisibility(), mb.isStrictFp(), (JClassType)this.getDeclaringClassType(binding));
            } else {
                declaration = JConstructorDeclaration.createUnresolvedConstructorDeclaration();
            }
        }
        if ((idExpression = (functionName = canBeResolved ? new JIdExpression(this.getFileLocation((ASTNode)sCI), this.convert(binding.getReturnType()), name, declaration) : new JIdExpression(this.getFileLocation((ASTNode)sCI), JClassType.createUnresolvableType(), name, declaration))).getDeclaration() != null) {
            functionName = new JIdExpression(idExpression.getFileLocation(), idExpression.getExpressionType(), name, declaration);
        }
        return new JMethodInvocationStatement(this.getFileLocation((ASTNode)sCI), new JSuperConstructorInvocation(this.getFileLocation((ASTNode)sCI), (JClassType)this.getDeclaringClassType(binding), (JExpression)functionName, params, declaration));
    }

    private JConstructorType convertConstructorType(IMethodBinding pBinding) {
        Preconditions.checkArgument((boolean)pBinding.isConstructor());
        JClassType declaringClass = (JClassType)this.getDeclaringClassType(pBinding);
        ITypeBinding[] paramBindings = pBinding.getParameterTypes();
        ArrayList<JType> paramTypes = new ArrayList<JType>();
        for (ITypeBinding type : paramBindings) {
            paramTypes.add(this.convert(type));
        }
        return new JConstructorType(declaringClass, paramTypes, pBinding.isVarargs());
    }

    private JMethodType convertMethodType(IMethodBinding pBinding) {
        Preconditions.checkArgument((!pBinding.isConstructor() ? 1 : 0) != 0);
        JClassOrInterfaceType declaringClass = this.getDeclaringClassType(pBinding);
        ITypeBinding[] paramBindings = pBinding.getParameterTypes();
        ArrayList<JType> paramTypes = new ArrayList<JType>();
        for (ITypeBinding type : paramBindings) {
            paramTypes.add(this.convert(type));
        }
        return new JMethodType(declaringClass, paramTypes, pBinding.isVarargs());
    }

    public JAstNode convertExpressionWithSideEffects(Expression e) {
        if (e == null) {
            this.logger.log(Level.FINE, new Object[]{"Expression to convert is null"});
            return null;
        }
        switch (e.getNodeType()) {
            case 7: {
                return this.convert((Assignment)e);
            }
            case 27: {
                return this.convert((InfixExpression)e);
            }
            case 34: {
                return this.convert((NumberLiteral)e);
            }
            case 13: {
                return this.convert((CharacterLiteral)e);
            }
            case 45: {
                return this.convert((StringLiteral)e);
            }
            case 33: {
                return this.convert((NullLiteral)e);
            }
            case 38: {
                return this.convert((PrefixExpression)e);
            }
            case 37: {
                return this.convert((PostfixExpression)e);
            }
            case 40: {
                return this.convert((QualifiedName)e);
            }
            case 9: {
                return this.convert((BooleanLiteral)e);
            }
            case 22: {
                return this.convert((FieldAccess)e);
            }
            case 42: {
                return this.convert((SimpleName)e);
            }
            case 36: {
                return this.convertExpressionWithoutSideEffects(((ParenthesizedExpression)e).getExpression());
            }
            case 32: {
                return this.convert((MethodInvocation)e);
            }
            case 14: {
                return this.convert((ClassInstanceCreation)e);
            }
            case 2: {
                return this.convert((ArrayAccess)e);
            }
            case 3: {
                return this.convert((ArrayCreation)e);
            }
            case 4: {
                return this.convert((ArrayInitializer)e);
            }
            case 16: {
                return this.convert((ConditionalExpression)e);
            }
            case 52: {
                return this.convert((ThisExpression)e);
            }
            case 62: {
                return this.convert((InstanceofExpression)e);
            }
            case 11: {
                return this.convert((CastExpression)e);
            }
            case 58: {
                return this.convert((VariableDeclarationExpression)e);
            }
            case 47: {
                return this.convert((SuperFieldAccess)e);
            }
            case 57: {
                return this.convert((TypeLiteral)e);
            }
            case 48: {
                return this.convert((SuperMethodInvocation)e);
            }
        }
        this.logger.log(Level.WARNING, new Object[]{"Expression of type " + AstDebugg.getTypeName(e.getNodeType()) + " not implemented"});
        return null;
    }

    private JAstNode convert(SuperMethodInvocation e) {
        JClassOrInterfaceType type;
        List p;
        boolean canBeResolved = e.resolveMethodBinding() != null;
        JClassOrInterfaceType declaringClassType = null;
        if (canBeResolved) {
            declaringClassType = (JClassOrInterfaceType)this.convert(e.resolveMethodBinding().getDeclaringClass());
            this.scope.registerClass(e.resolveMethodBinding().getDeclaringClass());
        }
        List<JExpression> params = (p = e.arguments()).size() > 0 ? this.convert(p) : new ArrayList<JExpression>();
        JExpression methodName = this.convertExpressionWithoutSideEffects((Expression)e.getName());
        JMethodDeclaration declaration = null;
        ModifierBean mb = null;
        if (canBeResolved) {
            mb = ModifierBean.getModifiers(e.resolveMethodBinding());
        }
        if (methodName instanceof JIdExpression) {
            JIdExpression idExpression = (JIdExpression)methodName;
            String name = idExpression.getName();
            declaration = this.scope.lookupMethod(name);
            if (idExpression.getDeclaration() != null) {
                methodName = new JIdExpression(idExpression.getFileLocation(), idExpression.getExpressionType(), name, declaration);
            }
        }
        if (declaration == null) {
            declaration = canBeResolved ? this.scope.createExternMethodDeclaration(this.convertMethodType(e.resolveMethodBinding()), methodName.toASTString(), e.resolveMethodBinding().getName(), VisibilityModifier.PUBLIC, mb.isFinal(), mb.isAbstract(), mb.isStatic(), mb.isNative(), mb.isSynchronized(), mb.isStrictFp(), declaringClassType) : JMethodDeclaration.createUnresolvedMethodDeclaration();
        }
        JMethodInvocationExpression miv = new JMethodInvocationExpression(this.getFileLocation((ASTNode)e), this.convert(e.resolveTypeBinding()), methodName, params, declaration);
        if (canBeResolved && (type = miv.getDeclaringType()) instanceof JClassType) {
            miv.setRunTimeBinding((JClassType)type);
        }
        return miv;
    }

    private JAstNode convert(TypeLiteral pE) {
        throw new CFAGenerationRuntimeException("Standard Library support not yet implemented.\nCannot use Type Literals which would return a class Object.");
    }

    private JAstNode convert(SuperFieldAccess e) {
        boolean canBeResolved;
        IVariableBinding vb = e.resolveFieldBinding();
        boolean bl = canBeResolved = vb != null;
        if (canBeResolved) {
            return this.convert(e.getName());
        }
        FileLocation fileLoc = this.getFileLocation((ASTNode)e);
        JType type = this.convert(e.resolveTypeBinding());
        String name = e.getName().getIdentifier();
        return new JIdExpression(fileLoc, type, name, null);
    }

    private JAstNode convert(CastExpression e) {
        return new JCastExpression(this.getFileLocation((ASTNode)e), this.convert(e.resolveTypeBinding()), this.convertExpressionWithoutSideEffects(e.getExpression()));
    }

    private JIdExpression convert(VariableDeclarationExpression vde) {
        ArrayList<JVariableDeclaration> variableDeclarations = new ArrayList<JVariableDeclaration>();
        List variableDeclarationFragments = vde.fragments();
        FileLocation fileLoc = this.getFileLocation((ASTNode)vde);
        Type type = vde.getType();
        ModifierBean mB = ModifierBean.getModifiers(vde.modifiers());
        assert (!mB.isAbstract()) : "Local Variable has abstract modifier?";
        assert (!mB.isNative()) : "Local Variable has native modifier?";
        assert (mB.getVisibility() == VisibilityModifier.NONE) : "Local Variable has Visibility modifier?";
        assert (!mB.isStatic()) : "Local Variable has static modifier?";
        assert (!mB.isStrictFp()) : "Local Variable has strictFp modifier?";
        assert (!mB.isSynchronized()) : "Local Variable has synchronized modifier?";
        for (VariableDeclarationFragment vdf : variableDeclarationFragments) {
            NameAndInitializer nameAndInitializer = this.getNamesAndInitializer(vdf);
            JVariableDeclaration newD = new JVariableDeclaration(fileLoc, this.convert(type), nameAndInitializer.getName(), nameAndInitializer.getName(), this.getQualifiedName(nameAndInitializer.getName()), nameAndInitializer.getInitializer(), mB.isFinal());
            variableDeclarations.add(newD);
        }
        this.forInitDeclarations.addAll(variableDeclarations);
        return null;
    }

    private JExpression convert(InstanceofExpression e) {
        FileLocation fileloc = this.getFileLocation((ASTNode)e);
        JExpression leftOperand = this.convertExpressionWithoutSideEffects(e.getLeftOperand());
        JType type = this.convert(e.getRightOperand().resolveBinding());
        assert (leftOperand instanceof JIdExpression) : "There are other expressions for instanceOf?";
        assert (type instanceof JClassOrInterfaceType) : "There are other types for this expression?";
        JIdExpression referenceVariable = (JIdExpression)leftOperand;
        JType instanceOfType = this.convert(e.resolveTypeBinding());
        assert (instanceOfType instanceof JSimpleType && ((JSimpleType)instanceOfType).getType() == JBasicType.BOOLEAN) : "InstanceofExpression is not always of type boolean!";
        return this.createInstanceOfExpression(referenceVariable, (JClassOrInterfaceType)type, fileloc);
    }

    private JExpression createInstanceOfExpression(JIdExpression pLeftOperand, JClassOrInterfaceType pClassOrInterfaceType, FileLocation pLocation) {
        List<JClassType> allPossibleClasses = this.getSubClasses(pClassOrInterfaceType);
        if (pClassOrInterfaceType instanceof JInterfaceType && allPossibleClasses.isEmpty()) {
            return new JBooleanLiteralExpression(pLocation, false);
        }
        return this.createInstanceOfDisjunction(pLeftOperand, allPossibleClasses, JSimpleType.getBoolean(), pLocation);
    }

    private List<JClassType> getSubClasses(JClassOrInterfaceType pType) {
        Set<JClassType> subClassTypeSet;
        assert (pType instanceof JInterfaceType || pType instanceof JClassType) : "Unhandled type " + pType;
        if (pType instanceof JInterfaceType) {
            subClassTypeSet = ((JInterfaceType)pType).getAllKnownImplementingClassesOfInterface();
        } else {
            JClassType classType = (JClassType)pType;
            subClassTypeSet = classType.getAllSubTypesOfClass();
            subClassTypeSet.add(classType);
        }
        return Lists.newArrayList(subClassTypeSet);
    }

    private JExpression createInstanceOfDisjunction(JIdExpression pLeftOperand, List<JClassType> pConcreteClassTypes, JType pExpressionType, FileLocation pLocation) {
        AbstractExpression currentCondition = this.convertClassRunTimeCompileTimeAccord(pLocation, pLeftOperand, (JClassOrInterfaceType)pConcreteClassTypes.remove(0));
        for (JClassType currentSubType : pConcreteClassTypes) {
            JRunTimeTypeEqualsType newCondition = this.convertClassRunTimeCompileTimeAccord(pLocation, pLeftOperand, (JClassOrInterfaceType)currentSubType);
            currentCondition = new JBinaryExpression(pLocation, pExpressionType, (JExpression)((Object)currentCondition), newCondition, JBinaryExpression.BinaryOperator.CONDITIONAL_OR);
        }
        return currentCondition;
    }

    private JRunTimeTypeEqualsType convertClassRunTimeCompileTimeAccord(FileLocation pFileloc, JIdExpression pDeclaration, JClassOrInterfaceType pClassType) {
        JVariableRunTimeType runTimeTyp = new JVariableRunTimeType(pFileloc, pDeclaration);
        return new JRunTimeTypeEqualsType(pFileloc, runTimeTyp, pClassType);
    }

    private JAstNode convert(ThisExpression e) {
        return new JThisExpression(this.getFileLocation((ASTNode)e), (JClassOrInterfaceType)this.convert(e.resolveTypeBinding()));
    }

    private JAstNode convert(FieldAccess e) {
        JExpression identifier;
        boolean canBeResolved;
        if (this.isArrayLengthExpression(e)) {
            return this.createJArrayLengthExpression(e);
        }
        IVariableBinding fieldBinding = e.resolveFieldBinding();
        boolean bl = canBeResolved = fieldBinding != null;
        if (canBeResolved) {
            this.scope.registerClass(fieldBinding.getDeclaringClass());
        }
        if (!((identifier = this.convertExpressionWithoutSideEffects((Expression)e.getName())) instanceof JIdExpression)) {
            throw new CFAGenerationRuntimeException("Identifier of FieldAccess could not be processed.", (ASTNode)e);
        }
        JIdExpression idExpIdentifier = (JIdExpression)identifier;
        JExpression qualifier = this.convertExpressionWithoutSideEffects(e.getExpression());
        if (qualifier instanceof JThisExpression) {
            return idExpIdentifier;
        }
        if (!(qualifier instanceof JIdExpression)) {
            throw new CFAGenerationRuntimeException("Qualifier of FieldAccess could not be processed.", (ASTNode)e);
        }
        JSimpleDeclaration decl = idExpIdentifier.getDeclaration();
        if (!(decl instanceof JFieldDeclaration)) {
            throw new CFAGenerationRuntimeException("Identifier of FieldAccess does not identify a field.", (ASTNode)e);
        }
        return new JFieldAccess(idExpIdentifier.getFileLocation(), idExpIdentifier.getExpressionType(), idExpIdentifier.getName(), (JFieldDeclaration)decl, (JIdExpression)qualifier);
    }

    private boolean isArrayLengthExpression(FieldAccess e) {
        return e.getExpression() instanceof ArrayAccess;
    }

    private JArrayLengthExpression createJArrayLengthExpression(FieldAccess e) {
        JExpression qualifierExpression = this.convertExpressionWithoutSideEffects(e.getExpression());
        return JArrayLengthExpression.getInstance(qualifierExpression, this.getFileLocation((ASTNode)e));
    }

    private JAstNode convert(ClassInstanceCreation cIC) {
        JIdExpression functionName;
        JIdExpression idExpression;
        String simpleName;
        String name;
        List p;
        boolean canBeResolved;
        IMethodBinding binding = cIC.resolveConstructorBinding();
        boolean bl = canBeResolved = binding != null;
        if (canBeResolved) {
            this.scope.registerClass(binding.getDeclaringClass());
        }
        List<JExpression> params = (p = cIC.arguments()).size() > 0 ? this.convert(p) : new ArrayList<JExpression>();
        if (canBeResolved) {
            name = NameConverter.convertName(binding);
            simpleName = binding.getName();
        } else {
            name = cIC.toString();
            simpleName = cIC.toString();
        }
        JConstructorDeclaration declaration = (JConstructorDeclaration)this.scope.lookupMethod(name);
        if (declaration == null) {
            if (canBeResolved) {
                ModifierBean mb = ModifierBean.getModifiers(binding);
                declaration = new JConstructorDeclaration(this.getFileLocation((ASTNode)cIC), this.convertConstructorType(binding), name, simpleName, new ArrayList<JParameterDeclaration>(), mb.getVisibility(), mb.isStrictFp(), (JClassType)this.getDeclaringClassType(binding));
            } else {
                declaration = new JConstructorDeclaration(this.getFileLocation((ASTNode)cIC), JConstructorType.createUnresolvableConstructorType(), name, simpleName, new ArrayList<JParameterDeclaration>(), VisibilityModifier.NONE, false, JClassType.createUnresolvableType());
            }
        }
        if ((idExpression = (functionName = new JIdExpression(this.getFileLocation((ASTNode)cIC), this.convert(cIC.resolveTypeBinding()), name, declaration))).getDeclaration() != null) {
            functionName = new JIdExpression(idExpression.getFileLocation(), idExpression.getExpressionType(), name, declaration);
        }
        return new JClassInstanceCreation(this.getFileLocation((ASTNode)cIC), (JClassType)this.getDeclaringClassType(binding), (JExpression)functionName, params, declaration);
    }

    private JAstNode convert(ConditionalExpression e) {
        JIdExpression tmp;
        this.conditionalTemporaryVariable = tmp = this.createTemporaryVariable((Expression)e);
        this.conditionalExpression = e;
        return tmp;
    }

    private JAstNode convert(ArrayInitializer initializer) {
        if (initializer == null) {
            this.logger.log(Level.FINE, new Object[]{"Array initializer to convert is null"});
            return null;
        }
        JArrayType type = (JArrayType)this.convert(initializer.resolveTypeBinding());
        ArrayList<JExpression> initializerExpressions = new ArrayList<JExpression>();
        List expressions = initializer.expressions();
        for (Expression exp : expressions) {
            initializerExpressions.add(this.convertExpressionWithoutSideEffects(exp));
        }
        return new JArrayInitializer(this.getFileLocation((ASTNode)initializer), initializerExpressions, type);
    }

    private JAstNode convert(ArrayCreation Ace) {
        FileLocation fileloc = this.getFileLocation((ASTNode)Ace);
        JArrayInitializer initializer = (JArrayInitializer)this.convertExpressionWithoutSideEffects((Expression)Ace.getInitializer());
        JArrayType type = this.convert(Ace.getType());
        ArrayList<JExpression> length = new ArrayList<JExpression>(type.getDimensions());
        List dim = Ace.dimensions();
        if (initializer != null) {
            for (int dimension = 0; dimension < type.getDimensions(); ++dimension) {
                length.add(new JIntegerLiteralExpression(fileloc, BigInteger.valueOf(dimension)));
            }
        } else {
            for (Expression exp : dim) {
                length.add(this.convertExpressionWithoutSideEffects(exp));
            }
        }
        return new JArrayCreationExpression(fileloc, type, initializer, length);
    }

    private JAstNode convert(ArrayAccess e) {
        JExpression subscriptExpression = this.convertExpressionWithoutSideEffects(e.getArray());
        JExpression index = this.convertExpressionWithoutSideEffects(e.getIndex());
        assert (subscriptExpression != null);
        assert (index != null);
        return new JArraySubscriptExpression(this.getFileLocation((ASTNode)e), this.convert(e.resolveTypeBinding()), subscriptExpression, index);
    }

    private JAstNode convert(QualifiedName e) {
        boolean canBeResolved;
        if (this.isArrayLengthExpression(e)) {
            return this.createJArrayLengthExpression(e);
        }
        IBinding binding = e.resolveBinding();
        boolean bl = canBeResolved = binding != null;
        if (canBeResolved) {
            if (binding instanceof IMethodBinding) {
                String name = NameConverter.convertName((IMethodBinding)e.resolveBinding());
                return new JIdExpression(this.getFileLocation((ASTNode)e), this.convert(e.resolveTypeBinding()), name, null);
            }
            if (binding instanceof IVariableBinding) {
                IVariableBinding vb = (IVariableBinding)binding;
                if (vb.isEnumConstant()) {
                    return new JEnumConstantExpression(this.getFileLocation((ASTNode)e), (JClassType)this.convert(e.resolveTypeBinding()), NameConverter.convertName((IVariableBinding)e.resolveBinding()));
                }
                return this.convertQualifiedVariableIdentificationExpression(e, vb);
            }
            String name = e.getFullyQualifiedName();
            return new JIdExpression(this.getFileLocation((ASTNode)e), this.convert(e.resolveTypeBinding()), name, null);
        }
        String name = e.getFullyQualifiedName();
        return new JIdExpression(this.getFileLocation((ASTNode)e), this.convert(e.resolveTypeBinding()), name, null);
    }

    private boolean isArrayLengthExpression(QualifiedName e) {
        JExpression qualifierExpression = this.convertExpressionWithoutSideEffects((Expression)e.getQualifier());
        String lengthExpression = "length";
        IBinding lengthBinding = e.resolveBinding();
        return lengthBinding != null && lengthBinding.getName().equals("length") && this.isArrayType(qualifierExpression.getExpressionType()) || this.isMainArgumentArray(e, qualifierExpression);
    }

    private boolean isMainArgumentArray(QualifiedName e, JExpression qualifierExpression) {
        IBinding lengthBinding = e.resolveBinding();
        if (qualifierExpression instanceof JIdExpression) {
            JSimpleDeclaration qualifierDecl = ((JIdExpression)qualifierExpression).getDeclaration();
            return lengthBinding == null && this.isArrayType(qualifierDecl.getType()) && qualifierDecl instanceof JParameterDeclaration;
        }
        return false;
    }

    private JArrayLengthExpression createJArrayLengthExpression(QualifiedName e) {
        JExpression qualifierExpression = this.convertExpressionWithoutSideEffects((Expression)e.getQualifier());
        return JArrayLengthExpression.getInstance(qualifierExpression, this.getFileLocation((ASTNode)e));
    }

    private boolean isArrayType(JType pType) {
        return pType instanceof JArrayType;
    }

    private JAstNode convertQualifiedVariableIdentificationExpression(QualifiedName e, IVariableBinding vb) {
        JExpression identifier = this.convertExpressionWithoutSideEffects((Expression)e.getName());
        if (!(identifier instanceof JIdExpression)) {
            throw new CFAGenerationRuntimeException("Identifier of FieldAccess could not be processed.", (ASTNode)e);
        }
        JIdExpression idExpIdentifier = (JIdExpression)identifier;
        JExpression qualifier = this.convertExpressionWithoutSideEffects((Expression)e.getQualifier());
        if (qualifier instanceof JThisExpression) {
            return idExpIdentifier;
        }
        if (!(qualifier instanceof JIdExpression)) {
            throw new CFAGenerationRuntimeException("Qualifier of FieldAccess could not be processed.", (ASTNode)e);
        }
        JSimpleDeclaration decl = idExpIdentifier.getDeclaration();
        if (!(decl instanceof JFieldDeclaration)) {
            throw new CFAGenerationRuntimeException("Identifier of FieldAccess does not identify a field.", (ASTNode)e);
        }
        return new JFieldAccess(idExpIdentifier.getFileLocation(), idExpIdentifier.getExpressionType(), idExpIdentifier.getName(), (JFieldDeclaration)decl, (JIdExpression)qualifier);
    }

    public JMethodInvocationExpression convert(FunctionEntryNode newFunctionEntryNode, JMethodInvocationExpression oldMethodCall) {
        JMethodDeclaration declaration = (JMethodDeclaration)newFunctionEntryNode.getFunctionDefinition();
        String name = newFunctionEntryNode.getFunctionName();
        JIdExpression methodName = new JIdExpression(oldMethodCall.getFileLocation(), JSimpleType.getUnspecified(), name, declaration);
        if (oldMethodCall instanceof JReferencedMethodInvocationExpression) {
            return new JReferencedMethodInvocationExpression(oldMethodCall.getFileLocation(), oldMethodCall.getExpressionType(), methodName, oldMethodCall.getParameterExpressions(), declaration, ((JReferencedMethodInvocationExpression)oldMethodCall).getReferencedVariable());
        }
        return new JMethodInvocationExpression(oldMethodCall.getFileLocation(), oldMethodCall.getExpressionType(), methodName, oldMethodCall.getParameterExpressions(), declaration);
    }

    private JAstNode convert(MethodInvocation mi) {
        List p;
        boolean canBeResolve = mi.resolveMethodBinding() != null;
        JClassOrInterfaceType declaringClassType = null;
        if (canBeResolve) {
            declaringClassType = (JClassOrInterfaceType)this.convert(mi.resolveMethodBinding().getDeclaringClass());
            this.scope.registerClass(mi.resolveMethodBinding().getDeclaringClass());
        }
        List<JExpression> params = (p = mi.arguments()).size() > 0 ? this.convert(p) : new ArrayList<JExpression>();
        JExpression methodName = this.convertExpressionWithoutSideEffects((Expression)mi.getName());
        JMethodDeclaration declaration = null;
        JExpression referencedVariableName = null;
        ModifierBean mb = null;
        if (canBeResolve && !(mb = ModifierBean.getModifiers(mi.resolveMethodBinding())).isStatic) {
            referencedVariableName = this.convertExpressionWithoutSideEffects(mi.getExpression());
        }
        if (methodName instanceof JIdExpression) {
            JIdExpression idExpression = (JIdExpression)methodName;
            String name = idExpression.getName();
            declaration = this.scope.lookupMethod(name);
            if (idExpression.getDeclaration() != null) {
                methodName = new JIdExpression(idExpression.getFileLocation(), idExpression.getExpressionType(), name, declaration);
            }
        }
        if (declaration == null) {
            declaration = canBeResolve ? this.scope.createExternMethodDeclaration(this.convertMethodType(mi.resolveMethodBinding()), methodName.toASTString(), mi.resolveMethodBinding().getName(), VisibilityModifier.PUBLIC, mb.isFinal(), mb.isAbstract(), mb.isStatic(), mb.isNative(), mb.isSynchronized(), mb.isStrictFp(), declaringClassType) : JMethodDeclaration.createUnresolvedMethodDeclaration();
        }
        if (!(referencedVariableName instanceof JIdExpression)) {
            return new JMethodInvocationExpression(this.getFileLocation((ASTNode)mi), this.convert(mi.resolveTypeBinding()), methodName, params, declaration);
        }
        return new JReferencedMethodInvocationExpression(this.getFileLocation((ASTNode)mi), this.convert(mi.resolveTypeBinding()), methodName, params, declaration, (JIdExpression)referencedVariableName);
    }

    private List<JExpression> convert(List<Expression> el) {
        ArrayList<JExpression> result = new ArrayList<JExpression>(el.size());
        for (Expression expression : el) {
            result.add(this.convertExpressionWithoutSideEffects(expression));
        }
        return result;
    }

    private JAstNode convert(SimpleName e) {
        boolean canBeResolved;
        String name = null;
        JMethodDeclaration declaration = null;
        IBinding binding = e.resolveBinding();
        boolean bl = canBeResolved = binding != null;
        if (canBeResolved) {
            if (binding instanceof IVariableBinding) {
                return this.convertSimpleVariable(e, (IVariableBinding)binding);
            }
            if (binding instanceof IMethodBinding) {
                name = NameConverter.convertName((IMethodBinding)binding);
                declaration = this.scope.lookupMethod(name);
            } else if (binding instanceof ITypeBinding) {
                name = e.getIdentifier();
            }
        } else {
            name = e.getIdentifier();
        }
        assert (name != null);
        return new JIdExpression(this.getFileLocation((ASTNode)e), this.convert(e.resolveTypeBinding()), name, declaration);
    }

    private JAstNode convertSimpleVariable(SimpleName e, IVariableBinding vb) {
        if (((IVariableBinding)e.resolveBinding()).isEnumConstant()) {
            return new JEnumConstantExpression(this.getFileLocation((ASTNode)e), (JClassType)this.convert(e.resolveTypeBinding()), NameConverter.convertName((IVariableBinding)e.resolveBinding()));
        }
        String name = NameConverter.convertName(vb);
        JSimpleDeclaration declaration = this.scope.lookupVariable(name);
        if (declaration == null) {
            declaration = this.createVariableDeclarationFromBinding(e, vb);
        }
        assert (name.equals(declaration.getName())) : "Created a false declaration for " + e.toString();
        JType type = this.convert(e.resolveTypeBinding());
        return new JIdExpression(this.getFileLocation((ASTNode)e), type, name, declaration);
    }

    private JSimpleDeclaration createVariableDeclarationFromBinding(SimpleName e, IVariableBinding vb) {
        if (!vb.isField()) {
            throw new CFAGenerationRuntimeException("Declaration of Variable " + e.getIdentifier() + " not found.", (ASTNode)e);
        }
        String name = NameConverter.convertName(vb);
        String simpleName = vb.getName();
        ModifierBean mb = ModifierBean.getModifiers(vb.getModifiers());
        JType type = this.convert(e.resolveTypeBinding());
        JFieldDeclaration decl = this.scope.createExternFieldDeclaration(type, name, simpleName, mb.isFinal(), mb.isStatic(), mb.getVisibility(), mb.isVolatile(), mb.isTransient());
        return decl;
    }

    private JAstNode convert(Assignment e) {
        FileLocation fileLoc = this.getFileLocation((ASTNode)e);
        JType type = this.convert(e.resolveTypeBinding());
        JLeftHandSide leftHandSide = (JLeftHandSide)this.convertExpressionWithoutSideEffects(e.getLeftHandSide());
        JBinaryExpression.BinaryOperator op = this.convert(e.getOperator(), leftHandSide.getExpressionType());
        if (op == null) {
            JAstNode rightHandSide = this.convertExpressionWithSideEffects(e.getRightHandSide());
            if (rightHandSide instanceof JExpression) {
                return new JExpressionAssignmentStatement(fileLoc, leftHandSide, (JExpression)rightHandSide);
            }
            if (rightHandSide instanceof JMethodInvocationExpression) {
                return new JMethodInvocationAssignmentStatement(fileLoc, leftHandSide, (JMethodInvocationExpression)rightHandSide);
            }
            if (rightHandSide instanceof JAssignment) {
                this.preSideAssignments.add(rightHandSide);
                return new JExpressionAssignmentStatement(fileLoc, leftHandSide, ((JAssignment)rightHandSide).getLeftHandSide());
            }
            throw new CFAGenerationRuntimeException("Expression is not free of side-effects");
        }
        JExpression rightHandSide = this.convertExpressionWithoutSideEffects(e.getRightHandSide());
        JBinaryExpression exp = new JBinaryExpression(fileLoc, type, leftHandSide, rightHandSide, op);
        return new JExpressionAssignmentStatement(fileLoc, leftHandSide, exp);
    }

    private JBinaryExpression.BinaryOperator convert(Assignment.Operator op, JType type) {
        String invalidTypeMsg = "Invalid type '" + type + "' for assignment with binary operation.";
        JBasicType basicType = type instanceof JSimpleType ? ((JSimpleType)type).getType() : null;
        if (op.equals(Assignment.Operator.ASSIGN)) {
            return null;
        }
        if (basicType != null) {
            switch (basicType) {
                case BOOLEAN: {
                    return this.convertBooleanOperator(op);
                }
                case BYTE: 
                case SHORT: 
                case INT: 
                case LONG: 
                case DOUBLE: 
                case FLOAT: {
                    return this.convertNumberOperator(op);
                }
            }
            throw new CFAGenerationRuntimeException(invalidTypeMsg);
        }
        throw new CFAGenerationRuntimeException(invalidTypeMsg);
    }

    private JBinaryExpression.BinaryOperator convertBooleanOperator(Assignment.Operator op) {
        if (op.equals(Assignment.Operator.BIT_AND_ASSIGN)) {
            return JBinaryExpression.BinaryOperator.LOGICAL_AND;
        }
        if (op.equals(Assignment.Operator.BIT_OR_ASSIGN)) {
            return JBinaryExpression.BinaryOperator.LOGICAL_OR;
        }
        if (op.equals(Assignment.Operator.BIT_XOR_ASSIGN)) {
            return JBinaryExpression.BinaryOperator.LOGICAL_XOR;
        }
        throw new CFAGenerationRuntimeException("Invalid operator " + op + " for boolean assignment");
    }

    private JBinaryExpression.BinaryOperator convertNumberOperator(Assignment.Operator op) {
        if (op.equals(Assignment.Operator.BIT_AND_ASSIGN)) {
            return JBinaryExpression.BinaryOperator.BINARY_AND;
        }
        if (op.equals(Assignment.Operator.BIT_OR_ASSIGN)) {
            return JBinaryExpression.BinaryOperator.BINARY_OR;
        }
        if (op.equals(Assignment.Operator.BIT_XOR_ASSIGN)) {
            return JBinaryExpression.BinaryOperator.BINARY_XOR;
        }
        if (op.equals(Assignment.Operator.DIVIDE_ASSIGN)) {
            return JBinaryExpression.BinaryOperator.DIVIDE;
        }
        if (op.equals(Assignment.Operator.LEFT_SHIFT_ASSIGN)) {
            return JBinaryExpression.BinaryOperator.SHIFT_LEFT;
        }
        if (op.equals(Assignment.Operator.RIGHT_SHIFT_SIGNED_ASSIGN)) {
            return JBinaryExpression.BinaryOperator.SHIFT_RIGHT_SIGNED;
        }
        if (op.equals(Assignment.Operator.RIGHT_SHIFT_UNSIGNED_ASSIGN)) {
            return JBinaryExpression.BinaryOperator.SHIFT_RIGHT_UNSIGNED;
        }
        if (op.equals(Assignment.Operator.MINUS_ASSIGN)) {
            return JBinaryExpression.BinaryOperator.MINUS;
        }
        if (op.equals(Assignment.Operator.PLUS_ASSIGN)) {
            return JBinaryExpression.BinaryOperator.PLUS;
        }
        if (op.equals(Assignment.Operator.REMAINDER_ASSIGN)) {
            return JBinaryExpression.BinaryOperator.MODULO;
        }
        if (op.equals(Assignment.Operator.TIMES_ASSIGN)) {
            return JBinaryExpression.BinaryOperator.MULTIPLY;
        }
        throw new CFAGenerationRuntimeException("Invalid operator " + op + " for number assignment.");
    }

    private JExpression convert(BooleanLiteral e) {
        return new JBooleanLiteralExpression(this.getFileLocation((ASTNode)e), e.booleanValue());
    }

    private JAstNode convert(PrefixExpression e) {
        PrefixExpression.Operator op = e.getOperator();
        if (op.equals(PrefixExpression.Operator.INCREMENT) || op.equals(PrefixExpression.Operator.DECREMENT)) {
            return this.handlePreFixIncOrDec(e, op);
        }
        JExpression operand = this.convertExpressionWithoutSideEffects(e.getOperand());
        FileLocation fileLoc = this.getFileLocation((ASTNode)e);
        return new JUnaryExpression(fileLoc, this.convert(e.resolveTypeBinding()), operand, this.convert(op));
    }

    private JAstNode convert(PostfixExpression e) {
        PostfixExpression.Operator op = e.getOperator();
        return this.handlePostFixIncOrDec(e, op);
    }

    private JAstNode handlePostFixIncOrDec(PostfixExpression e, PostfixExpression.Operator op) {
        JBinaryExpression.BinaryOperator postOp = null;
        if (op.equals(PostfixExpression.Operator.INCREMENT)) {
            postOp = JBinaryExpression.BinaryOperator.PLUS;
        } else if (op.equals(PostfixExpression.Operator.DECREMENT)) {
            postOp = JBinaryExpression.BinaryOperator.MINUS;
        }
        assert (postOp != null) : "Increment/Decrement Severe Error.";
        FileLocation fileLoc = this.getFileLocation((ASTNode)e);
        JType type = this.convert(e.resolveTypeBinding());
        JLeftHandSide operand = (JLeftHandSide)this.convertExpressionWithoutSideEffects(e.getOperand());
        JIntegerLiteralExpression preOne = new JIntegerLiteralExpression(fileLoc, BigInteger.ONE);
        JBinaryExpression preExp = new JBinaryExpression(fileLoc, type, operand, preOne, postOp);
        return new JExpressionAssignmentStatement(fileLoc, operand, preExp);
    }

    private JAstNode handlePreFixIncOrDec(PrefixExpression e, PrefixExpression.Operator op) {
        JBinaryExpression.BinaryOperator preOp = null;
        if (op.equals(PrefixExpression.Operator.INCREMENT)) {
            preOp = JBinaryExpression.BinaryOperator.PLUS;
        } else if (op.equals(PrefixExpression.Operator.DECREMENT)) {
            preOp = JBinaryExpression.BinaryOperator.MINUS;
        }
        FileLocation fileLoc = this.getFileLocation((ASTNode)e);
        JType type = this.convert(e.resolveTypeBinding());
        JLeftHandSide operand = (JLeftHandSide)this.convertExpressionWithoutSideEffects(e.getOperand());
        JIntegerLiteralExpression preOne = new JIntegerLiteralExpression(fileLoc, BigInteger.ONE);
        JBinaryExpression preExp = new JBinaryExpression(fileLoc, type, operand, preOne, preOp);
        return new JExpressionAssignmentStatement(fileLoc, operand, preExp);
    }

    private JUnaryExpression.UnaryOperator convert(PrefixExpression.Operator op) {
        if (op.equals(PrefixExpression.Operator.NOT)) {
            return JUnaryExpression.UnaryOperator.NOT;
        }
        if (op.equals(PrefixExpression.Operator.PLUS)) {
            return JUnaryExpression.UnaryOperator.PLUS;
        }
        if (op.equals(PrefixExpression.Operator.COMPLEMENT)) {
            return JUnaryExpression.UnaryOperator.COMPLEMENT;
        }
        if (op.equals(PrefixExpression.Operator.MINUS)) {
            return JUnaryExpression.UnaryOperator.MINUS;
        }
        throw new CFAGenerationRuntimeException("Could not proccess Operator:" + op.toString() + ".");
    }

    private JExpression convert(InfixExpression e) {
        FileLocation fileLoc = this.getFileLocation((ASTNode)e);
        JType type = this.convert(e.resolveTypeBinding());
        JExpression leftHandSide = this.convertExpressionWithoutSideEffects(e.getLeftOperand());
        assert (leftHandSide != null);
        JExpression rightHandSide = this.convertExpressionWithoutSideEffects(e.getRightOperand());
        assert (rightHandSide != null);
        JType leftHandType = leftHandSide.getExpressionType();
        JType rightHandType = rightHandSide.getExpressionType();
        JBinaryExpression.BinaryOperator op = this.convert(e.getOperator(), leftHandType, rightHandType);
        JBinaryExpression binaryExpression = new JBinaryExpression(fileLoc, type, leftHandSide, rightHandSide, op);
        if (e.hasExtendedOperands()) {
            List extOperands = e.extendedOperands();
            for (Expression extendedOperand : extOperands) {
                binaryExpression = new JBinaryExpression(fileLoc, type, binaryExpression, this.convertExpressionWithoutSideEffects(extendedOperand), op);
            }
        }
        return binaryExpression;
    }

    private JBinaryExpression.BinaryOperator convert(InfixExpression.Operator op, JType pOp1Type, JType pOp2Type) {
        String invalidTypeMsg = "Invalid operation '" + pOp1Type + " " + op + " " + pOp2Type + "'";
        JBasicType basicTypeOp1 = null;
        JBasicType basicTypeOp2 = null;
        if (pOp1Type instanceof JSimpleType) {
            basicTypeOp1 = ((JSimpleType)pOp1Type).getType();
        }
        if (pOp2Type instanceof JSimpleType) {
            basicTypeOp2 = ((JSimpleType)pOp2Type).getType();
        }
        if (basicTypeOp1 == null || basicTypeOp2 == null) {
            if (op.equals(InfixExpression.Operator.EQUALS)) {
                return JBinaryExpression.BinaryOperator.EQUALS;
            }
            if (op.equals(InfixExpression.Operator.NOT_EQUALS)) {
                return JBinaryExpression.BinaryOperator.NOT_EQUALS;
            }
            throw new CFAGenerationRuntimeException(invalidTypeMsg);
        }
        if (this.isNumericCompatible(basicTypeOp1) && this.isNumericCompatible(basicTypeOp2)) {
            return this.convertNumericOperator(op);
        }
        if (this.isBooleanCompatible(basicTypeOp1) && this.isBooleanCompatible(basicTypeOp2)) {
            return this.convertBooleanOperator(op);
        }
        throw new CFAGenerationRuntimeException(invalidTypeMsg);
    }

    private boolean isNumericCompatible(JBasicType pType) {
        return pType != null && (pType.isIntegerType() || pType.isFloatingPointType() || pType == JBasicType.UNSPECIFIED);
    }

    private boolean isBooleanCompatible(JBasicType pType) {
        return pType == JBasicType.BOOLEAN || pType == JBasicType.UNSPECIFIED;
    }

    private JBinaryExpression.BinaryOperator convertNumericOperator(InfixExpression.Operator op) {
        if (op.equals(InfixExpression.Operator.PLUS)) {
            return JBinaryExpression.BinaryOperator.PLUS;
        }
        if (op.equals(InfixExpression.Operator.MINUS)) {
            return JBinaryExpression.BinaryOperator.MINUS;
        }
        if (op.equals(InfixExpression.Operator.DIVIDE)) {
            return JBinaryExpression.BinaryOperator.DIVIDE;
        }
        if (op.equals(InfixExpression.Operator.TIMES)) {
            return JBinaryExpression.BinaryOperator.MULTIPLY;
        }
        if (op.equals(InfixExpression.Operator.REMAINDER)) {
            return JBinaryExpression.BinaryOperator.MODULO;
        }
        if (op.equals(InfixExpression.Operator.GREATER)) {
            return JBinaryExpression.BinaryOperator.GREATER_THAN;
        }
        if (op.equals(InfixExpression.Operator.LESS)) {
            return JBinaryExpression.BinaryOperator.LESS_THAN;
        }
        if (op.equals(InfixExpression.Operator.GREATER_EQUALS)) {
            return JBinaryExpression.BinaryOperator.GREATER_EQUAL;
        }
        if (op.equals(InfixExpression.Operator.LESS_EQUALS)) {
            return JBinaryExpression.BinaryOperator.LESS_EQUAL;
        }
        if (op.equals(InfixExpression.Operator.LEFT_SHIFT)) {
            return JBinaryExpression.BinaryOperator.SHIFT_LEFT;
        }
        if (op.equals(InfixExpression.Operator.RIGHT_SHIFT_SIGNED)) {
            return JBinaryExpression.BinaryOperator.SHIFT_RIGHT_SIGNED;
        }
        if (op.equals(InfixExpression.Operator.RIGHT_SHIFT_UNSIGNED)) {
            return JBinaryExpression.BinaryOperator.SHIFT_RIGHT_UNSIGNED;
        }
        if (op.equals(InfixExpression.Operator.NOT_EQUALS)) {
            return JBinaryExpression.BinaryOperator.NOT_EQUALS;
        }
        if (op.equals(InfixExpression.Operator.EQUALS)) {
            return JBinaryExpression.BinaryOperator.EQUALS;
        }
        if (op.equals(InfixExpression.Operator.AND)) {
            return JBinaryExpression.BinaryOperator.BINARY_AND;
        }
        if (op.equals(InfixExpression.Operator.OR)) {
            return JBinaryExpression.BinaryOperator.BINARY_OR;
        }
        if (op.equals(InfixExpression.Operator.XOR)) {
            return JBinaryExpression.BinaryOperator.BINARY_XOR;
        }
        throw new CFAGenerationRuntimeException("Could not proccess Operator: " + op.toString());
    }

    private JBinaryExpression.BinaryOperator convertBooleanOperator(InfixExpression.Operator op) {
        if (op.equals(InfixExpression.Operator.CONDITIONAL_AND)) {
            return JBinaryExpression.BinaryOperator.CONDITIONAL_AND;
        }
        if (op.equals(InfixExpression.Operator.CONDITIONAL_OR)) {
            return JBinaryExpression.BinaryOperator.CONDITIONAL_OR;
        }
        if (op.equals(InfixExpression.Operator.NOT_EQUALS)) {
            return JBinaryExpression.BinaryOperator.NOT_EQUALS;
        }
        if (op.equals(InfixExpression.Operator.EQUALS)) {
            return JBinaryExpression.BinaryOperator.EQUALS;
        }
        if (op.equals(InfixExpression.Operator.AND)) {
            return JBinaryExpression.BinaryOperator.LOGICAL_AND;
        }
        if (op.equals(InfixExpression.Operator.OR)) {
            return JBinaryExpression.BinaryOperator.LOGICAL_OR;
        }
        if (op.equals(InfixExpression.Operator.XOR)) {
            return JBinaryExpression.BinaryOperator.LOGICAL_XOR;
        }
        throw new CFAGenerationRuntimeException("Could not proccess Operator: " + op.toString());
    }

    private JExpression convert(NumberLiteral e) {
        FileLocation fileLoc = this.getFileLocation((ASTNode)e);
        JType type = this.convert(e.resolveTypeBinding());
        String valueStr = e.getToken();
        JBasicType t = ((JSimpleType)type).getType();
        switch (t) {
            case INT: {
                return new JIntegerLiteralExpression(fileLoc, this.parseIntegerLiteral(valueStr, (ASTNode)e));
            }
            case FLOAT: {
                return new JFloatLiteralExpression(fileLoc, this.parseFloatLiteral(valueStr, e));
            }
            case DOUBLE: {
                return new JFloatLiteralExpression(fileLoc, this.parseFloatLiteral(valueStr, e));
            }
        }
        return new JIntegerLiteralExpression(this.getFileLocation((ASTNode)e), BigInteger.valueOf(Long.parseLong(e.getToken())));
    }

    private BigDecimal parseFloatLiteral(String valueStr, NumberLiteral e) {
        BigDecimal value;
        try {
            value = new BigDecimal(valueStr);
        }
        catch (NumberFormatException nfe1) {
            try {
                value = BigDecimal.valueOf(Double.parseDouble(valueStr));
            }
            catch (NumberFormatException nfe2) {
                throw new CFAGenerationRuntimeException("Illegal floating point literal", nfe2);
            }
        }
        return value;
    }

    private BigInteger parseIntegerLiteral(String s, ASTNode e) {
        BigInteger result;
        assert (!s.endsWith("l") && !s.endsWith("L"));
        try {
            if (s.startsWith("0x") || s.startsWith("0X")) {
                s = s.substring(2);
                result = new BigInteger(s, 16);
            } else {
                result = s.startsWith("0") ? new BigInteger(s, 8) : (s.startsWith("0b || 0B") ? new BigInteger(s, 2) : new BigInteger(s, 10));
            }
        }
        catch (NumberFormatException e1) {
            throw new CFAGenerationRuntimeException("Invalid int [" + s + "]", e1);
        }
        ASTConverter.check(this.isInIntegerRange(result), "Invalid int [" + s + "]", e);
        return result;
    }

    private boolean isInIntegerRange(BigInteger value) {
        BigInteger smallestPossibleValue = BigInteger.valueOf(Integer.MIN_VALUE);
        BigInteger biggestPossibleValue = BigInteger.valueOf(Integer.MAX_VALUE);
        return value.compareTo(smallestPossibleValue) >= 0 && value.compareTo(biggestPossibleValue) <= 0;
    }

    public JMethodInvocationAssignmentStatement getIteratorFromIterable(Expression pExpr) {
        JExpression iterable = this.convertExpressionWithoutSideEffects(pExpr);
        if (!(iterable instanceof JIdExpression)) {
            throw new CFAGenerationRuntimeException(pExpr.toString() + "was not correctly processed.", (ASTNode)pExpr);
        }
        FileLocation fileLoc = this.getFileLocation((ASTNode)pExpr);
        LinkedList parameters = new LinkedList();
        JInterfaceType iteratorTyp = JInterfaceType.createUnresolvableType();
        JIdExpression name = new JIdExpression(fileLoc, iteratorTyp, "iterator", null);
        JReferencedMethodInvocationExpression mi = new JReferencedMethodInvocationExpression(fileLoc, iteratorTyp, name, parameters, null, (JIdExpression)iterable);
        String varName = "it_";
        int i = 0;
        while (this.scope.variableNameInUse(varName + i, varName + i)) {
            ++i;
        }
        varName = varName + i;
        JVariableDeclaration decl = new JVariableDeclaration(fileLoc, iteratorTyp, varName, varName, this.getQualifiedName(varName), null, false);
        this.scope.registerDeclarationOfThisClass(decl);
        this.preSideAssignments.add(decl);
        this.enhancedForLoopIterator = new JIdExpression(decl.getFileLocation(), iteratorTyp, varName, decl);
        return new JMethodInvocationAssignmentStatement(fileLoc, this.enhancedForLoopIterator, mi);
    }

    public JExpression createIteratorCondition(Expression e) {
        FileLocation fileloc = this.enhancedForLoopIterator.getFileLocation();
        JSimpleType type = JSimpleType.getBoolean();
        JIdExpression name = new JIdExpression(fileloc, type, "hasNext", null);
        LinkedList parameters = new LinkedList();
        JReferencedMethodInvocationExpression mi = new JReferencedMethodInvocationExpression(fileloc, type, name, parameters, null, this.enhancedForLoopIterator);
        return this.addSideassignmentsForExpressionsWithoutMethodInvocationSideEffects(mi, e);
    }

    public JMethodInvocationAssignmentStatement assignParameterToNextIteratorItem(SingleVariableDeclaration formalParameter) {
        FileLocation fileLoc = this.getFileLocation((ASTNode)formalParameter);
        JSimpleDeclaration param = this.scope.lookupVariable(NameConverter.convertName(formalParameter.resolveBinding()));
        if (param == null) {
            throw new CFAGenerationRuntimeException("Formal Parameter " + formalParameter.toString() + " could not be proccessed", (ASTNode)formalParameter);
        }
        JIdExpression paramIdExpr = new JIdExpression(fileLoc, param.getType(), param.getName(), param);
        LinkedList parameters = new LinkedList();
        JIdExpression name = new JIdExpression(fileLoc, param.getType(), "next", null);
        JReferencedMethodInvocationExpression mi = new JReferencedMethodInvocationExpression(fileLoc, param.getType(), name, parameters, null, this.enhancedForLoopIterator);
        this.enhancedForLoopIterator = null;
        return new JMethodInvocationAssignmentStatement(fileLoc, paramIdExpr, mi);
    }

    JStringLiteralExpression convert(StringLiteral e) {
        FileLocation fileLoc = this.getFileLocation((ASTNode)e);
        JType type = this.convert(e.resolveTypeBinding());
        return new JStringLiteralExpression(fileLoc, type, e.getLiteralValue());
    }

    JNullLiteralExpression convert(NullLiteral e) {
        return new JNullLiteralExpression(this.getFileLocation((ASTNode)e));
    }

    JCharLiteralExpression convert(CharacterLiteral e) {
        FileLocation fileLoc = this.getFileLocation((ASTNode)e);
        JType type = this.convert(e.resolveTypeBinding());
        return new JCharLiteralExpression(fileLoc, type, e.charValue());
    }

    public JExpression convertBooleanExpression(Expression e) {
        JExpression exp = this.convertExpressionWithoutSideEffects(e);
        if (!this.isBooleanExpression(exp)) {
            JBooleanLiteralExpression zero = new JBooleanLiteralExpression(exp.getFileLocation(), false);
            return new JBinaryExpression(exp.getFileLocation(), exp.getExpressionType(), exp, zero, JBinaryExpression.BinaryOperator.NOT_EQUALS);
        }
        return exp;
    }

    public boolean isBooleanExpression(JExpression e) {
        if (e instanceof JBinaryExpression) {
            return BOOLEAN_BINARY_OPERATORS.contains(((JBinaryExpression)e).getOperator());
        }
        if (e instanceof JUnaryExpression) {
            return ((JUnaryExpression)e).getOperator() == JUnaryExpression.UnaryOperator.NOT;
        }
        JType type = e.getExpressionType();
        return type instanceof JSimpleType && ((JSimpleType)type).getType() == JBasicType.BOOLEAN;
    }

    JObjectReferenceReturn getConstructorObjectReturn(ITypeBinding declaringClass) {
        assert (declaringClass.isClass() || declaringClass.isEnum()) : declaringClass.getName() + " is not a Class";
        JClassType objectReturnType = (JClassType)this.convert(declaringClass);
        return new JObjectReferenceReturn(FileLocation.DUMMY, objectReturnType);
    }

    public JRunTimeTypeEqualsType convertClassRunTimeCompileTimeAccord(FileLocation fileloc, JMethodInvocationExpression methodInvocation, JClassOrInterfaceType classType) {
        if (methodInvocation instanceof JReferencedMethodInvocationExpression) {
            JIdExpression referencedVariable = ((JReferencedMethodInvocationExpression)methodInvocation).getReferencedVariable();
            JVariableRunTimeType methodReturnType = new JVariableRunTimeType(fileloc, referencedVariable);
            return new JRunTimeTypeEqualsType(fileloc, methodReturnType, classType);
        }
        return new JRunTimeTypeEqualsType(fileloc, new JThisExpression(fileloc, methodInvocation.getDeclaringType()), classType);
    }

    public void assignRunTimeClass(JReferencedMethodInvocationExpression methodInvocation, JClassInstanceCreation functionCall) {
        JClassType returnType = functionCall.getExpressionType();
        methodInvocation.setRunTimeBinding(returnType);
    }

    public JExpressionAssignmentStatement getBooleanAssign(JLeftHandSide pLeftHandSide, boolean booleanLiteral) {
        return new JExpressionAssignmentStatement(pLeftHandSide.getFileLocation(), pLeftHandSide, new JBooleanLiteralExpression(pLeftHandSide.getFileLocation(), booleanLiteral));
    }

    public JMethodDeclaration createDefaultConstructor(ITypeBinding classBinding) {
        LinkedList<JType> paramTypes = new LinkedList<JType>();
        LinkedList<JParameterDeclaration> param = new LinkedList<JParameterDeclaration>();
        JConstructorType type = new JConstructorType((JClassType)this.convert(classBinding), paramTypes, false);
        String simpleName = classBinding.getName();
        return new JConstructorDeclaration(FileLocation.DUMMY, type, NameConverter.convertDefaultConstructorName(classBinding), simpleName, param, VisibilityModifier.PUBLIC, false, type.getReturnType());
    }

    static class ModifierBean {
        private final boolean isFinal;
        private final boolean isStatic;
        private final boolean isVolatile;
        private final boolean isTransient;
        private final boolean isNative;
        private final boolean isAbstract;
        private final boolean isStrictFp;
        private final boolean isSynchronized;
        private final VisibilityModifier visibility;

        public ModifierBean(boolean pIsFinal, boolean pIsStatic, boolean pIsVolatile, boolean pIsTransient, VisibilityModifier pVisibility, boolean pIsNative, boolean pIsAbstract, boolean pIsStrictFp, boolean pIsSynchronized) {
            this.visibility = pVisibility;
            this.isFinal = pIsFinal;
            this.isStatic = pIsStatic;
            this.isVolatile = pIsVolatile;
            this.isTransient = pIsTransient;
            this.isNative = pIsNative;
            this.isAbstract = pIsAbstract;
            this.isStrictFp = pIsStrictFp;
            this.isSynchronized = pIsSynchronized;
        }

        public static ModifierBean getModifiers(IMethodBinding imb) {
            return ModifierBean.getModifiers(imb.getModifiers());
        }

        public static ModifierBean getModifiers(int modifiers) {
            boolean isFinal = Modifier.isFinal((int)modifiers);
            boolean isStatic = Modifier.isStatic((int)modifiers);
            boolean isVolatile = Modifier.isVolatile((int)modifiers);
            boolean isTransient = Modifier.isTransient((int)modifiers);
            boolean isNative = Modifier.isNative((int)modifiers);
            boolean isAbstract = Modifier.isAbstract((int)modifiers);
            boolean isStrictFp = Modifier.isStrictfp((int)modifiers);
            boolean isSynchronized = Modifier.isSynchronized((int)modifiers);
            VisibilityModifier visibility = null;
            if (Modifier.isPublic((int)modifiers)) {
                visibility = VisibilityModifier.PUBLIC;
            }
            if (Modifier.isProtected((int)modifiers)) {
                assert (visibility == null) : "Can only declare one Visibility Modifier";
                visibility = VisibilityModifier.PROTECTED;
            }
            if (Modifier.isPrivate((int)modifiers)) {
                assert (visibility == null) : "Can only declare one Visibility Modifier";
                visibility = VisibilityModifier.PRIVATE;
            }
            if (visibility == null) {
                visibility = VisibilityModifier.NONE;
            }
            return new ModifierBean(isFinal, isStatic, isVolatile, isTransient, visibility, isNative, isAbstract, isStrictFp, isSynchronized);
        }

        public static ModifierBean getModifiers(ITypeBinding pBinding) {
            int modifiers = pBinding.getModifiers();
            assert (pBinding.isClass() || pBinding.isEnum() || pBinding.isInterface() || pBinding.isAnnotation() || pBinding.isRecovered()) : "This type can't have modifiers";
            return ModifierBean.getModifiers(modifiers);
        }

        static ModifierBean getModifiers(List<IExtendedModifier> modifiers) {
            VisibilityModifier visibility = null;
            boolean isFinal = false;
            boolean isStatic = false;
            boolean isVolatile = false;
            boolean isTransient = false;
            boolean isNative = false;
            boolean isAbstract = false;
            boolean isStrictFp = false;
            boolean isSynchronized = false;
            block14: for (IExtendedModifier modifier : modifiers) {
                if (!modifier.isModifier()) continue;
                Modifier.ModifierKeyword modifierEnum = ((Modifier)modifier).getKeyword();
                switch (modifierEnum.toFlagValue()) {
                    case 16: {
                        isFinal = true;
                        continue block14;
                    }
                    case 8: {
                        isStatic = true;
                        continue block14;
                    }
                    case 64: {
                        isVolatile = true;
                        continue block14;
                    }
                    case 128: {
                        isTransient = true;
                        continue block14;
                    }
                    case 1: {
                        assert (visibility == null) : "Can only declare one Visibility Modifier";
                        visibility = VisibilityModifier.PUBLIC;
                        continue block14;
                    }
                    case 4: {
                        assert (visibility == null) : "Can only declare one Visibility Modifier";
                        visibility = VisibilityModifier.PROTECTED;
                        continue block14;
                    }
                    case 0: {
                        assert (visibility == null) : "Can only declare one Visibility Modifier";
                        visibility = VisibilityModifier.NONE;
                        continue block14;
                    }
                    case 2: {
                        assert (visibility == null) : "Can only declare one Visibility Modifier";
                        visibility = VisibilityModifier.PRIVATE;
                        continue block14;
                    }
                    case 256: {
                        isNative = true;
                        continue block14;
                    }
                    case 1024: {
                        isAbstract = true;
                        continue block14;
                    }
                    case 2048: {
                        isStrictFp = true;
                        continue block14;
                    }
                    case 32: {
                        isSynchronized = true;
                        continue block14;
                    }
                }
                assert (false) : " Unkown  Modifier";
            }
            if (visibility == null) {
                visibility = VisibilityModifier.NONE;
            }
            return new ModifierBean(isFinal, isStatic, isVolatile, isTransient, visibility, isNative, isAbstract, isStrictFp, isSynchronized);
        }

        public VisibilityModifier getVisibility() {
            return this.visibility;
        }

        public boolean isFinal() {
            return this.isFinal;
        }

        public boolean isStatic() {
            return this.isStatic;
        }

        public boolean isVolatile() {
            return this.isVolatile;
        }

        public boolean isTransient() {
            return this.isTransient;
        }

        public boolean isNative() {
            return this.isNative;
        }

        public boolean isAbstract() {
            return this.isAbstract;
        }

        public boolean isStrictFp() {
            return this.isStrictFp;
        }

        public boolean isSynchronized() {
            return this.isSynchronized;
        }
    }

    private static class NameAndInitializer {
        private final String name;
        private final JInitializerExpression initializer;

        @Nullable
        public NameAndInitializer(String pName, JInitializerExpression pInitializer) {
            Preconditions.checkNotNull((Object)pName);
            this.name = pName;
            this.initializer = pInitializer;
        }

        public String getName() {
            return this.name;
        }

        @Nullable
        public JInitializerExpression getInitializer() {
            return this.initializer;
        }
    }
}

