/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.parser.eclipse.java;

import com.google.common.collect.SortedSetMultimap;
import com.google.common.collect.TreeMultimap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.sosy_lab.common.Pair;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.ast.ADeclaration;
import org.sosy_lab.cpachecker.cfa.ast.java.JDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.java.JFieldDeclaration;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.java.JMethodEntryNode;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.java.ASTConverter;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.java.CFAGenerationRuntimeException;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.java.CFAMethodBuilder;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.java.Scope;

class CFABuilder
extends ASTVisitor {
    private static final boolean SKIP_CHILDREN = false;
    private static final boolean VISIT_CHILDREN = true;
    private final Map<String, MethodDeclaration> allParsedMethodDeclaration = new HashMap<String, MethodDeclaration>();
    private final SortedMap<String, FunctionEntryNode> cfas = new TreeMap<String, FunctionEntryNode>();
    private final SortedSetMultimap<String, CFANode> cfaNodes = TreeMultimap.create();
    private final Scope scope;
    private final ASTConverter astCreator;
    private final LogManager logger;

    public CFABuilder(LogManager pLogger, Scope pScope) {
        this.logger = pLogger;
        this.scope = pScope;
        this.astCreator = new ASTConverter(this.scope, this.logger);
    }

    public SortedMap<String, FunctionEntryNode> getCFAs() {
        return this.cfas;
    }

    public SortedSetMultimap<String, CFANode> getCFANodes() {
        return this.cfaNodes;
    }

    public List<Pair<ADeclaration, String>> getStaticFieldDeclarations() {
        Map<String, JFieldDeclaration> staticFieldDeclarations = this.scope.getStaticFieldDeclarations();
        ArrayList<Pair<ADeclaration, String>> result = new ArrayList<Pair<ADeclaration, String>>(staticFieldDeclarations.size());
        for (Map.Entry<String, JFieldDeclaration> entry : staticFieldDeclarations.entrySet()) {
            ADeclaration declaration = entry.getValue();
            result.add((Pair<ADeclaration, String>)Pair.of((Object)declaration, (Object)entry.getKey()));
        }
        return result;
    }

    public boolean visit(TypeDeclaration typeDec) {
        ITypeBinding classBinding = typeDec.resolveBinding();
        if (!typeDec.isPackageMemberTypeDeclaration()) {
            ASTConverter.ModifierBean mB = ASTConverter.ModifierBean.getModifiers(typeDec.resolveBinding());
            if (mB.isStatic() || typeDec.isInterface()) {
                this.scope.enterClass(this.astCreator.convertClassOrInterfaceType(classBinding));
                return true;
            }
            return false;
        }
        this.scope.enterClass(this.astCreator.convertClassOrInterfaceType(classBinding));
        return true;
    }

    public boolean visit(MethodDeclaration md) {
        CFAMethodBuilder methodBuilder = new CFAMethodBuilder(this.logger, this.scope, this.astCreator);
        md.accept((ASTVisitor)methodBuilder);
        JMethodEntryNode startNode = methodBuilder.getStartNode();
        String methodName = startNode.getFunctionName();
        if (this.cfas.containsKey(methodName)) {
            throw new CFAGenerationRuntimeException("Duplicate method " + methodName);
        }
        this.cfas.put(methodName, startNode);
        this.cfaNodes.putAll((Object)methodName, methodBuilder.getCfaNodes());
        this.allParsedMethodDeclaration.put(methodName, md);
        return false;
    }

    public boolean visit(FieldDeclaration fd) {
        List<JDeclaration> newDs = this.astCreator.convert(fd);
        assert (!newDs.isEmpty());
        if (this.astCreator.numberOfPreSideAssignments() > 0) {
            throw new CFAGenerationRuntimeException("Initializer of field variable has side effect.", (ASTNode)fd);
        }
        return false;
    }

    public void endVisit(TypeDeclaration typeDef) {
        ASTConverter.ModifierBean mB;
        if (!(typeDef.isPackageMemberTypeDeclaration() || (mB = ASTConverter.ModifierBean.getModifiers(typeDef.resolveBinding())).isStatic() || typeDef.isInterface())) {
            return;
        }
        ITypeBinding classBinding = typeDef.resolveBinding();
        boolean hasDefaultConstructor = this.hasDefaultConstructor(classBinding);
        if (hasDefaultConstructor) {
            CFAMethodBuilder methodBuilder = new CFAMethodBuilder(this.logger, this.scope, this.astCreator);
            methodBuilder.createDefaultConstructor(classBinding);
            JMethodEntryNode startNode = methodBuilder.getStartNode();
            String methodName = startNode.getFunctionName();
            if (this.cfas.containsKey(methodName)) {
                throw new CFAGenerationRuntimeException("Duplicate default Constructor " + methodName);
            }
            this.cfas.put(methodName, startNode);
            this.cfaNodes.putAll((Object)methodName, methodBuilder.getCfaNodes());
            this.allParsedMethodDeclaration.put(methodName, null);
        }
        this.scope.leaveClass();
    }

    private boolean hasDefaultConstructor(ITypeBinding classBinding) {
        IMethodBinding[] declaredMethods;
        if (classBinding.isInterface()) {
            return false;
        }
        for (IMethodBinding declaredMethod : declaredMethods = classBinding.getDeclaredMethods()) {
            if (declaredMethod.isDefaultConstructor()) {
                return true;
            }
            if (!declaredMethod.isConstructor()) continue;
            return false;
        }
        return true;
    }

    public Scope getScope() {
        return this.scope;
    }

    public Map<String, MethodDeclaration> getAllParsedMethodDeclaration() {
        return this.allParsedMethodDeclaration;
    }

    public ASTConverter getAstCreator() {
        return this.astCreator;
    }

    public void preVisit(ASTNode problem) {
        if (8 == (problem.getFlags() & 8) || 1 == (problem.getFlags() & 1)) {
            throw new CFAGenerationRuntimeException("Syntax error.", problem);
        }
    }
}

