/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.parser.eclipse.java;

import com.google.common.base.Preconditions;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AssertStatement;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BooleanLiteral;
import org.eclipse.jdt.core.dom.BreakStatement;
import org.eclipse.jdt.core.dom.ConditionalExpression;
import org.eclipse.jdt.core.dom.ContinueStatement;
import org.eclipse.jdt.core.dom.DoStatement;
import org.eclipse.jdt.core.dom.EnhancedForStatement;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.LabeledStatement;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SwitchCase;
import org.eclipse.jdt.core.dom.SwitchStatement;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.WhileStatement;
import org.sosy_lab.common.Pair;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFACreationUtils;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionCall;
import org.sosy_lab.cpachecker.cfa.ast.AInitializer;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.java.JAssignment;
import org.sosy_lab.cpachecker.cfa.ast.java.JAstNode;
import org.sosy_lab.cpachecker.cfa.ast.java.JBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JBooleanLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JClassInstanceCreation;
import org.sosy_lab.cpachecker.cfa.ast.java.JDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.java.JExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JExpressionAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.java.JExpressionStatement;
import org.sosy_lab.cpachecker.cfa.ast.java.JFieldDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.java.JIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JInitializerExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JLeftHandSide;
import org.sosy_lab.cpachecker.cfa.ast.java.JMethodDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.java.JMethodInvocationAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.java.JMethodInvocationExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JMethodInvocationStatement;
import org.sosy_lab.cpachecker.cfa.ast.java.JObjectReferenceReturn;
import org.sosy_lab.cpachecker.cfa.ast.java.JParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.java.JReferencedMethodInvocationExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JReturnStatement;
import org.sosy_lab.cpachecker.cfa.ast.java.JRightHandSide;
import org.sosy_lab.cpachecker.cfa.ast.java.JSimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.java.JStatement;
import org.sosy_lab.cpachecker.cfa.ast.java.JVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.model.AbstractCFAEdge;
import org.sosy_lab.cpachecker.cfa.model.BlankEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdgeType;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.CFATerminationNode;
import org.sosy_lab.cpachecker.cfa.model.FunctionExitNode;
import org.sosy_lab.cpachecker.cfa.model.c.CLabelNode;
import org.sosy_lab.cpachecker.cfa.model.java.JAssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.java.JDeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.java.JMethodEntryNode;
import org.sosy_lab.cpachecker.cfa.model.java.JReturnStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.java.JStatementEdge;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.java.ASTConverter;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.java.CFAGenerationRuntimeException;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.java.Scope;
import org.sosy_lab.cpachecker.cfa.types.java.JClassOrInterfaceType;
import org.sosy_lab.cpachecker.util.CFATraversal;
import org.sosy_lab.cpachecker.util.CFAUtils;

class CFAMethodBuilder
extends ASTVisitor {
    private static final boolean VISIT_CHILDS = true;
    private static final boolean SKIP_CHILDS = false;
    private static final int ONLY_EDGE = 0;
    private final Deque<CFANode> locStack = new ArrayDeque<CFANode>();
    private final Deque<CFANode> loopStartStack = new ArrayDeque<CFANode>();
    private final Deque<CFANode> loopNextStack = new ArrayDeque<CFANode>();
    private final Deque<CFANode> elseStack = new ArrayDeque<CFANode>();
    private final Deque<JExpression> switchExprStack = new ArrayDeque<JExpression>();
    private final Deque<CFANode> switchCaseStack = new ArrayDeque<CFANode>();
    private final Map<String, CLabelNode> labelMap = new HashMap<String, CLabelNode>();
    private final Map<String, List<Pair<CFANode, ContinueStatement>>> registeredContinues = new HashMap<String, List<Pair<CFANode, ContinueStatement>>>();
    private JMethodEntryNode cfa = null;
    private final Set<CFANode> cfaNodes = new HashSet<CFANode>();
    private final Scope scope;
    private final ASTConverter astCreator;
    private final LogManager logger;

    public CFAMethodBuilder(LogManager pLogger, Scope pScope, ASTConverter pAstCreator) {
        this.logger = pLogger;
        this.scope = pScope;
        this.astCreator = pAstCreator;
    }

    JMethodEntryNode getStartNode() {
        Preconditions.checkState((this.cfa != null ? 1 : 0) != 0);
        return this.cfa;
    }

    Set<CFANode> getCfaNodes() {
        Preconditions.checkState((this.cfa != null ? 1 : 0) != 0);
        return this.cfaNodes;
    }

    public void preVisit(ASTNode problem) {
        if (8 == problem.getFlags() || 1 == problem.getFlags()) {
            throw new CFAGenerationRuntimeException("Parse Error.", problem);
        }
    }

    public boolean visit(MethodDeclaration mDeclaration) {
        if (this.locStack.size() != 0) {
            throw new CFAGenerationRuntimeException("Nested method declarations?");
        }
        assert (this.cfa == null);
        JMethodDeclaration mdef = this.astCreator.convert(mDeclaration);
        this.handleMethodDeclaration(mdef);
        if (mDeclaration.isConstructor()) {
            this.addNonStaticFieldMember();
        }
        if (!mdef.isAbstract() && !mdef.isNative()) {
            mDeclaration.getBody().accept((ASTVisitor)this);
        }
        return false;
    }

    private void addNonStaticFieldMember() {
        JClassOrInterfaceType currentClassType = this.scope.getCurrentClassType();
        Map<String, JFieldDeclaration> fieldDecl = this.scope.getNonStaticFieldDeclarationOfClass(currentClassType);
        Collection<JFieldDeclaration> classFieldDeclaration = fieldDecl.values();
        for (JDeclaration jDeclaration : classFieldDeclaration) {
            LinkedList<JDeclaration> declaration = new LinkedList<JDeclaration>();
            declaration.add(jDeclaration);
            String rawSignature = jDeclaration.toASTString();
            CFANode nextNode = this.addDeclarationsToCFA(declaration, jDeclaration.getFileLocation(), rawSignature, this.locStack.poll());
            this.locStack.push(nextNode);
        }
    }

    private void handleMethodDeclaration(JMethodDeclaration fdef) {
        String nameOfFunction = fdef.getName();
        assert (!nameOfFunction.isEmpty());
        this.scope.enterMethod(fdef);
        List<JParameterDeclaration> parameters = fdef.getParameters();
        ArrayList<String> parameterNames = new ArrayList<String>(parameters.size());
        for (JParameterDeclaration param : parameters) {
            this.scope.registerDeclarationOfThisClass(param);
            parameterNames.add(param.getName());
        }
        FunctionExitNode returnNode = new FunctionExitNode(nameOfFunction);
        this.cfaNodes.add(returnNode);
        JMethodEntryNode startNode = new JMethodEntryNode(fdef.getFileLocation(), fdef, returnNode, parameterNames, this.scope.getReturnVariable());
        returnNode.setEntryNode(startNode);
        this.cfaNodes.add(startNode);
        this.cfa = startNode;
        CFANode nextNode = new CFANode(nameOfFunction);
        this.cfaNodes.add(nextNode);
        this.locStack.push(nextNode);
        BlankEdge dummyEdge = new BlankEdge("", fdef.getFileLocation(), startNode, nextNode, "Function start dummy edge");
        this.addToCFA(dummyEdge);
    }

    public boolean visit(VariableDeclarationStatement sd) {
        assert (this.locStack.size() > 0) : "not in a methods's scope";
        CFANode prevNode = this.locStack.pop();
        CFANode nextNode = this.addDeclarationsToCFA(sd, prevNode);
        assert (nextNode != null);
        this.locStack.push(nextNode);
        return false;
    }

    public boolean visit(SingleVariableDeclaration sd) {
        assert (this.locStack.size() > 0) : "not in a methods's scope";
        CFANode prevNode = this.locStack.pop();
        CFANode nextNode = this.addDeclarationsToCFA(sd, prevNode);
        assert (nextNode != null);
        this.locStack.push(nextNode);
        return false;
    }

    private void handleReturnFromObject(FileLocation fileloc, String rawSignature, ITypeBinding cb) {
        assert (cb.isClass()) : cb.getName() + "is no Object Return";
        CFANode prevNode = this.locStack.pop();
        FunctionExitNode functionExitNode = this.cfa.getExitNode();
        JObjectReferenceReturn cfaObjectReturn = this.astCreator.getConstructorObjectReturn(cb);
        JReturnStatementEdge edge = new JReturnStatementEdge("", cfaObjectReturn, fileloc, prevNode, functionExitNode);
        this.addToCFA(edge);
        CFANode nextNode = new CFANode(this.cfa.getFunctionName());
        this.cfaNodes.add(nextNode);
        this.locStack.push(nextNode);
    }

    public void endVisit(MethodDeclaration declaration) {
        if (declaration.isConstructor()) {
            FileLocation fileloc = this.astCreator.getFileLocation((ASTNode)declaration);
            String rawSignature = declaration.toString();
            ITypeBinding declaringClass = declaration.resolveBinding().getDeclaringClass();
            this.handleReturnFromObject(fileloc, rawSignature, declaringClass);
        }
        this.handleEndVisitMethodDeclaration();
    }

    private void handleEndVisitMethodDeclaration() {
        if (this.locStack.size() != 1) {
            throw new CFAGenerationRuntimeException("Depth wrong. Geoff needs to do more work");
        }
        CFANode lastNode = this.locStack.pop();
        if (CFACreationUtils.isReachableNode(lastNode)) {
            BlankEdge blankEdge = new BlankEdge("", FileLocation.DUMMY, lastNode, this.cfa.getExitNode(), "default return");
            this.addToCFA(blankEdge);
        }
        Set<CFANode> reachableNodes = CFATraversal.dfs().collectNodesReachableFrom(this.cfa);
        Iterator<CFANode> it = this.cfaNodes.iterator();
        while (it.hasNext()) {
            CFANode n = it.next();
            if (reachableNodes.contains(n)) continue;
            it.remove();
        }
        this.scope.leaveMethod();
    }

    private CFANode handleSideassignments(CFANode prevNode, String rawSignature, FileLocation fileLocation) {
        CFANode nextNode = null;
        while (this.astCreator.numberOfSideAssignments() > 0) {
            nextNode = new CFANode(this.cfa.getFunctionName());
            this.cfaNodes.add(nextNode);
            JAstNode sideeffect = this.astCreator.getNextSideAssignment();
            this.createSideAssignmentEdges(prevNode, nextNode, rawSignature, fileLocation, sideeffect);
            prevNode = nextNode;
        }
        return prevNode;
    }

    private void handleSideassignments(CFANode prevNode, String rawSignature, FileLocation fileLocation, CFANode lastNode) {
        CFANode nextNode = null;
        while (this.astCreator.numberOfPreSideAssignments() > 0) {
            JAstNode sideeffect = this.astCreator.getNextPreSideAssignment();
            if (this.astCreator.numberOfPreSideAssignments() > 0) {
                nextNode = new CFANode(this.cfa.getFunctionName());
                this.cfaNodes.add(nextNode);
            } else {
                nextNode = lastNode;
            }
            this.createSideAssignmentEdges(prevNode, nextNode, rawSignature, fileLocation, sideeffect);
            prevNode = nextNode;
        }
    }

    private CFANode handlePreSideassignments(CFANode prevNode, String rawSignature, FileLocation fileLocation) {
        CFANode nextNode = null;
        while (this.astCreator.numberOfPreSideAssignments() > 0) {
            nextNode = new CFANode(this.cfa.getFunctionName());
            this.cfaNodes.add(nextNode);
            JAstNode sideeffect = this.astCreator.getNextPreSideAssignment();
            this.createSideAssignmentEdges(prevNode, nextNode, rawSignature, fileLocation, sideeffect);
            prevNode = nextNode;
        }
        return prevNode;
    }

    private CFANode handlePreSideassignments(CFANode prevNode, String rawSignature, FileLocation fileLocation, CFANode lastNode) {
        CFANode nextNode = null;
        while (this.astCreator.numberOfPreSideAssignments() > 0) {
            nextNode = new CFANode(this.cfa.getFunctionName());
            this.cfaNodes.add(nextNode);
            JAstNode sideeffect = this.astCreator.getNextPreSideAssignment();
            this.createSideAssignmentEdges(prevNode, nextNode, rawSignature, fileLocation, sideeffect);
            prevNode = nextNode;
        }
        return prevNode;
    }

    private CFANode handlePostSideassignments(CFANode prevNode, String rawSignature, FileLocation fileLocation) {
        CFANode nextNode = null;
        while (this.astCreator.numberOfPostSideAssignments() > 0) {
            nextNode = new CFANode(this.cfa.getFunctionName());
            this.cfaNodes.add(nextNode);
            JAstNode sideeffect = this.astCreator.getNextPostSideAssignment();
            this.createSideAssignmentEdges(prevNode, nextNode, rawSignature, fileLocation, sideeffect);
            prevNode = nextNode;
        }
        return prevNode;
    }

    private CFANode handlePostSideassignments(CFANode prevNode, String rawSignature, FileLocation fileLocation, CFANode lastNode) {
        CFANode nextNode = null;
        while (this.astCreator.numberOfPostSideAssignments() > 0) {
            nextNode = new CFANode(this.cfa.getFunctionName());
            this.cfaNodes.add(nextNode);
            JAstNode sideeffect = this.astCreator.getNextPostSideAssignment();
            this.createSideAssignmentEdges(prevNode, nextNode, rawSignature, fileLocation, sideeffect);
            prevNode = nextNode;
        }
        return prevNode;
    }

    private void createSideAssignmentEdges(CFANode prevNode, CFANode nextNode, String rawSignature, FileLocation fileLocation, JAstNode sideeffect) {
        AbstractCFAEdge previous = sideeffect instanceof JStatement ? new JStatementEdge(rawSignature, (JStatement)sideeffect, fileLocation, prevNode, nextNode) : (sideeffect instanceof JAssignment ? new JStatementEdge(rawSignature, (JStatement)sideeffect, fileLocation, prevNode, nextNode) : (sideeffect instanceof JIdExpression ? new JStatementEdge(rawSignature, new JExpressionStatement(sideeffect.getFileLocation(), (JExpression)sideeffect), fileLocation, prevNode, nextNode) : new JDeclarationEdge(rawSignature, fileLocation, prevNode, nextNode, (JDeclaration)sideeffect)));
        this.addToCFA(previous);
    }

    private CFANode addDeclarationsToCFA(List<JDeclaration> declList, FileLocation fileLocation, String rawSignature, CFANode prevNode) {
        CFANode middleNode = new CFANode(this.cfa.getFunctionName());
        this.cfaNodes.add(middleNode);
        if (this.astCreator.getConditionalExpression() != null) {
            this.handleConditionalStatementWithDeclaration(prevNode, middleNode);
        } else {
            middleNode = prevNode;
        }
        middleNode = this.handleSideassignments(middleNode, rawSignature, fileLocation);
        for (JDeclaration newD : declList) {
            middleNode = this.addDeclarationtoCFA(newD, rawSignature, middleNode);
        }
        return middleNode;
    }

    private CFANode addDeclarationtoCFA(JDeclaration newD, String rawSignature, CFANode prevNode) {
        CFANode nextNode = new CFANode(this.cfa.getFunctionName());
        this.cfaNodes.add(nextNode);
        JDeclarationEdge edge = new JDeclarationEdge(rawSignature, newD.getFileLocation(), prevNode, nextNode, newD);
        this.addToCFA(edge);
        prevNode = nextNode;
        if (newD instanceof JVariableDeclaration && !(newD instanceof JFieldDeclaration)) {
            boolean resolveInitializer;
            this.scope.registerDeclarationOfThisClass(newD);
            AInitializer initializer = ((JVariableDeclaration)newD).getInitializer();
            boolean bl = resolveInitializer = initializer instanceof JInitializerExpression && this.astCreator.isBooleanExpression(((JInitializerExpression)initializer).getExpression()) && !(((JInitializerExpression)initializer).getExpression() instanceof JBooleanLiteralExpression);
            if (resolveInitializer) {
                prevNode = this.resolveBooleanInitializer((JVariableDeclaration)newD, prevNode);
            }
        }
        return prevNode;
    }

    private CFANode resolveBooleanInitializer(JVariableDeclaration newD, CFANode prevNode) {
        AInitializer initializer = newD.getInitializer();
        CFANode afterResolvedBooleanExpressionNode = new CFANode(this.cfa.getFunctionName());
        this.cfaNodes.add(afterResolvedBooleanExpressionNode);
        JExpression booleanInitializer = ((JInitializerExpression)initializer).getExpression();
        JIdExpression variableExpression = new JIdExpression(newD.getFileLocation(), newD.getType(), newD.getName(), newD);
        this.resolveBooleanAssignment(booleanInitializer, (JLeftHandSide)variableExpression, prevNode, afterResolvedBooleanExpressionNode);
        prevNode = afterResolvedBooleanExpressionNode;
        return prevNode;
    }

    private void handleConditionalStatementWithDeclaration(CFANode prevNode, CFANode lastNode) {
        ConditionalExpression condExp = this.astCreator.getConditionalExpression();
        this.astCreator.resetConditionalExpression();
        this.handleTernaryExpression(condExp, prevNode, lastNode);
    }

    private CFANode addDeclarationsToCFA(VariableDeclarationStatement sd, CFANode prevNode) {
        FileLocation fileLocation = this.astCreator.getFileLocation((ASTNode)sd);
        this.handleElseCondition((Statement)sd);
        List<JDeclaration> declList = this.astCreator.convert(sd);
        String rawSignature = sd.toString();
        return this.addDeclarationsToCFA(declList, fileLocation, rawSignature, prevNode);
    }

    private CFANode addDeclarationsToCFA(SingleVariableDeclaration sd, CFANode prevNode) {
        FileLocation fileLocation = this.astCreator.getFileLocation((ASTNode)sd);
        ArrayList<JDeclaration> declList = new ArrayList<JDeclaration>(1);
        declList.add(this.astCreator.convert(sd));
        String rawSignature = sd.toString();
        return this.addDeclarationsToCFA(declList, fileLocation, rawSignature, prevNode);
    }

    public boolean visit(Block bl) {
        this.handleElseCondition((Statement)bl);
        this.scope.enterBlock();
        return true;
    }

    public void endVisit(Block bl) {
        this.scope.leaveBlock();
    }

    public boolean visit(AssertStatement assertStatement) {
        BlankEdge blankEdge;
        this.handleElseCondition((Statement)assertStatement);
        FileLocation fileloc = this.astCreator.getFileLocation((ASTNode)assertStatement);
        String methodName = this.cfa.getFunctionName();
        Expression condition = assertStatement.getExpression();
        String rawSignature = assertStatement.toString();
        CFANode prevNode = this.locStack.pop();
        CFANode postAssertNode = new CFANode(methodName);
        this.cfaNodes.add(postAssertNode);
        this.locStack.push(postAssertNode);
        CFANode successfulNode = new CFANode(methodName);
        this.cfaNodes.add(successfulNode);
        CFANode unsuccessfulNode = new CFANode(methodName);
        this.cfaNodes.add(unsuccessfulNode);
        CFATerminationNode endNode = new CFATerminationNode(methodName);
        this.cfaNodes.add(endNode);
        CONDITION kind = this.getConditionKind(condition);
        this.createConditionEdges(condition, fileloc, prevNode, successfulNode, unsuccessfulNode);
        boolean createUnsuccessfulEdge = true;
        boolean createSuccessfulEdge = true;
        switch (kind) {
            case ALWAYS_TRUE: {
                createUnsuccessfulEdge = false;
                break;
            }
            case ALWAYS_FALSE: {
                createSuccessfulEdge = false;
                break;
            }
        }
        if (createSuccessfulEdge) {
            blankEdge = new BlankEdge(rawSignature, fileloc, successfulNode, postAssertNode, "assert success");
            this.addToCFA(blankEdge);
        }
        if (createUnsuccessfulEdge) {
            boolean hasMessage;
            boolean bl = hasMessage = assertStatement.getMessage() != null;
            if (!hasMessage) {
                blankEdge = new BlankEdge(rawSignature, fileloc, unsuccessfulNode, endNode, "assert fail");
                this.addToCFA(blankEdge);
            } else {
                this.astCreator.convertExpressionWithoutSideEffects(assertStatement.getMessage());
                unsuccessfulNode = this.handleSideassignments(unsuccessfulNode, rawSignature, fileloc);
                blankEdge = new BlankEdge(rawSignature, fileloc, unsuccessfulNode, endNode, "assert fail");
                this.addToCFA(blankEdge);
            }
        }
        return false;
    }

    private void handleElseCondition(Statement statement) {
        boolean isFirstElseStatement;
        Statement node = statement;
        boolean bl = isFirstElseStatement = node.getLocationInParent() == IfStatement.ELSE_STATEMENT_PROPERTY;
        if (isFirstElseStatement) {
            CFANode prevNode = this.locStack.pop();
            CFANode nextNode = this.locStack.peek();
            if (CFACreationUtils.isReachableNode(prevNode)) {
                BlankEdge blankEdge = new BlankEdge("", FileLocation.DUMMY, prevNode, nextNode, "");
                this.addToCFA(blankEdge);
            }
            CFANode elseNode = this.elseStack.pop();
            this.locStack.push(elseNode);
        }
    }

    public boolean visit(ExpressionStatement expressionStatement) {
        boolean isReferencedInstanceMethod;
        this.handleElseCondition((Statement)expressionStatement);
        CFANode prevNode = this.locStack.pop();
        JStatement statement = this.astCreator.convert(expressionStatement);
        boolean bl = isReferencedInstanceMethod = statement instanceof AFunctionCall && ((AFunctionCall)((Object)statement)).getFunctionCallExpression() instanceof JReferencedMethodInvocationExpression;
        if (isReferencedInstanceMethod) {
            JReferencedMethodInvocationExpression methodInvocation = (JReferencedMethodInvocationExpression)((AFunctionCall)((Object)statement)).getFunctionCallExpression();
            this.searchForRunTimeClass(methodInvocation, prevNode);
        }
        String rawSignature = expressionStatement.toString();
        CFANode lastNode = new CFANode(this.cfa.getFunctionName());
        this.cfaNodes.add(lastNode);
        if (this.astCreator.getConditionalExpression() != null) {
            this.handleConditionalStatement(prevNode, lastNode, statement);
            lastNode = this.handleSideassignments(lastNode, rawSignature, statement.getFileLocation());
        } else {
            boolean isResolvable;
            CFANode nextNode = this.handleSideassignments(prevNode, rawSignature, statement.getFileLocation());
            boolean bl2 = isResolvable = statement instanceof JExpressionAssignmentStatement && this.astCreator.isBooleanExpression(((JExpressionAssignmentStatement)statement).getRightHandSide()) && !(((JExpressionAssignmentStatement)statement).getRightHandSide() instanceof JBooleanLiteralExpression);
            if (isResolvable) {
                Assignment booleanAssignment = (Assignment)expressionStatement.getExpression();
                JExpressionAssignmentStatement booleanAssignmentExpression = (JExpressionAssignmentStatement)statement;
                this.resolveBooleanAssignment(booleanAssignment.getRightHandSide(), booleanAssignmentExpression.getLeftHandSide(), nextNode, lastNode);
            } else {
                JStatementEdge edge = new JStatementEdge(rawSignature, statement, statement.getFileLocation(), nextNode, lastNode);
                this.addToCFA(edge);
            }
        }
        this.locStack.push(lastNode);
        return false;
    }

    public boolean visit(SuperConstructorInvocation sCI) {
        this.handleElseCondition((Statement)sCI);
        CFANode prevNode = this.locStack.pop();
        JStatement statement = this.astCreator.convert(sCI);
        String rawSignature = sCI.toString();
        CFANode lastNode = new CFANode(this.cfa.getFunctionName());
        this.cfaNodes.add(lastNode);
        CFANode nextNode = this.handleSideassignments(prevNode, rawSignature, statement.getFileLocation());
        JStatementEdge edge = new JStatementEdge(rawSignature, statement, statement.getFileLocation(), nextNode, lastNode);
        this.addToCFA(edge);
        this.locStack.push(lastNode);
        return false;
    }

    private void resolveBooleanAssignment(Expression condition, JLeftHandSide variableExpression, CFANode prevNode, CFANode afterResolvedBooleanExpressionNode) {
        this.resolveBooleanAssignment(this.astCreator.convertBooleanExpression(condition), variableExpression, prevNode, afterResolvedBooleanExpressionNode);
    }

    private void resolveBooleanAssignment(JExpression condition, JLeftHandSide variableExpression, CFANode prevNode, CFANode afterResolvedBooleanExpressionNode) {
        FileLocation fileLocation = variableExpression.getFileLocation();
        String methodName = this.cfa.getFunctionName();
        String rawSignature = condition.toString();
        CFANode trueNode = new CFANode(methodName);
        this.cfaNodes.add(trueNode);
        CFANode falseNode = new CFANode(methodName);
        this.cfaNodes.add(falseNode);
        this.createConditionEdges(condition, fileLocation, prevNode, trueNode, falseNode);
        JExpressionAssignmentStatement trueAssign = this.astCreator.getBooleanAssign(variableExpression, true);
        JExpressionAssignmentStatement falseAssign = this.astCreator.getBooleanAssign(variableExpression, false);
        JStatementEdge trueAssignmentEdge = new JStatementEdge(rawSignature, trueAssign, variableExpression.getFileLocation(), trueNode, afterResolvedBooleanExpressionNode);
        this.addToCFA(trueAssignmentEdge);
        JStatementEdge falseAssignmentEdge = new JStatementEdge(rawSignature, falseAssign, variableExpression.getFileLocation(), falseNode, afterResolvedBooleanExpressionNode);
        this.addToCFA(falseAssignmentEdge);
    }

    private void searchForRunTimeClass(JReferencedMethodInvocationExpression methodInvocation, CFANode prevNode) {
        boolean finished = prevNode.getNumEnteringEdges() != 1;
        CFANode traversedNode = prevNode;
        JSimpleDeclaration referencedVariable = methodInvocation.getReferencedVariable().getDeclaration();
        while (!finished) {
            CFAEdge currentEdge = traversedNode.getEnteringEdge(0);
            if (currentEdge.getEdgeType() == CFAEdgeType.StatementEdge) {
                JStatement statement = ((JStatementEdge)currentEdge).getStatement();
                if (statement instanceof JExpressionAssignmentStatement) {
                    if (this.isReferencableVariable(referencedVariable, (JAssignment)statement)) {
                        referencedVariable = this.assignVariableReference((JExpressionAssignmentStatement)statement);
                    } else {
                        finished = this.isReferenced(referencedVariable, (JAssignment)statement);
                    }
                } else if (statement instanceof JMethodInvocationStatement) {
                    finished = referencedVariable instanceof JFieldDeclaration;
                } else if (statement instanceof JMethodInvocationAssignmentStatement && (finished = this.isReferenced(referencedVariable, (JAssignment)statement))) {
                    this.assignClassRunTimeInstanceIfInstanceCreation(methodInvocation, (JMethodInvocationAssignmentStatement)statement);
                }
            }
            if (finished = finished || traversedNode.getNumEnteringEdges() == 1) continue;
            traversedNode = currentEdge.getPredecessor();
        }
    }

    private boolean isReferenced(JSimpleDeclaration referencedVariable, JAssignment assignment) {
        JLeftHandSide leftHandSide = assignment.getLeftHandSide();
        return leftHandSide instanceof JIdExpression && ((JIdExpression)leftHandSide).getDeclaration().getName().equals(referencedVariable.getName());
    }

    private void assignClassRunTimeInstanceIfInstanceCreation(JReferencedMethodInvocationExpression methodInvocation, JMethodInvocationAssignmentStatement functionCallAssignment) {
        JMethodInvocationExpression methodCall = functionCallAssignment.getFunctionCallExpression();
        if (methodCall instanceof JClassInstanceCreation) {
            this.astCreator.assignRunTimeClass(methodInvocation, (JClassInstanceCreation)methodCall);
        }
    }

    private JSimpleDeclaration assignVariableReference(JExpressionAssignmentStatement expressionAssignment) {
        JIdExpression newReferencedVariable = (JIdExpression)expressionAssignment.getRightHandSide();
        return newReferencedVariable.getDeclaration();
    }

    private boolean isReferencableVariable(JSimpleDeclaration referencedVariable, JAssignment assignment) {
        JLeftHandSide leftHandSide = assignment.getLeftHandSide();
        JRightHandSide rightHandSide = assignment.getRightHandSide();
        return leftHandSide instanceof JIdExpression && rightHandSide instanceof JIdExpression && ((JIdExpression)leftHandSide).getDeclaration().getName().equals(referencedVariable.getName());
    }

    private void handleConditionalStatement(CFANode prevNode, CFANode lastNode, JStatement statement) {
        ConditionalExpression condExp = this.astCreator.getConditionalExpression();
        this.astCreator.resetConditionalExpression();
        ASTNode parentExp = condExp.getParent();
        while (parentExp.getNodeType() == 36 || parentExp.getNodeType() == 37 || parentExp.getNodeType() == 38) {
            parentExp = parentExp.getParent();
        }
        if (parentExp.getNodeType() != 60 && parentExp.getNodeType() != 7) {
            this.handleTernaryStatement(condExp, prevNode, lastNode);
        } else if (statement != null) {
            this.handleTernaryExpression(condExp, prevNode, lastNode, statement);
        } else {
            this.handleTernaryExpression(condExp, prevNode, lastNode);
        }
    }

    private void handleTernaryExpression(ConditionalExpression condExp, CFANode rootNode, CFANode lastNode, JAstNode pExp) {
        FileLocation fileLoc = this.astCreator.getFileLocation((ASTNode)condExp);
        CFANode middle = new CFANode(this.cfa.getFunctionName());
        this.cfaNodes.add(middle);
        this.handleTernaryExpression(condExp, rootNode, middle);
        String signature = pExp.toASTString();
        this.createSideAssignmentEdges(middle, lastNode, signature, fileLoc, pExp);
    }

    private void handleTernaryExpression(ConditionalExpression condExp, CFANode rootNode, CFANode lastNode) {
        FileLocation fileLoc = this.astCreator.getFileLocation((ASTNode)condExp);
        String rawSignature = condExp.toString();
        JIdExpression tempVar = this.astCreator.getConditionalTemporaryVariable();
        rootNode = this.handleSideassignments(rootNode, rawSignature, fileLoc);
        CFANode thenNode = new CFANode(this.cfa.getFunctionName());
        this.cfaNodes.add(thenNode);
        CFANode elseNode = new CFANode(this.cfa.getFunctionName());
        this.cfaNodes.add(elseNode);
        Expression condtion = condExp.getExpression();
        this.buildConditionTree(condtion, fileLoc, rootNode, thenNode, elseNode, thenNode, elseNode, true, true);
        Expression thenExp = condExp.getThenExpression();
        Expression elseExp = condExp.getElseExpression();
        this.createTernaryExpressionEdges(thenExp, lastNode, fileLoc, thenNode, tempVar);
        this.createTernaryExpressionEdges(elseExp, lastNode, fileLoc, elseNode, tempVar);
    }

    private void handleTernaryStatement(ConditionalExpression condExp, CFANode rootNode, CFANode lastNode) {
        FileLocation fileLoc = this.astCreator.getFileLocation((ASTNode)condExp);
        while (this.astCreator.numberOfPreSideAssignments() > 0) {
            this.astCreator.getNextPreSideAssignment();
        }
        CFANode thenNode = new CFANode(this.cfa.getFunctionName());
        this.cfaNodes.add(thenNode);
        CFANode elseNode = new CFANode(this.cfa.getFunctionName());
        this.cfaNodes.add(elseNode);
        Expression condition = condExp.getExpression();
        this.buildConditionTree(condition, fileLoc, rootNode, thenNode, elseNode, thenNode, elseNode, true, true);
        Expression thenExp = condExp.getThenExpression();
        Expression elseExp = condExp.getElseExpression();
        this.createTernaryStatementEdges(thenExp, lastNode, fileLoc, thenNode);
        this.createTernaryStatementEdges(elseExp, lastNode, fileLoc, elseNode);
    }

    private void createTernaryExpressionEdges(Expression condExp, CFANode lastNode, FileLocation fileLocation, CFANode prevNode, JIdExpression tempVar) {
        boolean noFurtherConditionalExpression;
        JAstNode exp = this.astCreator.convertExpressionWithSideEffects(condExp);
        boolean bl = noFurtherConditionalExpression = exp != this.astCreator.getConditionalTemporaryVariable() && this.astCreator.getConditionalExpression() == null;
        if (noFurtherConditionalExpression) {
            if (this.astCreator.getConditionalExpression() != null) {
                CFANode tmp = new CFANode(this.cfa.getFunctionName());
                this.cfaNodes.add(tmp);
                this.handleTernaryExpressionTail(exp, fileLocation, prevNode, tmp, tempVar);
                prevNode = tmp;
            } else if (this.astCreator.numberOfSideAssignments() > 0) {
                CFANode tmp = new CFANode(this.cfa.getFunctionName());
                this.cfaNodes.add(tmp);
                this.handleSideassignments(prevNode, exp.toASTString(), fileLocation, tmp);
                prevNode = tmp;
            }
            FileLocation fileLoc = this.astCreator.getFileLocation((ASTNode)condExp);
            String rawSignature = condExp.toString();
            if (exp instanceof JExpression) {
                JExpressionAssignmentStatement assignment = new JExpressionAssignmentStatement(fileLoc, tempVar, (JExpression)exp);
                JStatementEdge edge = new JStatementEdge(rawSignature, assignment, fileLocation, prevNode, lastNode);
                this.addToCFA(edge);
            } else if (exp instanceof JMethodInvocationExpression) {
                JMethodInvocationAssignmentStatement assignment = new JMethodInvocationAssignmentStatement(fileLoc, tempVar, (JMethodInvocationExpression)exp);
                JStatementEdge edge = new JStatementEdge(rawSignature, assignment, fileLocation, prevNode, lastNode);
                this.addToCFA(edge);
            } else {
                CFANode middle = new CFANode(this.cfa.getFunctionName());
                this.cfaNodes.add(middle);
                JStatementEdge edge = new JStatementEdge(rawSignature, (JStatement)exp, fileLocation, prevNode, middle);
                this.addToCFA(edge);
                JExpressionAssignmentStatement assignment = new JExpressionAssignmentStatement(fileLoc, tempVar, ((JAssignment)exp).getLeftHandSide());
                edge = new JStatementEdge(condExp.toString(), assignment, fileLocation, middle, lastNode);
                this.addToCFA(edge);
            }
        } else {
            this.handleTernaryExpressionTail(exp, fileLocation, prevNode, lastNode, tempVar);
        }
    }

    private void createTernaryStatementEdges(Expression condExp, CFANode lastNode, FileLocation fileLocation, CFANode prevNode) {
        JAstNode exp = this.astCreator.convertExpressionWithSideEffects(condExp);
        if (exp != this.astCreator.getConditionalTemporaryVariable() && this.astCreator.getConditionalExpression() == null) {
            if (this.astCreator.getConditionalExpression() != null) {
                CFANode tmp = new CFANode(this.cfa.getFunctionName());
                this.cfaNodes.add(tmp);
                this.handleTernaryStatementTail(exp, fileLocation, prevNode, tmp);
                prevNode = tmp;
            } else if (this.astCreator.numberOfPreSideAssignments() > 0) {
                CFANode tmp = new CFANode(this.cfa.getFunctionName());
                this.cfaNodes.add(tmp);
                this.handleSideassignments(prevNode, exp.toASTString(), fileLocation, tmp);
                prevNode = tmp;
            }
            if (exp instanceof JExpression) {
                JStatementEdge edge = new JStatementEdge(condExp.toString(), new JExpressionStatement(this.astCreator.getFileLocation((ASTNode)condExp), (JExpression)exp), fileLocation, prevNode, lastNode);
                this.addToCFA(edge);
            } else if (exp instanceof JMethodInvocationExpression) {
                JStatementEdge edge = new JStatementEdge(condExp.toString(), new JMethodInvocationStatement(this.astCreator.getFileLocation((ASTNode)condExp), (JMethodInvocationExpression)exp), fileLocation, prevNode, lastNode);
                this.addToCFA(edge);
            } else {
                CFANode middle = new CFANode(this.cfa.getFunctionName());
                this.cfaNodes.add(middle);
                JStatementEdge edge = new JStatementEdge(condExp.toString(), (JStatement)exp, fileLocation, prevNode, middle);
                this.addToCFA(edge);
                edge = new JStatementEdge(condExp.toString(), new JExpressionStatement(this.astCreator.getFileLocation((ASTNode)condExp), ((JExpressionAssignmentStatement)exp).getLeftHandSide()), fileLocation, middle, lastNode);
                this.addToCFA(edge);
            }
        } else {
            this.handleTernaryStatementTail(exp, fileLocation, prevNode, lastNode);
        }
    }

    private void handleTernaryExpressionTail(JAstNode exp, FileLocation fileLocation, CFANode branchNode, CFANode lastNode, JIdExpression leftHandSide) {
        CFANode nextNode = new CFANode(this.cfa.getFunctionName());
        this.cfaNodes.add(nextNode);
        ConditionalExpression condExp = this.astCreator.getConditionalExpression();
        this.astCreator.resetConditionalExpression();
        JIdExpression rightHandSide = this.astCreator.getConditionalTemporaryVariable();
        this.handleTernaryExpression(condExp, branchNode, nextNode, exp);
        JExpressionAssignmentStatement stmt = new JExpressionAssignmentStatement(exp.getFileLocation(), leftHandSide, rightHandSide);
        this.addToCFA(new JStatementEdge(stmt.toASTString(), stmt, fileLocation, nextNode, lastNode));
    }

    private void handleTernaryStatementTail(JAstNode exp, FileLocation fileLocation, CFANode branchNode, CFANode lastNode) {
        CFANode nextNode = new CFANode(this.cfa.getFunctionName());
        this.cfaNodes.add(nextNode);
        ConditionalExpression condExp = this.astCreator.getConditionalExpression();
        this.astCreator.resetConditionalExpression();
        JIdExpression rightHandSide = this.astCreator.getConditionalTemporaryVariable();
        this.handleTernaryExpression(condExp, branchNode, nextNode);
        JExpressionStatement stmt = new JExpressionStatement(exp.getFileLocation(), rightHandSide);
        this.addToCFA(new JStatementEdge(stmt.toASTString(), stmt, fileLocation, nextNode, lastNode));
    }

    public boolean visit(IfStatement ifStatement) {
        CFANode elseNode;
        boolean noElseBranch;
        FileLocation fileloc = this.astCreator.getFileLocation((ASTNode)ifStatement);
        this.handleElseCondition((Statement)ifStatement);
        CFANode prevNode = this.locStack.pop();
        CFANode postIfNode = new CFANode(this.cfa.getFunctionName());
        this.cfaNodes.add(postIfNode);
        this.locStack.push(postIfNode);
        CFANode thenNode = new CFANode(this.cfa.getFunctionName());
        this.cfaNodes.add(thenNode);
        this.locStack.push(thenNode);
        boolean bl = noElseBranch = ifStatement.getElseStatement() == null;
        if (noElseBranch) {
            elseNode = postIfNode;
        } else {
            elseNode = new CFANode(this.cfa.getFunctionName());
            this.cfaNodes.add(elseNode);
            this.elseStack.push(elseNode);
        }
        Expression condition = ifStatement.getExpression();
        this.createConditionEdges(condition, fileloc, prevNode, thenNode, elseNode);
        return true;
    }

    public void endVisit(IfStatement ifStatement) {
        CFANode prevNode = this.locStack.pop();
        CFANode nextNode = this.locStack.peek();
        if (CFACreationUtils.isReachableNode(prevNode)) {
            for (CFAEdge prevEdge : CFAUtils.allEnteringEdges(prevNode).toList()) {
                boolean isBlankEdge = prevEdge instanceof BlankEdge && prevEdge.getDescription().equals("");
                if (!isBlankEdge) continue;
                CFANode prevPrevNode = prevEdge.getPredecessor();
                assert (prevPrevNode.getNumLeavingEdges() == 1);
                prevNode.removeEnteringEdge(prevEdge);
                prevPrevNode.removeLeavingEdge(prevEdge);
                BlankEdge blankEdge = new BlankEdge("", prevEdge.getFileLocation(), prevPrevNode, nextNode, "");
                this.addToCFA(blankEdge);
            }
            if (prevNode.getNumEnteringEdges() > 0) {
                BlankEdge blankEdge = new BlankEdge("", FileLocation.DUMMY, prevNode, nextNode, "");
                this.addToCFA(blankEdge);
            }
        }
    }

    private void createConditionEdges(Expression condition, FileLocation fileLocation, CFANode rootNode, CFANode thenNode, CFANode elseNode) {
        this.createConditionEdges(this.astCreator.convertBooleanExpression(condition), fileLocation, rootNode, thenNode, elseNode);
    }

    private void createConditionEdges(JExpression condition, FileLocation fileLocation, CFANode rootNode, CFANode thenNode, CFANode elseNode) {
        assert (condition != null);
        CONDITION kind = this.getConditionKind(condition);
        String rawSignature = condition.toString();
        switch (kind) {
            case ALWAYS_FALSE: {
                BlankEdge falseEdge = new BlankEdge(rawSignature, fileLocation, rootNode, elseNode, "");
                this.addToCFA(falseEdge);
                break;
            }
            case ALWAYS_TRUE: {
                BlankEdge trueEdge = new BlankEdge(rawSignature, fileLocation, rootNode, thenNode, "");
                this.addToCFA(trueEdge);
                break;
            }
            case NORMAL: {
                this.buildConditionTree(condition, fileLocation, rootNode, thenNode, elseNode, thenNode, elseNode, true, true);
                break;
            }
            default: {
                throw new InternalError("Missing switch clause");
            }
        }
    }

    private void buildConditionTree(JExpression condition, FileLocation fileLocation, CFANode rootNode, CFANode thenNode, CFANode elseNode, CFANode thenNodeForLastThen, CFANode elseNodeForLastElse, boolean furtherThenComputation, boolean furtherElseComputation) {
        if (condition instanceof JBinaryExpression && ((JBinaryExpression)condition).getOperator() == JBinaryExpression.BinaryOperator.CONDITIONAL_AND) {
            CFANode innerNode = new CFANode(this.cfa.getFunctionName());
            this.cfaNodes.add(innerNode);
            this.buildConditionTree(((JBinaryExpression)condition).getOperand1(), fileLocation, rootNode, innerNode, elseNode, thenNodeForLastThen, elseNodeForLastElse, true, true);
            this.buildConditionTree(((JBinaryExpression)condition).getOperand2(), fileLocation, innerNode, thenNode, elseNode, thenNodeForLastThen, elseNodeForLastElse, true, true);
        } else if (condition instanceof JBinaryExpression && ((JBinaryExpression)condition).getOperator() == JBinaryExpression.BinaryOperator.CONDITIONAL_OR) {
            CFANode innerNode = new CFANode(this.cfa.getFunctionName());
            this.cfaNodes.add(innerNode);
            this.buildConditionTree(((JBinaryExpression)condition).getOperand1(), fileLocation, rootNode, thenNode, innerNode, thenNodeForLastThen, elseNodeForLastElse, true, true);
            this.buildConditionTree(((JBinaryExpression)condition).getOperand2(), fileLocation, innerNode, thenNode, elseNode, thenNodeForLastThen, elseNodeForLastElse, true, true);
        } else if (condition instanceof JBinaryExpression && ((JBinaryExpression)condition).getOperator() == JBinaryExpression.BinaryOperator.LOGICAL_OR) {
            CFANode innerNode = new CFANode(this.cfa.getFunctionName());
            CFANode innerEagerNode = new CFANode(this.cfa.getFunctionName());
            this.cfaNodes.add(innerNode);
            this.cfaNodes.add(innerEagerNode);
            this.buildConditionTree(((JBinaryExpression)condition).getOperand1(), fileLocation, rootNode, innerEagerNode, innerNode, thenNodeForLastThen, elseNodeForLastElse, true, true);
            this.buildConditionTree(((JBinaryExpression)condition).getOperand2(), fileLocation, innerNode, thenNode, elseNode, thenNodeForLastThen, elseNodeForLastElse, true, true);
            this.buildConditionTree(((JBinaryExpression)condition).getOperand2(), fileLocation, innerEagerNode, thenNode, thenNode, thenNodeForLastThen, elseNodeForLastElse, true, true);
        } else if (condition instanceof JBinaryExpression && ((JBinaryExpression)condition).getOperator() == JBinaryExpression.BinaryOperator.LOGICAL_AND) {
            CFANode innerNode = new CFANode(this.cfa.getFunctionName());
            CFANode innerEagerNode = new CFANode(this.cfa.getFunctionName());
            this.cfaNodes.add(innerNode);
            this.cfaNodes.add(innerEagerNode);
            this.buildConditionTree(((JBinaryExpression)condition).getOperand1(), fileLocation, rootNode, innerNode, innerEagerNode, thenNodeForLastThen, elseNodeForLastElse, true, true);
            this.buildConditionTree(((JBinaryExpression)condition).getOperand2(), fileLocation, innerNode, thenNode, elseNode, thenNodeForLastThen, elseNodeForLastElse, true, true);
            this.buildConditionTree(((JBinaryExpression)condition).getOperand2(), fileLocation, innerEagerNode, elseNode, elseNode, thenNodeForLastThen, elseNodeForLastElse, true, true);
        } else {
            this.buildConditionTreeCondition(condition, fileLocation, rootNode, thenNode, elseNode, thenNodeForLastThen, elseNodeForLastElse, furtherThenComputation, furtherElseComputation);
        }
    }

    private void buildConditionTreeCondition(JExpression condition, FileLocation fileLocation, CFANode rootNode, CFANode thenNode, CFANode elseNode, CFANode thenNodeForLastThen, CFANode elseNodeForLastElse, boolean furtherThenComputation, boolean furtherElseComputation) {
        String rawSignature = condition.toASTString();
        if (furtherThenComputation) {
            thenNodeForLastThen = thenNode;
        }
        if (furtherElseComputation) {
            elseNodeForLastElse = elseNode;
        }
        CFANode nextNode = null;
        if (this.astCreator.getConditionalExpression() != null) {
            nextNode = new CFANode(this.cfa.getFunctionName());
            this.cfaNodes.add(nextNode);
            this.handleConditionalStatement(rootNode, nextNode, null);
        } else {
            nextNode = rootNode;
        }
        nextNode = this.handleSideassignments(nextNode, rawSignature, condition.getFileLocation());
        if (thenNode.equals(elseNode)) {
            BlankEdge blankEdge = new BlankEdge(rawSignature, fileLocation, nextNode, elseNode, rawSignature);
            this.addToCFA(blankEdge);
            return;
        }
        JAssumeEdge JAssumeEdgeFalse = new JAssumeEdge("!(" + rawSignature + ")", fileLocation, nextNode, elseNodeForLastElse, condition, false);
        this.addToCFA(JAssumeEdgeFalse);
        JAssumeEdge JAssumeEdgeTrue = new JAssumeEdge(rawSignature, fileLocation, nextNode, thenNodeForLastThen, condition, true);
        this.addToCFA(JAssumeEdgeTrue);
    }

    private void buildConditionTree(Expression condition, FileLocation fileLocation, CFANode rootNode, CFANode thenNode, CFANode elseNode, CFANode thenNodeForLastThen, CFANode elseNodeForLastElse, boolean furtherThenComputation, boolean furtherElseComputation) {
        JExpression cond = this.astCreator.convertBooleanExpression(condition);
        this.buildConditionTree(cond, fileLocation, rootNode, thenNode, elseNode, thenNodeForLastThen, elseNodeForLastElse, furtherThenComputation, furtherElseComputation);
    }

    private CONDITION getConditionKind(JExpression condition) {
        if (condition instanceof JBooleanLiteralExpression) {
            if (((JBooleanLiteralExpression)condition).getValue().booleanValue()) {
                return CONDITION.ALWAYS_TRUE;
            }
            return CONDITION.ALWAYS_FALSE;
        }
        return CONDITION.NORMAL;
    }

    private CONDITION getConditionKind(Expression cond) {
        while (cond.getNodeType() == 36) {
            cond = ((ParenthesizedExpression)cond).getExpression();
        }
        if (cond.getNodeType() == 9) {
            if (((BooleanLiteral)cond).booleanValue()) {
                return CONDITION.ALWAYS_TRUE;
            }
            return CONDITION.ALWAYS_FALSE;
        }
        return CONDITION.NORMAL;
    }

    public boolean visit(LabeledStatement labelStatement) {
        boolean innerStatementIsLoop;
        this.handleElseCondition((Statement)labelStatement);
        String labelName = labelStatement.getLabel().getIdentifier();
        if (this.labelMap.containsKey(labelName)) {
            throw new CFAGenerationRuntimeException("Duplicate label " + labelName + " in method " + this.cfa.getFunctionName() + ".", (ASTNode)labelStatement);
        }
        String mehtodName = this.cfa.getFunctionName();
        CLabelNode labelNode = new CLabelNode(mehtodName, labelName);
        this.cfaNodes.add(labelNode);
        this.labelMap.put(labelName, labelNode);
        int innerStatementTyp = labelStatement.getBody().getNodeType();
        boolean bl = innerStatementIsLoop = innerStatementTyp == 24 || innerStatementTyp == 61 || innerStatementTyp == 19;
        if (innerStatementIsLoop) {
            this.registeredContinues.put(labelName, new LinkedList());
        }
        labelStatement.getBody().accept((ASTVisitor)this);
        return false;
    }

    public void endVisit(LabeledStatement labelStatement) {
        String labelName = labelStatement.getLabel().getIdentifier();
        assert (this.labelMap.containsKey(labelName)) : "Label Name " + labelName + " to be deleted " + "out of scope, but scope does not contain it";
        CLabelNode labelNode = this.labelMap.get(labelStatement.getLabel().getIdentifier());
        CFANode prevNode = this.locStack.pop();
        if (CFACreationUtils.isReachableNode(prevNode)) {
            BlankEdge blankEdge = new BlankEdge(labelStatement.toString(), FileLocation.DUMMY, prevNode, labelNode, "Label: " + labelName);
            this.addToCFA(blankEdge);
        }
        if (this.registeredContinues.containsKey(labelName)) {
            this.handleContinues(prevNode, this.registeredContinues.get(labelName));
            this.registeredContinues.remove(labelName);
        }
        this.locStack.push(labelNode);
        this.labelMap.remove(labelStatement.getLabel().getIdentifier());
    }

    private void handleContinues(CFANode nodeAfterLoopStart, List<Pair<CFANode, ContinueStatement>> continues) {
        CFANode startLoopNode = this.getStartLoopNodeFromPrevLabelNode(nodeAfterLoopStart);
        for (Pair<CFANode, ContinueStatement> continuePair : continues) {
            this.handleLabledContinueStatement((ContinueStatement)continuePair.getSecond(), (CFANode)continuePair.getFirst(), startLoopNode);
        }
    }

    private CFANode getStartLoopNodeFromPrevLabelNode(CFANode nodeAfterLoopStart) {
        CFAEdge edge = nodeAfterLoopStart.getEnteringEdge(0);
        assert (edge.getPredecessor().isLoopStart()) : "Did not find start Loop";
        return edge.getPredecessor();
    }

    public boolean visit(SwitchStatement statement) {
        this.handleElseCondition((Statement)statement);
        FileLocation fileloc = this.astCreator.getFileLocation((ASTNode)statement);
        CFANode prevNode = this.locStack.pop();
        CFANode firstSwitchNode = new CFANode(this.cfa.getFunctionName());
        this.cfaNodes.add(firstSwitchNode);
        JExpression switchExpression = this.astCreator.convertExpressionWithoutSideEffects(statement.getExpression());
        String rawSignature = "switch (" + statement.getExpression().toString() + ")";
        String description = "switch (" + switchExpression.toASTString() + ")";
        BlankEdge firstSwitchEdge = new BlankEdge(rawSignature, fileloc, prevNode, firstSwitchNode, description);
        this.addToCFA(firstSwitchEdge);
        this.switchExprStack.push(switchExpression);
        this.switchCaseStack.push(firstSwitchNode);
        CFANode postSwitchNode = new CFANode(this.cfa.getFunctionName());
        this.cfaNodes.add(postSwitchNode);
        this.loopNextStack.push(postSwitchNode);
        this.locStack.push(postSwitchNode);
        this.locStack.push(new CFANode(this.cfa.getFunctionName()));
        for (Statement st : statement.statements()) {
            st.accept((ASTVisitor)this);
        }
        CFANode lastNodeInSwitch = this.locStack.pop();
        CFANode lastNotCaseNode = this.switchCaseStack.pop();
        this.switchExprStack.pop();
        assert (postSwitchNode == this.loopNextStack.pop());
        assert (postSwitchNode == this.locStack.peek());
        assert (this.switchExprStack.size() == this.switchCaseStack.size());
        BlankEdge blankEdge = new BlankEdge("", FileLocation.DUMMY, lastNotCaseNode, postSwitchNode, "");
        this.addToCFA(blankEdge);
        BlankEdge blankEdge2 = new BlankEdge("", FileLocation.DUMMY, lastNodeInSwitch, postSwitchNode, "");
        this.addToCFA(blankEdge2);
        return false;
    }

    public boolean visit(SwitchCase switchCase) {
        if (switchCase.isDefault()) {
            this.handleDefault(this.astCreator.getFileLocation((ASTNode)switchCase));
        } else {
            this.handleCase(switchCase, this.astCreator.getFileLocation((ASTNode)switchCase));
        }
        return true;
    }

    private void handleCase(SwitchCase statement, FileLocation fileloc) {
        JExpression switchExpr = this.switchExprStack.peek();
        JExpression caseExpr = this.astCreator.convertExpressionWithoutSideEffects(statement.getExpression());
        JBinaryExpression binExp = new JBinaryExpression(fileloc, switchExpr.getExpressionType(), switchExpr, caseExpr, JBinaryExpression.BinaryOperator.EQUALS);
        CFANode rootNode = this.switchCaseStack.pop();
        CFANode caseNode = new CFANode(this.cfa.getFunctionName());
        CFANode notCaseNode = new CFANode(this.cfa.getFunctionName());
        this.cfaNodes.add(caseNode);
        this.cfaNodes.add(notCaseNode);
        CFANode oldNode = this.locStack.pop();
        if (oldNode.getNumEnteringEdges() > 0) {
            BlankEdge blankEdge = new BlankEdge("", fileloc, oldNode, caseNode, "fall through");
            this.addToCFA(blankEdge);
        }
        this.switchCaseStack.push(notCaseNode);
        this.locStack.push(caseNode);
        JAssumeEdge JAssumeEdgeFalse = new JAssumeEdge("!(" + binExp.toASTString() + ")", fileloc, rootNode, notCaseNode, binExp, false);
        this.addToCFA(JAssumeEdgeFalse);
        JAssumeEdge JAssumeEdgeTrue = new JAssumeEdge(binExp.toASTString(), fileloc, rootNode, caseNode, binExp, true);
        this.addToCFA(JAssumeEdgeTrue);
    }

    private void handleDefault(FileLocation fileloc) {
        CFANode rootNode = this.switchCaseStack.pop();
        CFANode caseNode = new CFANode(this.cfa.getFunctionName());
        CFANode notCaseNode = new CFANode(this.cfa.getFunctionName());
        this.cfaNodes.add(caseNode);
        this.cfaNodes.add(notCaseNode);
        CFANode oldNode = this.locStack.pop();
        if (oldNode.getNumEnteringEdges() > 0) {
            BlankEdge blankEdge = new BlankEdge("", fileloc, oldNode, caseNode, "fall through");
            this.addToCFA(blankEdge);
        }
        this.switchCaseStack.push(notCaseNode);
        this.locStack.push(caseNode);
        BlankEdge trueEdge = new BlankEdge("default :", fileloc, rootNode, caseNode, "default");
        this.addToCFA(trueEdge);
    }

    public boolean visit(WhileStatement whileStatement) {
        this.handleElseCondition((Statement)whileStatement);
        FileLocation fileloc = this.astCreator.getFileLocation((ASTNode)whileStatement);
        CFANode prevNode = this.locStack.pop();
        CFANode loopStart = new CFANode(this.cfa.getFunctionName());
        this.cfaNodes.add(loopStart);
        loopStart.setLoopStart();
        this.loopStartStack.push(loopStart);
        CFANode firstLoopNode = new CFANode(this.cfa.getFunctionName());
        this.cfaNodes.add(firstLoopNode);
        CFANode postLoopNode = new CFANode(this.cfa.getFunctionName());
        this.cfaNodes.add(postLoopNode);
        this.loopNextStack.push(postLoopNode);
        this.locStack.push(postLoopNode);
        this.locStack.push(firstLoopNode);
        BlankEdge blankEdge = new BlankEdge("", fileloc, prevNode, loopStart, "while");
        this.addToCFA(blankEdge);
        Expression condition = whileStatement.getExpression();
        this.createConditionEdges(condition, fileloc, loopStart, firstLoopNode, postLoopNode);
        whileStatement.getBody().accept((ASTVisitor)this);
        return false;
    }

    public boolean visit(DoStatement doStatement) {
        this.handleElseCondition((Statement)doStatement);
        FileLocation fileloc = this.astCreator.getFileLocation((ASTNode)doStatement);
        CFANode prevNode = this.locStack.pop();
        CFANode loopStart = new CFANode(this.cfa.getFunctionName());
        this.cfaNodes.add(loopStart);
        loopStart.setLoopStart();
        this.loopStartStack.push(loopStart);
        CFANode firstLoopNode = new CFANode(this.cfa.getFunctionName());
        this.cfaNodes.add(firstLoopNode);
        CFANode postLoopNode = new CFANode(this.cfa.getFunctionName());
        this.cfaNodes.add(postLoopNode);
        this.loopNextStack.push(postLoopNode);
        this.locStack.push(postLoopNode);
        this.locStack.push(firstLoopNode);
        BlankEdge blankEdge = new BlankEdge("", fileloc, prevNode, firstLoopNode, "do");
        this.addToCFA(blankEdge);
        Expression condition = doStatement.getExpression();
        this.createConditionEdges(condition, fileloc, loopStart, firstLoopNode, postLoopNode);
        doStatement.getBody().accept((ASTVisitor)this);
        return false;
    }

    public void endVisit(WhileStatement whileStatement) {
        this.handleLeaveWhileLoop();
    }

    public void endVisit(DoStatement doStatement) {
        this.handleLeaveWhileLoop();
    }

    private void handleLeaveWhileLoop() {
        CFANode prevNode = this.locStack.pop();
        CFANode startNode = this.loopStartStack.pop();
        if (CFACreationUtils.isReachableNode(prevNode)) {
            BlankEdge blankEdge = new BlankEdge("", FileLocation.DUMMY, prevNode, startNode, "");
            this.addToCFA(blankEdge);
        }
        CFANode nextNode = this.loopNextStack.pop();
        assert (nextNode == this.locStack.peek());
    }

    public boolean visit(EnhancedForStatement forStatement) {
        this.scope.enterBlock();
        this.handleElseCondition((Statement)forStatement);
        FileLocation fileloc = this.astCreator.getFileLocation((ASTNode)forStatement);
        forStatement.getParameter().accept((ASTVisitor)this);
        CFANode prevNode = this.locStack.pop();
        CFANode loopInit = new CFANode(this.cfa.getFunctionName());
        this.cfaNodes.add(loopInit);
        this.addToCFA(new BlankEdge("", fileloc, prevNode, loopInit, "enhanced for"));
        Expression iterable = forStatement.getExpression();
        CFANode loopStart = this.createIteratorEdgeForEnhancedForLoop(iterable, fileloc, loopInit);
        loopStart.setLoopStart();
        CFANode firstLoopNode = new CFANode(this.cfa.getFunctionName());
        this.cfaNodes.add(firstLoopNode);
        CFANode postLoopNode = new CFANode(this.cfa.getFunctionName());
        this.cfaNodes.add(postLoopNode);
        this.loopNextStack.push(postLoopNode);
        this.locStack.push(postLoopNode);
        this.locStack.push(firstLoopNode);
        JExpression condition = this.astCreator.createIteratorCondition(forStatement.getExpression());
        this.createConditionEdgesForForLoop(condition, fileloc, loopStart, postLoopNode, firstLoopNode);
        CFANode lastNodeInLoop = new CFANode(this.cfa.getFunctionName());
        this.cfaNodes.add(lastNodeInLoop);
        this.assignFormalParameterForLoop(forStatement.getParameter(), fileloc);
        forStatement.getBody().accept((ASTVisitor)this);
        CFANode prev = this.locStack.pop();
        BlankEdge blankEdge = new BlankEdge("", fileloc, prev, lastNodeInLoop, "");
        this.addToCFA(blankEdge);
        BlankEdge loopEndToStart = new BlankEdge("", fileloc, lastNodeInLoop, loopStart, "");
        this.addToCFA(loopEndToStart);
        assert (postLoopNode == this.loopNextStack.pop());
        assert (postLoopNode == this.locStack.peek());
        this.scope.leaveBlock();
        return false;
    }

    private void assignFormalParameterForLoop(SingleVariableDeclaration parameter, FileLocation fileLocation) {
        CFANode prevNode = this.locStack.poll();
        JMethodInvocationAssignmentStatement assignment = this.astCreator.assignParameterToNextIteratorItem(parameter);
        CFANode nextNode = new CFANode(this.cfa.getFunctionName());
        this.cfaNodes.add(nextNode);
        JStatementEdge edge = new JStatementEdge(assignment.toASTString(), assignment, fileLocation, prevNode, nextNode);
        this.addToCFA(edge);
        this.locStack.push(nextNode);
    }

    private CFANode createIteratorEdgeForEnhancedForLoop(Expression expr, FileLocation fileLocation, CFANode loopInit) {
        CFANode prevNode = loopInit;
        JMethodInvocationAssignmentStatement assignment = this.astCreator.getIteratorFromIterable(expr);
        prevNode = this.handleSideassignments(prevNode, "", fileLocation);
        CFANode nextNode = new CFANode(this.cfa.getFunctionName());
        this.cfaNodes.add(nextNode);
        JStatementEdge edge = new JStatementEdge("", assignment, fileLocation, prevNode, nextNode);
        this.addToCFA(edge);
        return nextNode;
    }

    public boolean visit(ForStatement forStatement) {
        this.scope.enterBlock();
        this.handleElseCondition((Statement)forStatement);
        FileLocation fileloc = this.astCreator.getFileLocation((ASTNode)forStatement);
        CFANode prevNode = this.locStack.pop();
        CFANode loopInit = new CFANode(this.cfa.getFunctionName());
        this.cfaNodes.add(loopInit);
        this.addToCFA(new BlankEdge("", fileloc, prevNode, loopInit, "for"));
        List iniBlock = forStatement.initializers();
        CFANode loopStart = this.createInitEdgeForForLoop(iniBlock, fileloc, loopInit);
        loopStart.setLoopStart();
        CFANode firstLoopNode = new CFANode(this.cfa.getFunctionName());
        this.cfaNodes.add(firstLoopNode);
        CFANode postLoopNode = new CFANode(this.cfa.getFunctionName());
        this.cfaNodes.add(postLoopNode);
        this.loopNextStack.push(postLoopNode);
        this.locStack.push(postLoopNode);
        this.locStack.push(firstLoopNode);
        Expression condition = forStatement.getExpression();
        this.createConditionEdgesForForLoop(condition, fileloc, loopStart, postLoopNode, firstLoopNode);
        CFANode lastNodeInLoop = new CFANode(this.cfa.getFunctionName());
        this.cfaNodes.add(lastNodeInLoop);
        this.loopStartStack.push(lastNodeInLoop);
        forStatement.getBody().accept((ASTVisitor)this);
        CFANode prev = this.locStack.pop();
        BlankEdge blankEdge = new BlankEdge("", fileloc, prev, lastNodeInLoop, "");
        this.addToCFA(blankEdge);
        List updateBlock = forStatement.updaters();
        this.createLastNodesAndEdgeForForLoop(updateBlock, fileloc, lastNodeInLoop, loopStart);
        assert (lastNodeInLoop == this.loopStartStack.pop());
        assert (postLoopNode == this.loopNextStack.pop());
        assert (postLoopNode == this.locStack.peek());
        this.scope.leaveBlock();
        return false;
    }

    private void createConditionEdgesForForLoop(Expression condition, FileLocation fileLocation, CFANode loopStart, CFANode postLoopNode, CFANode firstLoopNode) {
        if (condition == null) {
            BlankEdge blankEdge = new BlankEdge("", fileLocation, loopStart, firstLoopNode, "");
            this.addToCFA(blankEdge);
        } else {
            this.createConditionEdges(condition, fileLocation, loopStart, firstLoopNode, postLoopNode);
        }
    }

    private void createConditionEdgesForForLoop(JExpression condition, FileLocation fileLocation, CFANode loopStart, CFANode postLoopNode, CFANode firstLoopNode) {
        if (condition == null) {
            BlankEdge blankEdge = new BlankEdge("", fileLocation, loopStart, firstLoopNode, "");
            this.addToCFA(blankEdge);
        } else {
            this.createConditionEdges(condition, fileLocation, loopStart, firstLoopNode, postLoopNode);
        }
    }

    private void createLastNodesAndEdgeForForLoop(List<Expression> updaters, FileLocation fileLocation, CFANode loopEnd, CFANode loopStart) {
        int size = updaters.size();
        if (size == 0) {
            BlankEdge blankEdge = new BlankEdge("", fileLocation, loopEnd, loopStart, "");
            this.addToCFA(blankEdge);
        } else {
            CFANode prevNode = loopEnd;
            CFANode nextNode = null;
            for (Expression exp : updaters) {
                JAstNode node = this.astCreator.convertExpressionWithSideEffects(exp);
                nextNode = new CFANode(this.cfa.getFunctionName());
                this.cfaNodes.add(nextNode);
                if (node instanceof JIdExpression) {
                    BlankEdge blankEdge = new BlankEdge(node.toASTString(), fileLocation, prevNode, nextNode, "");
                    this.addToCFA(blankEdge);
                    continue;
                }
                if (node instanceof JExpressionAssignmentStatement) {
                    JStatementEdge lastEdge = new JStatementEdge(exp.toString(), (JExpressionAssignmentStatement)node, fileLocation, prevNode, nextNode);
                    this.addToCFA(lastEdge);
                    continue;
                }
                if (node instanceof JMethodInvocationAssignmentStatement) {
                    JStatementEdge edge = new JStatementEdge(exp.toString(), (JMethodInvocationAssignmentStatement)node, fileLocation, prevNode, nextNode);
                    this.addToCFA(edge);
                    continue;
                }
                throw new AssertionError((Object)("CFABuilder: unknown iteration-expressions in for-statement:\n" + exp.getClass()));
            }
            BlankEdge blankEdge = new BlankEdge("", fileLocation, nextNode, loopStart, "");
            this.addToCFA(blankEdge);
        }
    }

    private CFANode createInitEdgeForForLoop(List<Expression> initializers, FileLocation fileLocation, CFANode loopInit) {
        CFANode nextNode = loopInit;
        for (Expression exp : initializers) {
            JAstNode node = this.astCreator.convertExpressionWithSideEffects(exp);
            if (node == null && this.astCreator.numberOfForInitDeclarations() > 0) {
                List<JDeclaration> initBlock = this.astCreator.getForInitDeclaration();
                nextNode = this.addDeclarationsToCFA(initBlock, fileLocation, initializers.toString(), nextNode);
                this.astCreator.getForInitDeclaration().clear();
                continue;
            }
            if (node instanceof JIdExpression) {
                nextNode = new CFANode(this.cfa.getFunctionName());
                this.cfaNodes.add(nextNode);
                BlankEdge blankEdge = new BlankEdge(node.toASTString(), fileLocation, loopInit, nextNode, "");
                this.addToCFA(blankEdge);
                continue;
            }
            if (node instanceof JExpressionAssignmentStatement) {
                nextNode = new CFANode(this.cfa.getFunctionName());
                this.cfaNodes.add(nextNode);
                JStatementEdge lastEdge = new JStatementEdge(exp.toString(), (JExpressionAssignmentStatement)node, fileLocation, loopInit, nextNode);
                this.addToCFA(lastEdge);
                continue;
            }
            if (node instanceof JMethodInvocationAssignmentStatement) {
                nextNode = new CFANode(this.cfa.getFunctionName());
                this.cfaNodes.add(nextNode);
                JStatementEdge edge = new JStatementEdge(exp.toString(), (JMethodInvocationAssignmentStatement)node, fileLocation, loopInit, nextNode);
                this.addToCFA(edge);
                continue;
            }
            throw new AssertionError((Object)("CFABuilder: unknown iteration-expressions in for-statement:\n" + exp.getClass()));
        }
        assert (nextNode != null);
        return nextNode;
    }

    public boolean visit(BreakStatement breakStatement) {
        this.handleElseCondition((Statement)breakStatement);
        if (breakStatement.getLabel() == null) {
            this.handleBreakStatement(breakStatement);
        } else {
            this.handleLabeledBreakStatement(breakStatement);
        }
        return false;
    }

    private void handleBreakStatement(BreakStatement breakStatement) {
        FileLocation fileloc = this.astCreator.getFileLocation((ASTNode)breakStatement);
        CFANode prevNode = this.locStack.pop();
        CFANode postLoopNode = this.loopNextStack.peek();
        BlankEdge blankEdge = new BlankEdge(breakStatement.toString(), fileloc, prevNode, postLoopNode, "break");
        this.addToCFA(blankEdge);
        CFANode nextNode = new CFANode(this.cfa.getFunctionName());
        this.cfaNodes.add(nextNode);
        this.locStack.push(nextNode);
    }

    private void handleLabeledBreakStatement(BreakStatement breakStatement) {
        FileLocation fileloc = this.astCreator.getFileLocation((ASTNode)breakStatement);
        CFANode prevNode = this.locStack.pop();
        CFANode postLoopNode = this.labelMap.get(breakStatement.getLabel().getIdentifier());
        BlankEdge blankEdge = new BlankEdge(breakStatement.toString(), fileloc, prevNode, postLoopNode, "break ");
        this.addToCFA(blankEdge);
        CFANode nextNode = new CFANode(this.cfa.getFunctionName());
        this.cfaNodes.add(nextNode);
        this.locStack.push(nextNode);
    }

    public boolean visit(ContinueStatement continueStatement) {
        this.handleElseCondition((Statement)continueStatement);
        if (continueStatement.getLabel() == null) {
            this.handleContinueStatement(continueStatement);
        } else {
            this.registerLabledContinueStatement(continueStatement);
        }
        return false;
    }

    private void handleLabledContinueStatement(ContinueStatement continueStatement, CFANode prevNode, CFANode startLoopNode) {
        FileLocation fileloc = this.astCreator.getFileLocation((ASTNode)continueStatement);
        BlankEdge blankEdge = new BlankEdge(continueStatement.toString(), fileloc, prevNode, startLoopNode, "continue ");
        this.addToCFA(blankEdge);
    }

    private void registerLabledContinueStatement(ContinueStatement continueStatement) {
        CFANode prevNode = this.locStack.pop();
        List<Pair<CFANode, ContinueStatement>> prevNodeList = this.registeredContinues.get(continueStatement.getLabel().getIdentifier());
        if (prevNodeList == null) {
            throw new CFAGenerationRuntimeException("Could not Find Loop of Label Name " + continueStatement.getLabel().getIdentifier());
        }
        prevNodeList.add((Pair<CFANode, ContinueStatement>)Pair.of((Object)prevNode, (Object)continueStatement));
        CFANode nextNode = new CFANode(this.cfa.getFunctionName());
        this.cfaNodes.add(nextNode);
        this.locStack.push(nextNode);
    }

    private void handleContinueStatement(ContinueStatement continueStatement) {
        FileLocation fileloc = this.astCreator.getFileLocation((ASTNode)continueStatement);
        CFANode prevNode = this.locStack.pop();
        CFANode loopStartNode = this.loopStartStack.peek();
        BlankEdge blankEdge = new BlankEdge(continueStatement.toString(), fileloc, prevNode, loopStartNode, "continue");
        this.addToCFA(blankEdge);
        CFANode nextNode = new CFANode(this.cfa.getFunctionName());
        this.locStack.push(nextNode);
    }

    public boolean visit(ReturnStatement returnStatement) {
        FileLocation fileloc = this.astCreator.getFileLocation((ASTNode)returnStatement);
        CFANode prevNode = this.locStack.pop();
        CFANode nextNode = new CFANode(this.cfa.getFunctionName());
        this.cfaNodes.add(nextNode);
        FunctionExitNode functionExitNode = this.cfa.getExitNode();
        JReturnStatement cfJReturnStatement = this.astCreator.convert(returnStatement);
        prevNode = this.handleSideassignments(prevNode, returnStatement.toString(), fileloc);
        if (this.astCreator.getConditionalExpression() != null) {
            this.astCreator.resetConditionalExpression();
        }
        JReturnStatementEdge edge = new JReturnStatementEdge(returnStatement.toString(), cfJReturnStatement, fileloc, prevNode, functionExitNode);
        this.addToCFA(edge);
        this.locStack.push(nextNode);
        return false;
    }

    private void addToCFA(CFAEdge edge) {
        CFACreationUtils.addEdgeToCFA(edge, this.logger);
    }

    public void createDefaultConstructor(ITypeBinding classBinding) {
        if (this.locStack.size() != 0) {
            throw new CFAGenerationRuntimeException("Nested function declarations?");
        }
        assert (this.cfa == null);
        JMethodDeclaration fdef = this.astCreator.createDefaultConstructor(classBinding);
        this.handleMethodDeclaration(fdef);
        this.addNonStaticFieldMember();
        this.handleReturnFromObject(FileLocation.DUMMY, classBinding.getName(), classBinding);
        this.handleEndVisitMethodDeclaration();
    }

    private static enum CONDITION {
        NORMAL,
        ALWAYS_FALSE,
        ALWAYS_TRUE;

    }
}

