/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.parser.eclipse.java;

import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.sosy_lab.common.Pair;
import org.sosy_lab.cpachecker.cfa.CFACreationUtils;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionCall;
import org.sosy_lab.cpachecker.cfa.ast.AbstractStatement;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.java.JMethodDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.java.JMethodInvocationAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.java.JMethodInvocationExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JMethodInvocationStatement;
import org.sosy_lab.cpachecker.cfa.ast.java.JReferencedMethodInvocationExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JRunTimeTypeEqualsType;
import org.sosy_lab.cpachecker.cfa.ast.java.JStatement;
import org.sosy_lab.cpachecker.cfa.model.AStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.BlankEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.java.JAssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.java.JStatementEdge;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.java.ASTConverter;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.java.CFABuilder;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.java.NameConverter;
import org.sosy_lab.cpachecker.cfa.types.java.JClassOrInterfaceType;
import org.sosy_lab.cpachecker.cfa.types.java.JClassType;
import org.sosy_lab.cpachecker.cfa.types.java.JInterfaceType;
import org.sosy_lab.cpachecker.exceptions.JParserException;
import org.sosy_lab.cpachecker.util.CFAUtils;

class DynamicBindingCreator {
    private final ASTConverter astCreator;
    private final CFABuilder cfaBuilder;
    private final Map<String, List<Pair<FunctionEntryNode, JClassOrInterfaceType>>> subMethodsOfMethod = new HashMap<String, List<Pair<FunctionEntryNode, JClassOrInterfaceType>>>();
    private final Map<String, List<Pair<FunctionEntryNode, JClassOrInterfaceType>>> methodTypeBindingsOfMethod = new HashMap<String, List<Pair<FunctionEntryNode, JClassOrInterfaceType>>>();

    public DynamicBindingCreator(CFABuilder builder) {
        this.cfaBuilder = builder;
        this.astCreator = builder.getAstCreator();
    }

    public void trackAndCreateDynamicBindings() throws JParserException {
        SortedMap<String, FunctionEntryNode> cfAs = this.cfaBuilder.getCFAs();
        this.trackOverridenMethods(cfAs);
        this.completeMethodBindings();
        for (Map.Entry functionEntry : cfAs.entrySet()) {
            this.insertBindings((FunctionEntryNode)functionEntry.getValue());
        }
    }

    private void trackOverridenMethods(Map<String, FunctionEntryNode> cfAs) {
        Map<String, MethodDeclaration> allParsedMethodDeclaration = this.cfaBuilder.getAllParsedMethodDeclaration();
        for (Map.Entry<String, FunctionEntryNode> entry : cfAs.entrySet()) {
            String functionName = entry.getKey();
            FunctionEntryNode currEntryNode = entry.getValue();
            MethodDeclaration currMethod = allParsedMethodDeclaration.get(functionName);
            assert (allParsedMethodDeclaration.containsKey(functionName));
            if (currMethod == null || currMethod.isConstructor()) continue;
            this.trackOverridenMethods(currMethod, currEntryNode);
        }
    }

    private void completeMethodBindings() {
        for (String key : this.subMethodsOfMethod.keySet()) {
            this.methodTypeBindingsOfMethod.put(key, new LinkedList(this.subMethodsOfMethod.get(key)));
        }
        HashMap workMap = new HashMap();
        for (String key : this.subMethodsOfMethod.keySet()) {
            workMap.put(key, new LinkedList(this.subMethodsOfMethod.get(key)));
        }
        Map<String, MethodDeclaration> allParsedMethodDeclaration = this.cfaBuilder.getAllParsedMethodDeclaration();
        for (String methodName : workMap.keySet()) {
            if (allParsedMethodDeclaration.get(methodName) == null || allParsedMethodDeclaration.get(methodName).isConstructor()) continue;
            this.completeBindingsOfMethod(allParsedMethodDeclaration.get(methodName), methodName);
        }
    }

    private void completeBindingsOfMethod(MethodDeclaration methodDeclaration, String methodName) {
        JClassOrInterfaceType methodDeclaringType = this.astCreator.convertClassOrInterfaceType(methodDeclaration.resolveBinding().getDeclaringClass());
        if (methodDeclaringType instanceof JClassType) {
            this.completeBindingsForDeclaringClassType((JClassType)methodDeclaringType, methodName);
        } else if (methodDeclaringType instanceof JInterfaceType) {
            this.completeBindingsForDeclaringInterfaceType((JInterfaceType)methodDeclaringType, methodName);
        }
    }

    private void completeBindingsForDeclaringInterfaceType(JInterfaceType methodDeclaringType, String methodName) {
        Set<JClassType> directImpementingClasses = methodDeclaringType.getKnownInterfaceImplementingClasses();
        for (JClassType implementingClasses : directImpementingClasses) {
            this.copmleteBindingsForClassType(implementingClasses, methodName, methodName);
        }
        Set<JInterfaceType> subInterfaces = methodDeclaringType.getAllSubInterfacesOfInterface();
        for (JInterfaceType subInterface : subInterfaces) {
            for (JClassType implementingClasses : subInterface.getKnownInterfaceImplementingClasses()) {
                this.copmleteBindingsForClassType(implementingClasses, methodName, methodName);
            }
        }
    }

    private void completeBindingsForDeclaringClassType(JClassType methodDeclaringType, String methodName) {
        Set<JClassType> directSubClasses = methodDeclaringType.getDirectSubClasses();
        for (JClassType subClass : directSubClasses) {
            this.copmleteBindingsForClassType(subClass, methodName, methodName);
        }
    }

    private void copmleteBindingsForClassType(JClassType classType, String methodNametoBeRegistered, String methodNameToRegister) {
        String nextMethodNameToRegister = this.updateBinding(classType, methodNametoBeRegistered, methodNameToRegister);
        Set<JClassType> directSubClasses = classType.getDirectSubClasses();
        for (JClassType subClass : directSubClasses) {
            this.copmleteBindingsForClassType(subClass, methodNametoBeRegistered, nextMethodNameToRegister);
        }
    }

    private String updateBinding(JClassType classType, String methodNametoBeRegistered, String methodNameToRegister) {
        List<Pair<FunctionEntryNode, JClassOrInterfaceType>> subMethodBindings = this.subMethodsOfMethod.get(methodNameToRegister);
        String nextMethodNameToRegister = methodNameToRegister;
        Pair<Boolean, String> hasBindingAndBindingMethodName = this.typeHasBinding(classType, subMethodBindings);
        if (((Boolean)hasBindingAndBindingMethodName.getFirst()).booleanValue()) {
            nextMethodNameToRegister = (String)hasBindingAndBindingMethodName.getSecond();
        } else {
            this.methodTypeBindingsOfMethod.get(methodNametoBeRegistered).add((Pair<FunctionEntryNode, JClassOrInterfaceType>)Pair.of(this.cfaBuilder.getCFAs().get(methodNameToRegister), (Object)classType));
        }
        return nextMethodNameToRegister;
    }

    private Pair<Boolean, String> typeHasBinding(JClassOrInterfaceType classType, List<Pair<FunctionEntryNode, JClassOrInterfaceType>> subMethodBindings) {
        boolean result = false;
        for (Pair<FunctionEntryNode, JClassOrInterfaceType> methodTypeBindingPair : subMethodBindings) {
            result = ((JClassOrInterfaceType)methodTypeBindingPair.getSecond()).equals(classType);
            if (!result) continue;
            return Pair.of((Object)true, (Object)((FunctionEntryNode)methodTypeBindingPair.getFirst()).getFunctionName());
        }
        return Pair.of((Object)false, null);
    }

    private void insertBindings(FunctionEntryNode initialNode) throws JParserException {
        ArrayDeque<CFANode> workList = new ArrayDeque<CFANode>();
        HashSet<CFANode> processed = new HashSet<CFANode>();
        workList.addLast(initialNode);
        while (!workList.isEmpty()) {
            CFANode node = (CFANode)workList.pollFirst();
            if (!processed.add(node)) continue;
            for (CFAEdge edge : CFAUtils.leavingEdges(node)) {
                AStatementEdge statement;
                JStatement expr;
                if (edge instanceof AStatementEdge && (expr = (JStatement)(statement = (AStatementEdge)edge).getStatement()) instanceof AFunctionCall) {
                    this.createBindings(statement, (AFunctionCall)((Object)expr), processed);
                }
                CFANode successorNode = edge.getSuccessor();
                if (!node.getFunctionName().equals(successorNode.getFunctionName())) continue;
                workList.add(successorNode);
            }
        }
    }

    private void createBindings(AStatementEdge edge, AFunctionCall functionCall, Set<CFANode> pProcessed) {
        JMethodInvocationExpression functionCallExpression = (JMethodInvocationExpression)functionCall.getFunctionCallExpression();
        String functionName = functionCallExpression.getFunctionNameExpression().toASTString();
        if (this.methodTypeBindingsOfMethod.get(functionName) != null && !this.methodTypeBindingsOfMethod.get(functionName).isEmpty()) {
            if (functionCallExpression instanceof JReferencedMethodInvocationExpression) {
                if (!((JReferencedMethodInvocationExpression)functionCallExpression).hasKnownRunTimeBinding()) {
                    this.createMethodInvocationBindings(edge, pProcessed, functionName);
                } else {
                    this.createOnlyReferencedMethodInvocationBinding(edge, this.subMethodsOfMethod.get(functionName));
                }
            } else if (!(functionCallExpression.getDeclaration().isStatic() || functionCallExpression.getDeclaration().isFinal() || functionCallExpression.getDeclaringType() instanceof JInterfaceType || ((JClassType)functionCallExpression.getDeclaringType()).isFinal() || functionCallExpression.hasKnownRunTimeBinding())) {
                this.createMethodInvocationBindings(edge, pProcessed, functionName);
            }
        }
    }

    private void createMethodInvocationBindings(AStatementEdge edge, Set<CFANode> pProcessed, String functionName) {
        CFANode prevNode = edge.getPredecessor();
        CFANode postConditionNode = edge.getSuccessor();
        CFACreationUtils.removeEdgeFromNodes(edge);
        for (Pair<FunctionEntryNode, JClassOrInterfaceType> overridesThisMethod : this.methodTypeBindingsOfMethod.get(functionName)) {
            if (((JMethodDeclaration)((FunctionEntryNode)overridesThisMethod.getFirst()).getFunctionDefinition()).isAbstract()) continue;
            prevNode = this.createBinding(edge, overridesThisMethod, prevNode, postConditionNode, pProcessed);
        }
        this.createLastBinding(edge, prevNode, postConditionNode, pProcessed);
    }

    private void createOnlyReferencedMethodInvocationBinding(AStatementEdge edge, List<Pair<FunctionEntryNode, JClassOrInterfaceType>> subMethods) {
        AbstractStatement newFunctionCall;
        FunctionEntryNode onlyFunction = null;
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        AFunctionCall oldFunctionCall = (AFunctionCall)edge.getStatement();
        JReferencedMethodInvocationExpression oldFunctionCallExpression = (JReferencedMethodInvocationExpression)oldFunctionCall.getFunctionCallExpression();
        JClassType runTimeBinding = oldFunctionCallExpression.getRunTimeBinding();
        for (Pair<FunctionEntryNode, JClassOrInterfaceType> methodBinding : subMethods) {
            if (runTimeBinding.equals(methodBinding.getSecond())) {
                onlyFunction = (FunctionEntryNode)methodBinding.getFirst();
                break;
            }
            map.put(methodBinding.getSecond(), methodBinding.getFirst());
        }
        if (onlyFunction == null) {
            Set<JClassType> superTypes = runTimeBinding.getAllSuperClasses();
            for (JClassType superType : superTypes) {
                if (!map.containsKey(superType)) continue;
                onlyFunction = (FunctionEntryNode)map.get(superType);
                break;
            }
        }
        if (onlyFunction == null) {
            throw new IllegalArgumentException("No binding for function of type " + runTimeBinding.getName() + "found.");
        }
        CFANode postNode = edge.getSuccessor();
        CFANode prevNode = edge.getPredecessor();
        CFACreationUtils.removeEdgeFromNodes(edge);
        FileLocation fileloc = oldFunctionCallExpression.getFileLocation();
        JReferencedMethodInvocationExpression newFunctionCallExpression = (JReferencedMethodInvocationExpression)this.astCreator.convert(onlyFunction, oldFunctionCallExpression);
        if (oldFunctionCall instanceof JMethodInvocationAssignmentStatement) {
            JMethodInvocationAssignmentStatement oldFunctionCallAssignmentStatement = (JMethodInvocationAssignmentStatement)oldFunctionCall;
            newFunctionCall = new JMethodInvocationAssignmentStatement(fileloc, oldFunctionCallAssignmentStatement.getLeftHandSide(), newFunctionCallExpression);
        } else {
            assert (edge.getStatement() instanceof JMethodInvocationStatement) : "Statement is no Function Call";
            newFunctionCall = new JMethodInvocationStatement(fileloc, newFunctionCallExpression);
        }
        JStatementEdge functionCallEdge = new JStatementEdge(newFunctionCall.toASTString(), (JStatement)((Object)newFunctionCall), edge.getFileLocation(), prevNode, postNode);
        CFACreationUtils.addEdgeToCFA(functionCallEdge, null);
    }

    private void createLastBinding(AStatementEdge edge, CFANode prevNode, CFANode postConditionNode, Set<CFANode> pProcessed) {
        JMethodDeclaration decl = this.cfaBuilder.getScope().lookupMethod(((AFunctionCall)edge.getStatement()).getFunctionCallExpression().getFunctionNameExpression().toASTString());
        CFANode nextPrevNode = prevNode;
        if (!decl.isAbstract() && this.cfaBuilder.getCFAs().containsKey(decl.getName())) {
            nextPrevNode = this.createBinding(edge, (Pair<FunctionEntryNode, JClassOrInterfaceType>)Pair.of(this.cfaBuilder.getCFAs().get(decl.getName()), (Object)decl.getDeclaringClass()), prevNode, postConditionNode, pProcessed);
        }
        BlankEdge postConditionEdge = new BlankEdge(edge.getRawStatement(), edge.getFileLocation(), nextPrevNode, postConditionNode, "");
        CFACreationUtils.addEdgeToCFA(postConditionEdge, null);
    }

    private CFANode createBinding(AStatementEdge edge, Pair<FunctionEntryNode, JClassOrInterfaceType> overridesThisMethod, CFANode prevNode, CFANode postConditionNode, Set<CFANode> pProcessed) {
        AbstractStatement newFunctionCall;
        JMethodInvocationExpression oldFunctionCallExpression = (JMethodInvocationExpression)((AFunctionCall)edge.getStatement()).getFunctionCallExpression();
        AFunctionCall functionCall = (AFunctionCall)edge.getStatement();
        FileLocation fileloc = oldFunctionCallExpression.getFileLocation();
        String callInFunction = prevNode.getFunctionName();
        JMethodInvocationExpression newFunctionCallExpression = this.astCreator.convert((FunctionEntryNode)overridesThisMethod.getFirst(), oldFunctionCallExpression);
        CFANode successfulNode = new CFANode(callInFunction);
        this.cfaBuilder.getCFANodes().put((Object)callInFunction, (Object)successfulNode);
        pProcessed.add(successfulNode);
        CFANode unsuccessfulNode = new CFANode(callInFunction);
        this.cfaBuilder.getCFANodes().put((Object)callInFunction, (Object)unsuccessfulNode);
        pProcessed.add(unsuccessfulNode);
        this.createConditionEdges(prevNode, successfulNode, unsuccessfulNode, (JClassOrInterfaceType)overridesThisMethod.getSecond(), newFunctionCallExpression, fileloc);
        if (functionCall instanceof JMethodInvocationAssignmentStatement) {
            JMethodInvocationAssignmentStatement oldFunctionCallAssignmentStatement = (JMethodInvocationAssignmentStatement)functionCall;
            newFunctionCall = new JMethodInvocationAssignmentStatement(fileloc, oldFunctionCallAssignmentStatement.getLeftHandSide(), newFunctionCallExpression);
        } else {
            assert (edge.getStatement() instanceof JMethodInvocationStatement) : "Statement is no Function Call";
            newFunctionCall = new JMethodInvocationStatement(fileloc, newFunctionCallExpression);
        }
        CFANode postFunctionCallNode = new CFANode(callInFunction);
        this.cfaBuilder.getCFANodes().put((Object)callInFunction, (Object)postFunctionCallNode);
        pProcessed.add(postFunctionCallNode);
        JStatementEdge functionCallEdge = new JStatementEdge(edge.getRawStatement(), (JStatement)((Object)newFunctionCall), edge.getFileLocation(), successfulNode, postFunctionCallNode);
        CFACreationUtils.addEdgeToCFA(functionCallEdge, null);
        BlankEdge postConditionEdge = new BlankEdge(edge.getRawStatement(), edge.getFileLocation(), postFunctionCallNode, postConditionNode, "");
        CFACreationUtils.addEdgeToCFA(postConditionEdge, null);
        return unsuccessfulNode;
    }

    private void createConditionEdges(CFANode prevNode, CFANode successfulNode, CFANode unsuccessfulNode, JClassOrInterfaceType classTypeOfNewMethodInvocation, JMethodInvocationExpression methodInvocation, FileLocation fileloc) {
        JRunTimeTypeEqualsType exp = this.astCreator.convertClassRunTimeCompileTimeAccord(fileloc, methodInvocation, classTypeOfNewMethodInvocation);
        String rawSignature = exp.toASTString();
        JAssumeEdge JAssumeEdgeFalse = new JAssumeEdge("!(" + rawSignature + ")", fileloc, prevNode, unsuccessfulNode, exp, false);
        CFACreationUtils.addEdgeToCFA(JAssumeEdgeFalse, null);
        JAssumeEdge JAssumeEdgeTrue = new JAssumeEdge(rawSignature, fileloc, prevNode, successfulNode, exp, true);
        CFACreationUtils.addEdgeToCFA(JAssumeEdgeTrue, null);
    }

    private void trackOverridenMethods(MethodDeclaration declaration, FunctionEntryNode entryNode) {
        if (!this.subMethodsOfMethod.containsKey(entryNode.getFunctionDefinition().getName())) {
            this.subMethodsOfMethod.put(entryNode.getFunctionDefinition().getName(), new LinkedList());
        }
        Pair<FunctionEntryNode, JClassOrInterfaceType> toBeRegistered = this.getPairToBeRegistered(declaration, entryNode);
        this.registerForSuperClass(declaration.resolveBinding().getDeclaringClass().getSuperclass(), toBeRegistered, declaration.resolveBinding());
        this.registerForSuperIntefaces(declaration.resolveBinding().getDeclaringClass().getInterfaces(), toBeRegistered, declaration.resolveBinding());
    }

    private void registerForSuperIntefaces(ITypeBinding[] interfaces, Pair<FunctionEntryNode, JClassOrInterfaceType> toBeRegistered, IMethodBinding bindingToBeRegistered) {
        if (interfaces.length > 0) {
            for (ITypeBinding inface : interfaces) {
                IMethodBinding[] methodsBinding;
                for (IMethodBinding methodBinding : methodsBinding = inface.getDeclaredMethods()) {
                    if (!bindingToBeRegistered.overrides(methodBinding)) continue;
                    this.registerMethod(methodBinding, toBeRegistered);
                }
                this.registerForSuperIntefaces(inface.getInterfaces(), toBeRegistered, bindingToBeRegistered);
            }
        }
    }

    private void registerForSuperClass(ITypeBinding superClass, Pair<FunctionEntryNode, JClassOrInterfaceType> toBeRegistered, IMethodBinding bindingToBeRegistered) {
        if (superClass != null) {
            IMethodBinding[] methodsBinding;
            for (IMethodBinding methodBinding : methodsBinding = superClass.getDeclaredMethods()) {
                if (!bindingToBeRegistered.overrides(methodBinding)) continue;
                this.registerMethod(methodBinding, toBeRegistered);
            }
            this.registerForSuperIntefaces(superClass.getInterfaces(), toBeRegistered, bindingToBeRegistered);
            this.registerForSuperClass(superClass.getSuperclass(), toBeRegistered, bindingToBeRegistered);
        }
    }

    private void registerMethod(IMethodBinding overriddenMethod, Pair<FunctionEntryNode, JClassOrInterfaceType> toBeRegistered) {
        String overridenMethodName = NameConverter.convertName(overriddenMethod);
        if (!this.subMethodsOfMethod.containsKey(overridenMethodName)) {
            this.subMethodsOfMethod.put(overridenMethodName, new LinkedList());
        }
        this.subMethodsOfMethod.get(overridenMethodName).add(toBeRegistered);
    }

    private Pair<FunctionEntryNode, JClassOrInterfaceType> getPairToBeRegistered(MethodDeclaration declaration, FunctionEntryNode entryNode) {
        JClassOrInterfaceType classType = this.astCreator.convertClassOrInterfaceType(declaration.resolveBinding().getDeclaringClass());
        return Pair.of((Object)entryNode, (Object)classType);
    }
}

