/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.parser.eclipse.java;

import com.google.common.base.Splitter;
import com.google.common.io.FileWriteMode;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.logging.Level;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.io.Path;
import org.sosy_lab.common.io.Paths;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.time.Timer;
import org.sosy_lab.cpachecker.cfa.CSourceOriginMapping;
import org.sosy_lab.cpachecker.cfa.Language;
import org.sosy_lab.cpachecker.cfa.ParseResult;
import org.sosy_lab.cpachecker.cfa.Parser;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.java.CFABuilder;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.java.CFAGenerationRuntimeException;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.java.DynamicBindingCreator;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.java.Scope;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.java.THDotBuilder;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.java.TypeHierarchy;
import org.sosy_lab.cpachecker.exceptions.JParserException;

@Options
class EclipseJavaParser
implements Parser {
    @Option(secure=true, name="java.encoding", description="use the following encoding for java files")
    private Charset encoding = StandardCharsets.UTF_8;
    @Option(secure=true, name="java.version", description="Specifies the java version of source code accepted")
    private String version = "1.7";
    @Option(secure=true, name="java.sourcepath", description="Specify the source code path to search for java class or interface definitions")
    private String javaSourcepath = "";
    @Option(secure=true, name="java.classpath", description="Specify the class code path to search for java class or interface definitions")
    private String javaClasspath = "";
    @Option(secure=true, name="java.exportTypeHierarchy", description="export TypeHierarchy as .dot file")
    private boolean exportTypeHierarchy = true;
    @Option(secure=true, name="java.typeHierarchyFile", description="export TypeHierarchy as .dot file")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private Path exportTypeHierarchyFile = Paths.get((String)"typeHierarchy.dot", (String[])new String[0]);
    private final ASTParser parser = ASTParser.newParser((int)4);
    private final LogManager logger;
    private final Timer parseTimer = new Timer();
    private final Timer cfaTimer = new Timer();
    private final String[] javaSourcePaths;
    private final String[] javaClassPaths;
    private static final boolean IGNORE_METHOD_BODY = true;
    private static final boolean PARSE_METHOD_BODY = false;
    private static final String JAVA_SOURCE_FILE_REGEX = ".*\\.java";

    public EclipseJavaParser(LogManager pLogger, Configuration config) throws InvalidConfigurationException {
        config.inject((Object)this);
        this.logger = pLogger;
        this.javaClassPaths = this.getJavaPaths(this.javaClasspath);
        this.javaSourcePaths = this.javaSourcepath.isEmpty() ? this.javaClassPaths : this.getJavaPaths(this.javaSourcepath);
        if (this.javaSourcePaths.length == 0) {
            throw new InvalidConfigurationException("No valid Paths could be found.");
        }
    }

    private String[] getJavaPaths(String javaPath) {
        ArrayList<String> resultList = new ArrayList<String>();
        for (String path : Splitter.on((String)File.pathSeparator).trimResults().omitEmptyStrings().split((CharSequence)javaPath)) {
            Path directory = Paths.get((String)path, (String[])new String[0]);
            if (!directory.exists()) {
                this.logger.log(Level.WARNING, new Object[]{"Path " + directory + " could not be found."});
                continue;
            }
            if (!directory.canRead()) {
                this.logger.log(Level.WARNING, new Object[]{"Path " + directory + " can not be read."});
                continue;
            }
            resultList.add(directory.toAbsolutePath().getPath());
        }
        return resultList.toArray(new String[resultList.size()]);
    }

    @Override
    public ParseResult parseFile(String mainClassName, CSourceOriginMapping sourceOriginMapping) throws JParserException {
        Path mainClassFile = this.getMainClassFile(mainClassName);
        Scope scope = this.prepareScope(mainClassName);
        ParseResult result = this.buildCFA(this.parse(mainClassFile), scope);
        this.exportTypeHierarchy(scope);
        return result;
    }

    private void exportTypeHierarchy(Scope pScope) {
        if (this.exportTypeHierarchy && this.exportTypeHierarchyFile != null) {
            try (Writer w = this.exportTypeHierarchyFile.asCharSink(StandardCharsets.UTF_8, new FileWriteMode[0]).openBufferedStream();){
                THDotBuilder.generateDOT(w, pScope);
            }
            catch (IOException e) {
                this.logger.logUserException(Level.WARNING, (Throwable)e, "Could not write TypeHierarchy to dot file");
            }
        }
    }

    private Path getMainClassFile(String mainClassName) throws JParserException {
        Path mainClass = this.searchForClassFile(mainClassName);
        if (mainClass == null) {
            throw new JParserException("Could not find main class in the specified paths");
        }
        return mainClass;
    }

    private Scope prepareScope(String mainClassName) throws JParserException {
        List<JavaFileAST> astsOfFoundFiles = this.getASTsOfProgram();
        TypeHierarchy typeHierarchy = TypeHierarchy.createTypeHierachy(this.logger, astsOfFoundFiles);
        return new Scope(mainClassName, typeHierarchy);
    }

    private List<JavaFileAST> getASTsOfProgram() throws JParserException {
        Set<Path> sourceFileToBeParsed = this.getJavaFilesInSourcePaths();
        LinkedList<JavaFileAST> astsOfFoundFiles = new LinkedList<JavaFileAST>();
        for (Path file : sourceFileToBeParsed) {
            String fileName = file.getName();
            CompilationUnit ast = this.parse(file, true);
            astsOfFoundFiles.add(new JavaFileAST(fileName, ast));
        }
        return astsOfFoundFiles;
    }

    private Set<Path> getJavaFilesInSourcePaths() throws JParserException {
        HashSet<Path> sourceFileToBeParsed = new HashSet<Path>();
        for (String path : this.javaSourcePaths) {
            sourceFileToBeParsed.addAll(this.getJavaFilesInPath(path));
        }
        return sourceFileToBeParsed;
    }

    private Set<Path> getJavaFilesInPath(String path) throws JParserException {
        Path mainDirectory = Paths.get((String)path, (String[])new String[0]);
        assert (mainDirectory.isDirectory()) : "Could not find directory at" + path;
        HashSet<Path> sourceFileToBeParsed = new HashSet<Path>();
        LinkedList<Path> directorysToBeSearched = new LinkedList<Path>();
        HashSet<Path> directorysReached = new HashSet<Path>();
        this.addDirectory(mainDirectory, directorysToBeSearched, directorysReached);
        while (!directorysToBeSearched.isEmpty()) {
            Path directory = (Path)directorysToBeSearched.poll();
            if (!directory.exists() || !directory.canRead()) continue;
            for (String fileName : directory.list()) {
                this.addFileWhereAppropriate(fileName, directory, sourceFileToBeParsed, directorysToBeSearched, directorysReached);
            }
        }
        return sourceFileToBeParsed;
    }

    private void addFileWhereAppropriate(String fileName, Path directory, Set<Path> sourceFileToBeParsed, Queue<Path> directorysToBeSearched, Set<Path> pDirectorysReached) {
        Path file = Paths.get((String)directory.getAbsolutePath(), (String[])new String[]{fileName});
        if (fileName.matches(JAVA_SOURCE_FILE_REGEX)) {
            this.addJavaFile(file, sourceFileToBeParsed);
        } else if (file.isDirectory()) {
            this.addDirectory(file, directorysToBeSearched, pDirectorysReached);
        }
    }

    private void addDirectory(Path file, Queue<Path> directorysToBeSearched, Set<Path> directorysReached) {
        if (file.exists() && file.canRead() && !directorysReached.contains(file)) {
            directorysToBeSearched.add(file);
            directorysReached.add(file);
        } else {
            this.logger.log(Level.WARNING, new Object[]{"No permission to read directory " + file.getName() + "."});
        }
    }

    private void addJavaFile(Path file, Set<Path> sourceFileToBeParsed) {
        if (file.exists() && file.canRead() && !sourceFileToBeParsed.contains(file)) {
            sourceFileToBeParsed.add(file);
        } else {
            this.logger.log(Level.WARNING, new Object[]{"No permission to read java file " + file.getName() + "."});
        }
    }

    @Override
    public ParseResult parseString(String pFilename, String pCode, CSourceOriginMapping sourceOriginMapping) throws JParserException {
        throw new JParserException("Function not yet implemented");
    }

    private CompilationUnit parse(Path file) throws JParserException {
        return this.parse(file, false);
    }

    private CompilationUnit parse(Path file, boolean ignoreMethodBody) throws JParserException {
        this.parser.setEnvironment(this.javaClassPaths, this.javaSourcePaths, this.getEncodings(), false);
        this.parser.setResolveBindings(true);
        this.parser.setStatementsRecovery(true);
        this.parser.setBindingsRecovery(true);
        Hashtable options = JavaCore.getOptions();
        JavaCore.setComplianceOptions((String)this.version, (Map)options);
        this.parser.setCompilerOptions((Map)options);
        this.parseTimer.start();
        try {
            String source = file.asCharSource(this.encoding).read();
            this.parser.setUnitName(file.getCanonicalPath());
            this.parser.setSource(source.toCharArray());
            this.parser.setIgnoreMethodBodies(ignoreMethodBody);
            CompilationUnit compilationUnit = (CompilationUnit)this.parser.createAST(null);
            return compilationUnit;
        }
        catch (IOException e) {
            throw new JParserException(e);
        }
        finally {
            this.parseTimer.stop();
        }
    }

    private String[] getEncodings() {
        Object[] encodings = new String[this.javaSourcePaths.length];
        Arrays.fill(encodings, this.encoding.name());
        return encodings;
    }

    private ParseResult buildCFA(CompilationUnit ast, Scope scope) throws JParserException {
        this.cfaTimer.start();
        CFABuilder builder = new CFABuilder(this.logger, scope);
        try {
            ast.accept((ASTVisitor)builder);
            String nextClassToBeParsed = builder.getScope().getNextClass();
            while (nextClassToBeParsed != null) {
                Path classFile = this.searchForClassFile(nextClassToBeParsed);
                if (classFile != null) {
                    this.cfaTimer.stop();
                    CompilationUnit astNext = this.parse(classFile);
                    this.cfaTimer.start();
                    astNext.accept((ASTVisitor)builder);
                }
                nextClassToBeParsed = builder.getScope().getNextClass();
            }
            DynamicBindingCreator tracker = new DynamicBindingCreator(builder);
            tracker.trackAndCreateDynamicBindings();
            ParseResult parseResult = new ParseResult(builder.getCFAs(), builder.getCFANodes(), builder.getStaticFieldDeclarations(), Language.JAVA);
            return parseResult;
        }
        catch (CFAGenerationRuntimeException e) {
            throw new JParserException(e);
        }
        finally {
            this.cfaTimer.stop();
        }
    }

    private Path searchForClassFile(String nextClassToBeParsed) {
        String classFilePathPart = nextClassToBeParsed.replace('.', File.separatorChar) + ".java";
        for (String sourcePath : this.javaSourcePaths) {
            Path file = Paths.get((String)sourcePath, (String[])new String[]{classFilePathPart});
            if (!file.exists()) continue;
            return file;
        }
        return null;
    }

    @Override
    public Timer getParseTime() {
        return this.parseTimer;
    }

    @Override
    public Timer getCFAConstructionTime() {
        return this.cfaTimer;
    }

    public static final class JavaFileAST {
        private final String fileName;
        private final CompilationUnit ast;

        public JavaFileAST(String pFileName, CompilationUnit pAst) {
            this.fileName = pFileName;
            this.ast = pAst;
        }

        public CompilationUnit getAst() {
            return this.ast;
        }

        public String getFileName() {
            return this.fileName;
        }
    }
}

