/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.parser.eclipse.java;

import com.google.common.base.Joiner;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;

final class NameConverter {
    private NameConverter() {
    }

    public static String convertName(IMethodBinding binding) {
        StringBuilder name = new StringBuilder(NameConverter.convertClassOrInterfaceName(binding.getDeclaringClass()) + "_" + binding.getName());
        Object[] typeNames = NameConverter.convertTypeNames(binding.getParameterTypes());
        if (typeNames.length > 0) {
            name.append("_");
        }
        Joiner.on((String)"_").appendTo(name, typeNames);
        return name.toString();
    }

    public static String[] convertTypeNames(ITypeBinding[] parameterTypes) {
        String[] typeNames = new String[parameterTypes.length];
        int c = 0;
        for (ITypeBinding parameterTypeBindings : parameterTypes) {
            ITypeBinding elementType;
            typeNames[c] = parameterTypeBindings.getBinaryName().equals("String") || parameterTypeBindings.getQualifiedName().equals("java.lang.String") ? "java_lang_String" : (parameterTypeBindings.isArray() ? ((elementType = parameterTypeBindings.getElementType()).getBinaryName().equals("String") || elementType.getQualifiedName().equals("java.lang.String") ? "String[]" : elementType.getQualifiedName() + "[]") : parameterTypeBindings.getQualifiedName());
            ++c;
        }
        return typeNames;
    }

    public static String convertName(IVariableBinding vb) {
        StringBuilder name = new StringBuilder();
        if (vb.isField() && vb.getDeclaringClass() != null) {
            String declaringClassName = vb.getDeclaringClass().getQualifiedName();
            name.append(declaringClassName + "_");
        }
        name.append(vb.getName());
        return name.toString();
    }

    public static String convertClassOrInterfaceName(ITypeBinding classBinding) {
        return classBinding.getQualifiedName();
    }

    public static String convertDefaultConstructorName(ITypeBinding classBinding) {
        return classBinding.getQualifiedName() + "_" + classBinding.getName();
    }
}

