/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.parser.eclipse.java;

import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.java.JConstructorDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.java.JFieldDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.java.JMethodDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.java.JParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.java.JSimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.java.JVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.java.VisibilityModifier;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.java.CFAGenerationRuntimeException;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.java.NameConverter;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.java.TypeHierarchy;
import org.sosy_lab.cpachecker.cfa.types.java.JClassOrInterfaceType;
import org.sosy_lab.cpachecker.cfa.types.java.JClassType;
import org.sosy_lab.cpachecker.cfa.types.java.JConstructorType;
import org.sosy_lab.cpachecker.cfa.types.java.JInterfaceType;
import org.sosy_lab.cpachecker.cfa.types.java.JMethodType;
import org.sosy_lab.cpachecker.cfa.types.java.JSimpleType;
import org.sosy_lab.cpachecker.cfa.types.java.JType;

class Scope {
    private static final String RETURN_VAR_NAME = "__retval__";
    private final TypeHierarchy typeHierachy;
    private final LinkedList<Map<String, JSimpleDeclaration>> varsStack = Lists.newLinkedList();
    private final LinkedList<Map<String, JSimpleDeclaration>> varsList = Lists.newLinkedList();
    private final Map<String, JMethodDeclaration> methods;
    private final Map<String, JFieldDeclaration> fields;
    private String currentMethodName = null;
    private Optional<JVariableDeclaration> returnVariable;
    private JClassOrInterfaceType currentClassType = null;
    private final Stack<JClassOrInterfaceType> classStack = new Stack();
    private final String fullyQualifiedMainClassName;
    private final Queue<String> classesToBeParsed = new ConcurrentLinkedQueue<String>();
    private final Set<String> registeredClasses = new HashSet<String>();
    private int depth = 0;

    public Scope(String pFullyQualifiedMainClassName, TypeHierarchy pTypeHierarchy) {
        this.fullyQualifiedMainClassName = pFullyQualifiedMainClassName;
        this.enterProgramScope();
        this.registeredClasses.add(this.fullyQualifiedMainClassName);
        this.methods = pTypeHierarchy.getMethodDeclarations();
        this.fields = pTypeHierarchy.getFieldDeclarations();
        this.typeHierachy = pTypeHierarchy;
    }

    private void enterProgramScope() {
        this.varsStack.addLast(new HashMap());
        this.varsList.addLast(this.varsStack.getLast());
    }

    public boolean isProgramScope() {
        return this.varsStack.size() == 1 && this.depth == 0;
    }

    public boolean isTopClassScope() {
        return this.varsStack.size() == 1 && this.depth == 1;
    }

    public void enterMethod(JMethodDeclaration methodDef) {
        this.currentMethodName = methodDef.getOrigName();
        this.returnVariable = Optional.fromNullable((Object)this.createFunctionReturnVariable(methodDef));
        this.enterBlock();
    }

    private JVariableDeclaration createFunctionReturnVariable(JMethodDeclaration pMethod) {
        FileLocation fileLocation = pMethod.getFileLocation();
        JType returnType = (JType)pMethod.getType().getReturnType();
        String qualifiedReturnVarName = this.createQualifiedName(RETURN_VAR_NAME);
        if (JSimpleType.getVoid().equals(returnType)) {
            return null;
        }
        return new JVariableDeclaration(fileLocation, returnType, RETURN_VAR_NAME, RETURN_VAR_NAME, qualifiedReturnVarName, null, false);
    }

    public Optional<JVariableDeclaration> getReturnVariable() {
        Preconditions.checkState((this.returnVariable != null ? 1 : 0) != 0);
        return this.returnVariable;
    }

    public String createQualifiedName(String pVariableName) {
        return this.getCurrentMethodName() + "::" + pVariableName;
    }

    public void enterClass(JClassOrInterfaceType enteredClassType) {
        ++this.depth;
        if (!this.typeHierachy.containsType(enteredClassType)) {
            throw new CFAGenerationRuntimeException("Could not find Type for Class" + enteredClassType.getName());
        }
        if (this.depth > 0) {
            this.classStack.push(this.currentClassType);
        }
        this.currentClassType = enteredClassType;
        assert (this.depth >= 0);
    }

    public void leaveClass() {
        --this.depth;
        if (this.depth == 0) {
            this.currentClassType = null;
        } else {
            if (this.classStack.isEmpty()) {
                throw new CFAGenerationRuntimeException("Could not find enclosing class of nested class " + this.currentClassType);
            }
            this.currentClassType = this.classStack.pop();
        }
        assert (this.depth >= 0);
    }

    public void leaveMethod() {
        Preconditions.checkState((!this.isTopClassScope() ? 1 : 0) != 0);
        this.varsStack.removeLast();
        while (this.varsList.size() > this.varsStack.size()) {
            this.varsList.removeLast();
        }
        this.currentMethodName = null;
    }

    public void enterBlock() {
        this.varsStack.addLast(new HashMap());
        this.varsList.addLast(this.varsStack.getLast());
    }

    public void leaveBlock() {
        Preconditions.checkState((this.varsStack.size() > 2 ? 1 : 0) != 0);
        this.varsStack.removeLast();
    }

    public boolean variableNameInUse(String name, String origName) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)origName);
        Iterator<Map<String, JSimpleDeclaration>> it = this.varsList.descendingIterator();
        while (it.hasNext()) {
            Map<String, JSimpleDeclaration> vars = it.next();
            JSimpleDeclaration binding = vars.get(origName);
            if (binding != null && binding.getName().equals(name)) {
                return true;
            }
            binding = vars.get(name);
            if (binding == null || !binding.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public JSimpleDeclaration lookupVariable(String name) {
        Preconditions.checkNotNull((Object)name);
        Iterator<Map<String, JSimpleDeclaration>> it = this.varsStack.descendingIterator();
        while (it.hasNext()) {
            Map<String, JSimpleDeclaration> vars = it.next();
            JSimpleDeclaration binding = vars.get(name);
            if (binding == null) continue;
            return binding;
        }
        if (this.fields.containsKey(name)) {
            return this.fields.get(name);
        }
        return null;
    }

    public JMethodDeclaration lookupMethod(String name) {
        return this.methods.get(Preconditions.checkNotNull((Object)name));
    }

    public boolean isMethodRegistered(String name) {
        return this.methods.containsKey(Preconditions.checkNotNull((Object)name));
    }

    public void registerDeclarationOfThisClass(JSimpleDeclaration declaration) {
        Preconditions.checkArgument((declaration instanceof JVariableDeclaration || declaration instanceof JParameterDeclaration ? 1 : 0) != 0, (Object)("Tried to register a declaration which does not define a name in the standard namespace: " + declaration));
        Preconditions.checkArgument((!(declaration instanceof JFieldDeclaration) ? 1 : 0) != 0, (Object)"Can't register a field declaration, it has to be updated within the type Hierarchy");
        String name = declaration.getOrigName();
        assert (name != null);
        Map<String, JSimpleDeclaration> vars = this.varsStack.getLast();
        if (this.isProgramScope()) {
            throw new CFAGenerationRuntimeException("Could not find Class for Declaration " + declaration.getName(), declaration);
        }
        if (vars.containsKey(name)) {
            throw new CFAGenerationRuntimeException("Variable " + name + " already declared", declaration);
        }
        vars.put(name, declaration);
    }

    public String getCurrentMethodName() {
        return this.currentMethodName;
    }

    public String toString() {
        return "Functions: " + Joiner.on((char)' ').join(this.methods.keySet());
    }

    public void registerClass(ITypeBinding classBinding) {
        String className = classBinding.getQualifiedName();
        String topClassName = this.getTopLevelClass(classBinding);
        LinkedList<JClassOrInterfaceType> toBeAdded = new LinkedList<JClassOrInterfaceType>();
        if (!this.registeredClasses.contains(className)) {
            if (!this.registeredClasses.contains(topClassName)) {
                this.classesToBeParsed.add(topClassName);
            }
            this.registeredClasses.add(className);
        } else if (!this.fullyQualifiedMainClassName.equals(className)) {
            return;
        }
        JClassOrInterfaceType type = this.typeHierachy.getType(NameConverter.convertClassOrInterfaceName(classBinding));
        toBeAdded.addAll(type.getAllSubTypesOfType());
        for (JClassOrInterfaceType subClassType : toBeAdded) {
            String name = subClassType.getName();
            if (this.registeredClasses.contains(name)) continue;
            this.registeredClasses.add(name);
            this.classesToBeParsed.add(name);
        }
    }

    private String getTopLevelClass(ITypeBinding classBinding) {
        ITypeBinding nextClass = classBinding;
        ITypeBinding declaringClass = nextClass.getDeclaringClass();
        while (declaringClass != null) {
            nextClass = declaringClass;
            declaringClass = nextClass.getDeclaringClass();
        }
        assert (nextClass.isTopLevel());
        return nextClass.getQualifiedName();
    }

    public String getNextClass() {
        if (this.classesToBeParsed.isEmpty()) {
            return null;
        }
        return this.classesToBeParsed.poll();
    }

    public String getfullyQualifiedMainClassName() {
        return this.fullyQualifiedMainClassName;
    }

    public JClassOrInterfaceType getCurrentClassType() {
        return this.currentClassType;
    }

    public Set<JFieldDeclaration> getFieldDeclarations(JClassOrInterfaceType pType) {
        return this.typeHierachy.getFieldDeclarations(pType);
    }

    public Map<String, JFieldDeclaration> getStaticFieldDeclarations() {
        HashMap<String, JFieldDeclaration> result = new HashMap<String, JFieldDeclaration>();
        for (JFieldDeclaration declaration : this.fields.values()) {
            if (!declaration.isStatic()) continue;
            result.put(declaration.getName(), declaration);
        }
        return result;
    }

    public Map<String, JFieldDeclaration> getNonStaticFieldDeclarationOfClass(JClassOrInterfaceType pType) {
        HashMap<String, JFieldDeclaration> result = new HashMap<String, JFieldDeclaration>();
        if (this.typeHierachy.isExternType(pType)) {
            return result;
        }
        Set<JFieldDeclaration> fieldDecls = this.getFieldDeclarations(pType);
        for (JFieldDeclaration declaration : fieldDecls) {
            if (declaration.isStatic()) continue;
            result.put(declaration.getName(), declaration);
        }
        return result;
    }

    public String getFileOfCurrentType() {
        if (this.typeHierachy.containsType(this.currentClassType)) {
            return this.typeHierachy.getFileOfType(this.currentClassType);
        }
        return "";
    }

    public boolean containsInterfaceType(String typeName) {
        return this.typeHierachy.containsInterfaceType(typeName);
    }

    public JInterfaceType getInterfaceType(String typeName) {
        return this.typeHierachy.getInterfaceType(typeName);
    }

    public boolean containsClassType(String pTypeName) {
        return this.typeHierachy.containsClassType(pTypeName);
    }

    public JClassType getClassType(String pTypeName) {
        return this.typeHierachy.getClassType(pTypeName);
    }

    public JInterfaceType createNewInterfaceType(ITypeBinding pTypeBinding) {
        this.typeHierachy.updateTypeHierarchy(pTypeBinding);
        String newTypeName = NameConverter.convertClassOrInterfaceName(pTypeBinding);
        if (this.containsInterfaceType(newTypeName)) {
            return this.getInterfaceType(newTypeName);
        }
        return JInterfaceType.createUnresolvableType();
    }

    public JClassType createNewClassType(ITypeBinding pTypeBinding) {
        this.typeHierachy.updateTypeHierarchy(pTypeBinding);
        String newTypeName = NameConverter.convertClassOrInterfaceName(pTypeBinding);
        if (this.containsClassType(newTypeName)) {
            return this.getClassType(newTypeName);
        }
        return JClassType.createUnresolvableType();
    }

    public JMethodDeclaration createExternMethodDeclaration(JMethodType pConvertMethodType, String pName, String pSimpleName, VisibilityModifier pPublic, boolean pFinal, boolean pAbstract, boolean pStatic, boolean pNative, boolean pSynchronized, boolean pStrictFp, JClassOrInterfaceType pDeclaringClassType) {
        JMethodDeclaration decl = JMethodDeclaration.createExternMethodDeclaration(pConvertMethodType, pName, pSimpleName, pPublic, pFinal, pAbstract, pStatic, pNative, pSynchronized, pStrictFp, pDeclaringClassType);
        Preconditions.checkArgument((!this.methods.containsKey(decl.getName()) ? 1 : 0) != 0);
        this.methods.put(decl.getName(), decl);
        return decl;
    }

    public JConstructorDeclaration createExternConstructorDeclaration(JConstructorType pConvertConstructorType, String pName, String pSimpleName, VisibilityModifier pVisibility, boolean pStrictFp, JClassType pDeclaringClassType) {
        JConstructorDeclaration decl = JConstructorDeclaration.createExternConstructorDeclaration(pConvertConstructorType, pName, pSimpleName, pVisibility, pStrictFp, pDeclaringClassType);
        Preconditions.checkArgument((!this.methods.containsKey(decl.getName()) ? 1 : 0) != 0);
        this.methods.put(decl.getName(), decl);
        return decl;
    }

    public boolean isFieldRegistered(String pFieldName) {
        return this.fields.containsKey(pFieldName);
    }

    public JFieldDeclaration lookupField(String pFieldName) {
        Preconditions.checkArgument((boolean)this.fields.containsKey(pFieldName));
        return this.fields.get(pFieldName);
    }

    public JFieldDeclaration createExternFieldDeclaration(JType pType, String pName, String pSimpleName, boolean pIsFinal, boolean pIsStatic, VisibilityModifier pVisibility, boolean pIsVolatile, boolean pIsTransient) {
        JFieldDeclaration decl = JFieldDeclaration.createExternFieldDeclaration(pType, pName, pSimpleName, pIsFinal, pIsStatic, pIsTransient, pIsVolatile, pVisibility);
        Preconditions.checkArgument((!this.fields.containsKey(decl.getName()) ? 1 : 0) != 0);
        this.fields.put(decl.getName(), decl);
        return decl;
    }

    public TypeHierarchy getTypeHierarchy() {
        return this.typeHierachy;
    }
}

