/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.parser.eclipse.java;

import com.google.common.base.Joiner;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sosy_lab.cpachecker.cfa.ast.java.JFieldDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.java.JMethodDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.java.JParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.java.VisibilityModifier;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.java.Scope;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.java.TypeHierarchy;
import org.sosy_lab.cpachecker.cfa.types.java.JClassOrInterfaceType;
import org.sosy_lab.cpachecker.cfa.types.java.JClassType;
import org.sosy_lab.cpachecker.cfa.types.java.JInterfaceType;

class THDotBuilder {
    private static final String NORMAL = "normal";
    private static final String EMPTY = "empty";
    private static final String NONE = "none";
    private static final String SOLID = "solid";
    private static final String DASHED = "dashed";
    private static final String ODOT = "odot";
    private final Appendable sb;
    private final Set<JClassOrInterfaceType> types;
    private final TypeHierarchy typeHierarchy;

    private THDotBuilder(Appendable pSb, Set<JClassOrInterfaceType> pTypes, TypeHierarchy pTypeHierarchy) {
        this.sb = pSb;
        this.types = pTypes;
        this.typeHierarchy = pTypeHierarchy;
    }

    public static void generateDOT(Appendable pW, Scope scope) throws IOException {
        Set<JClassOrInterfaceType> types = scope.getTypeHierarchy().getTypes();
        THDotBuilder builder = new THDotBuilder(pW, types, scope.getTypeHierarchy());
        builder.generateTypeHierarchyDOT();
    }

    private void generateTypeHierarchyDOT() throws IOException {
        this.generateHeader();
        for (JClassOrInterfaceType type : this.types) {
            this.addNodeDefinition(type);
        }
        this.addEdges();
        this.generateTail();
    }

    private void generateTail() throws IOException {
        this.sb.append("}");
    }

    private void addEdges() throws IOException {
        this.addSuperTypeEdges();
        this.addImplementsInterfaceEdges();
        this.addEnclosingTypeEdges();
    }

    private void addEnclosingTypeEdges() throws IOException {
        this.appendEdgeStyle(NORMAL, SOLID, ODOT);
        for (JClassOrInterfaceType type : this.types) {
            if (type.isTopLevel()) continue;
            this.addEnclosingType(type);
        }
    }

    private void addEnclosingType(JClassOrInterfaceType pType) throws IOException {
        String typeName = NameConverter.getNodeName(pType);
        JClassOrInterfaceType enclosingType = pType.getEnclosingType();
        String enclosingTypeName = NameConverter.getNodeName(enclosingType);
        this.addEdge(typeName, enclosingTypeName);
    }

    private void appendEdgeStyle(String arrowhead, String style, String arrowtail) throws IOException {
        this.sb.append("        edge [\n");
        this.sb.append("                  arrowhead = \"" + arrowhead + "\"\n");
        this.sb.append("                  style = \"" + style + "\"\n");
        this.sb.append("                  arrowtail = \"" + arrowtail + "\"\n");
        this.sb.append("        ]\n");
        this.sb.append("\n");
    }

    private void addImplementsInterfaceEdges() throws IOException {
        this.appendEdgeStyle(EMPTY, DASHED, NONE);
        for (JClassOrInterfaceType type : this.types) {
            if (!(type instanceof JClassType)) continue;
            this.addImplementsInterfaceEdge((JClassType)type);
        }
    }

    private void addImplementsInterfaceEdge(JClassType pType) throws IOException {
        String typeName = NameConverter.getNodeName(pType);
        Set<JInterfaceType> implementedInterfaces = pType.getImplementedInterfaces();
        for (JInterfaceType implementedInterface : implementedInterfaces) {
            String superTypeName = NameConverter.getNodeName(implementedInterface);
            this.addEdge(typeName, superTypeName);
        }
    }

    private void addSuperTypeEdges() throws IOException {
        this.appendEdgeStyle(EMPTY, SOLID, NONE);
        for (JClassOrInterfaceType type : this.types) {
            if (type instanceof JClassType) {
                this.addSuperTypeEdges((JClassType)type);
                continue;
            }
            if (!(type instanceof JInterfaceType)) continue;
            this.addSuperTypeEdges((JInterfaceType)type);
        }
    }

    private void addSuperTypeEdges(JInterfaceType pType) throws IOException {
        Set<JInterfaceType> superTypes = pType.getSuperInterfaces();
        String typeName = NameConverter.getNodeName(pType);
        for (JInterfaceType superType : superTypes) {
            String superTypeName = NameConverter.getNodeName(superType);
            this.addEdge(typeName, superTypeName);
        }
    }

    private void addEdge(String sourceTypeName, String destTypeName) throws IOException {
        this.sb.append("        ");
        this.sb.append(sourceTypeName);
        this.sb.append(" -> ");
        this.sb.append(destTypeName);
        this.sb.append("\n");
    }

    private void addSuperTypeEdges(JClassType pType) throws IOException {
        JClassType superType = pType.getParentClass();
        if (superType == null) {
            return;
        }
        String typeName = NameConverter.getNodeName(pType);
        String superTypeName = NameConverter.getNodeName(superType);
        this.addEdge(typeName, superTypeName);
    }

    private void addNodeDefinition(JClassOrInterfaceType pType) throws IOException {
        Set<JFieldDeclaration> fieldDecl = new HashSet<JFieldDeclaration>();
        Set<JMethodDeclaration> methodDecl = new HashSet<JMethodDeclaration>();
        boolean isExternType = this.typeHierarchy.isExternType(pType);
        if (!isExternType) {
            fieldDecl = this.typeHierarchy.getFieldDeclarations(pType);
            methodDecl = this.typeHierarchy.getMethodDeclarations(pType);
        }
        this.addNodeDefinition(pType, isExternType, fieldDecl, methodDecl);
    }

    private void addNodeDefinition(JClassOrInterfaceType pType, boolean pIsExternType, Set<JFieldDeclaration> pFieldDecl, Set<JMethodDeclaration> pMethodDecl) throws IOException {
        String nodeName = NameConverter.getNodeName(pType);
        String label = this.getLabelContentOfNode(pType, pIsExternType, pFieldDecl, pMethodDecl);
        this.sb.append("        " + nodeName + " [\n");
        this.sb.append("                  label = \"" + label + "\"\n");
        this.sb.append("        ]\n");
        this.sb.append("\n");
    }

    private String getLabelContentOfNode(JClassOrInterfaceType pType, boolean pIsExternType, Set<JFieldDeclaration> pFieldDecl, Set<JMethodDeclaration> pMethodDecl) {
        StringBuilder label = new StringBuilder();
        label.append("{");
        this.appendNameRowToLabel(label, pType, pIsExternType);
        this.appendAttributesToLabel(label, pType, pFieldDecl);
        this.appendMethodsToLabel(label, pType, pMethodDecl);
        label.append("}");
        return label.toString();
    }

    private void appendMethodsToLabel(StringBuilder pLabel, JClassOrInterfaceType pType, Set<JMethodDeclaration> pMethodDecl) {
        for (JMethodDeclaration method : pMethodDecl) {
            this.appendMethodToLabel(pLabel, pType, method);
        }
    }

    private void appendMethodToLabel(StringBuilder pLabel, JClassOrInterfaceType pType, JMethodDeclaration pMethod) {
        String visibilityLabel = this.getVisibilityLabel(pMethod);
        String methodName = pMethod.getSimpleName();
        String typeString = pMethod.getType().getReturnType().toASTString("");
        String parameters = this.getParameterLabel(pLabel, pMethod.getParameters());
        pLabel.append(visibilityLabel);
        pLabel.append(" ");
        pLabel.append(methodName);
        pLabel.append("(");
        pLabel.append(parameters);
        pLabel.append(")");
        pLabel.append(": ");
        pLabel.append(typeString);
        pLabel.append("\\l");
    }

    private String getParameterLabel(StringBuilder pLabel, List<JParameterDeclaration> pParameters) {
        ArrayList<String> parameterStrings = new ArrayList<String>(pParameters.size());
        for (JParameterDeclaration param : pParameters) {
            parameterStrings.add(this.getParameterLabel(param));
        }
        return Joiner.on((String)",").join(parameterStrings);
    }

    private String getParameterLabel(JParameterDeclaration pParam) {
        String paramName = pParam.getName();
        String paramType = pParam.getType().toASTString("");
        return paramName + ":" + paramType;
    }

    private String getVisibilityLabel(JMethodDeclaration pMethod) {
        return this.getVisibilityLabel(pMethod.getVisibility());
    }

    private void appendAttributesToLabel(StringBuilder pLabel, JClassOrInterfaceType pType, Set<JFieldDeclaration> pFieldDecl) {
        for (JFieldDeclaration attr : pFieldDecl) {
            this.appendAttributToLabel(pLabel, pType, attr);
        }
        pLabel.append("|");
    }

    private void appendAttributToLabel(StringBuilder pLabel, JClassOrInterfaceType pType, JFieldDeclaration pAttr) {
        String visibilityLabel = this.getVisibilityLabel(pAttr);
        String fieldName = pAttr.getSimpleName();
        String typeName = pAttr.getType().toASTString("");
        pLabel.append(visibilityLabel);
        pLabel.append(fieldName);
        pLabel.append(": ");
        pLabel.append(typeName);
        pLabel.append("\\l");
    }

    private String getVisibilityLabel(JFieldDeclaration pAttr) {
        return this.getVisibilityLabel(pAttr.getVisibility());
    }

    private String getVisibilityLabel(VisibilityModifier visibility) {
        switch (visibility) {
            case PUBLIC: {
                return "+";
            }
            case PROTECTED: {
                return "#";
            }
            case NONE: {
                return "";
            }
            case PRIVATE: {
                return "-";
            }
        }
        throw new AssertionError();
    }

    private void appendNameRowToLabel(StringBuilder pLabel, JClassOrInterfaceType pType, boolean pIsExternType) {
        String simpleName = pType.getSimpleName();
        pLabel.append(simpleName + "|");
    }

    private void generateHeader() throws IOException {
        this.sb.append("digraph TypeHierarchy { \n");
        this.sb.append("        fontname = \"Bitstream Vera Sans\"\n");
        this.sb.append("        fontsize = 8\n");
        this.sb.append("\n");
        this.sb.append("        node [\n");
        this.sb.append("                  fontname = \"Bitstream Vera Sans\"\n");
        this.sb.append("                  fontsize = 8\n");
        this.sb.append("                  shape = \"record\"\n");
        this.sb.append("        ]\n");
        this.sb.append("\n");
        this.sb.append("        edge [\n");
        this.sb.append("                  fontname = \"Bitstream Vera Sans\"\n");
        this.sb.append("                  fontsize = 8\n");
        this.sb.append("        ]\n");
        this.sb.append("\n");
    }

    private static class NameConverter {
        private NameConverter() {
        }

        private static String getNodeName(JClassOrInterfaceType pType) {
            return NameConverter.escapeNodeName(pType.getName());
        }

        private static String escapeNodeName(String nodeName) {
            return nodeName.replace(".", "_");
        }
    }
}

