/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.parser.eclipse.java;

import com.google.common.base.Preconditions;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.java.ASTConverter;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.java.CFAGenerationRuntimeException;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.java.NameConverter;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.java.TypeConverter;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.java.TypeHierarchy;
import org.sosy_lab.cpachecker.cfa.types.java.JClassOrInterfaceType;
import org.sosy_lab.cpachecker.cfa.types.java.JClassType;
import org.sosy_lab.cpachecker.cfa.types.java.JInterfaceType;

class THTypeConverter
extends TypeConverter {
    private final TypeHierarchy.THTypeTable typeTable;

    public THTypeConverter(TypeHierarchy.THTypeTable pTypeTable) {
        this.typeTable = pTypeTable;
    }

    @Override
    public JClassType convertClassType(ITypeBinding t) {
        JClassType resultType;
        Preconditions.checkArgument((t.isClass() || t.isEnum() ? 1 : 0) != 0);
        String typeName = NameConverter.convertClassOrInterfaceName(t);
        if (this.typeTable.containsType(typeName)) {
            JClassOrInterfaceType type = this.typeTable.getType(typeName);
            if (type instanceof JClassType) {
                return (JClassType)type;
            }
            throw new CFAGenerationRuntimeException("Class Type " + typeName + " was parsed as Interface.");
        }
        ITypeBinding superClass = t.getSuperclass();
        JClassType superClassType = superClass != null ? this.convertClassType(superClass) : JClassType.createUnresolvableType();
        ITypeBinding[] interfaceBindings = t.getInterfaces();
        HashSet<JInterfaceType> interfaces = new HashSet<JInterfaceType>();
        for (ITypeBinding itInterface : interfaceBindings) {
            interfaces.add(this.convertInterfaceType(itInterface));
        }
        if (t.isTopLevel()) {
            resultType = this.createClassType(t, superClassType, interfaces);
        } else {
            JClassOrInterfaceType enclosingType = this.convertEnclosingType(t);
            resultType = this.createClassType(t, superClassType, interfaces, enclosingType);
        }
        this.typeTable.registerType(resultType);
        return resultType;
    }

    @Override
    public JInterfaceType convertInterfaceType(ITypeBinding t) {
        JInterfaceType type;
        if (t.isClass()) {
            return JInterfaceType.createUnresolvableType();
        }
        Preconditions.checkArgument((boolean)t.isInterface());
        String typeName = NameConverter.convertClassOrInterfaceName(t);
        if (this.typeTable.containsType(typeName)) {
            JClassOrInterfaceType type2 = this.typeTable.getType(typeName);
            if (type2 instanceof JInterfaceType) {
                return (JInterfaceType)type2;
            }
            throw new CFAGenerationRuntimeException("Interface type " + typeName + " was parsed as class type.");
        }
        ITypeBinding[] interfaceBindings = t.getInterfaces();
        HashSet<JInterfaceType> interfaces = new HashSet<JInterfaceType>();
        for (ITypeBinding itInterface : interfaceBindings) {
            interfaces.add(this.convertInterfaceType(itInterface));
        }
        if (t.isTopLevel()) {
            type = this.createInterfaceType(t, interfaces);
        } else {
            JClassOrInterfaceType enclosingType = this.convertEnclosingType(t);
            type = this.createInterfaceType(t, interfaces, enclosingType);
        }
        this.typeTable.registerType(type);
        return type;
    }

    private JClassOrInterfaceType convertEnclosingType(ITypeBinding pT) {
        ITypeBinding enclosingTypeBinding = pT.getDeclaringClass();
        if (enclosingTypeBinding == null) {
            return JClassType.createUnresolvableType();
        }
        return this.convertClassOrInterfaceType(enclosingTypeBinding);
    }

    private JClassType createClassType(ITypeBinding t, JClassType pSuperClass, Set<JInterfaceType> pImplementedInterfaces) {
        Preconditions.checkArgument((boolean)t.isTopLevel());
        String name = NameConverter.convertClassOrInterfaceName(t);
        String simpleName = t.getName();
        ASTConverter.ModifierBean mB = ASTConverter.ModifierBean.getModifiers(t);
        return JClassType.valueOf(name, simpleName, mB.getVisibility(), mB.isFinal(), mB.isNative(), mB.isStrictFp(), pSuperClass, pImplementedInterfaces);
    }

    private JInterfaceType createInterfaceType(ITypeBinding t, Set<JInterfaceType> pExtendedInterfaces) {
        Preconditions.checkArgument((boolean)t.isTopLevel());
        String name = NameConverter.convertClassOrInterfaceName(t);
        String simpleName = t.getName();
        ASTConverter.ModifierBean mB = ASTConverter.ModifierBean.getModifiers(t);
        return JInterfaceType.valueOf(name, simpleName, mB.getVisibility(), pExtendedInterfaces);
    }

    private JClassType createClassType(ITypeBinding t, JClassType pSuperClass, Set<JInterfaceType> pImplementedInterfaces, JClassOrInterfaceType pEnclosingType) {
        Preconditions.checkArgument((!t.isTopLevel() ? 1 : 0) != 0);
        String name = NameConverter.convertClassOrInterfaceName(t);
        String simpleName = t.getName();
        ASTConverter.ModifierBean mB = ASTConverter.ModifierBean.getModifiers(t);
        return JClassType.valueOf(name, simpleName, mB.getVisibility(), mB.isFinal(), mB.isNative(), mB.isStrictFp(), pSuperClass, pImplementedInterfaces, pEnclosingType);
    }

    private JInterfaceType createInterfaceType(ITypeBinding t, Set<JInterfaceType> pExtendedInterfaces, JClassOrInterfaceType pEnclosingType) {
        Preconditions.checkArgument((!t.isTopLevel() ? 1 : 0) != 0);
        String name = NameConverter.convertClassOrInterfaceName(t);
        String simpleName = t.getName();
        ASTConverter.ModifierBean mB = ASTConverter.ModifierBean.getModifiers(t);
        return JInterfaceType.valueOf(name, simpleName, mB.getVisibility(), pExtendedInterfaces, pEnclosingType);
    }
}

