/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.parser.eclipse.java;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import javax.annotation.Nullable;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.java.JConstructorDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.java.JFieldDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.java.JMethodDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.java.JParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.java.ASTConverter;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.java.NameConverter;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.java.THTypeConverter;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.java.TypeHierarchy;
import org.sosy_lab.cpachecker.cfa.types.java.JClassOrInterfaceType;
import org.sosy_lab.cpachecker.cfa.types.java.JClassType;
import org.sosy_lab.cpachecker.cfa.types.java.JConstructorType;
import org.sosy_lab.cpachecker.cfa.types.java.JMethodType;
import org.sosy_lab.cpachecker.cfa.types.java.JType;

class TypeHierachyConverter {
    public final LogManager logger;
    public final THTypeConverter typeConverter;

    public TypeHierachyConverter(LogManager pLogger, TypeHierarchy.THTypeTable pTypeTable) {
        this.logger = pLogger;
        this.typeConverter = new THTypeConverter(pTypeTable);
    }

    public JMethodDeclaration convert(MethodDeclaration md, String pFileOfDeclaration) {
        IMethodBinding methodBinding = md.resolveBinding();
        if (methodBinding == null) {
            this.logger.log(Level.WARNING, new Object[]{md.getName()});
            this.logger.log(Level.WARNING, new Object[]{" can't be resolved."});
            return JMethodDeclaration.createUnresolvedMethodDeclaration();
        }
        String methodName = NameConverter.convertName(methodBinding);
        String simpleName = methodBinding.getName();
        ASTConverter.ModifierBean mb = ASTConverter.ModifierBean.getModifiers(md.modifiers());
        List<JParameterDeclaration> param = this.convertParameterList(md.parameters(), pFileOfDeclaration, methodName);
        ImmutableList parameterTypes = FluentIterable.from(param).transform((Function)new Function<JParameterDeclaration, JType>(){

            @Nullable
            public JType apply(@Nullable JParameterDeclaration pDecl) {
                Preconditions.checkNotNull((Object)pDecl);
                return pDecl.getType();
            }
        }).toList();
        FileLocation fileLoc = this.convertFileLocation((ASTNode)md, pFileOfDeclaration);
        if (md.isConstructor()) {
            JClassType declaringClass = this.convertClassOfConstructor(md);
            JConstructorType type = new JConstructorType(declaringClass, (List<JType>)parameterTypes, md.isVarargs());
            return new JConstructorDeclaration(fileLoc, type, methodName, simpleName, param, mb.getVisibility(), mb.isStrictFp(), declaringClass);
        }
        boolean isAbstract = mb.isAbstract() || md.resolveBinding().getDeclaringClass().isInterface();
        JMethodType methodType = new JMethodType(this.convert(md.getReturnType2()), (List<JType>)parameterTypes, md.isVarargs());
        JClassOrInterfaceType declaringClass = this.convertDeclaringClassType(md);
        return new JMethodDeclaration(fileLoc, methodType, methodName, simpleName, param, mb.getVisibility(), mb.isFinal(), isAbstract, mb.isStatic(), mb.isNative(), mb.isSynchronized(), mb.isStrictFp(), declaringClass);
    }

    public Set<JFieldDeclaration> convert(FieldDeclaration fd, String pFileOfDeclaration) {
        HashSet<JFieldDeclaration> result = new HashSet<JFieldDeclaration>();
        Type type = fd.getType();
        FileLocation fileLoc = this.convertFileLocation((ASTNode)fd, pFileOfDeclaration);
        ASTConverter.ModifierBean mB = ASTConverter.ModifierBean.getModifiers(fd.modifiers());
        assert (!mB.isAbstract()) : "Field Variable has this modifier?";
        assert (!mB.isNative()) : "Field Variable has this modifier?";
        assert (!mB.isStrictFp()) : "Field Variable has this modifier?";
        assert (!mB.isSynchronized()) : "Field Variable has this modifier?";
        List vdfs = fd.fragments();
        for (VariableDeclarationFragment vdf : vdfs) {
            result.add(this.handleFragment(vdf, type, fileLoc, mB));
        }
        Preconditions.checkArgument((!result.isEmpty() ? 1 : 0) != 0);
        return result;
    }

    private JFieldDeclaration handleFragment(VariableDeclarationFragment vdf, Type type, FileLocation fileLoc, ASTConverter.ModifierBean mB) {
        IVariableBinding vB = vdf.resolveBinding();
        Preconditions.checkNotNull((Object)vdf, (Object)("Can't resolve binding of field declaration " + vdf.getName().getFullyQualifiedName()));
        String qualifiedName = NameConverter.convertName(vB);
        String simpleName = vB.getName();
        JFieldDeclaration newD = new JFieldDeclaration(fileLoc, this.convert(type), qualifiedName, simpleName, mB.isFinal(), mB.isStatic(), mB.isTransient(), mB.isVolatile(), mB.getVisibility());
        return newD;
    }

    private JClassOrInterfaceType convertDeclaringClassType(MethodDeclaration md) {
        IMethodBinding methodBinding = md.resolveBinding();
        if (methodBinding == null) {
            return JClassType.createUnresolvableType();
        }
        ITypeBinding typeBinding = methodBinding.getDeclaringClass();
        if (typeBinding == null) {
            return JClassType.createUnresolvableType();
        }
        return this.typeConverter.convertClassOrInterfaceType(typeBinding);
    }

    private JClassType convertClassOfConstructor(MethodDeclaration md) {
        JClassOrInterfaceType type = this.convertDeclaringClassType(md);
        if (type instanceof JClassType) {
            return (JClassType)type;
        }
        return JClassType.createUnresolvableType();
    }

    private List<JParameterDeclaration> convertParameterList(List<SingleVariableDeclaration> ps, String fileOfDeclaration, String methodName) {
        ArrayList<JParameterDeclaration> paramsList = new ArrayList<JParameterDeclaration>(ps.size());
        for (SingleVariableDeclaration c : ps) {
            paramsList.add(this.convertParameter(c, fileOfDeclaration, methodName));
        }
        return paramsList;
    }

    private JParameterDeclaration convertParameter(SingleVariableDeclaration p, String fileOfDeclaration, String methodName) {
        JType type = this.convert(p.getType());
        ASTConverter.ModifierBean mb = ASTConverter.ModifierBean.getModifiers(p.getModifiers());
        String qualifiedName = p.getName().getFullyQualifiedName();
        return new JParameterDeclaration(this.convertFileLocation((ASTNode)p, fileOfDeclaration), type, qualifiedName, methodName + "::" + qualifiedName, mb.isFinal());
    }

    private JType convert(Type pType) {
        return this.typeConverter.convert(pType);
    }

    private FileLocation convertFileLocation(ASTNode l, String fileOfDeclaration) {
        if (l == null) {
            return FileLocation.DUMMY;
        }
        if (l.getRoot().getNodeType() != 15) {
            this.logger.log(Level.WARNING, new Object[]{"Can't find Placement Information for :" + l.toString()});
            return FileLocation.DUMMY;
        }
        CompilationUnit co = (CompilationUnit)l.getRoot();
        return new FileLocation(co.getLineNumber(l.getLength() + l.getStartPosition()), fileOfDeclaration, l.getLength(), l.getStartPosition(), co.getLineNumber(l.getStartPosition()));
    }

    public JClassOrInterfaceType convertClassOrInterfaceType(ITypeBinding pTypeBinding) {
        return this.typeConverter.convertClassOrInterfaceType(pTypeBinding);
    }
}

