/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.parser.eclipse.java;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.ast.java.JFieldDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.java.JMethodDeclaration;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.java.EclipseJavaParser;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.java.TypeHierachyConverter;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.java.TypeHierarchy;
import org.sosy_lab.cpachecker.cfa.types.java.JClassOrInterfaceType;
import org.sosy_lab.cpachecker.exceptions.JParserException;

class TypeHierachyCreator
extends ASTVisitor {
    private static final boolean VISIT_CHILDREN = true;
    private static final String JAVA_FILE_SUFFIX = ".java";
    private static final boolean SKIP_CHILDREN = false;
    private static final int FIRST = 0;
    private final LogManager logger;
    private final TypeHierarchy.THTypeTable typeTable;
    private final TypeHierachyConverter converter;
    private String fileOfCU;
    private boolean classNameException = false;
    private String className;
    private String expectedName;

    public TypeHierachyCreator(LogManager pLogger, TypeHierarchy.THTypeTable pTypeTable) {
        this.logger = pLogger;
        this.typeTable = pTypeTable;
        this.converter = new TypeHierachyConverter(this.logger, this.typeTable);
    }

    public void createTypeHierachy(List<EclipseJavaParser.JavaFileAST> pJavaProgram) throws JParserException {
        for (EclipseJavaParser.JavaFileAST ast : pJavaProgram) {
            this.fileOfCU = ast.getFileName();
            CompilationUnit cu = ast.getAst();
            cu.accept((ASTVisitor)this);
            if (!this.classNameException) continue;
            throw new JParserException("The top-level class " + this.className + " is not declared within a file " + "with the expected filename " + this.expectedName + ".\n It is instead declared in " + this.fileOfCU);
        }
    }

    public boolean visit(MethodDeclaration pMd) {
        JMethodDeclaration decl = this.converter.convert(pMd, this.fileOfCU);
        this.typeTable.registerMethodDeclaration(decl);
        return false;
    }

    public boolean visit(FieldDeclaration fD) {
        Set<JFieldDeclaration> decl = this.converter.convert(fD, this.fileOfCU);
        VariableDeclarationFragment vdf = (VariableDeclarationFragment)fD.fragments().get(0);
        IVariableBinding variableBinding = vdf.resolveBinding();
        Preconditions.checkNotNull((Object)variableBinding);
        ITypeBinding typeBinding = variableBinding.getDeclaringClass();
        Preconditions.checkNotNull((Object)typeBinding);
        JClassOrInterfaceType declaringClass = this.converter.convertClassOrInterfaceType(typeBinding);
        this.typeTable.registerFieldDeclaration(decl, declaringClass);
        return false;
    }

    public boolean visit(EnumDeclaration node) {
        ITypeBinding typeBinding = node.resolveBinding();
        if (typeBinding != null) {
            JClassOrInterfaceType type = this.converter.convertClassOrInterfaceType(typeBinding);
            this.typeTable.registerFileNameOfType(type, this.fileOfCU);
        }
        return true;
    }

    public boolean visit(TypeDeclaration node) {
        ITypeBinding typeBinding = node.resolveBinding();
        if (typeBinding != null) {
            String simpleName;
            String expectedFilename;
            if (typeBinding.isTopLevel() && !(expectedFilename = (simpleName = node.getName().getIdentifier()) + JAVA_FILE_SUFFIX).equals(this.fileOfCU)) {
                this.classNameException = true;
                this.expectedName = expectedFilename;
                this.className = simpleName;
                return false;
            }
            JClassOrInterfaceType type = this.converter.convertClassOrInterfaceType(typeBinding);
            this.typeTable.registerFileNameOfType(type, this.fileOfCU);
        }
        return !this.classNameException;
    }

    public TypeHierarchy.THTypeTable getTypeTable() {
        return this.typeTable;
    }
}

