/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.parser.eclipse.java;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.ast.java.JFieldDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.java.JMethodDeclaration;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.java.EclipseJavaParser;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.java.THTypeConverter;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.java.TypeHierachyCreator;
import org.sosy_lab.cpachecker.cfa.types.java.JClassOrInterfaceType;
import org.sosy_lab.cpachecker.cfa.types.java.JClassType;
import org.sosy_lab.cpachecker.cfa.types.java.JInterfaceType;
import org.sosy_lab.cpachecker.exceptions.JParserException;

final class TypeHierarchy {
    private Map<String, JClassOrInterfaceType> types;
    private Map<JClassOrInterfaceType, String> fileOfTypes;
    private Map<JClassOrInterfaceType, Set<JMethodDeclaration>> methodDeclarationsOfType;
    private Map<JClassOrInterfaceType, Set<JFieldDeclaration>> fieldDeclarationsOfType;
    private final THTypeTable typeTable;

    private TypeHierarchy(THTypeTable pTypeTable) {
        Preconditions.checkNotNull((Object)pTypeTable);
        this.typeTable = pTypeTable;
        this.types = pTypeTable.getTypes();
        this.fileOfTypes = pTypeTable.getTypeOfFiles();
        this.methodDeclarationsOfType = pTypeTable.getMethodDeclarationsOfType();
        this.fieldDeclarationsOfType = pTypeTable.getFieldDeclarationsOfType();
    }

    public Set<JClassOrInterfaceType> getTypes() {
        HashSet<JClassOrInterfaceType> typeSet = new HashSet<JClassOrInterfaceType>();
        for (JClassOrInterfaceType type : this.types.values()) {
            Preconditions.checkArgument((!typeSet.contains(type) ? 1 : 0) != 0);
            typeSet.add(type);
        }
        return typeSet;
    }

    public Map<JClassOrInterfaceType, String> getFileOfTypes() {
        return this.fileOfTypes;
    }

    public Map<String, JMethodDeclaration> getMethodDeclarations() {
        HashMap<String, JMethodDeclaration> declarations = new HashMap<String, JMethodDeclaration>();
        for (Set<JMethodDeclaration> decls : this.methodDeclarationsOfType.values()) {
            for (JMethodDeclaration decl : decls) {
                String name = decl.getName();
                Preconditions.checkArgument((!declarations.containsKey(name) ? 1 : 0) != 0);
                declarations.put(name, decl);
            }
        }
        return declarations;
    }

    public Set<JMethodDeclaration> getMethodDeclarations(JClassOrInterfaceType type) {
        Preconditions.checkArgument((!this.isExternType(type) ? 1 : 0) != 0, (Object)"Can't get the declarations of extern types.");
        return this.methodDeclarationsOfType.get(type);
    }

    public Map<String, JFieldDeclaration> getFieldDeclarations() {
        HashMap<String, JFieldDeclaration> declarations = new HashMap<String, JFieldDeclaration>();
        for (Set<JFieldDeclaration> decls : this.fieldDeclarationsOfType.values()) {
            for (JFieldDeclaration decl : decls) {
                String name = decl.getName();
                Preconditions.checkArgument((!declarations.containsKey(name) ? 1 : 0) != 0);
                declarations.put(name, decl);
            }
        }
        return declarations;
    }

    public Set<JFieldDeclaration> getFieldDeclarations(JClassOrInterfaceType type) {
        Preconditions.checkArgument((!this.isExternType(type) ? 1 : 0) != 0, (Object)"Can't get the declarations of extern types.");
        return this.fieldDeclarationsOfType.get(type);
    }

    public static TypeHierarchy createTypeHierachy(LogManager pLogger, List<EclipseJavaParser.JavaFileAST> pJavaProgram) throws JParserException {
        TypeHierachyCreator creator = new TypeHierachyCreator(pLogger, new THTypeTable());
        creator.createTypeHierachy(pJavaProgram);
        return new TypeHierarchy(creator.getTypeTable());
    }

    public boolean containsType(JClassOrInterfaceType pType) {
        return this.types.containsKey(pType.getName());
    }

    public boolean containsType(String pFullyQualifiedTypeName) {
        return this.types.containsKey(pFullyQualifiedTypeName);
    }

    @Nullable
    public JClassOrInterfaceType getType(String pFullyQualifiedTypeName) {
        return this.types.get(pFullyQualifiedTypeName);
    }

    @Nullable
    public String getFileOfType(JClassOrInterfaceType pType) {
        return this.fileOfTypes.get(pType);
    }

    public boolean isExternType(JClassOrInterfaceType pType) {
        return !this.fileOfTypes.containsKey(pType);
    }

    public boolean containsInterfaceType(String pTypeName) {
        boolean exists = this.types.containsKey(pTypeName);
        boolean isInterface = this.types.get(pTypeName) instanceof JInterfaceType;
        return exists && isInterface;
    }

    public JInterfaceType getInterfaceType(String pTypeName) {
        JClassOrInterfaceType type = this.types.get(pTypeName);
        if (type == null || !(type instanceof JInterfaceType)) {
            throw new IllegalStateException("Interface Type does not exist");
        }
        return (JInterfaceType)this.types.get(pTypeName);
    }

    public boolean containsClassType(String pTypeName) {
        boolean exists = this.types.containsKey(pTypeName);
        boolean isClass = this.types.get(pTypeName) instanceof JClassType;
        return exists && isClass;
    }

    public JClassType getClassType(String pTypeName) {
        JClassOrInterfaceType type = this.types.get(pTypeName);
        if (type == null || !(type instanceof JClassType)) {
            throw new IllegalStateException("Interface Type does not exist");
        }
        return (JClassType)this.types.get(pTypeName);
    }

    void updateTypeHierarchy(ITypeBinding classOrInterfaceBinding) {
        Preconditions.checkNotNull((Object)classOrInterfaceBinding);
        Preconditions.checkArgument((classOrInterfaceBinding.isClass() || classOrInterfaceBinding.isEnum() || classOrInterfaceBinding.isInterface() ? 1 : 0) != 0);
        THTypeConverter converter = new THTypeConverter(this.typeTable);
        converter.convertClassOrInterfaceType(classOrInterfaceBinding);
        this.types = this.typeTable.getTypes();
        this.fileOfTypes = this.typeTable.getTypeOfFiles();
        this.methodDeclarationsOfType = this.typeTable.getMethodDeclarationsOfType();
    }

    static class THTypeTable {
        private final Map<String, JClassOrInterfaceType> types = new HashMap<String, JClassOrInterfaceType>();
        private final Map<JClassOrInterfaceType, String> typeOfFiles = new HashMap<JClassOrInterfaceType, String>();
        private final Map<JClassOrInterfaceType, Set<JMethodDeclaration>> methodDeclarationsOfType = new HashMap<JClassOrInterfaceType, Set<JMethodDeclaration>>();
        private final Map<JClassOrInterfaceType, Set<JFieldDeclaration>> fieldDeclarationsOfType = new HashMap<JClassOrInterfaceType, Set<JFieldDeclaration>>();

        private THTypeTable() {
            JClassType objectType = JClassType.getTypeOfObject();
            this.registerType(objectType);
        }

        public Map<String, JClassOrInterfaceType> getTypes() {
            return ImmutableMap.copyOf(this.types);
        }

        public Map<JClassOrInterfaceType, String> getTypeOfFiles() {
            return ImmutableMap.copyOf(this.typeOfFiles);
        }

        public void registerType(JClassOrInterfaceType pType) {
            this.types.put(pType.getName(), pType);
            this.methodDeclarationsOfType.put(pType, new HashSet());
            this.fieldDeclarationsOfType.put(pType, new HashSet());
        }

        public void registerMethodDeclaration(JMethodDeclaration pDecl) {
            JClassOrInterfaceType declaringClass = pDecl.getDeclaringClass();
            Preconditions.checkArgument((boolean)this.methodDeclarationsOfType.containsKey(declaringClass));
            Preconditions.checkArgument((!this.methodDeclarationsOfType.get(declaringClass).contains(pDecl) ? 1 : 0) != 0);
            this.methodDeclarationsOfType.get(declaringClass).add(pDecl);
        }

        public void registerFieldDeclaration(JFieldDeclaration pDecl, JClassOrInterfaceType declaringClass) {
            Preconditions.checkArgument((boolean)this.fieldDeclarationsOfType.containsKey(declaringClass));
            Preconditions.checkArgument((!this.fieldDeclarationsOfType.get(declaringClass).contains(pDecl) ? 1 : 0) != 0);
            this.fieldDeclarationsOfType.get(declaringClass).add(pDecl);
        }

        public void registerFileNameOfType(JClassOrInterfaceType type, String fileName) {
            this.typeOfFiles.put(type, fileName);
        }

        public boolean containsType(String typeName) {
            return this.types.containsKey(typeName);
        }

        public JClassOrInterfaceType getType(String typeName) {
            return this.types.get(typeName);
        }

        public Map<JClassOrInterfaceType, Set<JMethodDeclaration>> getMethodDeclarationsOfType() {
            HashMap<JClassOrInterfaceType, ImmutableSet> tmp = new HashMap<JClassOrInterfaceType, ImmutableSet>();
            for (JClassOrInterfaceType type : this.methodDeclarationsOfType.keySet()) {
                Set<JMethodDeclaration> set = this.methodDeclarationsOfType.get(type);
                tmp.put(type, ImmutableSet.copyOf(set));
            }
            return ImmutableMap.copyOf(tmp);
        }

        public Map<JClassOrInterfaceType, Set<JFieldDeclaration>> getFieldDeclarationsOfType() {
            HashMap<JClassOrInterfaceType, ImmutableSet> tmp = new HashMap<JClassOrInterfaceType, ImmutableSet>();
            for (JClassOrInterfaceType type : this.fieldDeclarationsOfType.keySet()) {
                Set<JFieldDeclaration> set = this.fieldDeclarationsOfType.get(type);
                tmp.put(type, ImmutableSet.copyOf(set));
            }
            return ImmutableMap.copyOf(tmp);
        }

        public void registerFieldDeclaration(Set<JFieldDeclaration> pDecl, JClassOrInterfaceType pDeclaringClass) {
            for (JFieldDeclaration decl : pDecl) {
                this.registerFieldDeclaration(decl, pDeclaringClass);
            }
        }
    }
}

