/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.postprocessing.function;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.MutableCFA;
import org.sosy_lab.cpachecker.cfa.ast.AVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.c.CDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpressionAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializer;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CReturnStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.model.ADeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.BlankEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.FunctionExitNode;
import org.sosy_lab.cpachecker.cfa.model.c.CAssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CDeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CReturnStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CStatementEdge;
import org.sosy_lab.cpachecker.util.CFATraversal;

public class CFADeclarationMover {
    LogManager logger;

    public CFADeclarationMover(LogManager log) {
        this.logger = log;
    }

    public void moveDeclarationsToFunctionStart(MutableCFA cfa) {
        Collection<FunctionEntryNode> startNodes = cfa.getAllFunctionHeads();
        for (FunctionEntryNode node : startNodes) {
            this.handleDeclarationsInFunction(node, cfa);
        }
    }

    private void handleDeclarationsInFunction(FunctionEntryNode startNode, MutableCFA cfa) {
        CFAEdge firstRealFunctionEdge = startNode.getLeavingEdge(0);
        ArrayList<CFAEdge> secondRealFunctionEdge = new ArrayList<CFAEdge>();
        String functionName = startNode.getFunctionName();
        while (!firstRealFunctionEdge.getDescription().equals("Function start dummy edge")) {
            firstRealFunctionEdge = firstRealFunctionEdge.getSuccessor().getLeavingEdge(0);
        }
        CFANode actNode = firstRealFunctionEdge.getSuccessor();
        for (int i = 0; i < actNode.getNumLeavingEdges(); ++i) {
            secondRealFunctionEdge.add(actNode.getLeavingEdge(i));
        }
        List<CFAEdge> declarations = this.collectDeclarations(actNode);
        if (!declarations.isEmpty()) {
            CFANode tmpNode = new CFANode(functionName);
            cfa.addNode(tmpNode);
            BlankEdge declEndEdge = new BlankEdge("End of Declarations", FileLocation.DUMMY, actNode, tmpNode, "End of Declarations");
            tmpNode.addEnteringEdge(declEndEdge);
            for (CFAEdge e : secondRealFunctionEdge) {
                CFAEdge tmpEdge = this.moveEdgeToOtherPredecessor(e, tmpNode);
                actNode.removeLeavingEdge(e);
                if (!declarations.contains(e)) continue;
                declarations.add(declarations.indexOf(e), tmpEdge);
                declarations.remove(e);
            }
            secondRealFunctionEdge.clear();
            secondRealFunctionEdge.add(declEndEdge);
        }
        for (CFAEdge decl : declarations) {
            CFANode middleNode = new CFANode(functionName);
            cfa.addNode(middleNode);
            this.moveDeclEdgeToNewLocation((CDeclarationEdge)decl, actNode, middleNode, cfa);
            actNode = middleNode;
        }
        if (!declarations.isEmpty()) {
            for (CFAEdge e : secondRealFunctionEdge) {
                this.moveEdgeToOtherPredecessor(e, actNode);
            }
        }
    }

    private CFAEdge moveEdgeToOtherPredecessor(CFAEdge edge, CFANode pred) {
        CFANode succ = edge.getSuccessor();
        succ.removeEnteringEdge(edge);
        switch (edge.getEdgeType()) {
            case AssumeEdge: {
                edge = new CAssumeEdge(((CAssumeEdge)edge).getRawStatement(), edge.getFileLocation(), pred, edge.getSuccessor(), ((CAssumeEdge)edge).getExpression(), ((CAssumeEdge)edge).getTruthAssumption());
                pred.addLeavingEdge(edge);
                succ.addEnteringEdge(edge);
                return edge;
            }
            case BlankEdge: {
                edge = new BlankEdge(((BlankEdge)edge).getRawStatement(), edge.getFileLocation(), pred, edge.getSuccessor(), ((BlankEdge)edge).getDescription());
                pred.addLeavingEdge(edge);
                succ.addEnteringEdge(edge);
                return edge;
            }
            case DeclarationEdge: {
                edge = new CDeclarationEdge(((CDeclarationEdge)edge).getRawStatement(), edge.getFileLocation(), pred, edge.getSuccessor(), ((CDeclarationEdge)edge).getDeclaration());
                pred.addLeavingEdge(edge);
                succ.addEnteringEdge(edge);
                return edge;
            }
            case ReturnStatementEdge: {
                edge = new CReturnStatementEdge(((CReturnStatementEdge)edge).getRawStatement(), (CReturnStatement)((CReturnStatementEdge)edge).getRawAST().orNull(), edge.getFileLocation(), pred, (FunctionExitNode)edge.getSuccessor());
                pred.addLeavingEdge(edge);
                succ.addEnteringEdge(edge);
                return edge;
            }
            case StatementEdge: {
                edge = new CStatementEdge(((CStatementEdge)edge).getRawStatement(), ((CStatementEdge)edge).getStatement(), edge.getFileLocation(), pred, edge.getSuccessor());
                pred.addLeavingEdge(edge);
                succ.addEnteringEdge(edge);
                return edge;
            }
        }
        throw new AssertionError((Object)"should never happen");
    }

    private void moveDeclEdgeToNewLocation(CDeclarationEdge edge, CFANode pred, CFANode succ, MutableCFA cfa) {
        BlankEdge midEdge;
        CDeclaration decl = edge.getDeclaration();
        if (!(decl instanceof CVariableDeclaration)) {
            throw new AssertionError((Object)"Only variable declaration edges should be moved!");
        }
        CFANode actPred = edge.getPredecessor();
        CFANode actSucc = edge.getSuccessor();
        CVariableDeclaration varDecl = (CVariableDeclaration)decl;
        CInitializer init = varDecl.getInitializer();
        if (init instanceof CInitializerExpression) {
            actPred.removeLeavingEdge(edge);
            actSucc.removeEnteringEdge(edge);
            CExpressionAssignmentStatement stmt = new CExpressionAssignmentStatement(varDecl.getFileLocation(), new CIdExpression(varDecl.getFileLocation(), varDecl), ((CInitializerExpression)init).getExpression());
            CStatementEdge midEdge2 = new CStatementEdge(edge.getRawStatement(), stmt, edge.getFileLocation(), actPred, actSucc);
            actPred.addLeavingEdge(midEdge2);
            actSucc.addEnteringEdge(midEdge2);
        } else if (init != null) {
            this.logger.log(Level.WARNING, new Object[]{"Moving declaration to function start does not work correctly for initializer lists and designated initializers for arrays or structs, do not use the CFADeclarationMover if you are able to handle such expressions."});
            actPred.removeLeavingEdge(edge);
            actSucc.removeEnteringEdge(edge);
            midEdge = new BlankEdge(edge.getRawStatement(), edge.getFileLocation(), actPred, actSucc, "Declaration was moved to function start");
            actPred.addLeavingEdge(midEdge);
            actSucc.addEnteringEdge(midEdge);
        } else {
            actPred.removeLeavingEdge(edge);
            actSucc.removeEnteringEdge(edge);
            midEdge = new BlankEdge(edge.getRawStatement(), edge.getFileLocation(), actPred, actSucc, "Declaration was moved to function start");
            actPred.addLeavingEdge(midEdge);
            actSucc.addEnteringEdge(midEdge);
        }
        CVariableDeclaration declWithoutInitializer = new CVariableDeclaration(varDecl.getFileLocation(), varDecl.isGlobal(), varDecl.getCStorageClass(), varDecl.getType(), varDecl.getName(), varDecl.getOrigName(), varDecl.getQualifiedName(), null);
        CDeclarationEdge newEdge = new CDeclarationEdge(edge.getRawStatement(), edge.getFileLocation(), pred, succ, declWithoutInitializer);
        pred.addLeavingEdge(newEdge);
        succ.addEnteringEdge(newEdge);
    }

    private List<CFAEdge> collectDeclarations(CFANode startNode) {
        DeclarationCollector dc = new DeclarationCollector();
        CFATraversal.dfs().ignoreSummaryEdges().ignoreFunctionCalls().traverseOnce(startNode, dc);
        return dc.getCollectedDeclarations();
    }

    class DeclarationCollector
    extends CFATraversal.DefaultCFAVisitor {
        private final List<CFAEdge> edges = new ArrayList<CFAEdge>();

        public List<CFAEdge> getCollectedDeclarations() {
            return this.edges;
        }

        @Override
        public CFATraversal.TraversalProcess visitEdge(CFAEdge edge) {
            if (edge instanceof ADeclarationEdge && ((ADeclarationEdge)edge).getDeclaration() instanceof AVariableDeclaration) {
                this.edges.add(edge);
            }
            return CFATraversal.TraversalProcess.CONTINUE;
        }
    }
}

