/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.postprocessing.function;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.sosy_lab.common.Pair;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFACreationUtils;
import org.sosy_lab.cpachecker.cfa.MutableCFA;
import org.sosy_lab.cpachecker.cfa.ast.ADeclaration;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpressionBuilder;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCall;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CPointerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CSimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CUnaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.model.BlankEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.c.CAssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.c.CStatementEdge;
import org.sosy_lab.cpachecker.cfa.postprocessing.function.CReferencedFunctionsCollector;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.c.CFunctionType;
import org.sosy_lab.cpachecker.cfa.types.c.CPointerType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cfa.types.c.CVoidType;
import org.sosy_lab.cpachecker.util.CFATraversal;
import org.sosy_lab.cpachecker.util.CFAUtils;

@Options
public class CFunctionPointerResolver {
    @Option(secure=true, name="analysis.functionPointerEdgesForUnknownPointer", description="Create edge for skipping a function pointer call if its value is unknown.")
    private boolean createUndefinedFunctionCall = true;
    @Option(secure=true, name="analysis.functionPointerTargets", description="potential targets for call edges created for function pointer calls")
    private Set<FunctionSet> functionSets = ImmutableSet.of((Object)((Object)FunctionSet.USED_IN_CODE), (Object)((Object)FunctionSet.EQ_PARAM_SIZES), (Object)((Object)FunctionSet.RETURN_VALUE));
    private final Collection<FunctionEntryNode> candidateFunctions;
    private final Predicate<Pair<CFunctionCall, CFunctionType>> matchingFunctionCall;
    private final MutableCFA cfa;
    private final LogManager logger;

    public CFunctionPointerResolver(MutableCFA pCfa, List<Pair<ADeclaration, String>> pGlobalVars, Configuration config, LogManager pLogger) throws InvalidConfigurationException {
        this.cfa = pCfa;
        this.logger = pLogger;
        config.inject((Object)this);
        this.matchingFunctionCall = this.getFunctionSetPredicate(this.functionSets);
        if (this.functionSets.contains((Object)FunctionSet.USED_IN_CODE)) {
            CReferencedFunctionsCollector varCollector = new CReferencedFunctionsCollector();
            for (CFANode node : this.cfa.getAllNodes()) {
                for (CFAEdge edge : CFAUtils.leavingEdges(node)) {
                    varCollector.visitEdge(edge);
                }
            }
            for (Pair decl : pGlobalVars) {
                if (!(decl.getFirst() instanceof CVariableDeclaration)) continue;
                CVariableDeclaration varDecl = (CVariableDeclaration)decl.getFirst();
                varCollector.visitDeclaration(varDecl);
            }
            Set<String> addressedFunctions = varCollector.getCollectedFunctions();
            this.candidateFunctions = FluentIterable.from((Iterable)Sets.intersection(addressedFunctions, this.cfa.getAllFunctionNames())).transform(Functions.forMap(this.cfa.getAllFunctions())).toList();
            if (this.logger.wouldBeLogged(Level.ALL)) {
                this.logger.log(Level.ALL, new Object[]{"Possible target functions of function pointers:\n", Joiner.on((char)'\n').join(this.candidateFunctions)});
            }
        } else {
            this.candidateFunctions = this.cfa.getAllFunctionHeads();
        }
    }

    private Predicate<Pair<CFunctionCall, CFunctionType>> getFunctionSetPredicate(Collection<FunctionSet> pFunctionSets) {
        EnumSet<FunctionSet> functionSets = EnumSet.copyOf(pFunctionSets);
        if (functionSets.contains((Object)FunctionSet.EQ_PARAM_TYPES) || functionSets.contains((Object)FunctionSet.EQ_PARAM_SIZES)) {
            functionSets.add(FunctionSet.EQ_PARAM_COUNT);
        }
        ArrayList<Object> predicates = new ArrayList<Object>();
        block8: for (FunctionSet functionSet : functionSets) {
            switch (functionSet) {
                case ALL: {
                    continue block8;
                }
                case EQ_PARAM_COUNT: {
                    predicates.add(new Predicate<Pair<CFunctionCall, CFunctionType>>(){

                        public boolean apply(Pair<CFunctionCall, CFunctionType> pInput) {
                            boolean result = CFunctionPointerResolver.this.checkParamSizes(((CFunctionCall)pInput.getFirst()).getFunctionCallExpression(), (CFunctionType)pInput.getSecond());
                            if (!result) {
                                CFunctionPointerResolver.this.logger.log(Level.FINEST, new Object[]{"Function call", ((CFunctionCall)pInput.getFirst()).toASTString(), "does not match function", pInput.getSecond(), "because of number of parameters."});
                            }
                            return result;
                        }
                    });
                    continue block8;
                }
                case EQ_PARAM_SIZES: {
                    predicates.add(new Predicate<Pair<CFunctionCall, CFunctionType>>(){

                        public boolean apply(Pair<CFunctionCall, CFunctionType> pInput) {
                            return CFunctionPointerResolver.this.checkReturnAndParamSizes(((CFunctionCall)pInput.getFirst()).getFunctionCallExpression(), (CFunctionType)pInput.getSecond());
                        }
                    });
                    continue block8;
                }
                case EQ_PARAM_TYPES: {
                    predicates.add(new Predicate<Pair<CFunctionCall, CFunctionType>>(){

                        public boolean apply(Pair<CFunctionCall, CFunctionType> pInput) {
                            return CFunctionPointerResolver.this.checkReturnAndParamTypes(((CFunctionCall)pInput.getFirst()).getFunctionCallExpression(), (CFunctionType)pInput.getSecond());
                        }
                    });
                    continue block8;
                }
                case RETURN_VALUE: {
                    predicates.add(new Predicate<Pair<CFunctionCall, CFunctionType>>(){

                        public boolean apply(Pair<CFunctionCall, CFunctionType> pInput) {
                            return CFunctionPointerResolver.this.checkReturnValue((CFunctionCall)pInput.getFirst(), (CFunctionType)pInput.getSecond());
                        }
                    });
                    continue block8;
                }
                case USED_IN_CODE: {
                    continue block8;
                }
            }
            throw new AssertionError();
        }
        return Predicates.and(predicates);
    }

    public void resolveFunctionPointers() {
        FunctionPointerCallCollector visitor = new FunctionPointerCallCollector();
        for (FunctionEntryNode functionStartNode : this.cfa.getAllFunctionHeads()) {
            CFATraversal.dfs().traverseOnce(functionStartNode, visitor);
        }
        for (CStatementEdge edge : visitor.functionPointerCalls) {
            this.replaceFunctionPointerCall((CFunctionCall)edge.getStatement(), edge);
        }
    }

    private boolean isFunctionPointerCall(CFunctionCall call) {
        CFunctionCallExpression callExpr = call.getFunctionCallExpression();
        if (callExpr.getDeclaration() != null) {
            return false;
        }
        CExpression nameExpr = callExpr.getFunctionNameExpression();
        return !(nameExpr instanceof CIdExpression) || ((CIdExpression)nameExpr).getDeclaration() != null;
    }

    private void replaceFunctionPointerCall(CFunctionCall functionCall, CStatementEdge statement) {
        CExpression operand;
        CType operandType;
        CFunctionCallExpression fExp = functionCall.getFunctionCallExpression();
        this.logger.log(Level.FINEST, new Object[]{"Function pointer call", fExp});
        CExpression nameExp = fExp.getFunctionNameExpression();
        List<CFunctionEntryNode> funcs = this.getFunctionSet(functionCall);
        if (funcs.isEmpty()) {
            this.logger.logf(Level.WARNING, "%s: Function pointer %s with type %s is called, but no possible target functions were found.", new Object[]{statement.getFileLocation(), nameExp.toASTString(), nameExp.getExpressionType().toASTString("*")});
            return;
        }
        this.logger.log(Level.FINEST, new Object[]{"Inserting edges for the function pointer", nameExp.toASTString(), "with type", nameExp.getExpressionType().toASTString("*"), "to the functions", FluentIterable.from(funcs).transform((Function)new Function<CFANode, String>(){

            public String apply(CFANode pInput) {
                return pInput.getFunctionName();
            }
        })});
        FileLocation fileLocation = statement.getFileLocation();
        CFANode start = statement.getPredecessor();
        CFANode end = statement.getSuccessor();
        CFACreationUtils.removeEdgeFromNodes(statement);
        if (nameExp instanceof CPointerExpression && (operandType = (operand = ((CPointerExpression)nameExp).getOperand()).getExpressionType().getCanonicalType()) instanceof CPointerType && ((CPointerType)operandType).getType() instanceof CFunctionType) {
            nameExp = operand;
        }
        CFANode rootNode = start;
        for (FunctionEntryNode functionEntryNode : funcs) {
            CFANode thenNode = this.newCFANode(start.getFunctionName());
            CFANode elseNode = this.newCFANode(start.getFunctionName());
            CIdExpression func = new CIdExpression(nameExp.getFileLocation(), (CType)((Object)functionEntryNode.getFunctionDefinition().getType()), functionEntryNode.getFunctionName(), (CSimpleDeclaration)((Object)functionEntryNode.getFunctionDefinition()));
            CUnaryExpression amper = new CUnaryExpression(nameExp.getFileLocation(), func.getExpressionType(), func, CUnaryExpression.UnaryOperator.AMPER);
            CBinaryExpressionBuilder binExprBuilder = new CBinaryExpressionBuilder(this.cfa.getMachineModel(), this.logger);
            CBinaryExpression condition = binExprBuilder.buildBinaryExpressionUnchecked(nameExp, amper, CBinaryExpression.BinaryOperator.EQUALS);
            this.addConditionEdges(condition, rootNode, thenNode, elseNode, fileLocation);
            CFANode retNode = this.newCFANode(start.getFunctionName());
            String pRawStatement = "pointer call(" + functionEntryNode.getFunctionName() + ") " + statement.getRawStatement();
            CFunctionCall regularCall = this.createRegularCall(functionCall, functionEntryNode);
            this.createCallEdge(fileLocation, pRawStatement, thenNode, retNode, regularCall);
            BlankEdge be = new BlankEdge("skip", statement.getFileLocation(), retNode, end, "skip");
            CFACreationUtils.addEdgeUnconditionallyToCFA(be);
            rootNode = elseNode;
        }
        if (this.createUndefinedFunctionCall) {
            CStatementEdge summaryStatementEdge = new CStatementEdge(statement.getRawStatement(), statement.getStatement(), statement.getFileLocation(), rootNode, end);
            rootNode.addLeavingEdge(summaryStatementEdge);
            end.addEnteringEdge(summaryStatementEdge);
        } else {
            for (CFAEdge cFAEdge : CFAUtils.enteringEdges(rootNode)) {
                CFACreationUtils.removeEdgeFromNodes(cFAEdge);
            }
            this.cfa.removeNode(rootNode);
        }
    }

    private CIdExpression createIdExpression(CExpression nameExp, FunctionEntryNode fNode) {
        return new CIdExpression(nameExp.getFileLocation(), nameExp.getExpressionType(), fNode.getFunctionName(), (CSimpleDeclaration)((Object)fNode.getFunctionDefinition()));
    }

    private CFunctionCall createRegularCall(CFunctionCall functionCall, FunctionEntryNode fNode) {
        CFunctionCallExpression oldCallExpr = functionCall.getFunctionCallExpression();
        CFunctionCallExpression newCallExpr = new CFunctionCallExpression(oldCallExpr.getFileLocation(), oldCallExpr.getExpressionType(), this.createIdExpression(oldCallExpr.getFunctionNameExpression(), fNode), oldCallExpr.getParameterExpressions(), (CFunctionDeclaration)fNode.getFunctionDefinition());
        if (functionCall instanceof CFunctionCallAssignmentStatement) {
            CFunctionCallAssignmentStatement asgn = (CFunctionCallAssignmentStatement)functionCall;
            return new CFunctionCallAssignmentStatement(functionCall.getFileLocation(), asgn.getLeftHandSide(), newCallExpr);
        }
        if (functionCall instanceof CFunctionCallStatement) {
            return new CFunctionCallStatement(functionCall.getFileLocation(), newCallExpr);
        }
        throw new AssertionError((Object)"Unknown CFunctionCall subclass.");
    }

    private CFANode newCFANode(String functionName) {
        assert (this.cfa != null);
        CFANode nextNode = new CFANode(functionName);
        this.cfa.addNode(nextNode);
        return nextNode;
    }

    private void createCallEdge(FileLocation fileLocation, String pRawStatement, CFANode predecessorNode, CFANode successorNode, CFunctionCall functionCall) {
        CStatementEdge callEdge = new CStatementEdge(pRawStatement, functionCall, fileLocation, predecessorNode, successorNode);
        CFACreationUtils.addEdgeUnconditionallyToCFA(callEdge);
    }

    private void addConditionEdges(CExpression condition, CFANode rootNode, CFANode thenNode, CFANode elseNode, FileLocation fileLocation) {
        CAssumeEdge trueEdge = new CAssumeEdge(condition.toASTString(), fileLocation, rootNode, thenNode, condition, true);
        CFACreationUtils.addEdgeToCFA(trueEdge, this.logger);
        CAssumeEdge falseEdge = new CAssumeEdge("!(" + condition.toASTString() + ")", fileLocation, rootNode, elseNode, condition, false);
        CFACreationUtils.addEdgeToCFA(falseEdge, this.logger);
    }

    private List<CFunctionEntryNode> getFunctionSet(final CFunctionCall call) {
        return FluentIterable.from(this.candidateFunctions).filter(CFunctionEntryNode.class).filter(Predicates.compose(this.matchingFunctionCall, (Function)new Function<CFunctionEntryNode, Pair<CFunctionCall, CFunctionType>>(){

            public Pair<CFunctionCall, CFunctionType> apply(CFunctionEntryNode f) {
                return Pair.of((Object)call, (Object)f.getFunctionDefinition().getType());
            }
        })).toList();
    }

    private boolean checkReturnAndParamSizes(CFunctionCallExpression functionCallExpression, CFunctionType functionType) {
        MachineModel machine = this.cfa.getMachineModel();
        try {
            CType declRet = functionType.getReturnType();
            CType actRet = functionCallExpression.getExpressionType();
            if (machine.getSizeof(declRet) != machine.getSizeof(actRet)) {
                this.logger.log(Level.FINEST, new Object[]{"Function call", functionCallExpression.toASTString(), "with type", actRet, "does not match function", functionType, "with return type", declRet, "because of return types with different sizes."});
                return false;
            }
            List<CType> declParams = functionType.getParameters();
            List<CExpression> exprParams = functionCallExpression.getParameterExpressions();
            for (int i = 0; i < declParams.size(); ++i) {
                CType dt = declParams.get(i);
                CType et = exprParams.get(i).getExpressionType();
                if (machine.getSizeof(dt) == machine.getSizeof(et)) continue;
                this.logger.log(Level.FINEST, new Object[]{"Function call", functionCallExpression.toASTString(), "does not match function", functionType, "because actual parameter", i, "has type", et, "instead of", dt, "(differing sizes)."});
                return false;
            }
        }
        catch (IllegalArgumentException e) {
            this.logger.logUserException(Level.INFO, (Throwable)e, functionType.toASTString("") + " " + functionCallExpression);
            return true;
        }
        return true;
    }

    private boolean checkReturnAndParamTypes(CFunctionCallExpression functionCallExpression, CFunctionType functionType) {
        CType actRet;
        CType declRet = functionType.getReturnType();
        if (!this.isCompatibleType(declRet, actRet = functionCallExpression.getExpressionType())) {
            this.logger.log(Level.FINEST, new Object[]{"Function call", functionCallExpression.toASTString(), "with type", actRet, "does not match function", functionType, "with return type", declRet});
            return false;
        }
        List<CType> declParams = functionType.getParameters();
        List<CExpression> exprParams = functionCallExpression.getParameterExpressions();
        for (int i = 0; i < declParams.size(); ++i) {
            CType et;
            CType dt = declParams.get(i);
            if (this.isCompatibleType(dt, et = exprParams.get(i).getExpressionType())) continue;
            this.logger.log(Level.FINEST, new Object[]{"Function call", functionCallExpression.toASTString(), "does not match function", functionType, "because actual parameter", i, "has type", et, "instead of", dt});
            return false;
        }
        return true;
    }

    private boolean checkReturnValue(CFunctionCall call, CFunctionType functionType) {
        CType returnType;
        return !(call instanceof CFunctionCallAssignmentStatement) || !((returnType = functionType.getReturnType().getCanonicalType()) instanceof CVoidType);
    }

    private boolean isCompatibleType(CType declaredType, CType actualType) {
        return declaredType.getCanonicalType().equals(actualType.getCanonicalType());
    }

    private final boolean checkParamSizes(CFunctionCallExpression functionCallExpression, CFunctionType functionType) {
        List<CExpression> parameters = functionCallExpression.getParameterExpressions();
        int declaredParameters = functionType.getParameters().size();
        int actualParameters = parameters.size();
        return functionType.takesVarArgs() && declaredParameters <= actualParameters || declaredParameters == actualParameters;
    }

    private class FunctionPointerCallCollector
    extends CFATraversal.DefaultCFAVisitor {
        final List<CStatementEdge> functionPointerCalls = new ArrayList<CStatementEdge>();

        private FunctionPointerCallCollector() {
        }

        @Override
        public CFATraversal.TraversalProcess visitEdge(CFAEdge pEdge) {
            CStatementEdge edge;
            CStatement stmt;
            if (pEdge instanceof CStatementEdge && (stmt = (edge = (CStatementEdge)pEdge).getStatement()) instanceof CFunctionCall && CFunctionPointerResolver.this.isFunctionPointerCall((CFunctionCall)stmt)) {
                this.functionPointerCalls.add(edge);
            }
            return CFATraversal.TraversalProcess.CONTINUE;
        }
    }

    private static enum FunctionSet {
        ALL,
        USED_IN_CODE,
        EQ_PARAM_COUNT,
        EQ_PARAM_SIZES,
        EQ_PARAM_TYPES,
        RETURN_VALUE;

    }
}

