/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.postprocessing.function;

import java.util.ArrayList;
import java.util.HashSet;
import org.sosy_lab.cpachecker.cfa.MutableCFA;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCall;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdgeType;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.MultiEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CStatementEdge;
import org.sosy_lab.cpachecker.util.CFATraversal;

public class MultiEdgeCreator
extends CFATraversal.DefaultCFAVisitor {
    private final MutableCFA cfa;

    public static void createMultiEdges(MutableCFA cfa) {
        MultiEdgeCreator visitor = new MultiEdgeCreator(cfa);
        for (CFANode cFANode : cfa.getAllFunctionHeads()) {
            CFATraversal.dfs().ignoreSummaryEdges().traverseOnce(cFANode, visitor);
        }
    }

    private MultiEdgeCreator(MutableCFA pCfa) {
        this.cfa = pCfa;
    }

    @Override
    public CFATraversal.TraversalProcess visitNode(CFANode pNode) {
        if (this.nodeQualifiesAsStartNode(pNode)) {
            CFAEdge edge;
            ArrayList<CFAEdge> edges = new ArrayList<CFAEdge>();
            HashSet<CFANode> nodes = new HashSet<CFANode>();
            CFANode node = pNode;
            while (this.edgeQualifies(edge = node.getLeavingEdge(0))) {
                edges.add(edge);
                nodes.add(edge.getPredecessor());
                nodes.add(edge.getSuccessor());
                node = edge.getSuccessor();
                if (this.nodeQualifies(node)) continue;
            }
            if (edges.size() > 1) {
                CFAEdge firstEdge = (CFAEdge)edges.get(0);
                CFANode firstNode = firstEdge.getPredecessor();
                assert (firstNode == pNode);
                CFAEdge lastEdge = (CFAEdge)edges.get(edges.size() - 1);
                CFANode lastNode = lastEdge.getSuccessor();
                firstNode.removeLeavingEdge(firstEdge);
                lastNode.removeEnteringEdge(lastEdge);
                MultiEdge newEdge = new MultiEdge(firstNode, lastNode, edges);
                firstNode.addLeavingEdge(newEdge);
                lastNode.addEnteringEdge(newEdge);
                nodes.remove(firstNode);
                nodes.remove(lastNode);
                assert (!nodes.isEmpty());
                for (CFANode middleNode : nodes) {
                    this.cfa.removeNode(middleNode);
                }
            }
        }
        return CFATraversal.TraversalProcess.CONTINUE;
    }

    private boolean nodeQualifiesAsStartNode(CFANode node) {
        return node.getNumLeavingEdges() == 1 && node.getLeavingSummaryEdge() == null && node.getNumEnteringEdges() > 0;
    }

    private boolean nodeQualifies(CFANode node) {
        return node.getNumLeavingEdges() == 1 && node.getNumEnteringEdges() == 1 && node.getLeavingSummaryEdge() == null && !node.isLoopStart() && node.getClass() == CFANode.class;
    }

    private boolean edgeQualifies(CFAEdge edge) {
        boolean result = edge.getEdgeType() == CFAEdgeType.BlankEdge || edge.getEdgeType() == CFAEdgeType.DeclarationEdge || edge.getEdgeType() == CFAEdgeType.StatementEdge || edge.getEdgeType() == CFAEdgeType.ReturnStatementEdge;
        return result && !this.containsFunctionCall(edge);
    }

    private boolean containsFunctionCall(CFAEdge edge) {
        if (edge.getEdgeType() == CFAEdgeType.StatementEdge) {
            CStatementEdge statementEdge = (CStatementEdge)edge;
            return statementEdge.getStatement() instanceof CFunctionCall;
        }
        return false;
    }
}

