/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.postprocessing.global;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Set;
import java.util.logging.Level;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFACreationUtils;
import org.sosy_lab.cpachecker.cfa.MutableCFA;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.CPABuilder;
import org.sosy_lab.cpachecker.core.ShutdownNotifier;
import org.sosy_lab.cpachecker.core.algorithm.CPAAlgorithm;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.StateSpacePartition;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSetFactory;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.CFATraversal;
import org.sosy_lab.cpachecker.util.CPAs;

public class CFAReduction {
    private final Configuration config;
    private final LogManager logger;
    private final ShutdownNotifier shutdownNotifier;

    public CFAReduction(Configuration config, LogManager logger, ShutdownNotifier pShutdownNotifier) throws InvalidConfigurationException {
        if (config.getProperty("specification") == null) {
            throw new InvalidConfigurationException("Option cfa.removeIrrelevantForSpecification is only valid if a specification is given!");
        }
        this.config = config;
        this.logger = logger;
        this.shutdownNotifier = pShutdownNotifier;
    }

    public void removeIrrelevantForSpecification(MutableCFA cfa) throws InterruptedException {
        Collection<CFANode> errorNodes = this.getErrorNodesWithCPA(cfa);
        if (errorNodes.isEmpty()) {
            cfa.clear();
            return;
        }
        Collection<CFANode> allNodes = cfa.getAllNodes();
        if (errorNodes.size() == allNodes.size()) {
            return;
        }
        CFATraversal.NodeCollectingCFAVisitor cfaVisitor = new CFATraversal.NodeCollectingCFAVisitor();
        CFATraversal traversal = CFATraversal.dfs().backwards();
        for (CFANode n : errorNodes) {
            traversal.traverse(n, cfaVisitor);
        }
        Set<CFANode> relevantNodes = cfaVisitor.getVisitedNodes();
        assert (allNodes.containsAll(relevantNodes)) : "Inconsistent CFA";
        int numIrrelevantNodes = allNodes.size() - relevantNodes.size();
        this.logger.log(Level.INFO, new Object[]{"Detected", numIrrelevantNodes, "irrelevant CFA nodes."});
        if (numIrrelevantNodes == 0) {
            return;
        }
        Predicate irrelevantNode = Predicates.not((Predicate)Predicates.in(relevantNodes));
        ImmutableList removedNodes = ImmutableList.copyOf((Collection)Collections2.filter(allNodes, (Predicate)irrelevantNode));
        this.pruneIrrelevantNodes(cfa, (Collection<CFANode>)removedNodes, errorNodes);
    }

    private Collection<CFANode> getErrorNodesWithCPA(MutableCFA cfa) throws InterruptedException {
        try {
            LogManager lLogger = this.logger.withComponentName("CFAReduction");
            ReachedSetFactory lReachedSetFactory = new ReachedSetFactory(Configuration.defaultConfiguration(), lLogger);
            Configuration lConfig = Configuration.builder().copyFrom(this.config).setOption("output.disable", "true").clearOption("cpa").clearOption("cpas").clearOption("CompositeCPA.cpas").build();
            CPABuilder lBuilder = new CPABuilder(lConfig, lLogger, this.shutdownNotifier, lReachedSetFactory);
            ConfigurableProgramAnalysis lCpas = lBuilder.buildCPAWithSpecAutomatas(cfa);
            CPAAlgorithm lAlgorithm = CPAAlgorithm.create(lCpas, lLogger, lConfig, this.shutdownNotifier);
            ReachedSet lReached = lReachedSetFactory.create();
            lReached.add(lCpas.getInitialState(cfa.getMainFunction(), StateSpacePartition.getDefaultPartition()), lCpas.getInitialPrecision(cfa.getMainFunction(), StateSpacePartition.getDefaultPartition()));
            lAlgorithm.run(lReached);
            CPAs.closeCpaIfPossible(lCpas, lLogger);
            CPAs.closeIfPossible(lAlgorithm, lLogger);
            return FluentIterable.from((Iterable)lReached).filter(AbstractStates.IS_TARGET_STATE).transform(AbstractStates.EXTRACT_LOCATION).toSet();
        }
        catch (CPAException e) {
            this.logger.logUserException(Level.WARNING, (Throwable)e, "Error during CFA reduction, using full CFA");
        }
        catch (InvalidConfigurationException e) {
            this.logger.logUserException(Level.WARNING, (Throwable)e, "Invalid configuration used for CFA reduction, using full CFA");
        }
        return cfa.getAllNodes();
    }

    private void pruneIrrelevantNodes(MutableCFA cfa, Collection<CFANode> irrelevantNodes, Collection<CFANode> errorNodes) {
        for (CFANode n : irrelevantNodes) {
            cfa.removeNode(n);
            for (int edgeIndex = n.getNumEnteringEdges() - 1; edgeIndex >= 0; --edgeIndex) {
                CFAEdge removedEdge = n.getEnteringEdge(edgeIndex);
                CFANode prevNode = removedEdge.getPredecessor();
                if (errorNodes.contains(prevNode)) continue;
                CFACreationUtils.removeEdgeFromNodes(removedEdge);
            }
            while (n.getNumLeavingEdges() > 0) {
                CFACreationUtils.removeEdgeFromNodes(n.getLeavingEdge(0));
            }
            if (n.getEnteringSummaryEdge() != null) {
                CFACreationUtils.removeSummaryEdgeFromNodes(n.getEnteringSummaryEdge());
            }
            if (n.getLeavingSummaryEdge() == null) continue;
            CFACreationUtils.removeSummaryEdgeFromNodes(n.getLeavingSummaryEdge());
        }
    }
}

