/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.postprocessing.global;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.sosy_lab.common.Pair;
import org.sosy_lab.cpachecker.cfa.CFACreationUtils;
import org.sosy_lab.cpachecker.cfa.ast.AAstNode;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.c.CArrayDesignator;
import org.sosy_lab.cpachecker.cfa.ast.c.CArrayRangeDesignator;
import org.sosy_lab.cpachecker.cfa.ast.c.CArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CAssignment;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CComplexCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CComplexTypeDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CDesignatedInitializer;
import org.sosy_lab.cpachecker.cfa.ast.c.CDesignator;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpressionAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpressionStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFieldDesignator;
import org.sosy_lab.cpachecker.cfa.ast.c.CFieldReference;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializer;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializerList;
import org.sosy_lab.cpachecker.cfa.ast.c.CParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CPointerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CReturnStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CRightHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CSimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CTypeDefDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CUnaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.DefaultCExpressionVisitor;
import org.sosy_lab.cpachecker.cfa.model.AbstractCFAEdge;
import org.sosy_lab.cpachecker.cfa.model.BlankEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.CFATerminationNode;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.FunctionExitNode;
import org.sosy_lab.cpachecker.cfa.model.MultiEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CAssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CDeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionSummaryStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CLabelNode;
import org.sosy_lab.cpachecker.cfa.model.c.CReturnStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CStatementEdge;
import org.sosy_lab.cpachecker.cfa.types.Type;
import org.sosy_lab.cpachecker.cfa.types.c.CArrayType;
import org.sosy_lab.cpachecker.cfa.types.c.CComplexType;
import org.sosy_lab.cpachecker.cfa.types.c.CCompositeType;
import org.sosy_lab.cpachecker.cfa.types.c.CElaboratedType;
import org.sosy_lab.cpachecker.cfa.types.c.CEnumType;
import org.sosy_lab.cpachecker.cfa.types.c.CFunctionType;
import org.sosy_lab.cpachecker.cfa.types.c.CFunctionTypeWithNames;
import org.sosy_lab.cpachecker.cfa.types.c.CPointerType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cfa.types.c.CTypedefType;
import org.sosy_lab.cpachecker.cfa.types.c.DefaultCTypeVisitor;
import org.sosy_lab.cpachecker.util.CFATraversal;

class FunctionCloner
implements CFATraversal.CFAVisitor {
    private static final String ONLY_C_SUPPORTED = "only C supported";
    private static final String SUPERGRAPH_BUILD_TOO_EARLY = "functions should be cloned before building the supergraph";
    private final Map<CFANode, CFANode> nodeCache = new HashMap<CFANode, CFANode>();
    private final Map<AAstNode, AAstNode> astCache = new IdentityHashMap<AAstNode, AAstNode>();
    private final Map<Type, Type> typeCache = new IdentityHashMap<Type, Type>();
    private final CExpressionCloner expCloner = new CExpressionCloner();
    private final CTypeCloner typeCloner = new CTypeCloner();
    private final String oldFunctionname;
    private final String newFunctionname;
    private final boolean replaceFunctionOnly;

    public FunctionCloner(String oldFunctionname, String newFunctionname, boolean replaceFunctionOnly) {
        this.oldFunctionname = oldFunctionname;
        this.newFunctionname = newFunctionname;
        this.replaceFunctionOnly = replaceFunctionOnly;
    }

    public static Pair<FunctionEntryNode, Collection<CFANode>> cloneCFA(FunctionEntryNode pFunctionstart, String newFunctionName) {
        String oldFunctionName = pFunctionstart.getFunctionName();
        assert (!oldFunctionName.equals(newFunctionName));
        FunctionCloner visitor = new FunctionCloner(oldFunctionName, newFunctionName, false);
        CFATraversal.dfs().ignoreFunctionCalls().traverseOnce(pFunctionstart, visitor);
        return Pair.of((Object)((FunctionEntryNode)visitor.nodeCache.get(pFunctionstart)), visitor.nodeCache.values());
    }

    @Override
    public CFATraversal.TraversalProcess visitEdge(CFAEdge edge) {
        CFANode start = this.cloneNode(edge.getPredecessor(), true);
        CFANode end = this.cloneNode(edge.getSuccessor(), true);
        CFAEdge newEdge = this.cloneEdge(edge, start, end);
        assert (newEdge.getPredecessor() == start && newEdge.getSuccessor() == end);
        CFACreationUtils.addEdgeUnconditionallyToCFA(newEdge);
        return CFATraversal.TraversalProcess.CONTINUE;
    }

    @Override
    public CFATraversal.TraversalProcess visitNode(CFANode node) {
        this.cloneNode(node, true);
        return CFATraversal.TraversalProcess.CONTINUE;
    }

    public <T extends CFAEdge> T cloneEdge(T edge, CFANode start, CFANode end) {
        AbstractCFAEdge newEdge;
        FileLocation loc = edge.getFileLocation();
        String rawStatement = edge.getRawStatement();
        switch (edge.getEdgeType()) {
            case BlankEdge: {
                newEdge = new BlankEdge(rawStatement, loc, start, end, edge.getDescription());
                break;
            }
            case AssumeEdge: {
                if (edge instanceof CAssumeEdge) {
                    CAssumeEdge e = (CAssumeEdge)edge;
                    newEdge = new CAssumeEdge(rawStatement, loc, start, end, this.cloneAst(e.getExpression()), e.getTruthAssumption());
                    break;
                }
                throw new AssertionError((Object)ONLY_C_SUPPORTED);
            }
            case StatementEdge: {
                if (edge instanceof CFunctionSummaryStatementEdge) {
                    throw new AssertionError((Object)SUPERGRAPH_BUILD_TOO_EARLY);
                }
                if (edge instanceof CStatementEdge) {
                    newEdge = new CStatementEdge(rawStatement, this.cloneAst(((CStatementEdge)edge).getStatement()), loc, start, end);
                    break;
                }
                throw new AssertionError((Object)ONLY_C_SUPPORTED);
            }
            case DeclarationEdge: {
                if (edge instanceof CDeclarationEdge) {
                    newEdge = new CDeclarationEdge(rawStatement, loc, start, end, this.cloneAst(((CDeclarationEdge)edge).getDeclaration()));
                    break;
                }
                throw new AssertionError((Object)ONLY_C_SUPPORTED);
            }
            case ReturnStatementEdge: {
                assert (end instanceof FunctionExitNode);
                if (edge instanceof CReturnStatementEdge) {
                    newEdge = new CReturnStatementEdge(rawStatement, (CReturnStatement)this.cloneAst((AAstNode)((CReturnStatementEdge)edge).getRawAST().get()), loc, start, (FunctionExitNode)end);
                    break;
                }
                throw new AssertionError((Object)ONLY_C_SUPPORTED);
            }
            case MultiEdge: {
                MultiEdge e = (MultiEdge)edge;
                ArrayList<CFAEdge> clonedEdges = new ArrayList<CFAEdge>(e.getEdges().size());
                CFANode pred = start;
                for (CFAEdge child : e) {
                    CFANode succ = this.cloneNode(child.getSuccessor(), false);
                    clonedEdges.add(this.cloneEdge(child, pred, succ));
                    pred = succ;
                }
                assert (pred == end) : "cloned end-node must be in nodeMapping";
                for (int i = 1; i < clonedEdges.size() - 1; ++i) {
                    CFACreationUtils.addEdgeUnconditionallyToCFA((CFAEdge)clonedEdges.get(i));
                }
                newEdge = new MultiEdge(start, end, clonedEdges);
                break;
            }
            case FunctionCallEdge: {
                throw new AssertionError((Object)SUPERGRAPH_BUILD_TOO_EARLY);
            }
            case FunctionReturnEdge: {
                throw new AssertionError((Object)SUPERGRAPH_BUILD_TOO_EARLY);
            }
            case CallToReturnEdge: {
                throw new AssertionError((Object)SUPERGRAPH_BUILD_TOO_EARLY);
            }
            default: {
                throw new AssertionError((Object)("unhandled type of edge: " + (Object)((Object)edge.getEdgeType())));
            }
        }
        return (T)newEdge;
    }

    private <T extends CFANode> T cloneNode(@Nonnull T node, boolean addToMapping) {
        CFANode newNode;
        Preconditions.checkNotNull(node);
        if (this.nodeCache.containsKey(node)) {
            return (T)this.nodeCache.get(node);
        }
        if (node instanceof CLabelNode) {
            newNode = new CLabelNode(this.newFunctionname, ((CLabelNode)node).getLabel());
        } else if (node instanceof CFATerminationNode) {
            newNode = new CFATerminationNode(this.newFunctionname);
        } else if (node instanceof FunctionExitNode) {
            newNode = new FunctionExitNode(this.newFunctionname);
        } else if (node instanceof CFunctionEntryNode) {
            CFunctionEntryNode n = (CFunctionEntryNode)node;
            FunctionExitNode exitNode = n.getExitNode();
            boolean isExitNodeReachable = exitNode.getNumEnteringEdges() > 0;
            FunctionExitNode newExitNode = this.cloneNode(exitNode, isExitNodeReachable);
            Optional returnVariable = n.getReturnVariable();
            if (returnVariable.isPresent()) {
                returnVariable = Optional.of((Object)this.cloneAst((AAstNode)returnVariable.get()));
            }
            CFunctionEntryNode entryNode = new CFunctionEntryNode(n.getFileLocation(), this.cloneAst(n.getFunctionDefinition()), newExitNode, n.getFunctionParameterNames(), (Optional<CVariableDeclaration>)returnVariable);
            newExitNode.setEntryNode(entryNode);
            newNode = entryNode;
        } else {
            assert (node.getClass() == CFANode.class) : "unhandled subclass for CFANode: " + node.getClass();
            newNode = new CFANode(this.newFunctionname);
        }
        newNode.setReversePostorderId(node.getReversePostorderId());
        if (node.isLoopStart()) {
            newNode.setLoopStart();
        }
        if (addToMapping) {
            this.nodeCache.put(node, newNode);
        }
        return (T)newNode;
    }

    private <T extends AAstNode> T cloneAst(T ast) {
        if (ast == null) {
            return null;
        }
        if (this.astCache.containsKey(ast)) {
            return (T)this.astCache.get(ast);
        }
        AAstNode newAst = this.cloneAstDirect(ast);
        this.astCache.put(ast, newAst);
        return (T)newAst;
    }

    private <T extends AAstNode> List<T> cloneAstList(List<T> astList) {
        ArrayList<AAstNode> list = new ArrayList<AAstNode>(astList.size());
        for (AAstNode ast : astList) {
            list.add(this.cloneAst(ast));
        }
        return list;
    }

    private AAstNode cloneAstDirect(AAstNode ast) {
        FileLocation loc = ast.getFileLocation();
        if (ast instanceof CRightHandSide) {
            if (ast instanceof CExpression) {
                return ((CExpression)ast).accept(this.expCloner);
            }
            if (ast instanceof CFunctionCallExpression) {
                CFunctionCallExpression func = (CFunctionCallExpression)ast;
                return new CFunctionCallExpression(loc, this.cloneType(func.getExpressionType()), this.cloneAst(func.getFunctionNameExpression()), this.cloneAstList(func.getParameterExpressions()), this.cloneAst(func.getDeclaration()));
            }
        } else if (ast instanceof CInitializer) {
            if (ast instanceof CInitializerExpression) {
                return new CInitializerExpression(loc, this.cloneAst(((CInitializerExpression)ast).getExpression()));
            }
            if (ast instanceof CInitializerList) {
                return new CInitializerList(loc, this.cloneAstList(((CInitializerList)ast).getInitializers()));
            }
            if (ast instanceof CDesignatedInitializer) {
                CDesignatedInitializer di = (CDesignatedInitializer)ast;
                return new CDesignatedInitializer(loc, this.cloneAstList(di.getDesignators()), this.cloneAst(di.getRightHandSide()));
            }
        } else if (ast instanceof CSimpleDeclaration) {
            if (ast instanceof CVariableDeclaration) {
                CVariableDeclaration decl = (CVariableDeclaration)ast;
                CVariableDeclaration newDecl = new CVariableDeclaration(loc, decl.isGlobal(), decl.getCStorageClass(), this.cloneType(decl.getType()), decl.getName(), decl.getOrigName(), this.changeQualifiedName(decl.getQualifiedName()), null);
                this.astCache.put(ast, newDecl);
                newDecl.addInitializer(this.cloneAst(decl.getInitializer()));
                return newDecl;
            }
            if (ast instanceof CFunctionDeclaration) {
                CFunctionDeclaration decl = (CFunctionDeclaration)ast;
                ArrayList<CParameterDeclaration> l = new ArrayList<CParameterDeclaration>(decl.getParameters().size());
                for (CParameterDeclaration param : decl.getParameters()) {
                    l.add(this.cloneAst(param));
                }
                return new CFunctionDeclaration(loc, this.cloneType(decl.getType()), this.changeName(decl.getName()), l);
            }
            if (ast instanceof CComplexTypeDeclaration) {
                CComplexTypeDeclaration decl = (CComplexTypeDeclaration)ast;
                return new CComplexTypeDeclaration(loc, decl.isGlobal(), this.cloneType(decl.getType()));
            }
            if (ast instanceof CTypeDefDeclaration) {
                CTypeDefDeclaration decl = (CTypeDefDeclaration)ast;
                return new CTypeDefDeclaration(loc, decl.isGlobal(), this.cloneType(decl.getType()), decl.getName(), this.changeQualifiedName(decl.getQualifiedName()));
            }
            if (ast instanceof CParameterDeclaration) {
                CParameterDeclaration decl = (CParameterDeclaration)ast;
                CParameterDeclaration newDecl = new CParameterDeclaration(loc, this.cloneType(decl.getType()), decl.getName());
                newDecl.setQualifiedName(this.changeQualifiedName(decl.getQualifiedName()));
                return newDecl;
            }
            if (ast instanceof CEnumType.CEnumerator) {
                CEnumType.CEnumerator decl = (CEnumType.CEnumerator)ast;
                return new CEnumType.CEnumerator(loc, decl.getName(), this.changeQualifiedName(decl.getQualifiedName()), decl.getValue());
            }
        } else if (ast instanceof CStatement) {
            if (ast instanceof CFunctionCallAssignmentStatement) {
                CFunctionCallAssignmentStatement stat = (CFunctionCallAssignmentStatement)ast;
                return new CFunctionCallAssignmentStatement(loc, this.cloneAst(stat.getLeftHandSide()), this.cloneAst(stat.getRightHandSide()));
            }
            if (ast instanceof CExpressionAssignmentStatement) {
                CExpressionAssignmentStatement stat = (CExpressionAssignmentStatement)ast;
                return new CExpressionAssignmentStatement(loc, this.cloneAst(stat.getLeftHandSide()), this.cloneAst(stat.getRightHandSide()));
            }
            if (ast instanceof CFunctionCallStatement) {
                return new CFunctionCallStatement(loc, this.cloneAst(((CFunctionCallStatement)ast).getFunctionCallExpression()));
            }
            if (ast instanceof CExpressionStatement) {
                return new CExpressionStatement(loc, this.cloneAst(((CExpressionStatement)ast).getExpression()));
            }
        } else {
            if (ast instanceof CReturnStatement) {
                Optional returnAssignment;
                Optional returnExp = ((CReturnStatement)ast).getReturnValue();
                if (returnExp.isPresent()) {
                    returnExp = Optional.of((Object)this.cloneAst((AAstNode)returnExp.get()));
                }
                if ((returnAssignment = ((CReturnStatement)ast).asAssignment()).isPresent()) {
                    returnAssignment = Optional.of((Object)this.cloneAst((AAstNode)returnAssignment.get()));
                }
                return new CReturnStatement(loc, (Optional<CExpression>)returnExp, (Optional<CAssignment>)returnAssignment);
            }
            if (ast instanceof CDesignator) {
                if (ast instanceof CArrayDesignator) {
                    return new CArrayDesignator(loc, this.cloneAst(((CArrayDesignator)ast).getSubscriptExpression()));
                }
                if (ast instanceof CArrayRangeDesignator) {
                    return new CArrayRangeDesignator(loc, this.cloneAst(((CArrayRangeDesignator)ast).getFloorExpression()), this.cloneAst(((CArrayRangeDesignator)ast).getCeilExpression()));
                }
                if (ast instanceof CFieldDesignator) {
                    return new CFieldDesignator(loc, ((CFieldDesignator)ast).getFieldName());
                }
            }
        }
        throw new AssertionError((Object)("unhandled ASTNode " + ast + " of " + ast.getClass()));
    }

    private <T extends Type> T cloneType(T type) {
        if (type == null) {
            return null;
        }
        if (this.typeCache.containsKey(type)) {
            return (T)this.typeCache.get(type);
        }
        Type newType = this.cloneTypeDirect(type);
        this.typeCache.put(type, newType);
        return (T)newType;
    }

    private Type cloneTypeDirect(Type type) {
        if (type instanceof CType) {
            return ((CType)type).accept(this.typeCloner);
        }
        throw new AssertionError((Object)("unhandled Type " + type + " of " + type.getClass()));
    }

    private String changeName(String name) {
        return this.oldFunctionname.equals(name) ? this.newFunctionname : name;
    }

    private String changeQualifiedName(String qualifiedName) {
        if (!this.replaceFunctionOnly && qualifiedName.startsWith(this.oldFunctionname + "::")) {
            return this.newFunctionname + qualifiedName.substring(this.oldFunctionname.length());
        }
        return qualifiedName;
    }

    private class CTypeCloner
    extends DefaultCTypeVisitor<CType, RuntimeException> {
        private CTypeCloner() {
        }

        @Override
        public CType visitDefault(CType t) {
            return t;
        }

        @Override
        public CType visit(CArrayType type) {
            return new CArrayType(type.isConst(), type.isVolatile(), type.getType().accept(this), type.getLength());
        }

        @Override
        public CType visit(CCompositeType type) {
            CCompositeType comp = new CCompositeType(type.isConst(), type.isVolatile(), type.getKind(), (List<CCompositeType.CCompositeTypeMemberDeclaration>)ImmutableList.of(), type.getName(), type.getOrigName());
            FunctionCloner.this.typeCache.put(type, comp);
            ArrayList<CCompositeType.CCompositeTypeMemberDeclaration> l = new ArrayList<CCompositeType.CCompositeTypeMemberDeclaration>(type.getMembers().size());
            for (CCompositeType.CCompositeTypeMemberDeclaration decl : type.getMembers()) {
                l.add(new CCompositeType.CCompositeTypeMemberDeclaration(decl.getType().accept(this), decl.getName()));
            }
            comp.setMembers(l);
            return comp;
        }

        @Override
        public CType visit(CElaboratedType type) {
            return new CElaboratedType(type.isConst(), type.isVolatile(), type.getKind(), type.getName(), type.getOrigName(), (CComplexType)FunctionCloner.this.cloneType(type.getRealType()));
        }

        @Override
        public CType visit(CEnumType type) {
            ArrayList<CEnumType.CEnumerator> l = new ArrayList<CEnumType.CEnumerator>(type.getEnumerators().size());
            for (CEnumType.CEnumerator e : type.getEnumerators()) {
                CEnumType.CEnumerator enumType = new CEnumType.CEnumerator(e.getFileLocation(), e.getName(), FunctionCloner.this.changeQualifiedName(e.getQualifiedName()), e.hasValue() ? Long.valueOf(e.getValue()) : null);
                enumType.setEnum(e.getEnum());
                l.add(enumType);
            }
            return new CEnumType(type.isConst(), type.isVolatile(), l, type.getName(), type.getOrigName());
        }

        @Override
        public CType visit(CFunctionType type) {
            CFunctionType funcType;
            if (type instanceof CFunctionTypeWithNames) {
                ArrayList<CParameterDeclaration> l = new ArrayList<CParameterDeclaration>(type.getParameters().size());
                for (CParameterDeclaration param : ((CFunctionTypeWithNames)type).getParameterDeclarations()) {
                    l.add((CParameterDeclaration)FunctionCloner.this.cloneAst(param));
                }
                funcType = new CFunctionTypeWithNames(type.isConst(), type.isVolatile(), type.getReturnType(), (List<CParameterDeclaration>)l, type.takesVarArgs());
            } else {
                assert (type.getClass() == CFunctionType.class);
                ArrayList<CType> l = new ArrayList<CType>(type.getParameters().size());
                for (CType param : type.getParameters()) {
                    l.add((CType)FunctionCloner.this.cloneType(param));
                }
                funcType = new CFunctionType(type.isConst(), type.isVolatile(), type.getReturnType(), l, type.takesVarArgs());
            }
            funcType.setName(FunctionCloner.this.changeName(type.getName()));
            return funcType;
        }

        @Override
        public CType visit(CPointerType type) {
            return new CPointerType(type.isConst(), type.isVolatile(), type.getType().accept(this));
        }

        @Override
        public CType visit(CTypedefType type) {
            return new CTypedefType(type.isConst(), type.isVolatile(), type.getName(), type.getRealType().accept(this));
        }
    }

    private class CExpressionCloner
    extends DefaultCExpressionVisitor<CExpression, RuntimeException> {
        private CExpressionCloner() {
        }

        @Override
        protected CExpression visitDefault(CExpression exp) {
            return exp;
        }

        @Override
        public CExpression visit(CBinaryExpression exp) {
            return new CBinaryExpression(exp.getFileLocation(), exp.getExpressionType(), exp.getCalculationType(), exp.getOperand1().accept(this), exp.getOperand2().accept(this), exp.getOperator());
        }

        @Override
        public CExpression visit(CCastExpression exp) {
            return new CCastExpression(exp.getFileLocation(), (CType)FunctionCloner.this.cloneType(exp.getExpressionType()), exp.getOperand().accept(this));
        }

        @Override
        public CExpression visit(CUnaryExpression exp) {
            return new CUnaryExpression(exp.getFileLocation(), (CType)FunctionCloner.this.cloneType(exp.getExpressionType()), exp.getOperand().accept(this), exp.getOperator());
        }

        @Override
        public CExpression visit(CArraySubscriptExpression exp) {
            return new CArraySubscriptExpression(exp.getFileLocation(), (CType)FunctionCloner.this.cloneType(exp.getExpressionType()), exp.getArrayExpression().accept(this), exp.getSubscriptExpression().accept(this));
        }

        @Override
        public CExpression visit(CFieldReference exp) {
            return new CFieldReference(exp.getFileLocation(), (CType)FunctionCloner.this.cloneType(exp.getExpressionType()), exp.getFieldName(), exp.getFieldOwner().accept(this), exp.isPointerDereference());
        }

        @Override
        public CExpression visit(CIdExpression exp) {
            if (exp.getExpressionType() instanceof CFunctionType) {
                return new CIdExpression(exp.getFileLocation(), (CType)FunctionCloner.this.cloneType(exp.getExpressionType()), FunctionCloner.this.changeName(exp.getName()), (CSimpleDeclaration)FunctionCloner.this.cloneAst(exp.getDeclaration()));
            }
            return new CIdExpression(exp.getFileLocation(), (CType)FunctionCloner.this.cloneType(exp.getExpressionType()), exp.getName(), (CSimpleDeclaration)FunctionCloner.this.cloneAst(exp.getDeclaration()));
        }

        @Override
        public CExpression visit(CPointerExpression exp) {
            return new CPointerExpression(exp.getFileLocation(), (CType)FunctionCloner.this.cloneType(exp.getExpressionType()), exp.getOperand().accept(this));
        }

        @Override
        public CExpression visit(CComplexCastExpression exp) {
            return new CComplexCastExpression(exp.getFileLocation(), (CType)FunctionCloner.this.cloneType(exp.getExpressionType()), exp.getOperand().accept(this), exp.getType(), exp.isRealCast());
        }
    }
}

