/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.postprocessing.global.singleloop;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.FunctionSummaryEdge;
import org.sosy_lab.cpachecker.core.ShutdownNotifier;
import org.sosy_lab.cpachecker.util.CFAUtils;

class AcyclicGraph {
    private final Set<CFANode> nodes = new HashSet<CFANode>();
    private final Multimap<CFANode, CFAEdge> edges = LinkedHashMultimap.create();
    private final Set<CFANode> uncommittedNodes = new HashSet<CFANode>();
    private final Multimap<CFANode, CFAEdge> uncommittedEdges = LinkedHashMultimap.create();
    private final Predicate<CFAEdge> CONTAINS_EDGE = new Predicate<CFAEdge>(){

        public boolean apply(@Nullable CFAEdge pArg0) {
            return pArg0 != null && AcyclicGraph.this.containsEdge(pArg0);
        }
    };
    private final Function<CFANode, Iterable<CFAEdge>> GET_CONTAINED_LEAVING_EDGES = new Function<CFANode, Iterable<CFAEdge>>(){

        @Nullable
        public Iterable<CFAEdge> apply(@Nullable CFANode pArg0) {
            if (pArg0 == null) {
                return Collections.emptySet();
            }
            return AcyclicGraph.this.getLeavingEdges(pArg0).filter(AcyclicGraph.this.CONTAINS_EDGE).transform((Function)new Function<CFAEdge, CFAEdge>(){

                @Nullable
                public CFAEdge apply(@Nullable CFAEdge pArg0) {
                    if (pArg0 instanceof FunctionCallEdge) {
                        FunctionSummaryEdge summaryEdge = ((FunctionCallEdge)pArg0).getSummaryEdge();
                        return AcyclicGraph.this.containsNode(summaryEdge.getSuccessor()) ? summaryEdge : null;
                    }
                    return pArg0;
                }
            }).filter(Predicates.notNull());
        }
    };

    public AcyclicGraph(CFANode pRoot) {
        this.nodes.add(pRoot);
    }

    public Iterable<CFANode> getNodes() {
        return Iterables.concat(Collections.unmodifiableSet(this.nodes), Collections.unmodifiableSet(this.uncommittedNodes));
    }

    public Iterable<CFAEdge> getEdges() {
        return Iterables.concat(Collections.unmodifiableCollection(this.edges.values()), Collections.unmodifiableCollection(this.uncommittedEdges.values()));
    }

    public boolean containsNode(CFANode pNode) {
        return this.nodes.contains(pNode) || this.uncommittedNodes.contains(pNode);
    }

    public boolean containsEdge(CFAEdge pEdge) {
        return this.edges.containsValue((Object)pEdge) || this.uncommittedEdges.containsValue((Object)pEdge);
    }

    public void addEdge(CFAEdge pEdge, ShutdownNotifier pShutdownNotifier) throws InterruptedException {
        Preconditions.checkArgument((boolean)this.offerEdge(pEdge, pShutdownNotifier));
    }

    public boolean offerEdge(CFAEdge pEdge, ShutdownNotifier pShutdownNotifier) throws InterruptedException {
        if (this.containsEdge(pEdge)) {
            return true;
        }
        if (!this.containsNode(pEdge.getPredecessor()) || this.introducesLoop(pEdge, pShutdownNotifier)) {
            return false;
        }
        this.uncommittedEdges.put((Object)pEdge.getPredecessor(), (Object)pEdge);
        this.uncommittedNodes.add(pEdge.getSuccessor());
        return true;
    }

    public void commit() {
        this.nodes.addAll(this.uncommittedNodes);
        this.edges.putAll(this.uncommittedEdges);
        this.abort();
    }

    public void abort() {
        this.uncommittedNodes.clear();
        this.uncommittedEdges.clear();
    }

    public String toString() {
        return Iterables.toString(this.getEdges());
    }

    public boolean introducesLoop(CFAEdge pEdge, ShutdownNotifier pShutdownNotifier) throws InterruptedException {
        return CFAUtils.existsPath(pEdge.getSuccessor(), pEdge.getPredecessor(), this.GET_CONTAINED_LEAVING_EDGES, pShutdownNotifier);
    }

    private FluentIterable<CFAEdge> getLeavingEdges(CFANode pNode) {
        return FluentIterable.from((Iterable)Iterables.concat((Iterable)this.edges.get((Object)pNode), (Iterable)this.uncommittedEdges.get((Object)pNode)));
    }

    public AcyclicGraph reset(CFANode pNewRootNode) {
        this.abort();
        this.edges.clear();
        this.nodes.clear();
        this.nodes.add(pNewRootNode);
        return this;
    }
}

