/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.postprocessing.global.singleloop;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.BiMap;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.SortedSetMultimap;
import com.google.common.collect.TreeMultimap;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.math.BigInteger;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import javax.annotation.Nullable;
import org.sosy_lab.common.Pair;
import org.sosy_lab.common.collect.CopyOnWriteSortedMap;
import org.sosy_lab.common.collect.PathCopyingPersistentTreeMap;
import org.sosy_lab.common.collect.PersistentSortedMap;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFAReversePostorder;
import org.sosy_lab.cpachecker.cfa.Language;
import org.sosy_lab.cpachecker.cfa.MutableCFA;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpressionBuilder;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCall;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CReturnStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.model.BlankEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdgeType;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.CFATerminationNode;
import org.sosy_lab.cpachecker.cfa.model.FunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.FunctionExitNode;
import org.sosy_lab.cpachecker.cfa.model.FunctionReturnEdge;
import org.sosy_lab.cpachecker.cfa.model.FunctionSummaryEdge;
import org.sosy_lab.cpachecker.cfa.model.MultiEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CAssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CDeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionReturnEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionSummaryEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionSummaryStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CLabelNode;
import org.sosy_lab.cpachecker.cfa.model.c.CReturnStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.java.JMethodEntryNode;
import org.sosy_lab.cpachecker.cfa.postprocessing.global.singleloop.AcyclicGraph;
import org.sosy_lab.cpachecker.cfa.postprocessing.global.singleloop.CProgramCounterValueAssignmentEdge;
import org.sosy_lab.cpachecker.cfa.postprocessing.global.singleloop.CProgramCounterValueAssumeEdge;
import org.sosy_lab.cpachecker.cfa.postprocessing.global.singleloop.ProgramCounterValueAssignmentEdge;
import org.sosy_lab.cpachecker.cfa.postprocessing.global.singleloop.ProgramCounterValueAssumeEdge;
import org.sosy_lab.cpachecker.cfa.postprocessing.global.singleloop.SingleLoopHead;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.c.CFunctionType;
import org.sosy_lab.cpachecker.cfa.types.c.CNumericTypes;
import org.sosy_lab.cpachecker.cfa.types.c.CStorageClass;
import org.sosy_lab.cpachecker.core.ShutdownNotifier;
import org.sosy_lab.cpachecker.util.CFAUtils;
import org.sosy_lab.cpachecker.util.LoopStructure;

@Options(prefix="cfa.transformIntoSingleLoop")
public class CFASingleLoopTransformation {
    public static final String ARTIFICIAL_PROGRAM_COUNTER_FUNCTION_NAME = " ";
    public static final String PROGRAM_COUNTER_VAR_NAME = "___pc";
    private static final String DUMMY_EDGE = "DummyEdge";
    private static final Predicate<CFAEdge> DUMMY_EDGE_PREDICATE = new Predicate<CFAEdge>(){

        public boolean apply(@Nullable CFAEdge pArg0) {
            return CFASingleLoopTransformation.isDummyEdge(pArg0);
        }
    };
    private final LogManager logger;
    private final ShutdownNotifier shutdownNotifier;
    @Option(secure=true, description="Single loop transformation builds a decision tree based on the program counter values. This option causes the last program counter value not to be explicitly assumed in the decision tree, so that it is only indirectly represented by the assumption of falsehood for all other assumptions in the decision tree.")
    private boolean omitExplicitLastProgramCounterAssumption = false;
    @Option(secure=true, description="This option controls the size of the subgraphs referred to by program counter values. The larger the subgraphs, the fewer program counter values are required. Possible values are  MULTIPLE_PATHS, SINGLE_PATH and SINGLE_EDGE, where MULTIPLE_PATHS has the largest subgraphs (and fewest program counter values) and SINGLE_EDGE has the smallest subgraphs (and most program counter values). The larger the subgraphs, the closer the resulting graph will look like the original CFA.")
    private SubGraphGrowthStrategy subgraphGrowthStrategy = SubGraphGrowthStrategy.MULTIPLE_PATHS;

    private CFASingleLoopTransformation(LogManager pLogger, Configuration pConfig, ShutdownNotifier pShutdownNotifier) throws InvalidConfigurationException {
        this.logger = pLogger;
        this.shutdownNotifier = pShutdownNotifier;
        pConfig.inject((Object)this);
    }

    public static CFASingleLoopTransformation getSingleLoopTransformation(LogManager pLogger, Configuration pConfig, @Nullable ShutdownNotifier pShutdownNotifier) throws InvalidConfigurationException {
        return new CFASingleLoopTransformation(pLogger, pConfig, pShutdownNotifier);
    }

    public MutableCFA apply(MutableCFA pInputCFA) throws InvalidConfigurationException, InterruptedException {
        if (pInputCFA.getLoopStructure().isPresent()) {
            LoopStructure loopStructure = (LoopStructure)pInputCFA.getLoopStructure().get();
            if (loopStructure.getCount() == 0) {
                return pInputCFA;
            }
            if (loopStructure.getCount() == 1) {
                boolean modificationRequired;
                LoopStructure.Loop singleLoop = (LoopStructure.Loop)Iterables.getOnlyElement(loopStructure.getAllLoops());
                boolean bl = modificationRequired = singleLoop.getLoopHeads().size() > 1 || FluentIterable.from(singleLoop.getIncomingEdges()).filter(Predicates.not((Predicate)Predicates.instanceOf(CFunctionReturnEdge.class))).size() > 1;
                if (!modificationRequired) {
                    return pInputCFA;
                }
            }
        }
        CopyOnWriteSortedMap globalNewToOld = CopyOnWriteSortedMap.copyOf((PersistentSortedMap)PathCopyingPersistentTreeMap.of());
        FunctionEntryNode oldMainFunctionEntryNode = pInputCFA.getMainFunction();
        FunctionEntryNode start = (FunctionEntryNode)this.getOrCreateNewFromOld(oldMainFunctionEntryNode, (Map<CFANode, CFANode>)globalNewToOld);
        SingleLoopHead loopHead = new SingleLoopHead();
        ArrayDeque<CFANode> nodes = new ArrayDeque<CFANode>(CFASingleLoopTransformation.getAllNodes(oldMainFunctionEntryNode));
        this.eliminateSelfLoops(nodes);
        LinkedHashMultimap newPredecessorsToPC = LinkedHashMultimap.create();
        LinkedHashMap<Integer, CFANode> newSuccessorsToPC = new LinkedHashMap<Integer, CFANode>();
        globalNewToOld.put((Object)oldMainFunctionEntryNode, (Object)start);
        int pcValueOfStart = this.buildProgramCounterValueMaps(oldMainFunctionEntryNode, nodes, (Multimap<Integer, CFANode>)newPredecessorsToPC, newSuccessorsToPC, (CopyOnWriteSortedMap<CFANode, CFANode>)globalNewToOld);
        String pcVarName = PROGRAM_COUNTER_VAR_NAME;
        CInitializerExpression pcInitializer = new CInitializerExpression(FileLocation.DUMMY, new CIntegerLiteralExpression(FileLocation.DUMMY, CNumericTypes.INT, BigInteger.valueOf(pcValueOfStart)));
        CVariableDeclaration pcDeclaration = new CVariableDeclaration(FileLocation.DUMMY, true, CStorageClass.AUTO, CNumericTypes.INT, pcVarName, pcVarName, pcVarName, pcInitializer);
        CIdExpression pcIdExpression = new CIdExpression(FileLocation.DUMMY, pcDeclaration);
        CFANode declarationDummy = (CFANode)newSuccessorsToPC.get(pcValueOfStart);
        CDeclarationEdge pcDeclarationEdge = new CDeclarationEdge(String.format("int %s = %d;", pcVarName, pcValueOfStart), FileLocation.DUMMY, (CFANode)start, declarationDummy, pcDeclaration);
        ImmutableBiMap newSuccessorsToPCImmutable = ImmutableBiMap.copyOf(newSuccessorsToPC);
        CFASingleLoopTransformation.addToNodes(pcDeclarationEdge);
        this.simplify(start, (Multimap<Integer, CFANode>)newPredecessorsToPC, newSuccessorsToPC, (BiMap<Integer, CFANode>)newSuccessorsToPCImmutable, (Map<CFANode, CFANode>)globalNewToOld);
        CFASingleLoopTransformation.connectSubgraphLeavingNodesToLoopHead(loopHead, (Multimap<Integer, CFANode>)newPredecessorsToPC, pcIdExpression);
        this.connectLoopHeadToSubgraphEntryNodes(loopHead, newSuccessorsToPC, pcIdExpression, new CBinaryExpressionBuilder(pInputCFA.getMachineModel(), this.logger));
        this.fixSummaryEdges(start, (ImmutableBiMap<Integer, CFANode>)newSuccessorsToPCImmutable, (Map<CFANode, CFANode>)globalNewToOld);
        return this.buildCFA(start, loopHead, pInputCFA.getMachineModel(), pInputCFA.getLanguage());
    }

    private void simplify(CFANode pStartNode, Multimap<Integer, CFANode> pNewPredecessorsToPC, Map<Integer, CFANode> pNewSuccessorsToPC, BiMap<Integer, CFANode> pImmutableNewSuccessorsToPC, Map<CFANode, CFANode> pGlobalNewToOld) throws InterruptedException {
        Integer precedingPCValue;
        BiMap pcToNewSuccessors = pImmutableNewSuccessorsToPC.inverse();
        Iterator<Object> i$ = new ArrayList(pNewPredecessorsToPC.keySet()).iterator();
        while (i$.hasNext()) {
            int replaceablePCValue = (Integer)i$.next();
            this.shutdownNotifier.shutdownIfNecessary();
            CFANode newSuccessor = pNewSuccessorsToPC.get(replaceablePCValue);
            ArrayList tailsOfRedundantSubgraph = new ArrayList(pNewPredecessorsToPC.get((Object)replaceablePCValue));
            for (CFANode tailOfRedundantSubgraph : tailsOfRedundantSubgraph) {
                CFAEdge dummyEdge;
                if (tailOfRedundantSubgraph.getNumEnteringEdges() != 1 || !CFASingleLoopTransformation.isDummyEdge(dummyEdge = tailOfRedundantSubgraph.getEnteringEdge(0)) || dummyEdge.getPredecessor().getNumEnteringEdges() != 0 || (precedingPCValue = (Integer)pcToNewSuccessors.get(dummyEdge.getPredecessor())) == null) continue;
                Integer predToRemove = (Integer)pcToNewSuccessors.get(newSuccessor);
                CFANode removed = pNewSuccessorsToPC.remove(predToRemove);
                assert (removed == newSuccessor);
                for (CFANode removedPredecessor : pNewPredecessorsToPC.removeAll((Object)predToRemove)) {
                    pNewPredecessorsToPC.put((Object)precedingPCValue, (Object)removedPredecessor);
                }
                pNewPredecessorsToPC.remove((Object)precedingPCValue, (Object)tailOfRedundantSubgraph);
                pNewSuccessorsToPC.remove(precedingPCValue);
                pNewSuccessorsToPC.put(precedingPCValue, newSuccessor);
            }
        }
        for (CFAEdge oldDummyEdge : this.findEdges(DUMMY_EDGE_PREDICATE, pStartNode)) {
            this.shutdownNotifier.shutdownIfNecessary();
            CFANode successor = pGlobalNewToOld.get(oldDummyEdge.getSuccessor());
            for (CFAEdge edge : CFAUtils.enteringEdges(successor).toList()) {
                if (!CFASingleLoopTransformation.isDummyEdge(edge)) continue;
                CFASingleLoopTransformation.removeFromNodes(edge);
                CFANode predecessor = edge.getPredecessor();
                if (predecessor.getNumEnteringEdges() == 0 && (precedingPCValue = (Integer)pcToNewSuccessors.get(predecessor)) != null) {
                    pcToNewSuccessors.remove(predecessor);
                    pNewSuccessorsToPC.remove(precedingPCValue);
                    pNewSuccessorsToPC.put(precedingPCValue, edge.getSuccessor());
                    continue;
                }
                for (CFAEdge edgeEnteringPredecessor : CFAUtils.enteringEdges(predecessor).toList()) {
                    CFASingleLoopTransformation.removeFromNodes(edgeEnteringPredecessor);
                    edgeEnteringPredecessor = this.copyCFAEdgeWithNewNodes(edgeEnteringPredecessor, edgeEnteringPredecessor.getPredecessor(), successor, pGlobalNewToOld);
                    CFASingleLoopTransformation.addToNodes(edgeEnteringPredecessor);
                }
            }
        }
    }

    private void fixSummaryEdges(FunctionEntryNode pStartNode, ImmutableBiMap<Integer, CFANode> pNewSuccessorsToPC, Map<CFANode, CFANode> pGlobalNewToOld) throws InterruptedException {
        block0: for (FunctionCallEdge fce : this.findEdges(FunctionCallEdge.class, (CFANode)pStartNode)) {
            FunctionEntryNode entryNode = fce.getSuccessor();
            FunctionExitNode exitNode = entryNode.getExitNode();
            FunctionSummaryEdge oldSummaryEdge = fce.getSummaryEdge();
            CFANode oldSummarySuccessor = fce.getSummaryEdge().getSuccessor();
            Integer pcValue = (Integer)pNewSuccessorsToPC.inverse().get((Object)oldSummarySuccessor);
            if (pcValue == null) continue;
            for (CFANode potentialNewSummarySuccessor : CFAUtils.successorsOf(exitNode)) {
                ProgramCounterValueAssignmentEdge programCounterValueAssignmentEdge;
                CFAEdge potentialPCValueAssignmentEdge;
                if (potentialNewSummarySuccessor.getNumLeavingEdges() != 1 || !((potentialPCValueAssignmentEdge = potentialNewSummarySuccessor.getLeavingEdge(0)) instanceof ProgramCounterValueAssignmentEdge) || (programCounterValueAssignmentEdge = (ProgramCounterValueAssignmentEdge)potentialPCValueAssignmentEdge).getProgramCounterValue() != pcValue.intValue()) continue;
                FunctionSummaryEdge newSummaryEdge = (FunctionSummaryEdge)this.copyCFAEdgeWithNewNodes(oldSummaryEdge, oldSummaryEdge.getPredecessor(), potentialNewSummarySuccessor, pGlobalNewToOld);
                for (CFunctionSummaryStatementEdge edge : CFAUtils.leavingEdges(oldSummaryEdge.getPredecessor()).filter(CFunctionSummaryStatementEdge.class)) {
                    if (edge.getPredecessor() == newSummaryEdge.getPredecessor() && edge.getSuccessor() == newSummaryEdge.getSuccessor()) continue;
                    CFASingleLoopTransformation.removeFromNodes(edge);
                    if (exitNode.getNumEnteringEdges() <= 0) continue;
                    CFAEdge newEdge = this.copyCFAEdgeWithNewNodes(edge, newSummaryEdge.getPredecessor(), newSummaryEdge.getSuccessor(), pGlobalNewToOld);
                    CFASingleLoopTransformation.addToNodes(newEdge);
                }
                CFASingleLoopTransformation.removeSummaryEdgeFromNodes(oldSummaryEdge);
                oldSummaryEdge = newSummaryEdge.getPredecessor().getLeavingSummaryEdge();
                if (oldSummaryEdge != null) {
                    CFASingleLoopTransformation.removeSummaryEdgeFromNodes(oldSummaryEdge);
                }
                newSummaryEdge.getPredecessor().addLeavingSummaryEdge(newSummaryEdge);
                oldSummaryEdge = newSummaryEdge.getSuccessor().getEnteringSummaryEdge();
                if (oldSummaryEdge != null) {
                    CFASingleLoopTransformation.removeSummaryEdgeFromNodes(oldSummaryEdge);
                }
                newSummaryEdge.getSuccessor().addEnteringSummaryEdge(newSummaryEdge);
                continue block0;
            }
        }
    }

    private <T extends CFAEdge> Iterable<T> findEdges(Class<T> pTypeToken, CFANode pStartNode) {
        return FluentIterable.from(this.findEdges((Predicate<? super CFAEdge>)Predicates.instanceOf(pTypeToken), pStartNode)).filter(pTypeToken);
    }

    private Iterable<CFAEdge> findEdges(Predicate<? super CFAEdge> pPredicate, CFANode pStartNode) {
        ArrayList<CFAEdge> result = new ArrayList<CFAEdge>();
        HashSet<CFANode> visited = new HashSet<CFANode>();
        ArrayDeque<CFANode> waitlist = new ArrayDeque<CFANode>();
        waitlist.add(pStartNode);
        while (!waitlist.isEmpty()) {
            CFANode current = (CFANode)waitlist.poll();
            if (!visited.add(current)) continue;
            for (CFAEdge edge : CFAUtils.leavingEdges(current)) {
                if (pPredicate.apply((Object)edge)) {
                    result.add(edge);
                }
                waitlist.add(edge.getSuccessor());
            }
        }
        return result;
    }

    private int buildProgramCounterValueMaps(FunctionEntryNode pOldMainFunctionEntryNode, Iterable<CFANode> pNodes, Multimap<Integer, CFANode> pNewPredecessorsToPC, Map<Integer, CFANode> pNewSuccessorsToPC, CopyOnWriteSortedMap<CFANode, CFANode> pGlobalNewToOld) throws InterruptedException {
        HashSet<CFANode> visited = new HashSet<CFANode>();
        LinkedHashMap<CFANode, CFANode> tmpMap = new LinkedHashMap<CFANode, CFANode>();
        AcyclicGraph subgraph = null;
        int pcValueOfStart = -1;
        LinkedHashSet<CFANode> newWaitlistNodes = new LinkedHashSet<CFANode>();
        ArrayList<Pair> predecessorsAndSuccessors = new ArrayList<Pair>();
        for (CFANode subgraphRoot : pNodes) {
            if (!visited.add(subgraphRoot)) continue;
            this.shutdownNotifier.shutdownIfNecessary();
            boolean isOldMainEntryNode = subgraphRoot.equals(pOldMainFunctionEntryNode);
            if (isOldMainEntryNode) {
                subgraphRoot = new CFANode(subgraphRoot.getFunctionName());
                this.replaceInStructure(pOldMainFunctionEntryNode, subgraphRoot);
                CFANode newSubgraphRoot = this.getOrCreateNewFromOld(subgraphRoot, (Map<CFANode, CFANode>)pGlobalNewToOld);
                pcValueOfStart = CFASingleLoopTransformation.getPCValueFor(newSubgraphRoot);
                pNewSuccessorsToPC.put(pcValueOfStart, newSubgraphRoot);
                visited.add(subgraphRoot);
            }
            subgraph = subgraph == null ? new AcyclicGraph(subgraphRoot) : subgraph.reset(subgraphRoot);
            ArrayDeque<CFANode> waitlist = new ArrayDeque<CFANode>();
            waitlist.add(subgraphRoot);
            CopyOnWriteSortedMap newToOld = CopyOnWriteSortedMap.copyOf(pGlobalNewToOld);
            while (!waitlist.isEmpty()) {
                CFANode current = (CFANode)waitlist.poll();
                assert (subgraph.containsNode(current) && visited.contains(current));
                newWaitlistNodes.clear();
                predecessorsAndSuccessors.clear();
                HashSet<CFAEdge> edgesToRemove = new HashSet<CFAEdge>();
                HashSet<CFAEdge> edgesToAdd = new HashSet<CFAEdge>();
                for (CFAEdge edge : CFAUtils.leavingEdges(current).toList()) {
                    CFANode newSuccessor;
                    CFANode newPredecessor;
                    CFANode next = edge.getSuccessor();
                    assert (current != next) : "Self-loops must be eliminated previously";
                    if ((!visited.contains(next) || subgraph.containsNode(next)) && (edge.getEdgeType() == CFAEdgeType.ReturnStatementEdge || next instanceof CFATerminationNode || this.subgraphGrowthStrategy.isFurtherGrowthDesired(subgraph)) && subgraph.offerEdge(edge, this.shutdownNotifier)) {
                        if (!visited.add(next)) continue;
                        newWaitlistNodes.add(next);
                        continue;
                    }
                    assert (tmpMap.isEmpty());
                    if (edge.getEdgeType() == CFAEdgeType.FunctionCallEdge) {
                        newWaitlistNodes.clear();
                        predecessorsAndSuccessors.clear();
                        subgraph.abort();
                        newToOld = CopyOnWriteSortedMap.copyOf((CopyOnWriteSortedMap)pGlobalNewToOld);
                        edgesToAdd.clear();
                        edgesToRemove.clear();
                        FunctionCallEdge fce = (FunctionCallEdge)edge;
                        tmpMap.put(next, next);
                        tmpMap.put(fce.getSummaryEdge().getSuccessor(), fce.getSummaryEdge().getSuccessor());
                        CFAEdge newEdge = this.replaceAndCopy(edge, tmpMap, (Map<CFANode, CFANode>)newToOld, edgesToRemove, edgesToAdd);
                        newPredecessor = this.getOrCreateNewFromOld(current, (Map<CFANode, CFANode>)newToOld);
                        newSuccessor = newEdge.getPredecessor();
                        predecessorsAndSuccessors.add(Pair.of((Object)newPredecessor, (Object)newSuccessor));
                        for (CFAEdge otherEdge : CFAUtils.leavingEdges(current).toList()) {
                            if (otherEdge == edge) continue;
                            this.replaceAndCopy(otherEdge, (CFANode)tmpMap.get(current), otherEdge.getSuccessor(), tmpMap, (Map<CFANode, CFANode>)newToOld, edgesToRemove, edgesToAdd);
                        }
                        tmpMap.clear();
                        break;
                    }
                    edgesToRemove.add(edge);
                    tmpMap.put(current, current);
                    CFAEdge replacementEdge = this.copyCFAEdgeWithNewNodes(edge, tmpMap);
                    edgesToAdd.add(replacementEdge);
                    subgraph.addEdge(replacementEdge, this.shutdownNotifier);
                    CFANode dummy = replacementEdge.getSuccessor();
                    newPredecessor = this.getOrCreateNewFromOld(dummy, (Map<CFANode, CFANode>)newToOld);
                    newSuccessor = this.getOrCreateNewFromOld(next, (Map<CFANode, CFANode>)newToOld);
                    predecessorsAndSuccessors.add(Pair.of((Object)newPredecessor, (Object)newSuccessor));
                    tmpMap.clear();
                }
                pGlobalNewToOld = CopyOnWriteSortedMap.copyOf((CopyOnWriteSortedMap)newToOld);
                subgraph.commit();
                waitlist.addAll(newWaitlistNodes);
                for (Pair predecessorAndSuccessor : predecessorsAndSuccessors) {
                    CFANode predecessor = (CFANode)predecessorAndSuccessor.getFirst();
                    CFANode successor = (CFANode)predecessorAndSuccessor.getSecond();
                    this.registerTransitionThroughLoopHead(predecessor, successor, pNewPredecessorsToPC, pNewSuccessorsToPC);
                }
                for (CFAEdge edgeToRemove : edgesToRemove) {
                    CFASingleLoopTransformation.removeFromNodes(edgeToRemove);
                }
                for (CFAEdge edgeToAdd : edgesToAdd) {
                    CFASingleLoopTransformation.addToNodes(edgeToAdd);
                }
            }
            for (CFAEdge oldEdge : subgraph.getEdges()) {
                CFASingleLoopTransformation.addToNodes(this.copyCFAEdgeWithNewNodes(oldEdge, (Map<CFANode, CFANode>)pGlobalNewToOld));
            }
        }
        return pcValueOfStart;
    }

    private void registerTransitionThroughLoopHead(CFANode pPredecessor, CFANode pSuccessor, Multimap<Integer, CFANode> pPredecessorsToPC, Map<Integer, CFANode> pSuccessorsToPC) {
        if (!(pPredecessor instanceof CFATerminationNode)) {
            int pcToSuccessor = CFASingleLoopTransformation.getPCValueFor(pSuccessor);
            pPredecessorsToPC.put((Object)pcToSuccessor, (Object)pPredecessor);
            pSuccessorsToPC.put(pcToSuccessor, pSuccessor);
        }
    }

    private CFAEdge replaceAndCopy(CFAEdge pOriginalEdge, @Nullable Map<CFANode, CFANode> pOldToOld, Map<CFANode, CFANode> pGlobalNewToOld, Set<CFAEdge> pEdgesToRemove, Set<CFAEdge> pEdgesToAdd) {
        CFANode replacementPredecessor = this.getOrCreateNewFromOld(pOriginalEdge.getPredecessor(), pOldToOld);
        CFANode replacementSuccessor = this.getOrCreateNewFromOld(pOriginalEdge.getSuccessor(), pOldToOld);
        return this.replaceAndCopy(pOriginalEdge, replacementPredecessor, replacementSuccessor, pOldToOld, pGlobalNewToOld, pEdgesToRemove, pEdgesToAdd);
    }

    private CFAEdge replaceAndCopy(CFAEdge pOriginalEdge, CFANode pReplacementPredecessor, CFANode pReplacementSuccessor, @Nullable Map<CFANode, CFANode> pOldToOld, Map<CFANode, CFANode> pGlobalNewToOld, Set<CFAEdge> pEdgesToRemove, Set<CFAEdge> pEdgesToAdd) {
        pEdgesToRemove.add(pOriginalEdge);
        CFAEdge replacementEdge = this.copyCFAEdgeWithNewNodes(pOriginalEdge, pReplacementPredecessor, pReplacementSuccessor, pOldToOld);
        pEdgesToAdd.add(replacementEdge);
        CFAEdge newEdge = this.copyCFAEdgeWithNewNodes(replacementEdge, pGlobalNewToOld);
        pEdgesToAdd.add(newEdge);
        return newEdge;
    }

    private void eliminateSelfLoops(Collection<CFANode> pNodes) throws InterruptedException {
        ArrayList<CFANode> toAdd = new ArrayList<CFANode>();
        for (CFANode node : pNodes) {
            this.shutdownNotifier.shutdownIfNecessary();
            for (CFAEdge edge : CFAUtils.leavingEdges(node)) {
                FluentIterable<CFAEdge> leavingEdges;
                CFANode successor = edge.getSuccessor();
                if (successor == node) {
                    CFASingleLoopTransformation.removeFromNodes(edge);
                    LinkedHashMap<CFANode, CFANode> tmpMap = new LinkedHashMap<CFANode, CFANode>();
                    CFANode dummy = this.getOrCreateNewFromOld(successor, tmpMap);
                    tmpMap.put(node, node);
                    CFAEdge replacementEdge = this.copyCFAEdgeWithNewNodes(edge, node, dummy, tmpMap);
                    CFASingleLoopTransformation.addToNodes(replacementEdge);
                    BlankEdge dummyEdge = new BlankEdge("", edge.getFileLocation(), dummy, successor, DUMMY_EDGE);
                    CFASingleLoopTransformation.addToNodes(dummyEdge);
                    toAdd.add(dummy);
                    edge = dummyEdge;
                }
                if (edge.getEdgeType() != CFAEdgeType.AssumeEdge) continue;
                CFANode assumePredecessor = edge.getPredecessor();
                CFANode current = edge.getSuccessor();
                CFAEdge leavingEdge = edge;
                ArrayList<CFAEdge> edgesToRemove = new ArrayList<CFAEdge>();
                edgesToRemove.add(leavingEdge);
                while (!current.equals(assumePredecessor) && (leavingEdges = CFAUtils.leavingEdges(current)).size() == 1 && (leavingEdge = (CFAEdge)Iterables.getOnlyElement(leavingEdges)).getEdgeType() == CFAEdgeType.BlankEdge) {
                    current = leavingEdge.getSuccessor();
                    edgesToRemove.add(leavingEdge);
                }
                if (!current.equals(assumePredecessor)) continue;
                for (CFAEdge toRemove : edgesToRemove) {
                    CFASingleLoopTransformation.removeFromNodes(toRemove);
                }
                CFATerminationNode terminationNode = new CFATerminationNode(assumePredecessor.getFunctionName());
                CFAEdge newEdge = this.copyCFAEdgeWithNewNodes(edge, assumePredecessor, terminationNode, new LinkedHashMap<CFANode, CFANode>());
                CFASingleLoopTransformation.addToNodes(newEdge);
                toAdd.add(terminationNode);
            }
        }
        pNodes.addAll(toAdd);
    }

    private MutableCFA buildCFA(FunctionEntryNode pStartNode, CFANode pLoopHead, MachineModel pMachineModel, Language pLanguage) throws InvalidConfigurationException, InterruptedException {
        TreeMap<String, FunctionEntryNode> functions = new TreeMap<String, FunctionEntryNode>();
        SortedSetMultimap<String, CFANode> allNodes = this.mapNodesToFunctions(pStartNode, functions);
        pLoopHead.setReversePostorderId(-1);
        MutableCFA cfa = new MutableCFA(pMachineModel, functions, allNodes, pStartNode, pLanguage);
        LoopStructure loopStructure = LoopStructure.getLoopStructureForSingleLoop(pLoopHead);
        cfa.setLoopStructure((Optional<LoopStructure>)Optional.of((Object)loopStructure));
        return cfa;
    }

    private SortedSetMultimap<String, CFANode> mapNodesToFunctions(FunctionEntryNode pStartNode, Map<String, FunctionEntryNode> functions) throws InterruptedException {
        TreeMultimap allNodes = TreeMultimap.create();
        FunctionExitNode artificialFunctionExitNode = new FunctionExitNode(ARTIFICIAL_PROGRAM_COUNTER_FUNCTION_NAME);
        CFunctionDeclaration artificialFunctionDeclaration = new CFunctionDeclaration(FileLocation.DUMMY, CFunctionType.NO_ARGS_VOID_FUNCTION, ARTIFICIAL_PROGRAM_COUNTER_FUNCTION_NAME, (List<CParameterDeclaration>)ImmutableList.of());
        CFunctionEntryNode artificialFunctionEntryNode = new CFunctionEntryNode(FileLocation.DUMMY, artificialFunctionDeclaration, artificialFunctionExitNode, Collections.emptyList(), (Optional<CVariableDeclaration>)Optional.absent());
        Set<CFANode> nodes = CFASingleLoopTransformation.getAllNodes(pStartNode);
        for (CFANode node : nodes) {
            for (CFAEdge leavingEdge : CFAUtils.allLeavingEdges(node).toList()) {
                if (nodes.contains(leavingEdge.getSuccessor())) continue;
                CFASingleLoopTransformation.removeFromNodes(leavingEdge);
            }
            allNodes.put((Object)node.getFunctionName(), (Object)node);
            if (node instanceof FunctionEntryNode) {
                functions.put(node.getFunctionName(), (FunctionEntryNode)node);
                continue;
            }
            if (!node.getFunctionName().equals(ARTIFICIAL_PROGRAM_COUNTER_FUNCTION_NAME)) continue;
            functions.put(node.getFunctionName(), artificialFunctionEntryNode);
        }
        ImmutableList nodesWithNoIdAssigned = CFASingleLoopTransformation.getAllNodes(pStartNode);
        for (CFANode n : nodesWithNoIdAssigned) {
            n.setReversePostorderId(-1);
        }
        while (!nodesWithNoIdAssigned.isEmpty()) {
            this.shutdownNotifier.shutdownIfNecessary();
            CFAReversePostorder sorter = new CFAReversePostorder();
            sorter.assignSorting((CFANode)nodesWithNoIdAssigned.iterator().next());
            nodesWithNoIdAssigned = FluentIterable.from(nodesWithNoIdAssigned).filter((Predicate)new Predicate<CFANode>(){

                public boolean apply(@Nullable CFANode pArg0) {
                    if (pArg0 == null) {
                        return false;
                    }
                    return pArg0.getReversePostorderId() < 0;
                }
            }).toList();
        }
        return allNodes;
    }

    private static void removeFromGraph(CFANode pToRemove) {
        while (pToRemove.getNumEnteringEdges() > 0) {
            CFASingleLoopTransformation.removeFromNodes(pToRemove.getEnteringEdge(0));
        }
        if (pToRemove.getEnteringSummaryEdge() != null) {
            CFASingleLoopTransformation.removeSummaryEdgeFromNodes(pToRemove.getEnteringSummaryEdge());
        }
        while (pToRemove.getNumLeavingEdges() > 0) {
            CFASingleLoopTransformation.removeFromNodes(pToRemove.getLeavingEdge(0));
        }
        if (pToRemove.getLeavingSummaryEdge() != null) {
            CFASingleLoopTransformation.removeSummaryEdgeFromNodes(pToRemove.getLeavingSummaryEdge());
        }
    }

    private static void removeFromNodes(CFAEdge pEdge) {
        if (pEdge instanceof FunctionSummaryEdge) {
            CFASingleLoopTransformation.removeSummaryEdgeFromNodes((FunctionSummaryEdge)pEdge);
        } else {
            FunctionCallEdge functionCallEdge;
            FunctionSummaryEdge summaryEdge;
            pEdge.getPredecessor().removeLeavingEdge(pEdge);
            pEdge.getSuccessor().removeEnteringEdge(pEdge);
            if (pEdge instanceof FunctionCallEdge && (summaryEdge = (functionCallEdge = (FunctionCallEdge)pEdge).getSummaryEdge()) != null) {
                CFASingleLoopTransformation.removeSummaryEdgeFromNodes(summaryEdge);
            }
        }
    }

    private static void removeSummaryEdgeFromNodes(FunctionSummaryEdge pEdge) {
        CFANode successor;
        CFANode predecessor = pEdge.getPredecessor();
        if (predecessor.getLeavingSummaryEdge() == pEdge) {
            predecessor.removeLeavingSummaryEdge(pEdge);
        }
        if ((successor = pEdge.getSuccessor()).getEnteringSummaryEdge() == pEdge) {
            successor.removeEnteringSummaryEdge(pEdge);
        }
    }

    private static void addToNodes(CFAEdge pEdge) {
        CFANode predecessor = pEdge.getPredecessor();
        if (pEdge instanceof FunctionSummaryEdge) {
            FunctionSummaryEdge summaryEdge = (FunctionSummaryEdge)pEdge;
            FunctionSummaryEdge oldSummaryEdge = pEdge.getPredecessor().getLeavingSummaryEdge();
            if (oldSummaryEdge != null) {
                CFASingleLoopTransformation.removeSummaryEdgeFromNodes(oldSummaryEdge);
            }
            if ((oldSummaryEdge = pEdge.getSuccessor().getEnteringSummaryEdge()) != null) {
                CFASingleLoopTransformation.removeSummaryEdgeFromNodes(oldSummaryEdge);
            }
            predecessor.addLeavingSummaryEdge(summaryEdge);
            pEdge.getSuccessor().addEnteringSummaryEdge(summaryEdge);
        } else {
            assert (predecessor.getNumLeavingEdges() == 0 || predecessor.getNumLeavingEdges() <= 1 && pEdge.getEdgeType() == CFAEdgeType.AssumeEdge || predecessor instanceof FunctionExitNode && pEdge.getEdgeType() == CFAEdgeType.FunctionReturnEdge || predecessor.getLeavingEdge(0).getEdgeType() == CFAEdgeType.FunctionCallEdge && pEdge.getEdgeType() == CFAEdgeType.StatementEdge || predecessor.getLeavingEdge(0).getEdgeType() == CFAEdgeType.StatementEdge && pEdge.getEdgeType() == CFAEdgeType.FunctionCallEdge);
            predecessor.addLeavingEdge(pEdge);
            pEdge.getSuccessor().addEnteringEdge(pEdge);
        }
    }

    private static void connectSubgraphLeavingNodesToLoopHead(CFANode pLoopHead, Multimap<Integer, CFANode> pNewPredecessorsToPC, CIdExpression pPCIdExpression) {
        HashMap<Integer, CFANode> connectionNodes = new HashMap<Integer, CFANode>();
        for (Map.Entry newPredecessorToPC : pNewPredecessorsToPC.entries()) {
            int pcToSet = (Integer)newPredecessorToPC.getKey();
            CFANode connectionNode = (CFANode)connectionNodes.get(pcToSet);
            if (connectionNode == null) {
                connectionNode = new CFANode(ARTIFICIAL_PROGRAM_COUNTER_FUNCTION_NAME);
                connectionNodes.put(pcToSet, connectionNode);
                ProgramCounterValueAssignmentEdge edgeToLoopHead = CFASingleLoopTransformation.createProgramCounterAssignmentEdge(connectionNode, pLoopHead, pPCIdExpression, pcToSet);
                CFASingleLoopTransformation.addToNodes(edgeToLoopHead);
            }
            CFANode subgraphPredecessor = (CFANode)newPredecessorToPC.getValue();
            BlankEdge dummyEdge = new BlankEdge("", FileLocation.DUMMY, subgraphPredecessor, connectionNode, "");
            CFASingleLoopTransformation.addToNodes(dummyEdge);
        }
    }

    private void connectLoopHeadToSubgraphEntryNodes(SingleLoopHead pLoopHead, Map<Integer, CFANode> newSuccessorToPCMapping, CIdExpression pPCIdExpression, CBinaryExpressionBuilder pExpressionBuilder) {
        ArrayList<ProgramCounterValueAssumeEdge> toAdd = new ArrayList<ProgramCounterValueAssumeEdge>();
        CFANode decisionTreeNode = pLoopHead;
        LinkedHashMap<CFANode, CFANode> tmpMap = new LinkedHashMap<CFANode, CFANode>();
        for (Map.Entry<Integer, CFANode> entry : newSuccessorToPCMapping.entrySet()) {
            CFANode newSuccessor = entry.getValue();
            int pcToSet = entry.getKey();
            if (newSuccessor.getNumEnteringEdges() > 0) {
                assert (tmpMap.isEmpty());
                ProgramCounterValueAssignmentEdge pcAssignmentEdge = pLoopHead.getEnteringAssignmentEdge(pcToSet);
                if (pcAssignmentEdge != null) {
                    CFANode dummySuccessor = pcAssignmentEdge.getPredecessor();
                    for (CFAEdge enteringEdge : CFAUtils.allEnteringEdges(newSuccessor).toList()) {
                        CFANode replacementSuccessor = (CFANode)tmpMap.get(enteringEdge.getSuccessor());
                        if (replacementSuccessor == null) {
                            replacementSuccessor = this.getOrCreateNewFromOld(enteringEdge.getSuccessor(), tmpMap);
                            BlankEdge connectionEdge = new BlankEdge("", FileLocation.DUMMY, replacementSuccessor, dummySuccessor, "");
                            CFASingleLoopTransformation.addToNodes(connectionEdge);
                        }
                        CFAEdge replacementEdge = this.copyCFAEdgeWithNewNodes(enteringEdge, enteringEdge.getPredecessor(), replacementSuccessor, tmpMap);
                        CFASingleLoopTransformation.removeFromNodes(enteringEdge);
                        CFASingleLoopTransformation.addToNodes(replacementEdge);
                    }
                    tmpMap.clear();
                }
            }
            CFANode newDecisionTreeNode = new CFANode(ARTIFICIAL_PROGRAM_COUNTER_FUNCTION_NAME);
            ProgramCounterValueAssumeEdge toSequence = CFASingleLoopTransformation.createProgramCounterAssumeEdge(pExpressionBuilder, decisionTreeNode, newSuccessor, pPCIdExpression, pcToSet, true);
            ProgramCounterValueAssumeEdge toNewDecisionTreeNode = CFASingleLoopTransformation.createProgramCounterAssumeEdge(pExpressionBuilder, decisionTreeNode, newDecisionTreeNode, pPCIdExpression, pcToSet, false);
            toAdd.add(toSequence);
            toAdd.add(toNewDecisionTreeNode);
            decisionTreeNode = newDecisionTreeNode;
        }
        if (!toAdd.isEmpty()) {
            if (this.omitExplicitLastProgramCounterAssumption) {
                CFASingleLoopTransformation.removeLast(toAdd);
                CFAEdge lastTrueEdge = (CFAEdge)CFASingleLoopTransformation.removeLast(toAdd);
                if (!toAdd.isEmpty()) {
                    ProgramCounterValueAssumeEdge programCounterValueAssumeEdge = (ProgramCounterValueAssumeEdge)CFASingleLoopTransformation.removeLast(toAdd);
                    ProgramCounterValueAssumeEdge newLastEdge = CFASingleLoopTransformation.createProgramCounterAssumeEdge(pExpressionBuilder, programCounterValueAssumeEdge.getPredecessor(), lastTrueEdge.getSuccessor(), pPCIdExpression, programCounterValueAssumeEdge.getProgramCounterValue(), false);
                    toAdd.add(newLastEdge);
                } else {
                    BlankEdge blankEdge = new BlankEdge("", FileLocation.DUMMY, pLoopHead, lastTrueEdge.getSuccessor(), "");
                    CFASingleLoopTransformation.addToNodes(blankEdge);
                }
            } else {
                BlankEdge defaultBackEdge = new BlankEdge("", FileLocation.DUMMY, decisionTreeNode, new CFATerminationNode(ARTIFICIAL_PROGRAM_COUNTER_FUNCTION_NAME), "Illegal program counter value");
                CFASingleLoopTransformation.addToNodes(defaultBackEdge);
            }
        }
        for (CFAEdge cFAEdge : toAdd) {
            CFASingleLoopTransformation.addToNodes(cFAEdge);
        }
    }

    private static <T> T removeLast(List<T> pList) {
        int index = pList.size() - 1;
        if (index < 0) {
            throw new NoSuchElementException();
        }
        return pList.remove(index);
    }

    private static Set<CFANode> getAllNodes(CFANode pStartNode) {
        LinkedHashSet<CFANode> nodes = new LinkedHashSet<CFANode>();
        ArrayDeque<CFANode> waitlist = new ArrayDeque<CFANode>();
        ArrayDeque<Deque> callstacks = new ArrayDeque<Deque>();
        waitlist.add(pStartNode);
        callstacks.offer(new ArrayDeque());
        HashSet<CFANode> ignoredNodes = new HashSet<CFANode>();
        while (!waitlist.isEmpty()) {
            CFANode current = (CFANode)waitlist.poll();
            Deque currentCallstack = (Deque)callstacks.poll();
            if (!nodes.add(current)) continue;
            for (CFAEdge leavingEdge : CFAUtils.allLeavingEdges(current)) {
                Deque<FunctionSummaryEdge> newCallstack;
                CFANode successor = leavingEdge.getSuccessor();
                if (leavingEdge instanceof FunctionCallEdge) {
                    newCallstack = new ArrayDeque(currentCallstack);
                    newCallstack.push(((FunctionCallEdge)leavingEdge).getSummaryEdge());
                } else if (leavingEdge instanceof FunctionReturnEdge) {
                    if (currentCallstack.isEmpty()) {
                        ignoredNodes.add(successor);
                        continue;
                    }
                    newCallstack = new ArrayDeque(currentCallstack);
                    FunctionSummaryEdge summaryEdge = (FunctionSummaryEdge)newCallstack.pop();
                    if (!summaryEdge.equals(((FunctionReturnEdge)leavingEdge).getSummaryEdge())) {
                        ignoredNodes.add(successor);
                        continue;
                    }
                } else {
                    newCallstack = currentCallstack;
                }
                ignoredNodes.addAll((Collection<CFANode>)CFAUtils.predecessorsOf(current).toList());
                waitlist.offer(successor);
                callstacks.offer(currentCallstack);
            }
        }
        ignoredNodes.removeAll(nodes);
        for (CFANode ignoredNode : ignoredNodes) {
            CFASingleLoopTransformation.removeFromGraph(ignoredNode);
        }
        for (CFANode node : nodes) {
            for (CFANode predecessor : CFAUtils.predecessorsOf(node).toList()) {
                if (nodes.contains(predecessor)) continue;
                assert (!CFAUtils.predecessorsOf(predecessor).anyMatch(Predicates.in(nodes)));
                CFASingleLoopTransformation.removeFromGraph(predecessor);
            }
            for (CFANode successor : CFAUtils.successorsOf(node).toList()) {
                if (nodes.contains(successor)) continue;
                assert (!CFAUtils.successorsOf(successor).anyMatch(Predicates.in(nodes)));
                CFASingleLoopTransformation.removeFromGraph(successor);
            }
        }
        return nodes;
    }

    private void replaceInStructure(CFANode pOldNode, CFANode pNewNode) {
        CFAEdge oldEdge;
        LinkedHashMap<CFANode, CFANode> newToOld = new LinkedHashMap<CFANode, CFANode>();
        newToOld.put(pOldNode, pNewNode);
        while ((oldEdge = CFASingleLoopTransformation.removeNextEnteringEdge(pOldNode)) != null && CFASingleLoopTransformation.constantTrue(newToOld.put(oldEdge.getPredecessor(), oldEdge.getPredecessor())) || (oldEdge = CFASingleLoopTransformation.removeNextLeavingEdge(pOldNode)) != null && CFASingleLoopTransformation.constantTrue(newToOld.put(oldEdge.getSuccessor(), oldEdge.getSuccessor()))) {
            CFAEdge newEdge = this.copyCFAEdgeWithNewNodes(oldEdge, newToOld);
            CFASingleLoopTransformation.addToNodes(newEdge);
        }
    }

    private static boolean constantTrue(Object pParam) {
        return true;
    }

    @Nullable
    private static CFAEdge removeNextEnteringEdge(CFANode pCfaNode) {
        int numberOfEnteringEdges = pCfaNode.getNumEnteringEdges();
        CFAEdge result = null;
        if (numberOfEnteringEdges > 0) {
            result = pCfaNode.getEnteringEdge(numberOfEnteringEdges - 1);
        }
        if (result == null) {
            result = pCfaNode.getEnteringSummaryEdge();
        }
        if (result != null) {
            CFASingleLoopTransformation.removeFromNodes(result);
        }
        return result;
    }

    @Nullable
    private static CFAEdge removeNextLeavingEdge(CFANode pCfaNode) {
        int numberOfLeavingEdges = pCfaNode.getNumLeavingEdges();
        CFAEdge result = null;
        if (numberOfLeavingEdges > 0) {
            result = pCfaNode.getLeavingEdge(numberOfLeavingEdges - 1);
        }
        if (result == null) {
            result = pCfaNode.getLeavingSummaryEdge();
        }
        if (result != null) {
            CFASingleLoopTransformation.removeFromNodes(result);
        }
        return result;
    }

    private CFANode getOrCreateNewFromOld(CFANode pNode, @Nullable Map<CFANode, CFANode> pNewToOldMapping) {
        if (pNewToOldMapping == null) {
            return pNode;
        }
        CFANode result = pNewToOldMapping.get(pNode);
        if (result != null) {
            return result;
        }
        String functionName = pNode.getFunctionName();
        if (pNode instanceof CLabelNode) {
            result = new CLabelNode(functionName, ((CLabelNode)pNode).getLabel());
        } else if (pNode instanceof CFunctionEntryNode) {
            CFunctionEntryNode functionEntryNode = (CFunctionEntryNode)pNode;
            FunctionExitNode functionExitNode = (FunctionExitNode)this.getOrCreateNewFromOld(functionEntryNode.getExitNode(), pNewToOldMapping);
            result = functionExitNode.getEntryNode();
        } else if (pNode instanceof JMethodEntryNode) {
            JMethodEntryNode methodEntryNode = (JMethodEntryNode)pNode;
            FunctionExitNode functionExitNode = (FunctionExitNode)this.getOrCreateNewFromOld(methodEntryNode.getExitNode(), pNewToOldMapping);
            result = functionExitNode.getEntryNode();
        } else if (pNode instanceof FunctionExitNode) {
            FunctionEntryNode functionEntryNode;
            FunctionExitNode oldFunctionExitNode = (FunctionExitNode)pNode;
            FunctionEntryNode precomputedEntryNode = (FunctionEntryNode)pNewToOldMapping.get(oldFunctionExitNode.getEntryNode());
            if (precomputedEntryNode != null) {
                return precomputedEntryNode.getExitNode();
            }
            FunctionExitNode functionExitNode = new FunctionExitNode(functionName);
            FunctionEntryNode oldEntryNode = oldFunctionExitNode.getEntryNode();
            FileLocation entryFileLocation = oldEntryNode.getFileLocation();
            if (oldEntryNode instanceof CFunctionEntryNode) {
                functionEntryNode = new CFunctionEntryNode(entryFileLocation, ((CFunctionEntryNode)oldEntryNode).getFunctionDefinition(), functionExitNode, oldEntryNode.getFunctionParameterNames(), ((CFunctionEntryNode)oldEntryNode).getReturnVariable());
            } else if (oldEntryNode instanceof JMethodEntryNode) {
                functionEntryNode = new JMethodEntryNode(entryFileLocation, ((JMethodEntryNode)oldEntryNode).getFunctionDefinition(), functionExitNode, oldEntryNode.getFunctionParameterNames(), ((JMethodEntryNode)oldEntryNode).getReturnVariable());
            } else {
                throw new AssertionError();
            }
            functionExitNode.setEntryNode(functionEntryNode);
            pNewToOldMapping.put(pNode, functionExitNode);
            pNewToOldMapping.put(oldFunctionExitNode, functionEntryNode);
            result = functionExitNode;
        } else if (pNode instanceof CFATerminationNode) {
            result = new CFATerminationNode(functionName);
        } else if (pNode.getClass() != CFANode.class) {
            Class<?> clazz = pNode.getClass();
            Object[] requiredParameterTypes = new Class[]{Integer.TYPE, String.class};
            for (Constructor<?> cons : clazz.getConstructors()) {
                if (!cons.isAccessible() || !Arrays.equals(cons.getParameterTypes(), requiredParameterTypes)) continue;
                try {
                    result = (CFANode)cons.newInstance(functionName);
                    break;
                }
                catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
                    result = null;
                }
            }
            if (result == null) {
                result = new CFANode(functionName);
                this.logger.log(Level.WARNING, new Object[]{"Unknown node type " + clazz + "; created copy as instance of base type CFANode."});
            } else {
                this.logger.log(Level.WARNING, new Object[]{"Unknown node type " + clazz + "; created copy by reflection."});
            }
        } else {
            result = new CFANode(functionName);
        }
        pNewToOldMapping.put(pNode, result);
        return result;
    }

    private CFAEdge copyCFAEdgeWithNewNodes(CFAEdge pEdge, CFANode pNewPredecessor, CFANode pNewSuccessor, final Map<CFANode, CFANode> pNewToOldMapping) {
        String rawStatement = pEdge.getRawStatement();
        FileLocation fileLocation = pEdge.getFileLocation();
        switch (pEdge.getEdgeType()) {
            case AssumeEdge: {
                CAssumeEdge assumeEdge = (CAssumeEdge)pEdge;
                return new CAssumeEdge(rawStatement, fileLocation, pNewPredecessor, pNewSuccessor, assumeEdge.getExpression(), assumeEdge.getTruthAssumption());
            }
            case BlankEdge: {
                return new BlankEdge(rawStatement, fileLocation, pNewPredecessor, pNewSuccessor, pEdge.getDescription());
            }
            case DeclarationEdge: {
                CDeclarationEdge declarationEdge = (CDeclarationEdge)pEdge;
                return new CDeclarationEdge(rawStatement, fileLocation, pNewPredecessor, pNewSuccessor, declarationEdge.getDeclaration());
            }
            case FunctionCallEdge: {
                if (!(pNewSuccessor instanceof FunctionEntryNode)) {
                    throw new IllegalArgumentException("The successor of a function call edge must be a function entry node.");
                }
                CFunctionCallEdge functionCallEdge = (CFunctionCallEdge)pEdge;
                CFunctionSummaryEdge oldSummaryEdge = functionCallEdge.getSummaryEdge();
                CFunctionSummaryEdge functionSummaryEdge = (CFunctionSummaryEdge)this.copyCFAEdgeWithNewNodes(oldSummaryEdge, pNewPredecessor, this.getOrCreateNewFromOld(oldSummaryEdge.getSuccessor(), pNewToOldMapping), pNewToOldMapping);
                CFASingleLoopTransformation.addToNodes(functionSummaryEdge);
                Optional<CFunctionCall> cFunctionCall = functionCallEdge.getRawAST();
                return new CFunctionCallEdge(rawStatement, fileLocation, pNewPredecessor, (CFunctionEntryNode)pNewSuccessor, (CFunctionCall)cFunctionCall.orNull(), functionSummaryEdge);
            }
            case FunctionReturnEdge: {
                if (!(pNewPredecessor instanceof FunctionExitNode)) {
                    throw new IllegalArgumentException("The predecessor of a function return edge must be a function exit node.");
                }
                CFunctionReturnEdge functionReturnEdge = (CFunctionReturnEdge)pEdge;
                CFunctionSummaryEdge oldSummaryEdge = functionReturnEdge.getSummaryEdge();
                CFANode functionCallPred = oldSummaryEdge.getPredecessor();
                CFANode functionSummarySucc = oldSummaryEdge.getSuccessor();
                if (oldSummaryEdge != functionCallPred.getLeavingSummaryEdge() && functionCallPred.getLeavingSummaryEdge() != null) {
                    oldSummaryEdge = (CFunctionSummaryEdge)functionCallPred.getLeavingSummaryEdge();
                } else if (oldSummaryEdge != functionSummarySucc.getEnteringSummaryEdge() && functionSummarySucc.getEnteringSummaryEdge() != null) {
                    oldSummaryEdge = (CFunctionSummaryEdge)functionSummarySucc.getEnteringSummaryEdge();
                }
                CFunctionSummaryEdge functionSummaryEdge = (CFunctionSummaryEdge)this.copyCFAEdgeWithNewNodes(oldSummaryEdge, pNewToOldMapping);
                CFASingleLoopTransformation.addToNodes(functionSummaryEdge);
                return new CFunctionReturnEdge(fileLocation, (FunctionExitNode)pNewPredecessor, pNewSuccessor, functionSummaryEdge);
            }
            case MultiEdge: {
                MultiEdge multiEdge = (MultiEdge)pEdge;
                return new MultiEdge(pNewPredecessor, pNewSuccessor, (List<CFAEdge>)FluentIterable.from(multiEdge.getEdges()).transform((Function)new Function<CFAEdge, CFAEdge>(){

                    @Nullable
                    public CFAEdge apply(@Nullable CFAEdge pOldEdge) {
                        if (pOldEdge == null) {
                            return null;
                        }
                        return CFASingleLoopTransformation.this.copyCFAEdgeWithNewNodes(pOldEdge, pNewToOldMapping);
                    }
                }).toList());
            }
            case ReturnStatementEdge: {
                if (!(pNewSuccessor instanceof FunctionExitNode)) {
                    throw new IllegalArgumentException("The successor of a return statement edge must be a function exit node.");
                }
                CReturnStatementEdge returnStatementEdge = (CReturnStatementEdge)pEdge;
                Optional<CReturnStatement> cReturnStatement = returnStatementEdge.getRawAST();
                return new CReturnStatementEdge(rawStatement, (CReturnStatement)cReturnStatement.orNull(), fileLocation, pNewPredecessor, (FunctionExitNode)pNewSuccessor);
            }
            case StatementEdge: {
                CStatementEdge statementEdge = (CStatementEdge)pEdge;
                if (statementEdge instanceof CFunctionSummaryStatementEdge) {
                    CFunctionSummaryStatementEdge functionStatementEdge = (CFunctionSummaryStatementEdge)pEdge;
                    return new CFunctionSummaryStatementEdge(rawStatement, statementEdge.getStatement(), fileLocation, pNewPredecessor, pNewSuccessor, functionStatementEdge.getFunctionCall(), functionStatementEdge.getFunctionName());
                }
                return new CStatementEdge(rawStatement, statementEdge.getStatement(), fileLocation, pNewPredecessor, pNewSuccessor);
            }
            case CallToReturnEdge: {
                CFunctionSummaryEdge cFunctionSummaryEdge = (CFunctionSummaryEdge)pEdge;
                return new CFunctionSummaryEdge(rawStatement, fileLocation, pNewPredecessor, pNewSuccessor, cFunctionSummaryEdge.getExpression(), (CFunctionEntryNode)this.getOrCreateNewFromOld(cFunctionSummaryEdge.getFunctionEntry(), pNewToOldMapping));
            }
        }
        throw new IllegalArgumentException("Unsupported edge type: " + (Object)((Object)pEdge.getEdgeType()));
    }

    private CFAEdge copyCFAEdgeWithNewNodes(CFAEdge pEdge, Map<CFANode, CFANode> pNewToOldMapping) {
        CFANode newPredecessor = this.getOrCreateNewFromOld(pEdge.getPredecessor(), pNewToOldMapping);
        CFANode newSuccessor = this.getOrCreateNewFromOld(pEdge.getSuccessor(), pNewToOldMapping);
        return this.copyCFAEdgeWithNewNodes(pEdge, newPredecessor, newSuccessor, pNewToOldMapping);
    }

    private static boolean isDummyEdge(CFAEdge pEdge) {
        return pEdge != null && pEdge.getEdgeType() == CFAEdgeType.BlankEdge && pEdge.getDescription().equals(DUMMY_EDGE);
    }

    private static int getPCValueFor(CFANode pCFANode) {
        return pCFANode.getNodeNumber();
    }

    private static ProgramCounterValueAssignmentEdge createProgramCounterAssignmentEdge(CFANode pPredecessor, CFANode pSuccessor, CIdExpression pPCIdExpression, int pPCValue) {
        return new CProgramCounterValueAssignmentEdge(pPredecessor, pSuccessor, pPCIdExpression, pPCValue);
    }

    private static ProgramCounterValueAssumeEdge createProgramCounterAssumeEdge(CBinaryExpressionBuilder pExpressionBuilder, CFANode pPredecessor, CFANode pSuccessor, CIdExpression pPCIdExpression, int pPCValue, boolean pTruthAssumption) {
        return new CProgramCounterValueAssumeEdge(pExpressionBuilder, pPredecessor, pSuccessor, pPCIdExpression, pPCValue, pTruthAssumption);
    }

    private static enum SubGraphGrowthStrategy {
        MULTIPLE_PATHS{

            @Override
            public boolean isFurtherGrowthDesired(AcyclicGraph pGraph) {
                return true;
            }
        }
        ,
        SINGLE_PATH{

            @Override
            public boolean isFurtherGrowthDesired(AcyclicGraph pGraph) {
                for (CFANode node : pGraph.getNodes()) {
                    if (node.getNumLeavingEdges() <= 1) continue;
                    return false;
                }
                return true;
            }
        }
        ,
        SINGLE_EDGE{

            @Override
            public boolean isFurtherGrowthDesired(AcyclicGraph pGraph) {
                return false;
            }
        };


        abstract boolean isFurtherGrowthDesired(AcyclicGraph var1);
    }
}

