/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.postprocessing.global.singleloop;

import java.math.BigInteger;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpressionAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CStatement;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.c.CStatementEdge;
import org.sosy_lab.cpachecker.cfa.postprocessing.global.singleloop.ProgramCounterValueAssignmentEdge;
import org.sosy_lab.cpachecker.cfa.types.c.CNumericTypes;

class CProgramCounterValueAssignmentEdge
extends CStatementEdge
implements ProgramCounterValueAssignmentEdge {
    private int pcValue;

    public CProgramCounterValueAssignmentEdge(CFANode pPredecessor, CFANode pSuccessor, CIdExpression pPCIdExpression, int pPCValue) {
        super(CProgramCounterValueAssignmentEdge.buildRawStatement(pPCValue, pPCIdExpression), CProgramCounterValueAssignmentEdge.buildStatement(pPCValue, pPCIdExpression), FileLocation.DUMMY, pPredecessor, pSuccessor);
        this.pcValue = pPCValue;
    }

    @Override
    public int getProgramCounterValue() {
        return this.pcValue;
    }

    private static String buildRawStatement(int pPCValue, CIdExpression pPCIdExpression) {
        return String.format("%s = %d", pPCIdExpression.getName(), pPCValue);
    }

    private static CStatement buildStatement(int pPCValue, CIdExpression pPCIdExpression) {
        CIntegerLiteralExpression assignmentExpression = new CIntegerLiteralExpression(FileLocation.DUMMY, CNumericTypes.INT, BigInteger.valueOf(pPCValue));
        return new CExpressionAssignmentStatement(FileLocation.DUMMY, pPCIdExpression, assignmentExpression);
    }
}

