/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.postprocessing.global.singleloop;

import java.math.BigInteger;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpressionBuilder;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.c.CAssumeEdge;
import org.sosy_lab.cpachecker.cfa.postprocessing.global.singleloop.ProgramCounterValueAssumeEdge;
import org.sosy_lab.cpachecker.cfa.types.c.CNumericTypes;

class CProgramCounterValueAssumeEdge
extends CAssumeEdge
implements ProgramCounterValueAssumeEdge {
    private final int pcValue;

    public CProgramCounterValueAssumeEdge(CBinaryExpressionBuilder pExpressionBuilder, CFANode pPredecessor, CFANode pSuccessor, CIdExpression pPCIdExpression, int pPCValue, boolean pTruthAssumption) {
        super(CProgramCounterValueAssumeEdge.buildRawStatement(pPCValue, pPCIdExpression, pTruthAssumption), FileLocation.DUMMY, pPredecessor, pSuccessor, CProgramCounterValueAssumeEdge.buildExpression(pPCValue, pPCIdExpression, pExpressionBuilder), pTruthAssumption);
        this.pcValue = pPCValue;
    }

    @Override
    public int getProgramCounterValue() {
        return this.pcValue;
    }

    private static String buildRawStatement(int pPCValue, CIdExpression pPCIdExpression, boolean pTruthAssumption) {
        String rawStatement = String.format("%s == %d", pPCIdExpression.getName(), pPCValue);
        if (!pTruthAssumption) {
            rawStatement = String.format("!(%s)", rawStatement);
        }
        return rawStatement;
    }

    private static CExpression buildExpression(int pPCValue, CIdExpression pPCIdExpression, CBinaryExpressionBuilder pExpressionBuilder) {
        return pExpressionBuilder.buildBinaryExpressionUnchecked(pPCIdExpression, new CIntegerLiteralExpression(FileLocation.DUMMY, CNumericTypes.INT, BigInteger.valueOf(pPCValue)), CBinaryExpression.BinaryOperator.EQUALS);
    }
}

