/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.postprocessing.global.singleloop;

import com.google.common.base.Preconditions;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.postprocessing.global.singleloop.ProgramCounterValueAssignmentEdge;
import org.sosy_lab.cpachecker.util.CFAUtils;

public class SingleLoopHead
extends CFANode {
    private final Map<Integer, ProgramCounterValueAssignmentEdge> enteringPCValueAssignmentEdges = new HashMap<Integer, ProgramCounterValueAssignmentEdge>();

    public SingleLoopHead() {
        super(" ");
    }

    @Override
    public void addEnteringEdge(CFAEdge pEnteringEdge) {
        if (pEnteringEdge instanceof ProgramCounterValueAssignmentEdge) {
            ProgramCounterValueAssignmentEdge edge = (ProgramCounterValueAssignmentEdge)pEnteringEdge;
            int pcValue = edge.getProgramCounterValue();
            Preconditions.checkArgument((!this.enteringPCValueAssignmentEdges.containsKey(pcValue) ? 1 : 0) != 0, (Object)"All entering program counter value assignment edges must be unique.");
            this.enteringPCValueAssignmentEdges.put(pcValue, edge);
        } else assert (false);
        super.addEnteringEdge(pEnteringEdge);
    }

    @Override
    public void removeEnteringEdge(CFAEdge pEnteringEdge) {
        if (pEnteringEdge instanceof ProgramCounterValueAssignmentEdge && CFAUtils.enteringEdges(this).contains((Object)pEnteringEdge)) {
            ProgramCounterValueAssignmentEdge edge = (ProgramCounterValueAssignmentEdge)pEnteringEdge;
            this.enteringPCValueAssignmentEdges.remove(edge.getProgramCounterValue());
        }
        super.removeEnteringEdge(pEnteringEdge);
    }

    @Nullable
    public ProgramCounterValueAssignmentEdge getEnteringAssignmentEdge(int pPCValue) {
        return this.enteringPCValueAssignmentEdges.get(pPCValue);
    }

    public Set<String> getEnteringFunctionNames() {
        HashSet<String> results = new HashSet<String>();
        HashSet<CFANode> visited = new HashSet<CFANode>();
        ArrayDeque<SingleLoopHead> waitlist = new ArrayDeque<SingleLoopHead>();
        waitlist.offer(this);
        while (!waitlist.isEmpty()) {
            CFANode current = (CFANode)waitlist.poll();
            if (!visited.add(current)) continue;
            if (current.getFunctionName().equals(" ")) {
                waitlist.addAll((Collection<SingleLoopHead>)CFAUtils.allPredecessorsOf(current).toList());
                continue;
            }
            results.add(current.getFunctionName());
        }
        return results;
    }

    public Collection<Integer> getProgramCounterValues() {
        return Collections.unmodifiableSet(this.enteringPCValueAssignmentEdges.keySet());
    }
}

