/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.simplification;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.logging.Level;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.log.LogManagerWithoutDuplicates;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpressionBuilder;
import org.sosy_lab.cpachecker.cfa.ast.c.CCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCharLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFloatLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializer;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CSimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CTypeIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CUnaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.DefaultCExpressionVisitor;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.c.CEnumType;
import org.sosy_lab.cpachecker.cfa.types.c.CProblemType;
import org.sosy_lab.cpachecker.cfa.types.c.CSimpleType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cpa.value.AbstractExpressionValueVisitor;
import org.sosy_lab.cpachecker.cpa.value.type.NumericValue;
import org.sosy_lab.cpachecker.cpa.value.type.Value;

public class ExpressionSimplificationVisitor
extends DefaultCExpressionVisitor<CExpression, RuntimeException> {
    private final MachineModel machineModel;
    private final LogManagerWithoutDuplicates logger;

    public ExpressionSimplificationVisitor(MachineModel mm, LogManagerWithoutDuplicates pLogger) {
        this.machineModel = mm;
        this.logger = pLogger;
    }

    protected CExpression recursive(CExpression expr) {
        return expr.accept(this);
    }

    private NumericValue getValue(CExpression expr) {
        if (expr instanceof CIntegerLiteralExpression) {
            return new NumericValue(((CIntegerLiteralExpression)expr).getValue());
        }
        if (expr instanceof CCharLiteralExpression) {
            return new NumericValue((int)((CCharLiteralExpression)expr).getCharacter());
        }
        if (expr instanceof CFloatLiteralExpression) {
            return new NumericValue(((CFloatLiteralExpression)expr).getValue());
        }
        return null;
    }

    private CExpression convertExplicitValueToExpression(CExpression expr, Value value) {
        NumericValue numericResult = value.asNumericValue();
        if (numericResult != null && expr.getExpressionType() instanceof CSimpleType) {
            CSimpleType type = (CSimpleType)expr.getExpressionType();
            if (type.getType().isIntegerType()) {
                return new CIntegerLiteralExpression(expr.getFileLocation(), expr.getExpressionType(), BigInteger.valueOf(numericResult.longValue()));
            }
            if (type.getType().isFloatingPointType()) {
                try {
                    return new CFloatLiteralExpression(expr.getFileLocation(), expr.getExpressionType(), numericResult.bigDecimalValue());
                }
                catch (NumberFormatException nfe) {
                    this.logger.logf(Level.FINE, "Cannot simplify expression to numeric value %s, keeping original expression %s instead", new Object[]{numericResult, expr.toASTString()});
                    return expr;
                }
            }
        }
        if (numericResult != null) {
            this.logger.logf(Level.FINE, "Can not handle result of expression %s", new Object[]{numericResult.toString()});
        } else {
            this.logger.logf(Level.FINE, "Can not handle result of expression, numericResult is null.", new Object[0]);
        }
        return expr;
    }

    @Override
    protected CExpression visitDefault(CExpression expr) {
        return expr;
    }

    @Override
    public CExpression visit(CBinaryExpression expr) {
        CBinaryExpression.BinaryOperator binaryOperator = expr.getOperator();
        CExpression op1 = this.recursive(expr.getOperand1());
        NumericValue value1 = this.getValue(op1);
        CExpression op2 = this.recursive(expr.getOperand2());
        NumericValue value2 = this.getValue(op2);
        if (value1 == null || value2 == null) {
            CBinaryExpression newExpr;
            if (op1 == expr.getOperand1() && op2 == expr.getOperand2()) {
                newExpr = expr;
            } else {
                CBinaryExpressionBuilder binExprBuilder = new CBinaryExpressionBuilder(this.machineModel, (LogManager)this.logger);
                newExpr = binExprBuilder.buildBinaryExpressionUnchecked(op1, op2, binaryOperator);
            }
            return newExpr;
        }
        Value result = AbstractExpressionValueVisitor.calculateBinaryOperation(value1, value2, expr, this.machineModel, this.logger);
        return this.convertExplicitValueToExpression(expr, result);
    }

    @Override
    public CExpression visit(CCastExpression expr) {
        CExpression op = this.recursive(expr.getOperand());
        NumericValue value = this.getValue(op);
        if (value == null) {
            CCastExpression newExpr = op == expr.getOperand() ? expr : new CCastExpression(expr.getFileLocation(), expr.getExpressionType(), op);
            return newExpr;
        }
        Value castedValue = AbstractExpressionValueVisitor.castCValue(value, op.getExpressionType(), expr.getExpressionType(), this.machineModel, this.logger, expr.getFileLocation());
        return this.convertExplicitValueToExpression(expr, castedValue);
    }

    @Override
    public CExpression visit(CTypeIdExpression expr) {
        CTypeIdExpression.TypeIdOperator idOperator = expr.getOperator();
        CType innerType = expr.getType();
        switch (idOperator) {
            case SIZEOF: {
                int size = this.machineModel.getSizeof(innerType);
                return new CIntegerLiteralExpression(expr.getFileLocation(), expr.getExpressionType(), BigInteger.valueOf(size));
            }
        }
        return this.visitDefault(expr);
    }

    @Override
    public CExpression visit(CUnaryExpression expr) {
        CUnaryExpression.UnaryOperator unaryOperator = expr.getOperator();
        if (unaryOperator == CUnaryExpression.UnaryOperator.SIZEOF) {
            int result = this.machineModel.getSizeof(expr.getOperand().getExpressionType());
            return new CIntegerLiteralExpression(expr.getFileLocation(), expr.getExpressionType(), BigInteger.valueOf(result));
        }
        if (unaryOperator == CUnaryExpression.UnaryOperator.ALIGNOF) {
            int result = this.machineModel.getAlignof(expr.getOperand().getExpressionType());
            return new CIntegerLiteralExpression(expr.getFileLocation(), expr.getExpressionType(), BigInteger.valueOf(result));
        }
        CExpression op = this.recursive(expr.getOperand());
        NumericValue value = this.getValue(op);
        if (unaryOperator == CUnaryExpression.UnaryOperator.MINUS && value != null && op.getExpressionType() instanceof CSimpleType) {
            NumericValue negatedValue = value.negate();
            switch (((CSimpleType)op.getExpressionType()).getType()) {
                case CHAR: 
                case INT: {
                    return new CIntegerLiteralExpression(expr.getFileLocation(), expr.getExpressionType(), BigInteger.valueOf(negatedValue.longValue()));
                }
                case FLOAT: 
                case DOUBLE: {
                    return new CFloatLiteralExpression(expr.getFileLocation(), expr.getExpressionType(), BigDecimal.valueOf(negatedValue.doubleValue()));
                }
            }
        }
        CUnaryExpression newExpr = op == expr.getOperand() ? expr : new CUnaryExpression(expr.getFileLocation(), expr.getExpressionType(), op, unaryOperator);
        return newExpr;
    }

    @Override
    public CExpression visit(CIdExpression expr) {
        NumericValue v;
        CInitializer init;
        CSimpleDeclaration decl = expr.getDeclaration();
        CType type = expr.getExpressionType();
        if (decl instanceof CEnumType.CEnumerator && ((CEnumType.CEnumerator)decl).hasValue()) {
            long v2 = ((CEnumType.CEnumerator)decl).getValue();
            return new CIntegerLiteralExpression(expr.getFileLocation(), type, BigInteger.valueOf(v2));
        }
        if (!(type instanceof CProblemType) && type.isConst() && decl instanceof CVariableDeclaration && (init = ((CVariableDeclaration)decl).getInitializer()) instanceof CExpression && (v = this.getValue((CExpression)((Object)init))) != null && decl.getType() instanceof CSimpleType) {
            switch (((CSimpleType)type).getType()) {
                case CHAR: 
                case INT: {
                    return new CIntegerLiteralExpression(expr.getFileLocation(), type, BigInteger.valueOf(v.longValue()));
                }
                case FLOAT: 
                case DOUBLE: {
                    return new CFloatLiteralExpression(expr.getFileLocation(), type, BigDecimal.valueOf(v.doubleValue()));
                }
            }
        }
        return this.visitDefault(expr);
    }
}

