/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.types;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import org.sosy_lab.cpachecker.cfa.types.IAFunctionType;
import org.sosy_lab.cpachecker.cfa.types.Type;

public class AFunctionType
implements IAFunctionType {
    private final Type returnType;
    private final List<? extends Type> parameters;
    private final boolean takesVarArgs;

    public AFunctionType(Type pReturnType, List<? extends Type> pParameters, boolean pTakesVarArgs) {
        this.returnType = pReturnType;
        this.parameters = ImmutableList.copyOf(pParameters);
        this.takesVarArgs = pTakesVarArgs;
    }

    @Override
    public Type getReturnType() {
        return this.returnType;
    }

    @Override
    public List<? extends Type> getParameters() {
        return this.parameters;
    }

    @Override
    public boolean takesVarArgs() {
        return this.takesVarArgs;
    }

    @Override
    public String toASTString(String pDeclarator) {
        StringBuilder lASTString = new StringBuilder();
        lASTString.append(this.returnType.toASTString(""));
        lASTString.append(" ");
        lASTString.append(pDeclarator);
        lASTString.append("(");
        Joiner.on((String)", ").appendTo(lASTString, this.parameters);
        if (this.takesVarArgs) {
            if (!this.parameters.isEmpty()) {
                lASTString.append(", ");
            }
            lASTString.append("...");
        }
        lASTString.append(")");
        return lASTString.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 7;
        result = 31 * result + Objects.hashCode(this.parameters);
        result = 31 * result + Objects.hashCode(this.returnType);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AFunctionType)) {
            return false;
        }
        AFunctionType other = (AFunctionType)obj;
        return Objects.equals(this.parameters, other.parameters) && Objects.equals(this.returnType, other.returnType);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Return type: [");
        int parameterCounter = 0;
        sb.append(this.returnType.toString());
        sb.append("], ");
        sb.append("Parameters: " + this.parameters.size() + ", ");
        if (!this.parameters.isEmpty()) {
            for (Type type : this.parameters) {
                sb.append("Parameter " + ++parameterCounter + " type: [" + type + "], ");
            }
        }
        sb.append("VarArgs: " + this.takesVarArgs);
        return sb.toString();
    }
}

