/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.types;

import com.google.common.base.Preconditions;
import java.math.BigInteger;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.types.c.CArrayType;
import org.sosy_lab.cpachecker.cfa.types.c.CBasicType;
import org.sosy_lab.cpachecker.cfa.types.c.CComplexType;
import org.sosy_lab.cpachecker.cfa.types.c.CCompositeType;
import org.sosy_lab.cpachecker.cfa.types.c.CElaboratedType;
import org.sosy_lab.cpachecker.cfa.types.c.CEnumType;
import org.sosy_lab.cpachecker.cfa.types.c.CFunctionType;
import org.sosy_lab.cpachecker.cfa.types.c.CNumericTypes;
import org.sosy_lab.cpachecker.cfa.types.c.CPointerType;
import org.sosy_lab.cpachecker.cfa.types.c.CProblemType;
import org.sosy_lab.cpachecker.cfa.types.c.CSimpleType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cfa.types.c.CTypeVisitor;
import org.sosy_lab.cpachecker.cfa.types.c.CTypedefType;
import org.sosy_lab.cpachecker.cfa.types.c.CVoidType;

public final class MachineModel
extends Enum<MachineModel> {
    public static final /* enum */ MachineModel LINUX32 = new MachineModel(2, 4, 4, 8, 4, 8, 12, 1, 1, 4);
    public static final /* enum */ MachineModel LINUX64 = new MachineModel(2, 4, 8, 8, 4, 8, 16, 1, 1, 8);
    private final int sizeofShort;
    private final int sizeofInt;
    private final int sizeofLongInt;
    private final int sizeofLongLongInt;
    private final int sizeofFloat;
    private final int sizeofDouble;
    private final int sizeofLongDouble;
    private final int sizeofVoid;
    private final int sizeofBool;
    private final int sizeofPtr;
    private final int mSizeofChar = 1;
    private final int mSizeofCharInBits = 8;
    private final CSimpleType ptrEquivalent;
    private final CTypeVisitor<Integer, IllegalArgumentException> sizeofVisitor = new BaseSizeofVisitor(this);
    private final CTypeVisitor<Integer, IllegalArgumentException> alignofVisitor = new BaseAlignofVisitor(this);
    private static final /* synthetic */ MachineModel[] $VALUES;

    public static MachineModel[] values() {
        return (MachineModel[])$VALUES.clone();
    }

    public static MachineModel valueOf(String name) {
        return Enum.valueOf(MachineModel.class, name);
    }

    private MachineModel(int pSizeofShort, int pSizeofInt, int pSizeofLongInt, int pSizeofLongLongInt, int pSizeofFloat, int pSizeofDouble, int pSizeofLongDouble, int pSizeofVoid, int pSizeofBool, int pSizeOfPtr) {
        this.sizeofShort = pSizeofShort;
        this.sizeofInt = pSizeofInt;
        this.sizeofLongInt = pSizeofLongInt;
        this.sizeofLongLongInt = pSizeofLongLongInt;
        this.sizeofFloat = pSizeofFloat;
        this.sizeofDouble = pSizeofDouble;
        this.sizeofLongDouble = pSizeofLongDouble;
        this.sizeofVoid = pSizeofVoid;
        this.sizeofBool = pSizeofBool;
        this.sizeofPtr = pSizeOfPtr;
        if (this.sizeofPtr == this.sizeofInt) {
            this.ptrEquivalent = CNumericTypes.INT;
        } else if (this.sizeofPtr == this.sizeofLongInt) {
            this.ptrEquivalent = CNumericTypes.LONG_INT;
        } else if (this.sizeofPtr == this.sizeofLongLongInt) {
            this.ptrEquivalent = CNumericTypes.LONG_LONG_INT;
        } else if (this.sizeofPtr == this.sizeofShort) {
            this.ptrEquivalent = CNumericTypes.SHORT_INT;
        } else {
            throw new AssertionError((Object)"No ptr-Equivalent found");
        }
    }

    public CSimpleType getPointerEquivalentSimpleType() {
        return this.ptrEquivalent;
    }

    public CSimpleType getPointerDiffType() {
        assert (!this.ptrEquivalent.isUnsigned());
        return this.ptrEquivalent.getCanonicalType();
    }

    public boolean isDefaultCharSigned() {
        return true;
    }

    public boolean isSigned(CSimpleType t) {
        if ((t = t.getCanonicalType()).isSigned()) {
            return true;
        }
        if (t.isUnsigned()) {
            return false;
        }
        switch (t.getType()) {
            case CHAR: {
                return this.isDefaultCharSigned();
            }
            case FLOAT: 
            case DOUBLE: {
                return true;
            }
            case INT: {
                throw new AssertionError((Object)"Canonical type of INT should always have sign modifier");
            }
            case UNSPECIFIED: {
                throw new AssertionError((Object)"Canonical type should never be UNSPECIFIED");
            }
        }
        return false;
    }

    public int getSizeofCharInBits() {
        return 8;
    }

    public int getSizeofShort() {
        return this.sizeofShort;
    }

    public int getSizeofInt() {
        return this.sizeofInt;
    }

    public int getSizeofLongInt() {
        return this.sizeofLongInt;
    }

    public int getSizeofLongLongInt() {
        return this.sizeofLongLongInt;
    }

    public int getSizeofFloat() {
        return this.sizeofFloat;
    }

    public int getSizeofDouble() {
        return this.sizeofDouble;
    }

    public int getSizeofLongDouble() {
        return this.sizeofLongDouble;
    }

    public int getSizeofVoid() {
        return this.sizeofVoid;
    }

    public int getSizeofBool() {
        return this.sizeofBool;
    }

    public int getSizeofChar() {
        return 1;
    }

    public int getSizeofPtr() {
        return this.sizeofPtr;
    }

    public int getSizeof(CSimpleType type) {
        switch (type.getType()) {
            case BOOL: {
                return this.getSizeofBool();
            }
            case CHAR: {
                return this.getSizeofChar();
            }
            case FLOAT: {
                return this.getSizeofFloat();
            }
            case INT: 
            case UNSPECIFIED: {
                if (type.isLongLong()) {
                    return this.getSizeofLongLongInt();
                }
                if (type.isLong()) {
                    return this.getSizeofLongInt();
                }
                if (type.isShort()) {
                    return this.getSizeofShort();
                }
                return this.getSizeofInt();
            }
            case DOUBLE: {
                if (type.isLong()) {
                    return this.getSizeofLongDouble();
                }
                return this.getSizeofDouble();
            }
        }
        throw new AssertionError((Object)("Unrecognized CBasicType " + (Object)((Object)type.getType())));
    }

    public int getSizeofInBits(CSimpleType type) {
        return this.getSizeof(type) * this.getSizeofCharInBits();
    }

    public CSimpleType getPromotedCType(CSimpleType pType) {
        if (this.getSizeof(pType) < this.getSizeofInt()) {
            return CNumericTypes.SIGNED_INT;
        }
        return pType;
    }

    public BigInteger getMinimalIntegerValue(CSimpleType pType) {
        Preconditions.checkArgument((boolean)pType.getType().isIntegerType());
        if (this.isSigned(pType)) {
            return MachineModel.twoToThePowerOf(this.getSizeofInBits(pType) - 1).negate();
        }
        return BigInteger.ZERO;
    }

    public BigInteger getMaximalIntegerValue(CSimpleType pType) {
        Preconditions.checkArgument((boolean)pType.getType().isIntegerType());
        if (pType.getType() == CBasicType.BOOL) {
            return BigInteger.ONE;
        }
        if (this.isSigned(pType)) {
            return MachineModel.twoToThePowerOf(this.getSizeofInBits(pType) - 1).subtract(BigInteger.ONE);
        }
        return MachineModel.twoToThePowerOf(this.getSizeofInBits(pType)).subtract(BigInteger.ONE);
    }

    private static BigInteger twoToThePowerOf(int exp) {
        assert (exp > 0) : "Exponent " + exp + " is not greater than zero.";
        BigInteger result = BigInteger.ZERO.setBit(exp);
        assert (BigInteger.valueOf(2L).pow(exp).equals(result));
        return result;
    }

    public int getSizeof(CType type) {
        return type.accept(this.sizeofVisitor);
    }

    public int getAlignof(CType type) {
        return type.accept(this.alignofVisitor);
    }

    static {
        $VALUES = new MachineModel[]{LINUX32, LINUX64};
    }

    public static class BaseAlignofVisitor
    implements CTypeVisitor<Integer, IllegalArgumentException> {
        private final MachineModel model;

        public BaseAlignofVisitor(MachineModel model) {
            this.model = model;
        }

        @Override
        public Integer visit(CArrayType pArrayType) throws IllegalArgumentException {
            return pArrayType.getType().accept(this);
        }

        @Override
        public Integer visit(CCompositeType pCompositeType) throws IllegalArgumentException {
            switch (pCompositeType.getKind()) {
                case STRUCT: 
                case UNION: {
                    int size = 0;
                    int sizeOfType = 0;
                    for (CCompositeType.CCompositeTypeMemberDeclaration decl : pCompositeType.getMembers()) {
                        sizeOfType = decl.getType().accept(this);
                        size = Math.max(size, sizeOfType);
                    }
                    return size;
                }
            }
            throw new AssertionError();
        }

        @Override
        public Integer visit(CElaboratedType pElaboratedType) throws IllegalArgumentException {
            return pElaboratedType.getRealType().accept(this);
        }

        @Override
        public Integer visit(CEnumType pEnumType) throws IllegalArgumentException {
            return this.model.getSizeofInt();
        }

        @Override
        public Integer visit(CFunctionType pFunctionType) throws IllegalArgumentException {
            return 1;
        }

        @Override
        public Integer visit(CPointerType pPointerType) throws IllegalArgumentException {
            return this.model.getSizeofPtr();
        }

        @Override
        public Integer visit(CProblemType pProblemType) throws IllegalArgumentException {
            throw new IllegalArgumentException("Unknown C-Type: " + pProblemType.getClass().toString());
        }

        @Override
        public Integer visit(CSimpleType pSimpleType) throws IllegalArgumentException {
            return this.model.getSizeof(pSimpleType);
        }

        @Override
        public Integer visit(CTypedefType pTypedefType) throws IllegalArgumentException {
            return pTypedefType.getRealType().accept(this);
        }

        @Override
        public Integer visit(CVoidType pVoidType) throws IllegalArgumentException {
            return this.model.getSizeofVoid();
        }
    }

    public static class BaseSizeofVisitor
    implements CTypeVisitor<Integer, IllegalArgumentException> {
        private final MachineModel model;

        public BaseSizeofVisitor(MachineModel model) {
            this.model = model;
        }

        @Override
        public Integer visit(CArrayType pArrayType) throws IllegalArgumentException {
            CExpression arrayLength = pArrayType.getLength();
            if (arrayLength instanceof CIntegerLiteralExpression) {
                int length = ((CIntegerLiteralExpression)arrayLength).getValue().intValue();
                Integer sizeOfType = this.model.getSizeof(pArrayType.getType());
                if (sizeOfType != null) {
                    return length * sizeOfType;
                }
            }
            return this.model.getSizeofPtr();
        }

        @Override
        public Integer visit(CCompositeType pCompositeType) throws IllegalArgumentException {
            switch (pCompositeType.getKind()) {
                case STRUCT: {
                    return this.handleSizeOfStruct(pCompositeType);
                }
                case UNION: {
                    return this.handleSizeOfUnion(pCompositeType);
                }
            }
            throw new AssertionError();
        }

        private Integer handleSizeOfStruct(CCompositeType pCompositeType) {
            int size = 0;
            for (CCompositeType.CCompositeTypeMemberDeclaration decl : pCompositeType.getMembers()) {
                size += decl.getType().accept(this).intValue();
            }
            return size;
        }

        private Integer handleSizeOfUnion(CCompositeType pCompositeType) {
            int size = 0;
            int sizeOfType = 0;
            for (CCompositeType.CCompositeTypeMemberDeclaration decl : pCompositeType.getMembers()) {
                sizeOfType = decl.getType().accept(this);
                size = Math.max(size, sizeOfType);
            }
            return size;
        }

        @Override
        public Integer visit(CElaboratedType pElaboratedType) throws IllegalArgumentException {
            CComplexType def = pElaboratedType.getRealType();
            if (def != null) {
                return def.accept(this);
            }
            switch (pElaboratedType.getKind()) {
                case ENUM: {
                    return this.model.getSizeofInt();
                }
                case STRUCT: {
                    return this.model.getSizeofInt();
                }
                case UNION: {
                    return this.model.getSizeofInt();
                }
            }
            return this.model.getSizeofInt();
        }

        @Override
        public Integer visit(CEnumType pEnumType) throws IllegalArgumentException {
            return this.model.getSizeofInt();
        }

        @Override
        public Integer visit(CFunctionType pFunctionType) throws IllegalArgumentException {
            return this.model.getSizeofPtr();
        }

        @Override
        public Integer visit(CPointerType pPointerType) throws IllegalArgumentException {
            return this.model.getSizeofPtr();
        }

        @Override
        public Integer visit(CProblemType pProblemType) throws IllegalArgumentException {
            throw new IllegalArgumentException("Unknown C-Type: " + pProblemType.getClass().toString());
        }

        @Override
        public Integer visit(CSimpleType pSimpleType) throws IllegalArgumentException {
            return this.model.getSizeof(pSimpleType);
        }

        @Override
        public Integer visit(CTypedefType pTypedefType) throws IllegalArgumentException {
            return pTypedefType.getRealType().accept(this);
        }

        @Override
        public Integer visit(CVoidType pVoidType) throws IllegalArgumentException {
            return this.model.getSizeofVoid();
        }
    }
}

