/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.types.c;

import java.util.Objects;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.types.AArrayType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cfa.types.c.CTypeVisitor;

public class CArrayType
extends AArrayType
implements CType {
    private final CExpression length;
    private boolean isConst;
    private boolean isVolatile;

    public CArrayType(boolean pConst, boolean pVolatile, CType pType, CExpression pLength) {
        super(pType);
        this.isConst = pConst;
        this.isVolatile = pVolatile;
        this.length = pLength;
    }

    @Override
    public CType getType() {
        return (CType)super.getType();
    }

    public CExpression getLength() {
        return this.length;
    }

    @Override
    public String toASTString(String pDeclarator) {
        return (this.isConst() ? "const " : "") + (this.isVolatile() ? "volatile " : "") + this.getType().toASTString(pDeclarator + "[" + (this.length != null ? this.length.toASTString() : "") + "]");
    }

    @Override
    public boolean isConst() {
        return this.isConst;
    }

    @Override
    public boolean isVolatile() {
        return this.isVolatile;
    }

    @Override
    public String toString() {
        return (this.isConst() ? "const " : "") + (this.isVolatile() ? "volatile " : "") + "(" + this.getType().toString() + ")[" + (this.length != null ? this.length.toASTString() : "") + "]";
    }

    @Override
    public <R, X extends Exception> R accept(CTypeVisitor<R, X> pVisitor) throws X {
        return pVisitor.visit(this);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 7;
        result = 31 * result + Objects.hashCode(this.length);
        result = 31 * result + Objects.hashCode(this.isConst);
        result = 31 * result + Objects.hashCode(this.isVolatile);
        result = 31 * result + super.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CArrayType) || !super.equals(obj)) {
            return false;
        }
        CArrayType other = (CArrayType)obj;
        if (this.length instanceof CIntegerLiteralExpression && other.length instanceof CIntegerLiteralExpression ? !((CIntegerLiteralExpression)this.length).getValue().equals(((CIntegerLiteralExpression)other.length).getValue()) : !Objects.equals(this.length, other.length)) {
            return false;
        }
        return this.isConst == other.isConst && this.isVolatile == other.isVolatile;
    }

    @Override
    public CArrayType getCanonicalType() {
        return this.getCanonicalType(false, false);
    }

    @Override
    public CArrayType getCanonicalType(boolean pForceConst, boolean pForceVolatile) {
        return new CArrayType(false, false, this.getType().getCanonicalType(this.isConst || pForceConst, this.isVolatile || pForceVolatile), this.length);
    }
}

