/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.types.c;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import org.sosy_lab.cpachecker.cfa.types.c.CComplexType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cfa.types.c.CTypeVisitor;

public final class CCompositeType
implements CComplexType,
Serializable {
    private static final long serialVersionUID = -839957929135012583L;
    private final CComplexType.ComplexTypeKind kind;
    private List<CCompositeTypeMemberDeclaration> members;
    private final String name;
    private final String origName;
    private boolean isConst;
    private boolean isVolatile;

    public CCompositeType(boolean pConst, boolean pVolatile, CComplexType.ComplexTypeKind pKind, List<CCompositeTypeMemberDeclaration> pMembers, String pName, String pOrigName) {
        Preconditions.checkArgument((pKind == CComplexType.ComplexTypeKind.STRUCT || pKind == CComplexType.ComplexTypeKind.UNION ? 1 : 0) != 0);
        this.isConst = pConst;
        this.isVolatile = pVolatile;
        this.kind = pKind;
        this.members = ImmutableList.copyOf(pMembers);
        this.name = pName.intern();
        this.origName = pOrigName.intern();
    }

    @Override
    public CComplexType.ComplexTypeKind getKind() {
        return this.kind;
    }

    public List<CCompositeTypeMemberDeclaration> getMembers() {
        return this.members;
    }

    public void setMembers(List<CCompositeTypeMemberDeclaration> list) {
        this.members = ImmutableList.copyOf(list);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getQualifiedName() {
        return (this.kind.toASTString() + " " + this.name).trim();
    }

    @Override
    public String getOrigName() {
        return this.origName;
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        if (this.isConst()) {
            result.append("const ");
        }
        if (this.isVolatile()) {
            result.append("volatile ");
        }
        result.append(this.kind.toASTString());
        result.append(' ');
        result.append(this.name);
        return result.toString();
    }

    @Override
    public String toASTString(String pDeclarator) {
        StringBuilder lASTString = new StringBuilder();
        if (this.isConst()) {
            lASTString.append("const ");
        }
        if (this.isVolatile()) {
            lASTString.append("volatile ");
        }
        lASTString.append(this.kind.toASTString());
        lASTString.append(' ');
        lASTString.append(this.name);
        lASTString.append(" {\n");
        for (CCompositeTypeMemberDeclaration lMember : this.members) {
            lASTString.append("  ");
            lASTString.append(lMember.toASTString());
            lASTString.append("\n");
        }
        lASTString.append("} ");
        lASTString.append(pDeclarator);
        return lASTString.toString();
    }

    @Override
    public boolean isConst() {
        return this.isConst;
    }

    @Override
    public boolean isVolatile() {
        return this.isVolatile;
    }

    @Override
    public <R, X extends Exception> R accept(CTypeVisitor<R, X> pVisitor) throws X {
        return pVisitor.visit(this);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 7;
        result = 31 * result + Objects.hashCode(this.isConst);
        result = 31 * result + Objects.hashCode(this.isVolatile);
        result = 31 * result + Objects.hashCode((Object)this.kind);
        result = 31 * result + Objects.hashCode(this.name);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CCompositeType)) {
            return false;
        }
        CCompositeType other = (CCompositeType)obj;
        return this.isConst == other.isConst && this.isVolatile == other.isVolatile && this.kind == other.kind && Objects.equals(this.name, other.name);
    }

    @Override
    public CCompositeType getCanonicalType() {
        return this.getCanonicalType(false, false);
    }

    @Override
    public CCompositeType getCanonicalType(boolean pForceConst, boolean pForceVolatile) {
        return new CCompositeType(this.isConst || pForceConst, this.isVolatile || pForceVolatile, this.kind, this.members, this.name, this.origName);
    }

    public static final class CCompositeTypeMemberDeclaration
    implements Serializable {
        private static final long serialVersionUID = 8647666228796784933L;
        private final CType type;
        private final String name;

        public CCompositeTypeMemberDeclaration(CType pType, String pName) {
            this.type = (CType)Preconditions.checkNotNull((Object)pType);
            this.name = pName;
        }

        public int hashCode() {
            int prime = 31;
            int result = 7;
            result = 31 * result + Objects.hashCode(this.name);
            result = 31 * result + Objects.hashCode(this.type);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CCompositeTypeMemberDeclaration other = (CCompositeTypeMemberDeclaration)obj;
            return Objects.equals(this.name, other.name) && this.type.getCanonicalType().equals(other.type.getCanonicalType());
        }

        public CType getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        public String toASTString() {
            String name = Strings.nullToEmpty((String)this.getName());
            return this.getType().toASTString(name) + ";";
        }

        public String toString() {
            return this.toASTString();
        }
    }
}

