/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.types.c;

import com.google.common.collect.ImmutableList;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.c.CCharLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFloatLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializer;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializerList;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.types.c.CArrayType;
import org.sosy_lab.cpachecker.cfa.types.c.CBasicType;
import org.sosy_lab.cpachecker.cfa.types.c.CComplexType;
import org.sosy_lab.cpachecker.cfa.types.c.CCompositeType;
import org.sosy_lab.cpachecker.cfa.types.c.CElaboratedType;
import org.sosy_lab.cpachecker.cfa.types.c.CEnumType;
import org.sosy_lab.cpachecker.cfa.types.c.CNumericTypes;
import org.sosy_lab.cpachecker.cfa.types.c.CPointerType;
import org.sosy_lab.cpachecker.cfa.types.c.CSimpleType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;

public class CDefaults {
    private CDefaults() {
    }

    public static CInitializer forType(CType type, FileLocation fileLoc) {
        if ((type = type.getCanonicalType()) instanceof CPointerType) {
            return CDefaults.initializerFor(CDefaults.signedIntZero(fileLoc), fileLoc);
        }
        if (type instanceof CSimpleType) {
            CBasicType basicType = ((CSimpleType)type).getType();
            switch (basicType) {
                case CHAR: {
                    return CDefaults.initializerFor(new CCharLiteralExpression(fileLoc, type, '\u0000'), fileLoc);
                }
                case DOUBLE: 
                case FLOAT: {
                    return CDefaults.initializerFor(new CFloatLiteralExpression(fileLoc, type, BigDecimal.ZERO), fileLoc);
                }
                case UNSPECIFIED: 
                case BOOL: 
                case INT: {
                    return CDefaults.initializerFor(new CIntegerLiteralExpression(fileLoc, type, BigInteger.ZERO), fileLoc);
                }
            }
            throw new AssertionError((Object)("Unknown basic type '" + (Object)((Object)basicType) + "'"));
        }
        if (type instanceof CEnumType) {
            return CDefaults.initializerFor(CDefaults.signedIntZero(fileLoc), fileLoc);
        }
        if (type instanceof CElaboratedType) {
            if (((CElaboratedType)type).getKind() == CComplexType.ComplexTypeKind.ENUM) {
                return CDefaults.initializerFor(CDefaults.signedIntZero(fileLoc), fileLoc);
            }
            throw new IllegalArgumentException("Cannot produce initializer for incompletely defined type " + type);
        }
        if (type instanceof CCompositeType) {
            return CDefaults.emptyAggregate(fileLoc);
        }
        if (type instanceof CArrayType) {
            return CDefaults.emptyAggregate(fileLoc);
        }
        throw new IllegalArgumentException("Type " + type + " has no default value");
    }

    private static CInitializerList emptyAggregate(FileLocation fileLoc) {
        return new CInitializerList(fileLoc, (List<CInitializer>)ImmutableList.of());
    }

    private static CIntegerLiteralExpression signedIntZero(FileLocation fileLoc) {
        return new CIntegerLiteralExpression(fileLoc, CNumericTypes.SIGNED_INT, BigInteger.ZERO);
    }

    private static CInitializerExpression initializerFor(CExpression exp, FileLocation fileLoc) {
        return new CInitializerExpression(fileLoc, exp);
    }
}

