/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.types.c;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Objects;
import org.sosy_lab.cpachecker.cfa.types.c.CComplexType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cfa.types.c.CTypeVisitor;

public final class CElaboratedType
implements CComplexType,
Serializable {
    private static final long serialVersionUID = -3566628634889842927L;
    private final CComplexType.ComplexTypeKind kind;
    private final String name;
    private final String origName;
    private final boolean isConst;
    private final boolean isVolatile;
    private CComplexType realType = null;

    public CElaboratedType(boolean pConst, boolean pVolatile, CComplexType.ComplexTypeKind pKind, String pName, String pOrigName, CComplexType pRealType) {
        this.isConst = pConst;
        this.isVolatile = pVolatile;
        this.kind = pKind;
        this.name = pName.intern();
        this.origName = pOrigName.intern();
        this.realType = pRealType;
    }

    @Override
    public String getName() {
        if (this.realType != null) {
            return this.realType.getName();
        }
        return this.name;
    }

    @Override
    public String getQualifiedName() {
        return (this.kind.toASTString() + " " + this.name).trim();
    }

    @Override
    public String getOrigName() {
        if (this.realType != null) {
            return this.realType.getOrigName();
        }
        return this.origName;
    }

    @Override
    public CComplexType.ComplexTypeKind getKind() {
        return this.kind;
    }

    public CComplexType getRealType() {
        if (this.realType instanceof CElaboratedType) {
            return ((CElaboratedType)this.realType).getRealType();
        }
        return this.realType;
    }

    public void setRealType(CComplexType pRealType) {
        Preconditions.checkState((this.getRealType() == null ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)pRealType);
        Preconditions.checkArgument((pRealType != this ? 1 : 0) != 0);
        Preconditions.checkArgument((pRealType.getKind() == this.kind ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)pRealType.getName().equals(this.name));
        this.realType = pRealType;
    }

    @Override
    public String toASTString(String pDeclarator) {
        StringBuilder lASTString = new StringBuilder();
        if (this.isConst()) {
            lASTString.append("const ");
        }
        if (this.isVolatile()) {
            lASTString.append("volatile ");
        }
        lASTString.append(this.kind.toASTString());
        lASTString.append(" ");
        lASTString.append(this.name);
        lASTString.append(" ");
        lASTString.append(pDeclarator);
        return lASTString.toString();
    }

    @Override
    public String toString() {
        return this.getKind().toASTString() + " " + this.getName();
    }

    @Override
    public boolean isConst() {
        return this.isConst;
    }

    @Override
    public boolean isVolatile() {
        return this.isVolatile;
    }

    @Override
    public <R, X extends Exception> R accept(CTypeVisitor<R, X> pVisitor) throws X {
        return pVisitor.visit(this);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 7;
        result = 31 * result + Objects.hashCode(this.isConst);
        result = 31 * result + Objects.hashCode(this.isVolatile);
        result = 31 * result + Objects.hashCode((Object)this.kind);
        result = 31 * result + Objects.hashCode(this.name);
        result = 31 * result + Objects.hashCode(this.realType);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CElaboratedType)) {
            return false;
        }
        CElaboratedType other = (CElaboratedType)obj;
        return this.isConst == other.isConst && this.isVolatile == other.isVolatile && this.kind == other.kind && Objects.equals(this.name, other.name) && Objects.equals(this.realType, other.realType);
    }

    @Override
    public CType getCanonicalType() {
        return this.getCanonicalType(false, false);
    }

    @Override
    public CType getCanonicalType(boolean pForceConst, boolean pForceVolatile) {
        if (this.realType == null) {
            return new CElaboratedType(this.isConst || pForceConst, this.isVolatile || pForceVolatile, this.kind, this.name, this.origName, null);
        }
        return this.realType.getCanonicalType(this.isConst || pForceConst, this.isVolatile || pForceVolatile);
    }
}

