/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.types.c;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.sosy_lab.cpachecker.cfa.ast.AbstractSimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.c.CAstNodeVisitor;
import org.sosy_lab.cpachecker.cfa.ast.c.CSimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CSimpleDeclarationVisitor;
import org.sosy_lab.cpachecker.cfa.types.c.CComplexType;
import org.sosy_lab.cpachecker.cfa.types.c.CNumericTypes;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cfa.types.c.CTypeVisitor;

public final class CEnumType
implements CComplexType {
    private final ImmutableList<CEnumerator> enumerators;
    private final String name;
    private final String origName;
    private boolean isConst;
    private boolean isVolatile;

    public CEnumType(boolean pConst, boolean pVolatile, List<CEnumerator> pEnumerators, String pName, String pOrigName) {
        this.isConst = pConst;
        this.isVolatile = pVolatile;
        this.enumerators = ImmutableList.copyOf(pEnumerators);
        this.name = pName;
        this.origName = pOrigName;
    }

    @Override
    public boolean isConst() {
        return this.isConst;
    }

    @Override
    public boolean isVolatile() {
        return this.isVolatile;
    }

    public ImmutableList<CEnumerator> getEnumerators() {
        return this.enumerators;
    }

    @Override
    public CComplexType.ComplexTypeKind getKind() {
        return CComplexType.ComplexTypeKind.ENUM;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getQualifiedName() {
        return ("enum " + this.name).trim();
    }

    @Override
    public String getOrigName() {
        return this.origName;
    }

    @Override
    public String toASTString(String pDeclarator) {
        StringBuilder lASTString = new StringBuilder();
        if (this.isConst()) {
            lASTString.append("const ");
        }
        if (this.isVolatile()) {
            lASTString.append("volatile ");
        }
        lASTString.append("enum ");
        lASTString.append(this.name);
        lASTString.append(" {\n  ");
        Joiner.on((String)",\n  ").appendTo(lASTString, Iterables.transform(this.enumerators, (Function)CEnumerator.TO_AST_STRING));
        lASTString.append("\n} ");
        lASTString.append(pDeclarator);
        return lASTString.toString();
    }

    @Override
    public String toString() {
        return (this.isConst() ? "const " : "") + (this.isVolatile() ? "volatile " : "") + "enum " + this.name;
    }

    @Override
    public <R, X extends Exception> R accept(CTypeVisitor<R, X> pVisitor) throws X {
        return pVisitor.visit(this);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 7;
        result = 31 * result + Objects.hashCode(this.isConst);
        result = 31 * result + Objects.hashCode(this.isVolatile);
        result = 31 * result + Objects.hashCode(this.name);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CEnumType)) {
            return false;
        }
        CEnumType other = (CEnumType)obj;
        return this.isConst == other.isConst && this.isVolatile == other.isVolatile && Objects.equals(this.name, other.name) && Objects.equals(this.enumerators, other.enumerators);
    }

    @Override
    public CEnumType getCanonicalType() {
        return this.getCanonicalType(false, false);
    }

    @Override
    public CEnumType getCanonicalType(boolean pForceConst, boolean pForceVolatile) {
        return new CEnumType(this.isConst || pForceConst, this.isVolatile || pForceVolatile, (List<CEnumerator>)this.enumerators, this.name, this.origName);
    }

    public static final class CEnumerator
    extends AbstractSimpleDeclaration
    implements CSimpleDeclaration {
        @Nullable
        private final Long value;
        private CEnumType enumType;
        private final String qualifiedName;

        public CEnumerator(FileLocation pFileLocation, String pName, String pQualifiedName, Long pValue) {
            super(pFileLocation, CNumericTypes.SIGNED_INT, pName);
            Preconditions.checkNotNull((Object)pName);
            this.value = pValue;
            this.qualifiedName = (String)Preconditions.checkNotNull((Object)pQualifiedName);
        }

        public CEnumType getEnum() {
            return this.enumType;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof CEnumerator) || !super.equals(obj)) {
                return false;
            }
            CEnumerator other = (CEnumerator)obj;
            return Objects.equals(this.value, other.value) && this.qualifiedName.equals(other.qualifiedName);
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = 7;
            result = 31 * result + Objects.hashCode(this.value);
            result = 31 * result + Objects.hashCode(this.enumType);
            result = 31 * result + Objects.hashCode(this.qualifiedName);
            result = 31 * result + super.hashCode();
            return result;
        }

        public void setEnum(CEnumType pEnumType) {
            Preconditions.checkState((this.enumType == null ? 1 : 0) != 0);
            this.enumType = pEnumType;
        }

        @Override
        public String getQualifiedName() {
            return this.qualifiedName;
        }

        @Override
        public CType getType() {
            return (CType)super.getType();
        }

        public long getValue() {
            Preconditions.checkState((this.value != null ? 1 : 0) != 0, (Object)"Need to check hasValue() before calling getValue()");
            return this.value;
        }

        public boolean hasValue() {
            return this.value != null;
        }

        @Override
        public String toASTString() {
            return this.getName() + (this.hasValue() ? " = " + String.valueOf(this.value) : "");
        }

        @Override
        public <R, X extends Exception> R accept(CSimpleDeclarationVisitor<R, X> pV) throws X {
            return pV.visit(this);
        }

        @Override
        public <R, X extends Exception> R accept(CAstNodeVisitor<R, X> pV) throws X {
            return pV.visit(this);
        }
    }
}

