/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.types.c;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.sosy_lab.cpachecker.cfa.types.AFunctionType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cfa.types.c.CTypeVisitor;
import org.sosy_lab.cpachecker.cfa.types.c.CVoidType;

public class CFunctionType
extends AFunctionType
implements CType {
    public static final CFunctionType NO_ARGS_VOID_FUNCTION = CFunctionType.functionTypeWithReturnType(CVoidType.VOID);
    private boolean isConst;
    private boolean isVolatile;
    private String name = null;

    public static CFunctionType functionTypeWithReturnType(CType pReturnType) {
        return new CFunctionType(false, false, (CType)Preconditions.checkNotNull((Object)pReturnType), (List<CType>)ImmutableList.of(), false);
    }

    public CFunctionType(boolean pConst, boolean pVolatile, CType pReturnType, List<CType> pParameters, boolean pTakesVarArgs) {
        super(pReturnType, pParameters, pTakesVarArgs);
        this.isConst = pConst;
        this.isVolatile = pVolatile;
    }

    @Override
    public CType getReturnType() {
        return (CType)super.getReturnType();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String pName) {
        Preconditions.checkState((this.name == null ? 1 : 0) != 0);
        this.name = pName;
    }

    public List<CType> getParameters() {
        return super.getParameters();
    }

    @Override
    public String toString() {
        return this.toASTString(Strings.nullToEmpty((String)this.getName()), (Function<? super CType, String>)Functions.toStringFunction());
    }

    @Override
    public String toASTString(String pDeclarator) {
        return this.toASTString(pDeclarator, (Function<? super CType, String>)new Function<CType, String>(){

            public String apply(CType pInput) {
                return pInput.toASTString("");
            }
        });
    }

    public String toASTString(String pDeclarator, Function<? super CType, String> pTypeToString) {
        StringBuilder lASTString = new StringBuilder();
        if (this.isConst()) {
            lASTString.append("const ");
        }
        if (this.isVolatile()) {
            lASTString.append("volatile ");
        }
        lASTString.append((String)pTypeToString.apply((Object)this.getReturnType()));
        lASTString.append(" ");
        if (pDeclarator.startsWith("*")) {
            lASTString.append("(");
            lASTString.append(pDeclarator);
            lASTString.append(")");
        } else {
            lASTString.append(pDeclarator);
        }
        lASTString.append("(");
        Joiner.on((String)", ").appendTo(lASTString, Iterables.transform(this.getParameters(), pTypeToString));
        if (this.takesVarArgs()) {
            if (!this.getParameters().isEmpty()) {
                lASTString.append(", ");
            }
            lASTString.append("...");
        }
        lASTString.append(")");
        return lASTString.toString();
    }

    @Override
    public boolean isConst() {
        return this.isConst;
    }

    @Override
    public boolean isVolatile() {
        return this.isVolatile;
    }

    @Override
    public <R, X extends Exception> R accept(CTypeVisitor<R, X> pVisitor) throws X {
        return pVisitor.visit(this);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 7;
        result = 31 * result + Objects.hashCode(this.isConst);
        result = 31 * result + Objects.hashCode(this.isVolatile);
        result = 31 * result + super.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CFunctionType) || !super.equals(obj)) {
            return false;
        }
        CFunctionType other = (CFunctionType)obj;
        return this.isConst == other.isConst && this.isVolatile == other.isVolatile;
    }

    @Override
    public CFunctionType getCanonicalType() {
        return this.getCanonicalType(false, false);
    }

    @Override
    public CFunctionType getCanonicalType(boolean pForceConst, boolean pForceVolatile) {
        ArrayList<CType> newParameterTypes = new ArrayList<CType>();
        Iterator<CType> it = this.getParameters().iterator();
        while (it.hasNext()) {
            newParameterTypes.add(it.next().getCanonicalType());
        }
        return new CFunctionType(this.isConst || pForceConst, this.isVolatile || pForceVolatile, this.getReturnType().getCanonicalType(), newParameterTypes, this.takesVarArgs());
    }
}

