/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.types.c;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import org.sosy_lab.cpachecker.cfa.ast.c.CParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.types.c.CFunctionType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cfa.types.c.CTypeVisitor;

public final class CFunctionTypeWithNames
extends CFunctionType
implements CType {
    private final List<CParameterDeclaration> parameters;

    public CFunctionTypeWithNames(boolean pConst, boolean pVolatile, CType pReturnType, List<CParameterDeclaration> pParameters, boolean pTakesVarArgs) {
        super(pConst, pVolatile, pReturnType, (List<CType>)FluentIterable.from(pParameters).transform((Function)new Function<CParameterDeclaration, CType>(){

            public CType apply(CParameterDeclaration pInput) {
                return pInput.getType();
            }
        }).toList(), pTakesVarArgs);
        this.parameters = ImmutableList.copyOf(pParameters);
    }

    public List<CParameterDeclaration> getParameterDeclarations() {
        return this.parameters;
    }

    @Override
    public String toASTString(String pDeclarator) {
        StringBuilder lASTString = new StringBuilder();
        if (this.isConst()) {
            lASTString.append("const ");
        }
        if (this.isVolatile()) {
            lASTString.append("volatile ");
        }
        lASTString.append(this.getReturnType().toASTString(""));
        lASTString.append(" ");
        if (pDeclarator.startsWith("*")) {
            lASTString.append("(");
            lASTString.append(pDeclarator);
            lASTString.append(")");
        } else {
            lASTString.append(pDeclarator);
        }
        lASTString.append("(");
        Joiner.on((String)", ").appendTo(lASTString, this.getParameterDeclarations());
        if (this.takesVarArgs()) {
            if (!this.getParameters().isEmpty()) {
                lASTString.append(", ");
            }
            lASTString.append("...");
        }
        lASTString.append(")");
        return lASTString.toString();
    }

    @Override
    public <R, X extends Exception> R accept(CTypeVisitor<R, X> pVisitor) throws X {
        return pVisitor.visit(this);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 7;
        result = 31 * result + Objects.hashCode(this.parameters);
        result = 31 * result + super.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CFunctionTypeWithNames) || !super.equals(obj)) {
            return false;
        }
        CFunctionTypeWithNames other = (CFunctionTypeWithNames)obj;
        return Objects.equals(this.parameters, other.parameters);
    }
}

