/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.types.c;

import java.io.Serializable;
import java.util.Objects;
import org.sosy_lab.cpachecker.cfa.types.c.CArrayType;
import org.sosy_lab.cpachecker.cfa.types.c.CNumericTypes;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cfa.types.c.CTypeVisitor;
import org.sosy_lab.cpachecker.cfa.types.c.CVoidType;

public final class CPointerType
implements CType,
Serializable {
    private static final long serialVersionUID = -6423006826454509009L;
    public static final CPointerType POINTER_TO_VOID = new CPointerType(false, false, CVoidType.VOID);
    public static final CPointerType POINTER_TO_CONST_CHAR = new CPointerType(false, false, CNumericTypes.CHAR.getCanonicalType(true, false));
    private final CType type;
    private boolean isConst;
    private boolean isVolatile;

    public CPointerType(boolean pConst, boolean pVolatile, CType pType) {
        this.isConst = pConst;
        this.isVolatile = pVolatile;
        this.type = pType;
    }

    @Override
    public boolean isConst() {
        return this.isConst;
    }

    @Override
    public boolean isVolatile() {
        return this.isVolatile;
    }

    public CType getType() {
        return this.type;
    }

    @Override
    public String toString() {
        String decl = "(" + this.type.toString() + ")*";
        return (this.isConst() ? "const " : "") + (this.isVolatile() ? "volatile " : "") + decl;
    }

    @Override
    public String toASTString(String pDeclarator) {
        String decl = this.type instanceof CArrayType ? this.type.toASTString("(*" + pDeclarator + ")") : this.type.toASTString("*" + pDeclarator);
        return (this.isConst() ? "const " : "") + (this.isVolatile() ? "volatile " : "") + decl;
    }

    @Override
    public <R, X extends Exception> R accept(CTypeVisitor<R, X> pVisitor) throws X {
        return pVisitor.visit(this);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 7;
        result = 31 * result + Objects.hashCode(this.isConst);
        result = 31 * result + Objects.hashCode(this.isVolatile);
        result = 31 * result + Objects.hashCode(this.type);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CPointerType)) {
            return false;
        }
        CPointerType other = (CPointerType)obj;
        return this.isConst == other.isConst && this.isVolatile == other.isVolatile && Objects.equals(this.type, other.type);
    }

    @Override
    public CPointerType getCanonicalType() {
        return this.getCanonicalType(false, false);
    }

    @Override
    public CPointerType getCanonicalType(boolean pForceConst, boolean pForceVolatile) {
        return new CPointerType(this.isConst || pForceConst, this.isVolatile || pForceVolatile, this.type.getCanonicalType());
    }
}

