/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.types.c;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Objects;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cfa.types.c.CTypeVisitor;

public final class CTypedefType
implements CType,
Serializable {
    private static final long serialVersionUID = -3461236537115147688L;
    private final String name;
    private final CType realType;
    private boolean isConst;
    private boolean isVolatile;

    public CTypedefType(boolean pConst, boolean pVolatile, String pName, CType pRealType) {
        this.isConst = pConst;
        this.isVolatile = pVolatile;
        this.name = pName.intern();
        this.realType = (CType)Preconditions.checkNotNull((Object)pRealType);
    }

    public String getName() {
        return this.name;
    }

    public CType getRealType() {
        return this.realType;
    }

    @Override
    public String toString() {
        return this.toASTString("");
    }

    @Override
    public String toASTString(String pDeclarator) {
        return (this.isConst() ? "const " : "") + (this.isVolatile() ? "volatile " : "") + this.name + " " + pDeclarator;
    }

    @Override
    public boolean isConst() {
        return this.isConst;
    }

    @Override
    public boolean isVolatile() {
        return this.isVolatile;
    }

    @Override
    public <R, X extends Exception> R accept(CTypeVisitor<R, X> pVisitor) throws X {
        return pVisitor.visit(this);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 7;
        result = 31 * result + Objects.hashCode(this.name);
        result = 31 * result + Objects.hashCode(this.isConst);
        result = 31 * result + Objects.hashCode(this.isVolatile);
        result = 31 * result + Objects.hashCode(this.realType);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CTypedefType)) {
            return false;
        }
        CTypedefType other = (CTypedefType)obj;
        return Objects.equals(this.name, other.name) && this.isConst == other.isConst && this.isVolatile == other.isVolatile && Objects.equals(this.realType, other.realType);
    }

    @Override
    public CType getCanonicalType() {
        return this.getCanonicalType(this.isConst, this.isVolatile);
    }

    @Override
    public CType getCanonicalType(boolean pForceConst, boolean pForceVolatile) {
        return this.realType.getCanonicalType(pForceConst, pForceVolatile);
    }
}

